/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.level.LevelEvent;

public class CoreFakePlayer
extends FakePlayer {
    private static final String FAKE_PLAYER_USERNAME = "sophisticated_core_fake_player";
    private static final Map<ServerLevel, CoreFakePlayer> fakePlayers = new HashMap<ServerLevel, CoreFakePlayer>();
    private Vec3 position = Vec3.ZERO;
    private BlockPos blockPosition = BlockPos.ZERO;

    public static CoreFakePlayer get(ServerLevel level) {
        return fakePlayers.computeIfAbsent(level, CoreFakePlayer::new);
    }

    public static void onDimensionUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            fakePlayers.remove(level);
        }
    }

    private CoreFakePlayer(ServerLevel level) {
        this(level, new GameProfile(UUID.nameUUIDFromBytes(FAKE_PLAYER_USERNAME.getBytes()), FAKE_PLAYER_USERNAME));
    }

    private CoreFakePlayer(ServerLevel level, GameProfile name) {
        super(level, name);
    }

    protected void onEffectAdded(MobEffectInstance effect, @Nullable Entity entity) {
    }

    protected void onEffectUpdated(MobEffectInstance effect, boolean updateAttributes, @Nullable Entity entity) {
    }

    protected void onEffectsRemoved(Collection<MobEffectInstance> effects) {
    }

    public Vec3 position() {
        return this.position;
    }

    public BlockPos blockPosition() {
        return this.blockPosition;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
        this.blockPosition = BlockPos.containing((Position)position);
    }
}

