/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticateditemactions.client.gui.ItemActionsTranslationHelper;
import net.p3pp3rf1y.sophisticateditemactions.client.render.EntityHighlightRenderer;
import net.p3pp3rf1y.sophisticateditemactions.client.render.ItemFlightAnimator;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemTransferHandler;

public class ClientEventHandler {
    private static final String KEYBIND_SOPHISTICATEDCORE_CATEGORY = "key.category.sophisticateditemactions.main";
    public static final KeyMapping ITEM_HIGHLIGHT_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("item_highlight"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(59), "key.category.sophisticateditemactions.main");
    public static final KeyMapping ITEM_DEPOSIT_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("deposit_item"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(39), "key.category.sophisticateditemactions.main");
    public static final KeyMapping ITEM_RESTOCK_KEYBIND = new KeyMapping(ItemActionsTranslationHelper.INSTANCE.translKeybind("restock_item"), (IKeyConflictContext)ItemHighlightKeyConflictContext.INSTANCE, InputConstants.Type.KEYSYM.getOrCreate(92), "key.category.sophisticateditemactions.main");
    private static final List<Supplier<ItemStack>> HOVERED_STACK_SUPPLIERS = new ArrayList<Supplier<ItemStack>>();

    public static void registerHoveredStackSupplier(Supplier<ItemStack> stackSupplier) {
        HOVERED_STACK_SUPPLIERS.add(stackSupplier);
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ClientEventHandler::handleKeyInput);
        eventBus.addListener(ClientEventHandler::onPostClientTick);
        eventBus.addListener(ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(ClientEventHandler::renderLevelStage);
    }

    private static void renderLevelStage(RenderLevelStageEvent.AfterBlockEntities event) {
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        ItemFlightAnimator.render(event.getPoseStack(), partialTick, event.getCamera().getPosition());
        EntityHighlightRenderer.render(event.getPoseStack(), partialTick, event.getCamera().getPosition());
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ITEM_HIGHLIGHT_KEYBIND);
        event.register(ITEM_DEPOSIT_KEYBIND);
        event.register(ITEM_RESTOCK_KEYBIND);
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(key) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            screen.onClose();
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        AbstractContainerScreen screen;
        Screen screen2;
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (ITEM_HIGHLIGHT_KEYBIND.isActiveAndMatches(input) && (screen2 = event.getScreen()) instanceof AbstractContainerScreen && ClientEventHandler.tryHighlightItem((screen = (AbstractContainerScreen)screen2).getSlotUnderMouse())) {
            screen.onClose();
            event.setCanceled(true);
        }
    }

    public static void onPostClientTick(ClientTickEvent.Post event) {
        if (ITEM_HIGHLIGHT_KEYBIND.consumeClick()) {
            ClientEventHandler.tryHighlightItem();
        }
    }

    private static boolean tryHighlightItem(@Nullable Slot slot) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (slot == null || player == null || slot.getItem().isEmpty()) {
            return false;
        }
        HighlightHandler.highlightItem((Player)player, slot.getItem());
        return true;
    }

    private static void tryHighlightItem() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.getMainHandItem().isEmpty()) {
            return;
        }
        HighlightHandler.highlightItem((Player)player, player.getMainHandItem());
    }

    public static void handleKeyInput(InputEvent.Key event) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null && screen.isFocused()) {
            return;
        }
        if (!ITEM_DEPOSIT_KEYBIND.isUnbound() && ITEM_DEPOSIT_KEYBIND.getKey().getValue() == event.getKey() && event.getAction() == 1) {
            ClientEventHandler.tryDepositItem(event);
        } else if (!ITEM_RESTOCK_KEYBIND.isUnbound() && ITEM_RESTOCK_KEYBIND.getKey().getValue() == event.getKey() && event.getAction() == 1) {
            ClientEventHandler.tryRestockItem(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void tryRestockItem(InputEvent.Key event) {
        int slot;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int mods = event.getModifiers();
        boolean mainInventory = (mods & 1) != 0;
        boolean hotbar = (mods & 4) != 0;
        boolean fillEmpty = (mods & 2) != 0;
        Screen screen = Minecraft.getInstance().screen;
        ItemStack filter = ClientEventHandler.getHoveredStack();
        if (filter.isEmpty()) {
            if (screen != null) {
                if (!(screen instanceof AbstractContainerScreen)) return;
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                Slot slotUnderMouse = containerScreen.getSlotUnderMouse();
                if (slotUnderMouse == null || slotUnderMouse.getItem().isEmpty()) return;
                filter = slotUnderMouse.getItem();
                slot = slotUnderMouse.getSlotIndex();
            } else {
                filter = player.getMainHandItem();
                slot = player.getInventory().getSelectedSlot();
            }
        } else {
            slot = player.getInventory().getFreeSlot();
            fillEmpty = true;
            if (slot == -1) {
                return;
            }
        }
        if (mainInventory || hotbar) {
            ItemTransferHandler.restockMultipleItems((Player)player, filter, mainInventory, hotbar, fillEmpty);
            return;
        } else {
            ItemTransferHandler.restockItem((Player)player, filter, slot, fillEmpty);
        }
    }

    private static ItemStack getHoveredStack() {
        for (Supplier<ItemStack> supplier : HOVERED_STACK_SUPPLIERS) {
            ItemStack stack = supplier.get();
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private static void tryDepositItem(InputEvent.Key event) {
        boolean hotbar;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int mods = event.getModifiers();
        boolean mainInventory = (mods & 1) != 0;
        boolean onlyMatching = (mods & 2) == 0;
        boolean bl = hotbar = (mods & 4) != 0;
        if (mainInventory || hotbar) {
            ClientEventHandler.tryDepositMultipleItems((Player)player, mainInventory, hotbar, onlyMatching);
            return;
        }
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null) {
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                ClientEventHandler.tryDepositItem((Player)player, containerScreen.getSlotUnderMouse(), onlyMatching);
            }
        } else {
            ClientEventHandler.tryDepositItem((Player)player, onlyMatching);
        }
    }

    private static void tryDepositMultipleItems(Player player, boolean mainInventory, boolean hotbar, boolean onlyMatching) {
        ItemTransferHandler.depositMultipleItems(player, mainInventory, hotbar, onlyMatching);
    }

    private static void tryDepositItem(Player player, boolean onlyMatching) {
        ItemStack item = player.getMainHandItem();
        if (!item.isEmpty()) {
            ItemTransferHandler.depositItem(player, player.getInventory().getSelectedSlot(), onlyMatching);
        }
    }

    private static boolean tryDepositItem(Player player, @Nullable Slot slot, boolean onlyMatching) {
        if (slot == null || slot.getItem().isEmpty() || !(slot.container instanceof Inventory)) {
            return false;
        }
        ItemTransferHandler.depositItem(player, slot.getSlotIndex(), onlyMatching);
        return true;
    }

    private static class ItemHighlightKeyConflictContext
    implements IKeyConflictContext {
        public static final ItemHighlightKeyConflictContext INSTANCE = new ItemHighlightKeyConflictContext();

        private ItemHighlightKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.IN_GAME.isActive() && !Minecraft.getInstance().player.getMainHandItem().isEmpty() || KeyConflictContext.GUI.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

