/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticateditemactions.SophisticatedItemActions;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IEntityItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;

public class StandardStorageActionHandler
implements IBlockItemActionHandler,
IEntityItemActionHandler {
    public static final StandardStorageActionHandler INSTANCE = new StandardStorageActionHandler();
    public static final ResourceLocation ID = SophisticatedItemActions.getRL("item_handler");

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public boolean canActOn(Entity entity) {
        return entity.getCapability(Capabilities.ItemHandler.ENTITY, null) != null;
    }

    @Override
    public ItemMatchResult getItemMatch(ItemStackKey stackKey, Entity entity) {
        return StandardStorageActionHandler.getItemMatch(stackKey, (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY, null));
    }

    @Override
    public Optional<IDepositHandler> getDepositHandler(final Entity entity) {
        final IItemHandler cap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (cap == null) {
            return Optional.empty();
        }
        return Optional.of(new IDepositHandler(){

            @Override
            public Vec3 getPosition() {
                return entity.position();
            }

            @Override
            public ItemMatchResult getItemMatch(ItemStackKey stackKey) {
                return StandardStorageActionHandler.getItemMatch(stackKey, cap);
            }

            @Override
            public ItemStack insertItem(ItemStack stack) {
                return InventoryHelper.insertIntoInventoryMatchingFirst((ItemStack)stack, (IItemHandler)cap, (boolean)false);
            }
        });
    }

    @Override
    public Optional<IRestockHandler> getRestockHandler(final Entity entity) {
        final IItemHandler cap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY, null);
        if (cap == null) {
            return Optional.empty();
        }
        return Optional.of(new IRestockHandler(){

            @Override
            public Vec3 getPosition() {
                return entity.position();
            }

            @Override
            public ItemStack extractItem(ItemStack stack) {
                return InventoryHelper.extractFromInventory((ItemStack)stack, (IItemHandler)cap, (boolean)false);
            }
        });
    }

    private static ItemMatchResult getItemMatch(ItemStackKey stackKey, @Nullable IItemHandler cap) {
        if (cap == null) {
            return ItemMatchResult.NO_MATCH;
        }
        AtomicReference<ItemMatchResult> highlightResult = new AtomicReference<ItemMatchResult>(ItemMatchResult.NO_MATCH);
        InventoryHelper.iterate((IItemHandler)cap, (slot, stack) -> {
            if (stack.isEmpty()) {
                return;
            }
            if (stackKey.matches(stack)) {
                highlightResult.set(ItemMatchResult.MATCHING_STACK);
            } else if (stackKey.stack().getItem() == stack.getItem()) {
                highlightResult.set(ItemMatchResult.MATCHING_ITEM);
            }
        }, () -> highlightResult.get() == ItemMatchResult.MATCHING_STACK);
        return highlightResult.get();
    }

    @Override
    public boolean canActOn(Level level, BlockPos pos, BlockEntity blockEntity) {
        return level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null) != null;
    }

    @Override
    public ItemMatchResult getItemMatch(ServerPlayer player, ItemStackKey stackKey, BlockPos pos) {
        BlockState state = player.level().getBlockState(pos);
        if (state.getBlock() == Blocks.CHEST && state.getValue((Property)ChestBlock.TYPE) == ChestType.RIGHT) {
            return ItemMatchResult.NO_MATCH;
        }
        return StandardStorageActionHandler.getItemMatch(stackKey, (IItemHandler)player.level().getCapability(Capabilities.ItemHandler.BLOCK, pos, null));
    }

    @Override
    public Optional<IDepositHandler> getDepositHandler(ServerPlayer player, BlockPos pos) {
        ServerLevel level = player.level();
        final IItemHandler itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (itemHandler == null) {
            return Optional.empty();
        }
        final Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        return Optional.of(new IDepositHandler(){

            @Override
            public Vec3 getPosition() {
                return center;
            }

            @Override
            public ItemMatchResult getItemMatch(ItemStackKey stackKey) {
                return StandardStorageActionHandler.getItemMatch(stackKey, itemHandler);
            }

            @Override
            public ItemStack insertItem(ItemStack stack) {
                return InventoryHelper.insertIntoInventoryMatchingFirst((ItemStack)stack, (IItemHandler)itemHandler, (boolean)false);
            }
        });
    }

    @Override
    public Optional<IRestockHandler> getRestockHandler(ServerPlayer player, final BlockPos pos) {
        final IItemHandler itemHandler = (IItemHandler)player.level().getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (itemHandler == null) {
            return Optional.empty();
        }
        return Optional.of(new IRestockHandler(){

            @Override
            public Vec3 getPosition() {
                return Vec3.atCenterOf((Vec3i)pos);
            }

            @Override
            public ItemStack extractItem(ItemStack stack) {
                return InventoryHelper.extractFromInventory((ItemStack)stack, (IItemHandler)itemHandler, (boolean)false);
            }
        });
    }
}

