/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.client.init.ModParticles;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.StorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class ClientEventHandler {
    private static final int MIDDLE_BUTTON = 2;
    private static final String KEYBIND_SOPHISTICATEDCORE_CATEGORY = "keybind.sophisticatedcore.category";
    public static final KeyMapping SORT_KEYBIND = new KeyMapping(TranslationHelper.INSTANCE.translKeybind("sort"), (IKeyConflictContext)SophisticatedScreenKeyConflictContext.INSTANCE, InputConstants.Type.MOUSE.getOrCreate(2), "keybind.sophisticatedcore.category");

    private ClientEventHandler() {
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ModParticles::registerFactories);
        modBus.addListener(ClientEventHandler::registerFluidClientExtension);
        modBus.addListener(ClientEventHandler::registerKeyMappings);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(StorageSoundHandler::tick);
        eventBus.addListener(StorageSoundHandler::onWorldUnload);
        eventBus.addListener(ClientEventHandler::onDrawScreen);
        eventBus.addListener(ClientEventHandler::recipesReceived);
        eventBus.addListener(ClientEventHandler::handleGuiKeyPress);
        eventBus.addListener(ClientEventHandler::handleGuiMouseKeyPress);
        eventBus.addListener(ClientEventHandler::renderLevelStage);
    }

    private static void renderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        BlockHighlightRenderer.render(event.getPoseStack(), partialTick, event.getCamera().getPosition());
    }

    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(SORT_KEYBIND);
    }

    public static void handleGuiKeyPress(ScreenEvent.KeyPressed.Pre event) {
        InputConstants.Key key = InputConstants.getKey((int)event.getKeyCode(), (int)event.getScanCode());
        if (SORT_KEYBIND.isActiveAndMatches(key) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    public static void handleGuiMouseKeyPress(ScreenEvent.MouseButtonPressed.Pre event) {
        InputConstants.Key input = InputConstants.Type.MOUSE.getOrCreate(event.getButton());
        if (SORT_KEYBIND.isActiveAndMatches(input) && ClientEventHandler.tryCallSort(event.getScreen())) {
            event.setCanceled(true);
        }
    }

    private static boolean tryCallSort(Screen gui) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && (abstractContainerMenu = mc.player.containerMenu) instanceof StorageContainerMenuBase) {
            double mouseY;
            MouseHandler mh;
            double mouseX;
            StorageScreenBase screen;
            Slot selectedSlot;
            StorageContainerMenuBase container = (StorageContainerMenuBase)abstractContainerMenu;
            if (gui instanceof StorageScreenBase && ((selectedSlot = (screen = (StorageScreenBase)gui).getHoveredSlot(mouseX = (mh = mc.mouseHandler).xpos() * (double)mc.getWindow().getGuiScaledWidth() / (double)mc.getWindow().getScreenWidth(), mouseY = mh.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight())) == null || container.isNotPlayersInventorySlot(selectedSlot.index))) {
                container.sort();
                return true;
            }
        }
        return false;
    }

    private static void recipesReceived(RecipesReceivedEvent event) {
        RecipeHelper.setRecipes(event.getRecipeMap());
    }

    private static void onDrawScreen(ScreenEvent.Render.Post event) {
        AbstractContainerScreen containerGui;
        Minecraft mc;
        block9: {
            block8: {
                mc = Minecraft.getInstance();
                Screen gui = mc.screen;
                if (!(gui instanceof AbstractContainerScreen)) break block8;
                containerGui = (AbstractContainerScreen)gui;
                if (!(gui instanceof CreativeModeInventoryScreen) && mc.player != null) break block9;
            }
            return;
        }
        AbstractContainerMenu menu = containerGui.getMenu();
        ItemStack held = menu.getCarried();
        if (!held.isEmpty()) {
            Object object;
            Slot under = containerGui.getSlotUnderMouse();
            if (menu instanceof StorageContainerMenuBase) {
                StorageContainerMenuBase storageMenu = (StorageContainerMenuBase)menu;
                object = storageMenu.realInventorySlots;
            } else {
                object = menu.slots;
            }
            NonNullList slots = object;
            for (Slot s : slots) {
                Optional<StashResultAndTooltip> stashResultAndTooltip;
                ItemStack stack = s.getItem();
                if (!s.mayPickup((Player)mc.player) || stack.isEmpty() || (stashResultAndTooltip = ClientEventHandler.getStashResultAndTooltip(stack, held)).isEmpty()) continue;
                if (s == under) {
                    ClientEventHandler.renderSpecialTooltip(event, mc, event.getGuiGraphics(), stashResultAndTooltip.get());
                    continue;
                }
                ClientEventHandler.renderStashSign(mc, containerGui, event.getGuiGraphics(), s, stack, stashResultAndTooltip.get().stashResult());
            }
        }
    }

    private static void renderStashSign(Minecraft mc, AbstractContainerScreen<?> containerGui, GuiGraphics guiGraphics, Slot s, ItemStack stack, IStashStorageItem.StashResult stashResult) {
        int color;
        int x = containerGui.getGuiLeft() + s.x;
        int y = containerGui.getGuiTop() + s.y;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 300.0f);
        int n = color = stashResult == IStashStorageItem.StashResult.MATCH_AND_SPACE ? ChatFormatting.GREEN.getColor() : 0xFFFF00;
        if (stack.getItem() instanceof IStashStorageItem) {
            guiGraphics.drawString(mc.font, "+", x + 10, y + 8, color);
        } else {
            guiGraphics.drawString(mc.font, "-", x + 1, y, color);
        }
        poseStack.popPose();
    }

    private static void renderSpecialTooltip(ScreenEvent.Render.Post event, Minecraft mc, GuiGraphics guiGraphics, StashResultAndTooltip stashResultAndTooltip) {
        int x = event.getMouseX();
        int y = event.getMouseY();
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        guiGraphics.renderTooltip(mc.font, Collections.singletonList(Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".right_click_to_add_to_storage"))), stashResultAndTooltip.tooltip(), x, y);
        poseStack.popPose();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack inInventory, ItemStack held) {
        Item item;
        if (inInventory.getCount() == 1 && (item = inInventory.getItem()) instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(inInventory, held, stashStorageItem);
        }
        item = held.getItem();
        if (item instanceof IStashStorageItem) {
            IStashStorageItem stashStorageItem = (IStashStorageItem)item;
            return ClientEventHandler.getStashResultAndTooltip(held, inInventory, stashStorageItem);
        }
        return Optional.empty();
    }

    private static Optional<StashResultAndTooltip> getStashResultAndTooltip(ItemStack potentialStashStorage, ItemStack potentiallyStashable, IStashStorageItem stashStorageItem) {
        IStashStorageItem.StashResult stashResult = stashStorageItem.getItemStashable((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), potentialStashStorage, potentiallyStashable);
        if (stashResult == IStashStorageItem.StashResult.NO_SPACE) {
            return Optional.empty();
        }
        return Optional.of(new StashResultAndTooltip(stashResult, stashStorageItem.getInventoryTooltip(potentialStashStorage)));
    }

    private static void registerFluidClientExtension(RegisterClientExtensionsEvent event) {
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation XP_STILL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"block/xp_still");
            private static final ResourceLocation XP_FLOWING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedcore", (String)"block/xp_flowing");

            public ResourceLocation getStillTexture() {
                return XP_STILL_TEXTURE;
            }

            public ResourceLocation getFlowingTexture() {
                return XP_FLOWING_TEXTURE;
            }
        }, new FluidType[]{ModFluids.XP_FLUID_TYPE.get()});
    }

    private record StashResultAndTooltip(IStashStorageItem.StashResult stashResult, Optional<TooltipComponent> tooltip) {
    }

    private static class SophisticatedScreenKeyConflictContext
    implements IKeyConflictContext {
        public static final SophisticatedScreenKeyConflictContext INSTANCE = new SophisticatedScreenKeyConflictContext();

        private SophisticatedScreenKeyConflictContext() {
        }

        public boolean isActive() {
            return KeyConflictContext.GUI.isActive() && Minecraft.getInstance().screen instanceof StorageScreenBase;
        }

        public boolean conflicts(IKeyConflictContext other) {
            return this == other;
        }
    }
}

