/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.IRecipeDisplayGenerator;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapedRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ShapelessRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiShapedRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.jei.JeiShapelessRecipeDisplayBuilder;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class JeiRecipeDisplayGenerator
implements IRecipeDisplayGenerator<CraftingRecipe> {
    private final HolderGetter<Item> items = RecipeHelper.getItemLookup();
    private final List<RecipeHolder<CraftingRecipe>> craftingRecipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
    private final List<RecipeHolder<SmithingRecipe>> smithingRecipes = new ArrayList<RecipeHolder<SmithingRecipe>>();

    @Override
    public ShapedRecipeDisplayBuilder<CraftingRecipe> shaped(ItemStack result) {
        return new JeiShapedRecipeDisplayBuilder(this.items, this, result);
    }

    @Override
    public ShapelessRecipeDisplayBuilder<CraftingRecipe> shapeless(ItemStack result) {
        return new JeiShapelessRecipeDisplayBuilder(this.items, this, result);
    }

    @Override
    public IRecipeDisplayBuilder smithing(Optional<Ingredient> template, Optional<Ingredient> base, Optional<Ingredient> addition, ItemStack result) {
        return id -> this.acceptSmithing((RecipeHolder<SmithingRecipe>)new RecipeHolder(id, (Recipe)new SmithingTransformRecipe(template, base, addition, result)));
    }

    private void acceptSmithing(RecipeHolder<SmithingRecipe> recipe) {
        this.smithingRecipes.add(recipe);
    }

    public void acceptCrafting(RecipeHolder<CraftingRecipe> recipe) {
        this.craftingRecipes.add(recipe);
    }

    public List<RecipeHolder<CraftingRecipe>> getCraftingRecipes() {
        return this.craftingRecipes;
    }

    public List<RecipeHolder<SmithingRecipe>> getSmithingRecipes() {
        return this.smithingRecipes;
    }
}

