/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.StatefulComponentItemHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;

public class JukeboxUpgradeWrapper
extends UpgradeWrapperBase<JukeboxUpgradeWrapper, JukeboxUpgradeItem>
implements ITickableUpgrade {
    private static final int KEEP_ALIVE_SEND_INTERVAL = 5;
    private final StatefulComponentItemHandler discInventory;
    private long lastKeepAliveSendTime = 0L;
    private boolean isPlaying;
    private final LinkedList<Integer> playlist = new LinkedList();
    private final LinkedList<Integer> history = new LinkedList();
    private final Set<Integer> discsRemoved = new HashSet<Integer>();
    private final Set<Integer> discsAdded = new HashSet<Integer>();
    @Nullable
    private Entity entityPlaying = null;
    @Nullable
    private Level levelPlaying = null;
    @Nullable
    private BlockPos posPlaying = null;
    private final Runnable onFinishedCallback = this::onDiscFinished;

    protected JukeboxUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        if (upgrade.has(DataComponents.CONTAINER)) {
            upgrade.set(ModCoreDataComponents.LENIENT_CONTAINER, (Object)((ItemContainerContents)upgrade.get(DataComponents.CONTAINER)));
        }
        upgrade.remove(DataComponents.CONTAINER);
        this.discInventory = new StatefulComponentItemHandler((MutableDataComponentHolder)upgrade, ModCoreDataComponents.LENIENT_CONTAINER.get(), ((JukeboxUpgradeItem)this.upgradeItem).getNumberOfSlots()){

            @Override
            protected void onContentsChanged(int slot, ItemStack oldStack, ItemStack newStack) {
                super.onContentsChanged(slot, oldStack, newStack);
                JukeboxUpgradeWrapper.this.save();
                if (oldStack.isEmpty() && !newStack.isEmpty()) {
                    JukeboxUpgradeWrapper.this.discsAdded.add(slot);
                    JukeboxUpgradeWrapper.this.discsRemoved.remove(slot);
                } else if (!oldStack.isEmpty() && newStack.isEmpty()) {
                    JukeboxUpgradeWrapper.this.discsRemoved.add(slot);
                    JukeboxUpgradeWrapper.this.discsAdded.remove(slot);
                }
            }

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.isEmpty() || stack.has(DataComponents.JUKEBOX_PLAYABLE);
            }
        };
        this.isPlaying = (Boolean)upgrade.getOrDefault(ModCoreDataComponents.IS_PLAYING, (Object)false);
    }

    public boolean isShuffleEnabled() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHUFFLE, (Object)false);
    }

    public void setShuffleEnabled(boolean shuffleEnabled) {
        this.upgrade.set(ModCoreDataComponents.SHUFFLE, (Object)shuffleEnabled);
        this.save();
        this.initPlaylist(true);
    }

    public RepeatMode getRepeatMode() {
        return (RepeatMode)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.REPEAT_MODE, (Object)RepeatMode.NO));
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        this.upgrade.set(ModCoreDataComponents.REPEAT_MODE, (Object)repeatMode);
        this.save();
    }

    public ItemStack getDisc() {
        return this.getDiscSlotActive() > -1 ? this.discInventory.getStackInSlot(this.getDiscSlotActive()) : ItemStack.EMPTY;
    }

    public int getDiscSlotActive() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.DISC_SLOT_ACTIVE, (Object)-1);
    }

    private void setDiscSlotActive(int discSlotActive) {
        this.upgrade.set(ModCoreDataComponents.DISC_SLOT_ACTIVE, (Object)discSlotActive);
        this.save();
    }

    public void play(Level level, BlockPos pos) {
        if (this.isPlaying) {
            return;
        }
        this.levelPlaying = level;
        this.posPlaying = pos;
        this.playNext();
    }

    public void play(Entity entity) {
        if (this.isPlaying) {
            return;
        }
        this.entityPlaying = entity;
        this.playNext();
    }

    private void playDisc() {
        ServerLevel serverLevel;
        Level level;
        block5: {
            block4: {
                Level level2 = level = this.entityPlaying != null ? this.entityPlaying.level() : this.levelPlaying;
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (this.posPlaying != null || this.entityPlaying != null) break block5;
            }
            return;
        }
        if (this.getDisc().isEmpty()) {
            return;
        }
        this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> this.getJukeboxSongHolder(level).ifPresent(song -> {
            if (this.entityPlaying != null) {
                ServerStorageSoundHandler.startPlayingDisc(serverLevel, this.entityPlaying.position(), storageUuid, this.entityPlaying.getId(), (Holder<JukeboxSong>)song, this.onFinishedCallback);
            } else {
                ServerStorageSoundHandler.startPlayingDisc(serverLevel, this.posPlaying, storageUuid, (Holder<JukeboxSong>)song, this.onFinishedCallback);
            }
            this.upgrade.set(ModCoreDataComponents.DISC_FINISH_TIME, (Object)(level.getGameTime() + (long)((JukeboxSong)song.value()).lengthInTicks()));
        }));
        this.setIsPlaying(true);
    }

    public Optional<Holder<JukeboxSong>> getJukeboxSongHolder(Level level) {
        return JukeboxSong.fromStack((HolderLookup.Provider)level.registryAccess(), (ItemStack)this.getDisc());
    }

    private void onDiscFinished() {
        if (this.getRepeatMode() == RepeatMode.ONE) {
            this.playDisc();
        } else if (this.getRepeatMode() == RepeatMode.ALL) {
            this.playNext();
        } else {
            this.playNext(false);
        }
    }

    private void setIsPlaying(boolean playing) {
        this.isPlaying = playing;
        this.upgrade.set(ModCoreDataComponents.IS_PLAYING, (Object)playing);
        if (this.isPlaying) {
            this.storageWrapper.getRenderInfo().setUpgradeClientData(JukeboxUpgradeClientData.TYPE, new JukeboxUpgradeClientData(true));
        } else {
            this.removeClientData();
            this.setDiscSlotActive(-1);
        }
        this.save();
    }

    private void removeClientData() {
        this.storageWrapper.getRenderInfo().removeUpgradeClientData(JukeboxUpgradeClientData.TYPE);
    }

    public void stop(LivingEntity entity) {
        if (!(entity.level() instanceof ServerLevel)) {
            return;
        }
        this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.stopPlayingDisc(entity.level(), entity.position(), storageUuid));
        this.setIsPlaying(false);
        this.upgrade.remove(ModCoreDataComponents.DISC_FINISH_TIME);
        this.setDiscSlotActive(-1);
        this.playlist.clear();
        this.history.clear();
    }

    public IItemHandler getDiscInventory() {
        return this.discInventory;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (!level.isClientSide()) {
            if (!this.discsRemoved.isEmpty()) {
                this.discsRemoved.forEach(index -> {
                    this.playlist.remove(index);
                    this.history.remove(index);
                });
                this.discsRemoved.clear();
            }
            if (!this.discsAdded.isEmpty()) {
                this.playlist.addAll(this.discsAdded);
                this.discsAdded.clear();
            }
        }
        if (this.isPlaying && this.lastKeepAliveSendTime < level.getGameTime() - 5L) {
            this.storageWrapper.getContentsUuid().ifPresent(storageUuid -> ServerStorageSoundHandler.updateKeepAlive(storageUuid, level, Vec3.atCenterOf((Vec3i)pos), () -> this.setIsPlaying(false)));
            this.lastKeepAliveSendTime = level.getGameTime();
        }
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void onBeforeRemoved() {
        this.removeClientData();
    }

    public void next() {
        if (!this.isPlaying) {
            return;
        }
        this.playNext();
    }

    public void playNext() {
        this.playNext(true);
    }

    public void playNext(boolean startOverIfAtTheEnd) {
        Integer discIndex;
        if (this.playlist.isEmpty() && startOverIfAtTheEnd) {
            this.initPlaylist(false);
        }
        if (this.playlist.isEmpty()) {
            return;
        }
        if (this.getDiscSlotActive() != -1) {
            this.history.add(this.getDiscSlotActive());
            if (this.history.size() > this.discInventory.getSlots()) {
                this.history.poll();
            }
        }
        if ((discIndex = this.playlist.poll()) == null) {
            return;
        }
        this.setDiscSlotActive(discIndex);
        this.playDisc();
    }

    private void initPlaylist(boolean excludeActive) {
        this.playlist.clear();
        for (int i = 0; i < this.discInventory.getSlots(); ++i) {
            if (this.discInventory.getStackInSlot(i).isEmpty() || excludeActive && this.isPlaying && i == this.getDiscSlotActive()) continue;
            this.playlist.add(i);
        }
        if (this.isShuffleEnabled()) {
            Collections.shuffle(this.playlist);
        }
    }

    public void previous() {
        if (!this.isPlaying) {
            return;
        }
        this.playPrevious();
    }

    public void playPrevious() {
        if (this.history.isEmpty()) {
            return;
        }
        this.playlist.addFirst(this.getDiscSlotActive());
        Integer discIndex = this.history.pollLast();
        if (discIndex == null) {
            return;
        }
        this.setDiscSlotActive(discIndex);
        this.playDisc();
    }

    public long getDiscFinishTime() {
        return (Long)this.upgrade.getOrDefault(ModCoreDataComponents.DISC_FINISH_TIME, (Object)0L);
    }
}

