/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderHelper;
import net.p3pp3rf1y.sophisticatedcore.client.render.BlockHighlightRenderer;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;
import net.p3pp3rf1y.sophisticatedcore.util.VoxelOutliner;

public class EntityHighlightRenderer {
    public static final int HIGHLIGHT_DURATION = 40;
    private static long highlightExpireTime = 0L;
    private static Map<Integer, List<Integer>> highlightedStackEntityIds = new HashMap<Integer, List<Integer>>();

    public static void addHighlightedEntities(Map<Integer, List<Integer>> highlightEntities) {
        highlightEntities.forEach((color, entityIds) -> highlightedStackEntityIds.computeIfAbsent((Integer)color, k -> new ArrayList()).addAll(entityIds));
        highlightExpireTime = Minecraft.getInstance().level.getGameTime() + 40L;
    }

    public static void render(PoseStack poseStack, float partialTick, Vec3 cameraPos) {
        Minecraft mc = Minecraft.getInstance();
        if (highlightExpireTime < mc.level.getGameTime()) {
            if (!highlightedStackEntityIds.isEmpty()) {
                highlightedStackEntityIds.clear();
            }
            return;
        }
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        highlightedStackEntityIds.forEach((color, highlightedEntities) -> highlightedEntities.forEach(he -> EntityHighlightRenderer.renderHighlightedEntity(poseStack, partialTick, cameraPos, he, mc, buffer, color)));
    }

    private static void renderHighlightedEntity(PoseStack poseStack, float partialTick, Vec3 cameraPos, int entityId, Minecraft mc, MultiBufferSource.BufferSource buffer, int color) {
        Entity entity = mc.level.getEntity(entityId);
        if (entity == null) {
            return;
        }
        AABB boundingBox = entity.getBoundingBox();
        double x = Mth.lerp((double)partialTick, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)partialTick, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)partialTick, (double)entity.zOld, (double)entity.getZ());
        poseStack.pushPose();
        double halfH = boundingBox.getYsize() * 0.5;
        poseStack.translate(x - cameraPos.x(), y - cameraPos.y(), z - cameraPos.z());
        poseStack.translate(0.0, halfH, 0.0);
        float scale = 1.0f + Easing.EASE_IN_OUT_CUBIC.ease((float)BlockHighlightRenderer.tri01((double)mc.level.getGameTime(), (double)15.0, (double)partialTick)) * 0.05f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, -halfH, 0.0);
        BlockHighlightRenderHelper.renderThickEdges((PoseStack)poseStack, (MultiBufferSource)buffer, (int)color, (List)VoxelOutliner.edgesFromAABB((AABB)boundingBox), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ());
        poseStack.popPose();
    }
}

