/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.perigrine3.createcybernetics.client.ModKeyMappings;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.network.payload.OpenArmCannonPayload;
import com.perigrine3.createcybernetics.network.payload.OpenSpinalInjectorPayload;
import com.perigrine3.createcybernetics.screen.custom.ArmCannonWheelScreen;
import com.perigrine3.createcybernetics.screen.custom.CyberwareToggleWheelScreen;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class KeybindClientHandler {
    private KeybindClientHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Record payload;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        while (((KeyMapping)ModKeyMappings.CYBERWARE_WHEEL.get()).consumeClick()) {
            if (CyberwareToggleWheelScreen.isWheelOpen()) {
                CyberwareToggleWheelScreen.closeWheel();
                if (mc.screen == null) continue;
                mc.setScreen(null);
                continue;
            }
            mc.setScreen((Screen)new CyberwareToggleWheelScreen());
        }
        while (((KeyMapping)ModKeyMappings.ARM_CANNON_WHEEL.get()).consumeClick()) {
            PlayerCyberwareData data;
            if (ArmCannonWheelScreen.isOpen()) {
                ArmCannonWheelScreen.close();
                if (mc.screen == null) continue;
                mc.setScreen(null);
                continue;
            }
            ArmCannonWheelScreen.open(4);
            if (mc.player != null && mc.player.hasData(ModAttachments.CYBERWARE) && (data = (PlayerCyberwareData)mc.player.getData(ModAttachments.CYBERWARE)) != null) {
                ArmCannonWheelScreen.setPreselectedIndex(data.getArmCannonSelected());
            }
            mc.setScreen((Screen)new ArmCannonWheelScreen());
        }
        while (((KeyMapping)ModKeyMappings.SPINAL_INJECTOR.get()).consumeClick()) {
            if (mc.screen != null) continue;
            payload = new OpenSpinalInjectorPayload();
            PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (((KeyMapping)ModKeyMappings.ARM_CANNON.get()).consumeClick()) {
            if (mc.screen != null) continue;
            payload = new OpenArmCannonPayload();
            PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void passthroughMovementKeys(Minecraft mc) {
        KeybindClientHandler.passthrough(mc, mc.options.keyUp);
        KeybindClientHandler.passthrough(mc, mc.options.keyDown);
        KeybindClientHandler.passthrough(mc, mc.options.keyLeft);
        KeybindClientHandler.passthrough(mc, mc.options.keyRight);
        KeybindClientHandler.passthrough(mc, mc.options.keyJump);
        KeybindClientHandler.passthrough(mc, mc.options.keySprint);
        KeybindClientHandler.passthrough(mc, mc.options.keyShift);
    }

    private static void passthrough(Minecraft mc, KeyMapping key) {
        long window = mc.getWindow().getWindow();
        InputConstants.Key k = key.getKey();
        boolean down = k.getType() == InputConstants.Type.MOUSE ? GLFW.glfwGetMouseButton((long)window, (int)k.getValue()) == 1 : InputConstants.isKeyDown((long)window, (int)k.getValue());
        if (key.isDown() != down) {
            key.setDown(down);
        }
    }
}

