/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.cyberware.CybereyeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="createcybernetics", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class MissingEyesOverlayClient {
    private static final int ALPHA = 255;

    private MissingEyesOverlayClient() {
    }

    @SubscribeEvent
    public static void onRenderGuiPre(RenderGuiEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (mc.screen != null) {
            return;
        }
        PlayerCyberwareData data = (PlayerCyberwareData)mc.player.getData(ModAttachments.CYBERWARE);
        if (data == null) {
            return;
        }
        boolean eyesEnabled = MissingEyesOverlayClient.hasCybereyesInstalledAndEnabled(data);
        if (!eyesEnabled) {
            return;
        }
        boolean blinded = mc.player.hasEffect(MobEffects.BLINDNESS);
        boolean darkened = mc.player.hasEffect(MobEffects.DARKNESS);
        if (!blinded && !darkened) {
            return;
        }
        GuiGraphics gg = event.getGuiGraphics();
        int w = mc.getWindow().getGuiScaledWidth();
        int h = mc.getWindow().getGuiScaledHeight();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int argb = -16777216;
        gg.fill(0, 0, w, h, argb);
        RenderSystem.disableBlend();
    }

    private static boolean hasCybereyesInstalledAndEnabled(PlayerCyberwareData data) {
        InstalledCyberware[] arr = data.getAll().get((Object)CyberwareSlot.EYES);
        if (arr == null) {
            return false;
        }
        for (int idx = 0; idx < arr.length; ++idx) {
            ItemStack st;
            InstalledCyberware cw = arr[idx];
            if (cw == null || (st = cw.getItem()) == null || st.isEmpty() || !(st.getItem() instanceof CybereyeItem) || !data.isEnabled(CyberwareSlot.EYES, idx)) continue;
            return true;
        }
        return false;
    }
}

