/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.perigrine3.createcybernetics.effect.ModEffects;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="createcybernetics", value={Dist.CLIENT})
public final class SandevistanMirageTrail {
    private static final int RENDER_SNAPSHOTS = 241;
    private static final int TRAIL_LIFETIME_TICKS = 240;
    private static final float MIRAGE_MODEL_SCALE = 0.9375f;
    private static final double RENDER_DELAY_TICKS = 0.6725;
    private static final double SAMPLES_PER_SECOND = 60.0;
    private static final double SAMPLE_PERIOD_TICKS = 0.3333333333333333;
    private static final float MIN_CAMERA_DIST = 0.55f;
    private static final float MIN_CAMERA_DIST_SQR = 0.3025f;
    private static final int MAX_SNAPSHOTS = Math.max((int)Math.ceil(720.0) + 2, 241 + (int)Math.ceil(2.0175) + 2);
    private static final Map<UUID, Deque<Snapshot>> TRAILS = new HashMap<UUID, Deque<Snapshot>>();
    private static double lastFrameTimeTicks = Double.NaN;
    private static double accumulatorTicks = 0.0;

    private SandevistanMirageTrail() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Iterator<Map.Entry<UUID, Deque<Snapshot>>> it = TRAILS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, Deque<Snapshot>> e = it.next();
            Deque<Snapshot> q = e.getValue();
            if (q == null || q.isEmpty()) {
                it.remove();
                continue;
            }
            for (Snapshot s : q) {
                ++s.ageTicks;
            }
            while (!q.isEmpty() && q.peekFirst().ageTicks > 240) {
                q.pollFirst();
            }
            if (!q.isEmpty()) continue;
            it.remove();
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        if (poseStack == null) {
            return;
        }
        Vec3 camPos = event.getCamera().getPosition();
        float partial = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        SandevistanMirageTrail.recordSubTickSnapshots(mc, partial);
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        for (AbstractClientPlayer p : mc.level.players()) {
            EntityRenderer er;
            AbstractClientPlayer player;
            UUID id;
            Deque<Snapshot> q;
            if (!(p instanceof AbstractClientPlayer) || (q = TRAILS.get(id = (player = p).getUUID())) == null || q.isEmpty() || !((er = mc.getEntityRenderDispatcher().getRenderer((Entity)player)) instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)er;
            SandevistanMirageTrail.renderTrailForPlayer(poseStack, (MultiBufferSource)buffer, playerRenderer, player, q, camPos, partial);
        }
        buffer.endBatch();
    }

    private static void recordSubTickSnapshots(Minecraft mc, float currentPartial) {
        if (mc.level == null) {
            return;
        }
        double nowTimeTicks = (double)mc.level.getGameTime() + (double)currentPartial;
        if (Double.isNaN(lastFrameTimeTicks)) {
            lastFrameTimeTicks = nowTimeTicks;
            accumulatorTicks = 0.0;
            return;
        }
        double deltaTicks = nowTimeTicks - lastFrameTimeTicks;
        if (deltaTicks < 0.0) {
            deltaTicks = 0.0;
        }
        if (deltaTicks > 5.0) {
            deltaTicks = 5.0;
        }
        lastFrameTimeTicks = nowTimeTicks;
        accumulatorTicks += deltaTicks;
        while (accumulatorTicks >= 0.3333333333333333) {
            double sampleTimeTicks = nowTimeTicks - (accumulatorTicks -= 0.3333333333333333);
            float samplePartial = (float)(sampleTimeTicks - Math.floor(sampleTimeTicks));
            samplePartial = Mth.clamp((float)samplePartial, (float)0.0f, (float)1.0f);
            for (AbstractClientPlayer p : mc.level.players()) {
                if (!(p instanceof AbstractClientPlayer)) continue;
                AbstractClientPlayer player = p;
                boolean active = player.hasEffect(ModEffects.SANDEVISTAN_EFFECT) && player.isSprinting();
                UUID id = player.getUUID();
                if (!active) {
                    TRAILS.remove(id);
                    continue;
                }
                double x = Mth.lerp((double)samplePartial, (double)player.xo, (double)player.getX());
                double y = Mth.lerp((double)samplePartial, (double)player.yo, (double)player.getY());
                double z = Mth.lerp((double)samplePartial, (double)player.zo, (double)player.getZ());
                float bodyYaw = SandevistanMirageTrail.rotLerp(samplePartial, player.yRotO, player.getYRot());
                float headYaw = SandevistanMirageTrail.rotLerp(samplePartial, player.yHeadRotO, player.getYHeadRot());
                float pitch = SandevistanMirageTrail.rotLerp(samplePartial, player.xRotO, player.getXRot());
                float limbSwing = SandevistanMirageTrail.safeWalkPosition(player, samplePartial);
                float limbSwingAmount = SandevistanMirageTrail.safeWalkSpeed(player, samplePartial);
                Snapshot snap = new Snapshot(new Vec3(x, y, z), bodyYaw, headYaw, pitch, player.isCrouching(), limbSwing, limbSwingAmount, (float)sampleTimeTicks);
                Deque q = TRAILS.computeIfAbsent(id, k -> new ArrayDeque());
                q.addLast(snap);
                while (q.size() > MAX_SNAPSHOTS) {
                    q.pollFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderTrailForPlayer(PoseStack poseStack, MultiBufferSource buffer, PlayerRenderer playerRenderer, AbstractClientPlayer player, Deque<Snapshot> q, Vec3 camPos, float partial) {
        PlayerModel model = (PlayerModel)playerRenderer.getModel();
        Minecraft mc = Minecraft.getInstance();
        boolean isLocalFirstPerson = mc.player != null && mc.player.getUUID().equals(player.getUUID()) && mc.options.getCameraType() == CameraType.FIRST_PERSON;
        HumanoidModel.ArmPose prevRightPose = model.rightArmPose;
        HumanoidModel.ArmPose prevLeftPose = model.leftArmPose;
        boolean prevCrouching = model.crouching;
        float prevSwimAmount = model.swimAmount;
        float prevAttackTime = model.attackTime;
        boolean prevHat = model.hat.visible;
        boolean prevJacket = model.jacket.visible;
        boolean prevLeftSleeve = model.leftSleeve.visible;
        boolean prevRightSleeve = model.rightSleeve.visible;
        boolean prevLeftPants = model.leftPants.visible;
        boolean prevRightPants = model.rightPants.visible;
        boolean prevYoung = model.young;
        try {
            model.young = false;
            model.hat.visible = true;
            model.jacket.visible = true;
            model.leftSleeve.visible = true;
            model.rightSleeve.visible = true;
            model.leftPants.visible = true;
            model.rightPants.visible = true;
            Snapshot[] arr = q.toArray(new Snapshot[0]);
            int delaySamples = (int)Math.ceil(2.0175);
            int endExclusive = Math.max(0, arr.length - delaySamples);
            if (endExclusive <= 0) {
                return;
            }
            int start = Math.max(0, endExclusive - 241);
            int renderCount = endExclusive - start;
            if (renderCount <= 0) {
                return;
            }
            for (int i = start; i < endExclusive; ++i) {
                Vec3 toCam;
                int aBody;
                Snapshot s = arr[i];
                float t = (float)s.ageTicks / 240.0f;
                if (t < 0.0f || t > 1.0f) continue;
                float alpha = 1.0f - t;
                if ((aBody = (int)((alpha *= alpha) * 170.0f)) <= 0) continue;
                float indexNorm = (float)(i - start) / (float)Math.max(1, renderCount - 1);
                float baseHue = ((float)player.tickCount + partial) * 0.01f % 1.0f;
                float hue = (baseHue + indexNorm) % 1.0f;
                int rgb = Mth.hsvToRgb((float)hue, (float)0.9f, (float)1.0f);
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                Vec3 renderPos = s.pos;
                if (isLocalFirstPerson && (toCam = renderPos.subtract(camPos)).lengthSqr() < (double)0.3025f) continue;
                model.attackTime = 0.0f;
                model.crouching = s.crouching;
                model.swimAmount = 0.0f;
                model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
                model.leftArmPose = HumanoidModel.ArmPose.EMPTY;
                float netHeadYaw = SandevistanMirageTrail.wrapDegrees(s.headYaw - s.bodyYaw);
                model.setupAnim((LivingEntity)player, s.limbSwing, s.limbSwingAmount, s.ageInTicks, netHeadYaw, s.pitch);
                double dx = renderPos.x - camPos.x;
                double dy = renderPos.y - camPos.y;
                double dz = renderPos.z - camPos.z;
                poseStack.pushPose();
                try {
                    poseStack.translate(dx, dy, dz);
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - s.bodyYaw));
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    poseStack.scale(0.9375f, 0.9375f, 0.9375f);
                    poseStack.translate(0.0f, -1.6010667f, 0.0f);
                    int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)player.level(), (BlockPos)BlockPos.containing((double)renderPos.x, (double)renderPos.y, (double)renderPos.z));
                    int bodyColor = FastColor.ARGB32.color((int)aBody, (int)r, (int)g, (int)b);
                    ResourceLocation skin = player.getSkin().texture();
                    VertexConsumer vcBody = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)skin));
                    model.renderToBuffer(poseStack, vcBody, packedLight, OverlayTexture.NO_OVERLAY, bodyColor);
                    continue;
                }
                finally {
                    poseStack.popPose();
                }
            }
        }
        finally {
            model.rightArmPose = prevRightPose;
            model.leftArmPose = prevLeftPose;
            model.crouching = prevCrouching;
            model.swimAmount = prevSwimAmount;
            model.attackTime = prevAttackTime;
            model.hat.visible = prevHat;
            model.jacket.visible = prevJacket;
            model.leftSleeve.visible = prevLeftSleeve;
            model.rightSleeve.visible = prevRightSleeve;
            model.leftPants.visible = prevLeftPants;
            model.rightPants.visible = prevRightPants;
            model.young = prevYoung;
        }
    }

    private static float safeWalkPosition(AbstractClientPlayer player, float partial) {
        try {
            float f;
            WalkAnimationState wa = player.walkAnimation;
            Method m = wa.getClass().getMethod("position", Float.TYPE);
            Object r = m.invoke((Object)wa, Float.valueOf(partial));
            if (r instanceof Float) {
                Float f2 = (Float)r;
                f = f2.floatValue();
            } else {
                f = 0.0f;
            }
            return f;
        }
        catch (Throwable ignored1) {
            try {
                float f;
                WalkAnimationState wa = player.walkAnimation;
                Method m = wa.getClass().getMethod("position", new Class[0]);
                Object r = m.invoke((Object)wa, new Object[0]);
                if (r instanceof Float) {
                    Float f3 = (Float)r;
                    f = f3.floatValue();
                } else {
                    f = 0.0f;
                }
                return f;
            }
            catch (Throwable ignored2) {
                return 0.0f;
            }
        }
    }

    private static float safeWalkSpeed(AbstractClientPlayer player, float partial) {
        try {
            float f;
            WalkAnimationState wa = player.walkAnimation;
            Method m = wa.getClass().getMethod("speed", Float.TYPE);
            Object r = m.invoke((Object)wa, Float.valueOf(partial));
            if (r instanceof Float) {
                Float f2 = (Float)r;
                f = f2.floatValue();
            } else {
                f = 0.0f;
            }
            return f;
        }
        catch (Throwable ignored1) {
            try {
                float f;
                WalkAnimationState wa = player.walkAnimation;
                Method m = wa.getClass().getMethod("speed", new Class[0]);
                Object r = m.invoke((Object)wa, new Object[0]);
                if (r instanceof Float) {
                    Float f3 = (Float)r;
                    f = f3.floatValue();
                } else {
                    f = 0.0f;
                }
                return f;
            }
            catch (Throwable ignored2) {
                return 0.0f;
            }
        }
    }

    private static float wrapDegrees(float deg) {
        if ((deg %= 360.0f) >= 180.0f) {
            deg -= 360.0f;
        }
        if (deg < -180.0f) {
            deg += 360.0f;
        }
        return deg;
    }

    private static float rotLerp(float t, float a, float b) {
        float delta = SandevistanMirageTrail.wrapDegrees(b - a);
        return a + delta * t;
    }

    private static final class Snapshot {
        final Vec3 pos;
        final float bodyYaw;
        final float headYaw;
        final float pitch;
        final boolean crouching;
        final float limbSwing;
        final float limbSwingAmount;
        final float ageInTicks;
        int ageTicks;

        Snapshot(Vec3 pos, float bodyYaw, float headYaw, float pitch, boolean crouching, float limbSwing, float limbSwingAmount, float ageInTicks) {
            this.pos = pos;
            this.bodyYaw = bodyYaw;
            this.headYaw = headYaw;
            this.pitch = pitch;
            this.crouching = crouching;
            this.limbSwing = limbSwing;
            this.limbSwingAmount = limbSwingAmount;
            this.ageInTicks = ageInTicks;
            this.ageTicks = 0;
        }
    }
}

