/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.client.skin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.perigrine3.createcybernetics.client.skin.SkinHighlight;
import com.perigrine3.createcybernetics.client.skin.SkinModifierManager;
import com.perigrine3.createcybernetics.client.skin.SkinModifierState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class SkinHighlightLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public SkinHighlightLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parent) {
        super(parent);
    }

    private static boolean shouldRenderOverlaysFor(AbstractClientPlayer target) {
        Player viewer;
        Minecraft mc = Minecraft.getInstance();
        Entity cam = mc.getCameraEntity();
        return !(cam instanceof Player ? target.isInvisibleTo(viewer = (Player)cam) : target.isInvisible());
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!SkinHighlightLayer.shouldRenderOverlaysFor(player)) {
            return;
        }
        SkinModifierState state = SkinModifierManager.getPlayerSkinState(player);
        if (state == null || !state.hasHighlights()) {
            return;
        }
        PlayerSkin.Model modelType = player.getSkin().model();
        for (SkinHighlight highlight : state.getHighlights()) {
            if (highlight == null) continue;
            ResourceLocation tex = highlight.getTexture(modelType);
            int light = highlight.isEmissive() ? 0xF000F0 : packedLight;
            RenderType rt = RenderType.entityTranslucent((ResourceLocation)tex);
            int color = highlight.isEmissive() ? -1 : highlight.getColor();
            VertexConsumer vc = buffer.getBuffer(rt);
            ((PlayerModel)this.getParentModel()).renderToBuffer(poseStack, vc, light, OverlayTexture.NO_OVERLAY, color);
        }
    }
}

