/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.client.skin;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.client.skin.SkinHighlight;
import com.perigrine3.createcybernetics.client.skin.SkinHighlightRender;
import com.perigrine3.createcybernetics.client.skin.SkinModifier;
import com.perigrine3.createcybernetics.client.skin.SkinModifierState;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.ModItems;
import com.perigrine3.createcybernetics.util.ModTags;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;

public class SkinModifierManager {
    private static final Map<UUID, SkinModifierState> PLAYER_STATES = new HashMap<UUID, SkinModifierState>();
    private static final ResourceLocation MISSING_SKIN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/playermuscles_wide.png");
    private static final ResourceLocation CYBEREYES_PRIMARY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/cybereyes_dye_primary.png");
    private static final ResourceLocation CYBEREYES_SECONDARYY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/cybereyes_dye_secondary.png");
    private static final ResourceLocation RIGHT_CYBERLEG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberleg.png");
    private static final ResourceLocation RIGHT_CYBERLEG_PRIMARY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberleg_dye_primary.png");
    private static final ResourceLocation RIGHT_CYBERLEG_SECONDARY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberleg_dye_secondary.png");
    private static final ResourceLocation LEFT_CYBERLEG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberleg.png");
    private static final ResourceLocation LEFT_CYBERLEG_PRIMARY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberleg_dye_primary.png");
    private static final ResourceLocation LEFT_CYBERLEG_SECONDARY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberleg_dye_secondary.png");
    private static final ResourceLocation FULL_BODY_HIGHLIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/full_body_highlight.png");
    private static final ResourceLocation POLAR_BEAR_FUR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/polar_bear_fur.png");
    private static final ResourceLocation SPINAL_INJECTOR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/spinal_injector.png");
    private static final ResourceLocation SPINAL_INJECTOR_HIGHLIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/spinal_injector_highlight.png");
    private static final ResourceLocation SANDEVISTAN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/sandevistan.png");
    private static final ResourceLocation SANDEVISTAN_HIGHLIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/sandevistan_highlight.png");
    private static final ResourceLocation LEFT_CYBERARM_TEXTURE_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_wide.png");
    private static final ResourceLocation LEFT_CYBERARM_PRIMARY_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_dye_primary_wide.png");
    private static final ResourceLocation LEFT_CYBERARM_SECONDARY_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_dye_secondary_wide.png");
    private static final ResourceLocation RIGHT_CYBERARM_TEXTURE_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_wide.png");
    private static final ResourceLocation RIGHT_CYBERARM_PRIMARY_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_dye_primary_wide.png");
    private static final ResourceLocation RIGHT_CYBERARM_SECONDARY_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_dye_secondary_wide.png");
    private static final ResourceLocation FULLBODYCONVERSION_TEXTURE_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/full_body_conversion_wide.png");
    private static final ResourceLocation SYNTHSKIN_TEXTURE_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/synthskin_wide.png");
    private static final ResourceLocation NETHERPLATED_SKIN_TEXTURE_WIDE = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/isothermal_skin_wide.png");
    private static final ResourceLocation LEFT_CYBERARM_TEXTURE_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_slim.png");
    private static final ResourceLocation LEFT_CYBERARM_PRIMARY_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_dye_primary_slim.png");
    private static final ResourceLocation LEFT_CYBERARM_SECONDARY_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/left_cyberarm_dye_secondary_slim.png");
    private static final ResourceLocation RIGHT_CYBERARM_TEXTURE_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_slim.png");
    private static final ResourceLocation RIGHT_CYBERARM_PRIMARY_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_dye_primary_slim.png");
    private static final ResourceLocation RIGHT_CYBERARM_SECONDARY_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/right_cyberarm_dye_secondary_slim.png");
    private static final ResourceLocation FULLBODYCONVERSION_TEXTURE_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/full_body_conversion_slim.png");
    private static final ResourceLocation SYNTHSKIN_TEXTURE_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/synthskin_slim.png");
    private static final ResourceLocation NETHERPLATED_SKIN_TEXTURE_SLIM = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/entity/isothermal_skin_slim.png");

    public static SkinModifierState getPlayerSkinState(AbstractClientPlayer player) {
        int tint;
        if (!player.hasData(ModAttachments.CYBERWARE)) {
            return null;
        }
        PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
        if (data == null) {
            return null;
        }
        UUID playerId = player.getUUID();
        SkinModifierState state = PLAYER_STATES.computeIfAbsent(playerId, k -> new SkinModifierState());
        state.clearModifiers();
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_CYBEREYES.get(), CyberwareSlot.EYES) && data.isDyed((Item)ModItems.BASECYBERWARE_CYBEREYES.get(), CyberwareSlot.EYES)) {
            tint = data.dyeColor((Item)ModItems.BASECYBERWARE_CYBEREYES.get(), CyberwareSlot.EYES);
            state.addModifier(new SkinModifier(CYBEREYES_PRIMARY, CYBEREYES_PRIMARY, tint, false));
            state.addHighlight(new SkinHighlight(CYBEREYES_PRIMARY, CYBEREYES_PRIMARY, tint, false));
        }
        if (data.hasSpecificItem((Item)ModItems.SKINUPGRADES_NETHERITEPLATING.get(), CyberwareSlot.SKIN)) {
            state.removeModifier(new SkinModifier(LEFT_CYBERLEG_TEXTURE, LEFT_CYBERLEG_TEXTURE));
            state.removeModifier(new SkinModifier(RIGHT_CYBERLEG_TEXTURE, RIGHT_CYBERLEG_TEXTURE));
            state.removeModifier(new SkinModifier(LEFT_CYBERARM_TEXTURE_WIDE, LEFT_CYBERARM_TEXTURE_SLIM));
            state.removeModifier(new SkinModifier(RIGHT_CYBERARM_TEXTURE_WIDE, RIGHT_CYBERARM_TEXTURE_SLIM));
            state.removeModifier(new SkinModifier(FULLBODYCONVERSION_TEXTURE_WIDE, FULLBODYCONVERSION_TEXTURE_SLIM));
            state.removeModifier(new SkinModifier(SYNTHSKIN_TEXTURE_WIDE, SYNTHSKIN_TEXTURE_SLIM));
            state.addModifier(new SkinModifier(NETHERPLATED_SKIN_TEXTURE_WIDE, NETHERPLATED_SKIN_TEXTURE_SLIM, -1, true));
            return state;
        }
        if (data.hasSpecificItem((Item)ModItems.SKINUPGRADES_SYNTHSKIN.get(), CyberwareSlot.SKIN)) {
            int alpha = 100;
            int tint2 = FastColor.ARGB32.color((int)alpha, (int)255, (int)255, (int)255);
            state.removeModifier(new SkinModifier(LEFT_CYBERLEG_TEXTURE, LEFT_CYBERLEG_TEXTURE));
            state.removeModifier(new SkinModifier(RIGHT_CYBERLEG_TEXTURE, RIGHT_CYBERLEG_TEXTURE));
            state.removeModifier(new SkinModifier(LEFT_CYBERARM_TEXTURE_WIDE, LEFT_CYBERARM_TEXTURE_SLIM));
            state.removeModifier(new SkinModifier(RIGHT_CYBERARM_TEXTURE_WIDE, RIGHT_CYBERARM_TEXTURE_SLIM));
            state.removeModifier(new SkinModifier(FULLBODYCONVERSION_TEXTURE_WIDE, FULLBODYCONVERSION_TEXTURE_SLIM));
            if (data.hasSpecificItem((Item)ModItems.WETWARE_POLARBEARFUR.get(), CyberwareSlot.SKIN)) {
                state.addModifier(new SkinModifier(POLAR_BEAR_FUR_TEXTURE, POLAR_BEAR_FUR_TEXTURE));
            }
            state.addModifier(new SkinModifier(SYNTHSKIN_TEXTURE_WIDE, SYNTHSKIN_TEXTURE_SLIM, tint2, false, EnumSet.noneOf(SkinModifier.HideVanilla.class), EnumSet.noneOf(HumanoidArm.class), true));
            return state;
        }
        if (data.hasSpecificItem((Item)ModItems.WETWARE_POLARBEARFUR.get(), CyberwareSlot.SKIN)) {
            state.addModifier(new SkinModifier(POLAR_BEAR_FUR_TEXTURE, POLAR_BEAR_FUR_TEXTURE, -1, true));
        }
        if (!data.hasAnyTagged(ModTags.Items.SKIN_ITEMS, CyberwareSlot.SKIN)) {
            state.addModifier(new SkinModifier(MISSING_SKIN_TEXTURE, MISSING_SKIN_TEXTURE, -1, true));
        }
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_LEFTLEG.get(), CyberwareSlot.LLEG)) {
            state.addModifier(new SkinModifier(LEFT_CYBERLEG_TEXTURE, LEFT_CYBERLEG_TEXTURE, -1, false, EnumSet.of(SkinModifier.HideVanilla.LEFT_PANTS)));
            if (data.isDyed((Item)ModItems.BASECYBERWARE_LEFTLEG.get(), CyberwareSlot.LLEG)) {
                tint = data.dyeColor((Item)ModItems.BASECYBERWARE_LEFTLEG.get(), CyberwareSlot.LLEG);
                state.addModifier(new SkinModifier(LEFT_CYBERLEG_PRIMARY, LEFT_CYBERLEG_PRIMARY, tint, false, EnumSet.of(SkinModifier.HideVanilla.LEFT_PANTS)));
            }
        }
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_RIGHTLEG.get(), CyberwareSlot.RLEG)) {
            state.addModifier(new SkinModifier(RIGHT_CYBERLEG_TEXTURE, RIGHT_CYBERLEG_TEXTURE, -1, false, EnumSet.of(SkinModifier.HideVanilla.RIGHT_PANTS)));
            if (data.isDyed((Item)ModItems.BASECYBERWARE_RIGHTLEG.get(), CyberwareSlot.RLEG)) {
                tint = data.dyeColor((Item)ModItems.BASECYBERWARE_RIGHTLEG.get(), CyberwareSlot.RLEG);
                state.addModifier(new SkinModifier(RIGHT_CYBERLEG_PRIMARY, RIGHT_CYBERLEG_PRIMARY, tint, false, EnumSet.of(SkinModifier.HideVanilla.RIGHT_PANTS)));
            }
        }
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_LEFTARM.get(), CyberwareSlot.LARM)) {
            state.addModifier(new SkinModifier(LEFT_CYBERARM_TEXTURE_WIDE, LEFT_CYBERARM_TEXTURE_SLIM, -1, false, EnumSet.of(SkinModifier.HideVanilla.LEFT_SLEEVE), EnumSet.of(HumanoidArm.LEFT)));
            if (data.isDyed((Item)ModItems.BASECYBERWARE_LEFTARM.get(), CyberwareSlot.LARM)) {
                tint = data.dyeColor((Item)ModItems.BASECYBERWARE_LEFTARM.get(), CyberwareSlot.LARM);
                state.addModifier(new SkinModifier(LEFT_CYBERARM_PRIMARY_WIDE, LEFT_CYBERARM_PRIMARY_SLIM, tint, false, EnumSet.of(SkinModifier.HideVanilla.LEFT_SLEEVE)));
            }
        }
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_RIGHTARM.get(), CyberwareSlot.RARM)) {
            state.addModifier(new SkinModifier(RIGHT_CYBERARM_TEXTURE_WIDE, RIGHT_CYBERARM_TEXTURE_SLIM, -1, false, EnumSet.of(SkinModifier.HideVanilla.RIGHT_SLEEVE), EnumSet.of(HumanoidArm.RIGHT)));
            if (data.isDyed((Item)ModItems.BASECYBERWARE_RIGHTARM.get(), CyberwareSlot.RARM)) {
                tint = data.dyeColor((Item)ModItems.BASECYBERWARE_RIGHTARM.get(), CyberwareSlot.RARM);
                state.addModifier(new SkinModifier(RIGHT_CYBERARM_PRIMARY_WIDE, RIGHT_CYBERARM_PRIMARY_SLIM, tint, false, EnumSet.of(SkinModifier.HideVanilla.LEFT_SLEEVE)));
            }
        }
        if (data.hasSpecificItem((Item)ModItems.BONEUPGRADES_SPINALINJECTOR.get(), CyberwareSlot.BONE)) {
            state.addModifier(new SkinModifier(SPINAL_INJECTOR_TEXTURE, SPINAL_INJECTOR_TEXTURE, -1, false));
            SkinHighlightRender.apply(state, true, SPINAL_INJECTOR_HIGHLIGHT_TEXTURE, SPINAL_INJECTOR_HIGHLIGHT_TEXTURE, -1, true);
        }
        if (data.hasSpecificItem((Item)ModItems.BONEUPGRADES_SANDEVISTAN.get(), CyberwareSlot.BONE)) {
            state.addModifier(new SkinModifier(SANDEVISTAN_TEXTURE, SANDEVISTAN_TEXTURE, -1, false));
            SkinHighlightRender.apply(state, true, SANDEVISTAN_HIGHLIGHT_TEXTURE, SANDEVISTAN_HIGHLIGHT_TEXTURE, -1, true);
        }
        if (data.hasSpecificItem((Item)ModItems.BASECYBERWARE_RIGHTARM.get(), CyberwareSlot.RARM) && data.hasSpecificItem((Item)ModItems.BASECYBERWARE_LEFTARM.get(), CyberwareSlot.LARM) && data.hasSpecificItem((Item)ModItems.BASECYBERWARE_RIGHTLEG.get(), CyberwareSlot.RLEG) && data.hasSpecificItem((Item)ModItems.BASECYBERWARE_LEFTLEG.get(), CyberwareSlot.LLEG) && data.hasSpecificItem((Item)ModItems.SKINUPGRADES_METALPLATING.get(), CyberwareSlot.SKIN) && !data.hasSpecificItem((Item)ModItems.BODYPART_SKIN.get(), CyberwareSlot.SKIN) && data.hasSpecificItem((Item)ModItems.MUSCLEUPGRADES_SYNTHMUSCLE.get(), CyberwareSlot.MUSCLE) && !data.hasSpecificItem((Item)ModItems.BODYPART_MUSCLE.get(), CyberwareSlot.MUSCLE) && data.hasSpecificItem((Item)ModItems.HEARTUPGRADES_CYBERHEART.get(), CyberwareSlot.HEART) && !data.hasSpecificItem((Item)ModItems.BODYPART_HEART.get(), CyberwareSlot.HEART) && data.hasSpecificItem((Item)ModItems.BASECYBERWARE_LINEARFRAME.get(), CyberwareSlot.BONE) && !data.hasSpecificItem((Item)ModItems.BODYPART_SKELETON.get(), CyberwareSlot.BONE) && data.hasSpecificItem((Item)ModItems.BASECYBERWARE_CYBEREYES.get(), CyberwareSlot.EYES) && !data.hasSpecificItem((Item)ModItems.BODYPART_EYEBALLS.get(), CyberwareSlot.EYES) && data.hasSpecificItem((Item)ModItems.BONEUPGRADES_BONELACING.get(), CyberwareSlot.BONE)) {
            state.addModifier(new SkinModifier(FULLBODYCONVERSION_TEXTURE_WIDE, FULLBODYCONVERSION_TEXTURE_SLIM, -1, true));
            SkinHighlightRender.apply(state, true, FULL_BODY_HIGHLIGHT_TEXTURE, FULL_BODY_HIGHLIGHT_TEXTURE, -1, true);
        }
        return state;
    }
}

