/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.common.capabilities;

import com.perigrine3.createcybernetics.ConfigValues;
import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareData;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.common.surgery.DefaultOrgans;
import com.perigrine3.createcybernetics.item.cyberware.ArmCannonItem;
import com.perigrine3.createcybernetics.item.cyberware.SpinalInjectorItem;
import com.perigrine3.createcybernetics.util.ModTags;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerCyberwareData
implements ICyberwareData {
    private static final String NBT_CYBERWARE = "Cyberware";
    private static final String NBT_HUMANITY = "Humanity";
    private static final String NBT_ENERGY = "Energy";
    private static final String NBT_NEUROPOZYNE_APPLY_COUNT = "NeuropozyneApplyCount";
    private int neuropozyneApplyCount = 0;
    private static final String NBT_SPINAL_INJECTOR_INV = "SpinalInjectorInv";
    private final ItemStack[] spinalInjectorInv = new ItemStack[4];
    private static final String NBT_ARM_CANNON_INV = "ArmCannonInv";
    private final ItemStack[] armCannonInv = new ItemStack[4];
    private static final String NBT_ARM_CANNON_SELECTED = "ArmCannonSelected";
    private int armCannonSelected = 0;
    public static final int CHIPWARE_SLOT_COUNT = 2;
    private static final String NBT_CHIPWARE_INV = "ChipwareInv";
    private final ItemStack[] chipwareInv = new ItemStack[2];
    private final EnumMap<CyberwareSlot, InstalledCyberware[]> slots = new EnumMap(CyberwareSlot.class);
    private final EnumMap<CyberwareSlot, boolean[]> enabled = new EnumMap(CyberwareSlot.class);
    private boolean dirty = false;
    private int humanity = ConfigValues.BASE_HUMANITY;
    private int humanityBonus = 0;
    private int energyStored = 0;

    public PlayerCyberwareData() {
        int i;
        for (CyberwareSlot slot : CyberwareSlot.values()) {
            this.slots.put(slot, new InstalledCyberware[slot.size]);
            boolean[] en = new boolean[slot.size];
            for (int i2 = 0; i2 < en.length; ++i2) {
                en[i2] = true;
            }
            this.enabled.put(slot, en);
        }
        for (i = 0; i < this.spinalInjectorInv.length; ++i) {
            this.spinalInjectorInv[i] = ItemStack.EMPTY;
        }
        for (i = 0; i < this.armCannonInv.length; ++i) {
            this.armCannonInv[i] = ItemStack.EMPTY;
        }
        for (i = 0; i < this.chipwareInv.length; ++i) {
            this.chipwareInv[i] = ItemStack.EMPTY;
        }
        this.armCannonSelected = 0;
    }

    @Override
    public InstalledCyberware get(CyberwareSlot slot, int index) {
        return this.slots.get((Object)slot)[index];
    }

    @Override
    public void set(CyberwareSlot slot, int index, InstalledCyberware cyberware) {
        this.slots.get((Object)((Object)slot))[index] = cyberware;
        boolean[] en = this.enabled.get((Object)slot);
        if (en != null && index >= 0 && index < en.length) {
            ICyberwareItem cwItem;
            Item item;
            ItemStack st;
            boolean enabledByDefault = true;
            if (cyberware != null && (st = cyberware.getItem()) != null && !st.isEmpty() && (item = st.getItem()) instanceof ICyberwareItem && (cwItem = (ICyberwareItem)item).isToggleableByWheel(st, slot)) {
                enabledByDefault = false;
            }
            en[index] = enabledByDefault;
        }
        this.dirty = true;
    }

    @Override
    public InstalledCyberware remove(CyberwareSlot slot, int index) {
        InstalledCyberware old = this.slots.get((Object)slot)[index];
        this.slots.get((Object)((Object)slot))[index] = null;
        boolean[] en = this.enabled.get((Object)slot);
        if (en != null && index >= 0 && index < en.length) {
            en[index] = true;
        }
        this.dirty = true;
        return old;
    }

    @Override
    public Map<CyberwareSlot, InstalledCyberware[]> getAll() {
        return this.slots;
    }

    @Override
    public int getHumanity() {
        return this.humanity + this.humanityBonus;
    }

    @Override
    public void setHumanity(int value) {
        this.humanity = value;
        this.dirty = true;
    }

    public int getHumanityBase() {
        return this.humanity;
    }

    public int getHumanityBonus() {
        return this.humanityBonus;
    }

    public void setHumanityBonus(int bonus) {
        int clamped = Mth.clamp((int)bonus, (int)0, (int)1000);
        if (clamped != this.humanityBonus) {
            this.humanityBonus = clamped;
            this.dirty = true;
        }
    }

    public void clearHumanityBonus() {
        this.setHumanityBonus(0);
    }

    public void recomputeHumanityBaseFromInstalled() {
        int base = ConfigValues.BASE_HUMANITY;
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : this.slots.entrySet()) {
            InstalledCyberware[] arr = entry.getValue();
            if (arr == null) continue;
            for (InstalledCyberware cw : arr) {
                Item item;
                ItemStack stack;
                if (cw == null || (stack = cw.getItem()) == null || stack.isEmpty() || !((item = stack.getItem()) instanceof ICyberwareItem)) continue;
                ICyberwareItem item2 = (ICyberwareItem)item;
                base -= item2.getHumanityCost();
            }
        }
        this.humanity = Math.max(0, base);
        this.dirty = true;
    }

    public int getArmCannonSelected() {
        return Mth.clamp((int)this.armCannonSelected, (int)0, (int)3);
    }

    public void setArmCannonSelected(int idx) {
        int clamped = Mth.clamp((int)idx, (int)0, (int)3);
        if (clamped != this.armCannonSelected) {
            this.armCannonSelected = clamped;
            this.dirty = true;
        }
    }

    public ItemStack getChipwareStack(int slot) {
        if (slot < 0 || slot >= this.chipwareInv.length) {
            return ItemStack.EMPTY;
        }
        ItemStack st = this.chipwareInv[slot];
        return st == null ? ItemStack.EMPTY : st;
    }

    public void setChipwareStack(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.chipwareInv.length) {
            return;
        }
        if (stack == null || stack.isEmpty()) {
            this.chipwareInv[slot] = ItemStack.EMPTY;
            this.dirty = true;
            return;
        }
        if (!stack.is(ModTags.Items.DATA_SHARDS)) {
            this.chipwareInv[slot] = ItemStack.EMPTY;
            this.dirty = true;
            return;
        }
        ItemStack copy = stack.copy();
        copy.setCount(1);
        this.chipwareInv[slot] = copy;
        this.dirty = true;
    }

    public void clearChipwareInventory() {
        for (int i = 0; i < this.chipwareInv.length; ++i) {
            this.chipwareInv[i] = ItemStack.EMPTY;
        }
        this.dirty = true;
    }

    public boolean hasChipwareShard(TagKey<Item> tag) {
        for (int i = 0; i < 2; ++i) {
            ItemStack st = this.getChipwareStack(i);
            if (st.isEmpty() || !st.is(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChipwareShardExact(Item shardItem) {
        if (shardItem == null) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack st = this.getChipwareStack(i);
            if (st.isEmpty() || !st.is(shardItem)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(CyberwareSlot slot, int index) {
        boolean[] arr = this.enabled.get((Object)slot);
        if (arr == null) {
            return true;
        }
        if (index < 0 || index >= arr.length) {
            return true;
        }
        return arr[index];
    }

    public void setEnabled(CyberwareSlot slot, int index, boolean value) {
        boolean[] arr = this.enabled.get((Object)slot);
        if (arr == null) {
            return;
        }
        if (index < 0 || index >= arr.length) {
            return;
        }
        if (arr[index] != value) {
            arr[index] = value;
            this.dirty = true;
        }
    }

    public boolean toggleEnabled(CyberwareSlot slot, int index) {
        boolean next = !this.isEnabled(slot, index);
        this.setEnabled(slot, index, next);
        return next;
    }

    public boolean hasOrgan(CyberwareSlot slot) {
        InstalledCyberware[] arr;
        for (InstalledCyberware cw : arr = this.slots.get((Object)slot)) {
            if (cw == null || cw.getItem() == null || cw.getItem().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isOrganReplaced(CyberwareSlot slot) {
        InstalledCyberware[] arr;
        for (InstalledCyberware cw : arr = this.slots.get((Object)slot)) {
            ICyberwareItem item;
            Item item2;
            if (cw == null || cw.getItem().isEmpty() || !((item2 = cw.getItem().getItem()) instanceof ICyberwareItem) || !(item = (ICyberwareItem)item2).replacesOrgan() || !item.getReplacedOrgans().contains((Object)slot)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyInSlots(CyberwareSlot slot) {
        InstalledCyberware[] arr = this.slots.get((Object)slot);
        if (arr == null) {
            return false;
        }
        for (InstalledCyberware cw : arr) {
            if (cw == null || cw.getItem().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyTagged(TagKey<Item> tag, CyberwareSlot ... slotsToCheck) {
        for (CyberwareSlot slot : slotsToCheck) {
            InstalledCyberware[] arr = this.slots.get((Object)slot);
            if (arr == null) continue;
            for (InstalledCyberware cw : arr) {
                ItemStack stack;
                if (cw == null || (stack = cw.getItem()).isEmpty() || !stack.is(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSpecificItem(Item item, CyberwareSlot ... slotsToCheck) {
        for (CyberwareSlot slot : slotsToCheck) {
            InstalledCyberware[] arr = this.slots.get((Object)slot);
            if (arr == null) continue;
            for (InstalledCyberware cw : arr) {
                ItemStack stack;
                if (cw == null || (stack = cw.getItem()).isEmpty() || !stack.is(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInstalled(Item item, CyberwareSlot slot, int index) {
        InstalledCyberware[] arr = this.slots.get((Object)slot);
        if (arr == null) {
            return false;
        }
        if (index < 0 || index >= arr.length) {
            return false;
        }
        InstalledCyberware cw = arr[index];
        if (cw == null) {
            return false;
        }
        ItemStack stack = cw.getItem();
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return stack.is(item);
    }

    public boolean isInstalled(Item item, CyberwareSlot slot) {
        return this.hasSpecificItem(item, slot);
    }

    public boolean isDyed(CyberwareSlot slot, int index) {
        InstalledCyberware installed = this.get(slot, index);
        if (installed == null) {
            return false;
        }
        ItemStack st = installed.getItem();
        if (st == null || st.isEmpty()) {
            return false;
        }
        Item item = st.getItem();
        if (!(item instanceof ICyberwareItem)) {
            return false;
        }
        ICyberwareItem item2 = (ICyberwareItem)item;
        return item2.isDyed(st, slot);
    }

    public int dyeColor(CyberwareSlot slot, int index) {
        InstalledCyberware installed = this.get(slot, index);
        if (installed == null) {
            return -1;
        }
        ItemStack st = installed.getItem();
        if (st == null || st.isEmpty()) {
            return -1;
        }
        Item item = st.getItem();
        if (!(item instanceof ICyberwareItem)) {
            return -1;
        }
        ICyberwareItem item2 = (ICyberwareItem)item;
        return item2.dyeColor(st, slot);
    }

    public boolean isDyed(Item item, CyberwareSlot slotToCheck) {
        InstalledCyberware[] arr = this.slots.get((Object)slotToCheck);
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            ItemStack st;
            InstalledCyberware installed = arr[i];
            if (installed == null || (st = installed.getItem()) == null || st.isEmpty() || !st.is(item)) continue;
            Item item2 = st.getItem();
            if (item2 instanceof ICyberwareItem) {
                ICyberwareItem cw = (ICyberwareItem)item2;
                return cw.isDyed(st, slotToCheck);
            }
            return false;
        }
        return false;
    }

    public int dyeColor(Item item, CyberwareSlot slotToCheck) {
        InstalledCyberware[] arr = this.slots.get((Object)slotToCheck);
        if (arr == null) {
            return -1;
        }
        for (int i = 0; i < arr.length; ++i) {
            ItemStack st;
            InstalledCyberware installed = arr[i];
            if (installed == null || (st = installed.getItem()) == null || st.isEmpty() || !st.is(item)) continue;
            Item item2 = st.getItem();
            if (item2 instanceof ICyberwareItem) {
                ICyberwareItem cw = (ICyberwareItem)item2;
                return cw.dyeColor(st, slotToCheck);
            }
            return -1;
        }
        return -1;
    }

    public ItemStack getSpinalInjectorStack(int slot) {
        if (slot < 0 || slot >= this.spinalInjectorInv.length) {
            return ItemStack.EMPTY;
        }
        ItemStack st = this.spinalInjectorInv[slot];
        return st == null ? ItemStack.EMPTY : st;
    }

    public void setSpinalInjectorStack(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.spinalInjectorInv.length) {
            return;
        }
        if (stack == null || stack.isEmpty() || !SpinalInjectorItem.isInjectable(stack)) {
            this.spinalInjectorInv[slot] = ItemStack.EMPTY;
            this.dirty = true;
            return;
        }
        ItemStack copy = stack.copy();
        int cap = SpinalInjectorItem.maxStackFor(copy);
        if (copy.getCount() > cap) {
            copy.setCount(cap);
        }
        this.spinalInjectorInv[slot] = copy;
        this.dirty = true;
    }

    public void clearSpinalInjectorInventory() {
        for (int i = 0; i < this.spinalInjectorInv.length; ++i) {
            this.spinalInjectorInv[i] = ItemStack.EMPTY;
        }
        this.dirty = true;
    }

    public ItemStack getArmCannonStack(int slot) {
        if (slot < 0 || slot >= this.armCannonInv.length) {
            return ItemStack.EMPTY;
        }
        ItemStack st = this.armCannonInv[slot];
        return st == null ? ItemStack.EMPTY : st;
    }

    public void setArmCannonStack(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.armCannonInv.length) {
            return;
        }
        if (stack == null || stack.isEmpty() || !ArmCannonItem.isValidStoredItem(stack)) {
            this.armCannonInv[slot] = ItemStack.EMPTY;
            this.dirty = true;
            return;
        }
        ItemStack copy = stack.copy();
        int cap = Math.max(1, copy.getMaxStackSize());
        if (copy.getCount() > cap) {
            copy.setCount(cap);
        }
        this.armCannonInv[slot] = copy;
        this.dirty = true;
    }

    public void clearArmCannonInventory() {
        for (int i = 0; i < this.armCannonInv.length; ++i) {
            this.armCannonInv[i] = ItemStack.EMPTY;
        }
        this.dirty = true;
    }

    @Override
    public void clear() {
        int i;
        for (CyberwareSlot slot : CyberwareSlot.values()) {
            this.slots.put(slot, new InstalledCyberware[slot.size]);
            boolean[] en = this.enabled.get((Object)slot);
            if (en == null || en.length != slot.size) {
                en = new boolean[slot.size];
                this.enabled.put(slot, en);
            }
            for (int i2 = 0; i2 < en.length; ++i2) {
                en[i2] = true;
            }
        }
        for (i = 0; i < this.spinalInjectorInv.length; ++i) {
            this.spinalInjectorInv[i] = ItemStack.EMPTY;
        }
        for (i = 0; i < this.armCannonInv.length; ++i) {
            this.armCannonInv[i] = ItemStack.EMPTY;
        }
        for (i = 0; i < this.chipwareInv.length; ++i) {
            this.chipwareInv[i] = ItemStack.EMPTY;
        }
        this.armCannonSelected = 0;
        this.dirty = true;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clean() {
        this.dirty = false;
    }

    public void resetToDefaultOrgans() {
        for (CyberwareSlot slot : CyberwareSlot.values()) {
            InstalledCyberware[] arr = this.getAll().get((Object)slot);
            if (arr == null) continue;
            for (int i = 0; i < arr.length; ++i) {
                ItemStack def = DefaultOrgans.get(slot, i);
                if (def == null || def.isEmpty()) {
                    arr[i] = null;
                    this.setEnabled(slot, i, true);
                    continue;
                }
                int humanityCost = 0;
                Item item = def.getItem();
                if (item instanceof ICyberwareItem) {
                    ICyberwareItem cyberwareItem = (ICyberwareItem)item;
                    humanityCost = cyberwareItem.getHumanityCost();
                }
                arr[i] = new InstalledCyberware(def, slot, i, humanityCost);
                arr[i].setPowered(true);
                this.setEnabled(slot, i, true);
            }
        }
        this.dirty = true;
    }

    public int getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(Player player, int value) {
        int cap = this.getTotalEnergyCapacity(player);
        int clamped = Mth.clamp((int)value, (int)0, (int)cap);
        if (clamped != this.energyStored) {
            this.energyStored = clamped;
            this.dirty = true;
        }
    }

    public int getTotalEnergyCapacity(Player player) {
        int total = 0;
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : this.slots.entrySet()) {
            CyberwareSlot slot = entry.getKey();
            InstalledCyberware[] arr = entry.getValue();
            if (arr == null) continue;
            for (int i = 0; i < arr.length; ++i) {
                ICyberwareItem item;
                int cap;
                Item item2;
                ItemStack stack;
                InstalledCyberware cw = arr[i];
                if (cw == null || (stack = cw.getItem()) == null || stack.isEmpty() || !((item2 = stack.getItem()) instanceof ICyberwareItem) || (cap = (item = (ICyberwareItem)item2).getEnergyCapacity(player, stack, slot)) <= 0) continue;
                total += cap;
            }
        }
        return Math.max(0, total);
    }

    public int receiveEnergy(Player player, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int cap = this.getTotalEnergyCapacity(player);
        if (cap <= 0) {
            return 0;
        }
        int before = this.energyStored;
        int after = Mth.clamp((int)(before + amount), (int)0, (int)cap);
        if (after != before) {
            this.energyStored = after;
            this.dirty = true;
        }
        return after - before;
    }

    public int extractEnergy(int amount) {
        if (amount <= 0) {
            return 0;
        }
        int before = this.energyStored;
        int after = Math.max(0, before - amount);
        if (after != before) {
            this.energyStored = after;
            this.dirty = true;
        }
        return before - after;
    }

    public boolean tryConsumeEnergy(int amount) {
        if (amount <= 0) {
            return true;
        }
        if (this.energyStored < amount) {
            return false;
        }
        this.energyStored -= amount;
        this.dirty = true;
        return true;
    }

    public void clampEnergyToCapacity(Player player) {
        int cap = this.getTotalEnergyCapacity(player);
        int clamped = Mth.clamp((int)this.energyStored, (int)0, (int)cap);
        if (clamped != this.energyStored) {
            this.energyStored = clamped;
            this.dirty = true;
        }
    }

    public int getNeuropozyneApplyCount() {
        return Math.max(0, this.neuropozyneApplyCount);
    }

    public int incrementNeuropozyneApplyCount() {
        this.neuropozyneApplyCount = Math.max(0, this.neuropozyneApplyCount) + 1;
        this.dirty = true;
        return this.neuropozyneApplyCount;
    }

    public void resetNeuropozyneApplyCount() {
        this.neuropozyneApplyCount = 0;
        this.dirty = true;
    }

    private static CompoundTag cc$saveStackToCompound(HolderLookup.Provider provider, ItemStack stack) {
        CompoundTag ct;
        Tag t = stack.save(provider);
        return t instanceof CompoundTag ? (ct = (CompoundTag)t) : new CompoundTag();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : this.slots.entrySet()) {
            CyberwareSlot slot = entry.getKey();
            InstalledCyberware[] arr = entry.getValue();
            if (arr == null) continue;
            for (int i = 0; i < arr.length; ++i) {
                ItemStack stack;
                InstalledCyberware installed = arr[i];
                if (installed == null || (stack = installed.getItem()) == null || stack.isEmpty()) continue;
                CompoundTag c = installed.save(provider);
                c.putString("SlotGroup", slot.name());
                c.putInt("Index", i);
                c.putBoolean("Enabled", this.isEnabled(slot, i));
                list.add((Object)c);
            }
        }
        tag.put(NBT_CYBERWARE, (Tag)list);
        tag.putInt(NBT_HUMANITY, this.humanity);
        tag.putInt(NBT_ENERGY, this.energyStored);
        tag.putInt(NBT_ARM_CANNON_SELECTED, this.getArmCannonSelected());
        ListTag inj = new ListTag();
        for (int i = 0; i < this.spinalInjectorInv.length; ++i) {
            CompoundTag c = new CompoundTag();
            ItemStack st = this.spinalInjectorInv[i];
            if (st != null && !st.isEmpty() && SpinalInjectorItem.isInjectable(st)) {
                ItemStack copy = st.copy();
                int cap = SpinalInjectorItem.maxStackFor(copy);
                if (copy.getCount() > cap) {
                    copy.setCount(cap);
                }
                copy.save(provider, (Tag)c);
            }
            inj.add((Object)c);
        }
        tag.put(NBT_SPINAL_INJECTOR_INV, (Tag)inj);
        ListTag arm = new ListTag();
        for (int i = 0; i < this.armCannonInv.length; ++i) {
            CompoundTag c = new CompoundTag();
            ItemStack st = this.armCannonInv[i];
            if (st != null && !st.isEmpty()) {
                ItemStack copy = st.copy();
                int cap = Math.max(1, copy.getMaxStackSize());
                if (copy.getCount() > cap) {
                    copy.setCount(cap);
                }
                copy.save(provider, (Tag)c);
            }
            arm.add((Object)c);
        }
        tag.put(NBT_ARM_CANNON_INV, (Tag)arm);
        ListTag chip = new ListTag();
        for (int i = 0; i < this.chipwareInv.length; ++i) {
            ItemStack st = this.chipwareInv[i];
            if (st != null && !st.isEmpty() && st.is(ModTags.Items.DATA_SHARDS)) {
                ItemStack copy = st.copy();
                copy.setCount(1);
                chip.add((Object)PlayerCyberwareData.cc$saveStackToCompound(provider, copy));
                continue;
            }
            chip.add((Object)new CompoundTag());
        }
        tag.put(NBT_CHIPWARE_INV, (Tag)chip);
        tag.putInt(NBT_NEUROPOZYNE_APPLY_COUNT, this.neuropozyneApplyCount);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag c;
        int i;
        this.clear();
        ListTag list = tag.getList(NBT_CYBERWARE, 10);
        for (i = 0; i < list.size(); ++i) {
            CompoundTag c2 = list.getCompound(i);
            if (!c2.contains("SlotGroup", 8)) continue;
            CyberwareSlot slot = CyberwareSlot.valueOf(c2.getString("SlotGroup"));
            int index = c2.getInt("Index");
            InstalledCyberware loaded = InstalledCyberware.load(c2, provider);
            InstalledCyberware[] arr = this.slots.get((Object)slot);
            if (arr == null || index < 0 || index >= arr.length) continue;
            arr[index] = loaded;
            boolean en = c2.contains("Enabled", 1) ? c2.getBoolean("Enabled") : true;
            this.setEnabled(slot, index, en);
        }
        if (tag.contains(NBT_HUMANITY, 3)) {
            this.humanity = tag.getInt(NBT_HUMANITY);
        } else {
            this.humanity = ConfigValues.BASE_HUMANITY;
            this.recomputeHumanityBaseFromInstalled();
        }
        this.humanityBonus = 0;
        this.energyStored = tag.contains(NBT_ENERGY, 3) ? tag.getInt(NBT_ENERGY) : 0;
        this.armCannonSelected = tag.contains(NBT_ARM_CANNON_SELECTED, 3) ? Mth.clamp((int)tag.getInt(NBT_ARM_CANNON_SELECTED), (int)0, (int)3) : 0;
        for (i = 0; i < this.spinalInjectorInv.length; ++i) {
            this.spinalInjectorInv[i] = ItemStack.EMPTY;
        }
        if (tag.contains(NBT_SPINAL_INJECTOR_INV, 9)) {
            ListTag inj = tag.getList(NBT_SPINAL_INJECTOR_INV, 10);
            for (int i2 = 0; i2 < this.spinalInjectorInv.length && i2 < inj.size(); ++i2) {
                c = inj.getCompound(i2);
                ItemStack st = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)c);
                if (st.isEmpty() || !SpinalInjectorItem.isInjectable(st)) {
                    this.spinalInjectorInv[i2] = ItemStack.EMPTY;
                    continue;
                }
                int cap = SpinalInjectorItem.maxStackFor(st);
                if (st.getCount() > cap) {
                    st.setCount(cap);
                }
                this.spinalInjectorInv[i2] = st;
            }
        }
        if (tag.contains(NBT_ARM_CANNON_INV, 9)) {
            ListTag arm = tag.getList(NBT_ARM_CANNON_INV, 10);
            for (int i3 = 0; i3 < this.armCannonInv.length && i3 < arm.size(); ++i3) {
                c = arm.getCompound(i3);
                ItemStack st = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)c);
                if (st.isEmpty()) {
                    this.armCannonInv[i3] = ItemStack.EMPTY;
                    continue;
                }
                int cap = Math.max(1, st.getMaxStackSize());
                if (st.getCount() > cap) {
                    st.setCount(cap);
                }
                this.armCannonInv[i3] = st;
            }
        }
        for (int i4 = 0; i4 < this.chipwareInv.length; ++i4) {
            this.chipwareInv[i4] = ItemStack.EMPTY;
        }
        if (tag.contains(NBT_CHIPWARE_INV, 9)) {
            ListTag chip = tag.getList(NBT_CHIPWARE_INV, 10);
            for (int i5 = 0; i5 < this.chipwareInv.length && i5 < chip.size(); ++i5) {
                c = chip.getCompound(i5);
                ItemStack st = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)c);
                if (st.isEmpty() || !st.is(ModTags.Items.DATA_SHARDS)) {
                    this.chipwareInv[i5] = ItemStack.EMPTY;
                    continue;
                }
                st.setCount(1);
                this.chipwareInv[i5] = st;
            }
        }
        this.neuropozyneApplyCount = tag.contains(NBT_NEUROPOZYNE_APPLY_COUNT, 3) ? Math.max(0, tag.getInt(NBT_NEUROPOZYNE_APPLY_COUNT)) : 0;
        this.dirty = false;
    }
}

