/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.common.energy;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.block.ModBlocks;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.effect.ModEffects;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME)
public final class EnergyController {
    private static final String DEBUG_TAG = "cc_energy_debug";
    private static final boolean DEBUG_ACTIONBAR = true;
    private static final int DEBUG_EVERY_TICKS = 1;
    private static final Map<Class<?>, Boolean> OVERRIDES_SHOULD_GENERATE = new ConcurrentHashMap();
    private static final Map<Class<?>, Method> ENERGY_GETTER_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Field> ENERGY_FIELD_CACHE = new ConcurrentHashMap();

    private EnergyController() {
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        ICyberwareItem item;
        ItemStack stack;
        InstalledCyberware cw;
        int idx;
        TickStats stats;
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (!player.hasData(ModAttachments.CYBERWARE)) {
            return;
        }
        PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
        if (data == null) {
            return;
        }
        if (EnergyController.hasEmpEffect(player)) {
            data.setEnergyStored(player, 0);
            for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
                CyberwareSlot slot2 = entry.getKey();
                InstalledCyberware[] arr2 = entry.getValue();
                if (arr2 == null) continue;
                for (int i = 0; i < arr2.length; ++i) {
                    ICyberwareItem item2;
                    String paidKey;
                    InstalledCyberware installedCyberware = arr2[i];
                    if (installedCyberware == null) continue;
                    ItemStack itemStack = installedCyberware.getItem();
                    if (itemStack == null || itemStack.isEmpty()) {
                        installedCyberware.setPowered(false);
                        continue;
                    }
                    Item item3 = itemStack.getItem();
                    if (item3 instanceof ICyberwareItem && (paidKey = (item2 = (ICyberwareItem)item3).getActivationPaidNbtKey(player, itemStack, slot2)) != null && !paidKey.isBlank()) {
                        String persistentKey = EnergyController.buildActivationPersistentKey(paidKey, slot2, i);
                        player.getPersistentData().remove(persistentKey);
                    }
                    installedCyberware.setPowered(false);
                }
            }
            boolean debug = player.getTags().contains(DEBUG_TAG);
            if (debug) {
                TickStats stats2 = new TickStats();
                stats2.capacityTotal = data.getTotalEnergyCapacity(player);
                stats2.storedEnd = EnergyController.readStoredEnergySafe(data);
                EnergyController.maybeSendDebug(player, stats2);
            }
            return;
        }
        data.clampEnergyToCapacity(player);
        boolean debug = player.getTags().contains(DEBUG_TAG);
        TickStats tickStats = stats = debug ? new TickStats() : null;
        if (stats != null) {
            stats.storedStart = EnergyController.readStoredEnergySafe(data);
        }
        if (EnergyController.isOnChargerBlock(player)) {
            int chargerIn = 0;
            for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
                CyberwareSlot cyberwareSlot = entry.getKey();
                InstalledCyberware[] installedCyberwareArray = entry.getValue();
                if (installedCyberwareArray == null) continue;
                for (idx = 0; idx < installedCyberwareArray.length; ++idx) {
                    int req;
                    Item item4;
                    cw = installedCyberwareArray[idx];
                    if (cw == null || (stack = cw.getItem()) == null || stack.isEmpty() || !((item4 = stack.getItem()) instanceof ICyberwareItem) || !(item = (ICyberwareItem)item4).acceptsChargerEnergy(player, stack, cyberwareSlot) || (req = item.getChargerEnergyReceivePerTick(player, stack, cyberwareSlot)) <= 0) continue;
                    chargerIn += req;
                }
            }
            if (chargerIn > 0) {
                data.receiveEnergy(player, chargerIn);
            }
            data.clampEnergyToCapacity(player);
        }
        int totalCapacity = 0;
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
            CyberwareSlot cyberwareSlot = entry.getKey();
            InstalledCyberware[] installedCyberwareArray = entry.getValue();
            if (installedCyberwareArray == null) continue;
            for (idx = 0; idx < installedCyberwareArray.length; ++idx) {
                int cap;
                Item req;
                cw = installedCyberwareArray[idx];
                if (cw == null || (stack = cw.getItem()) == null || stack.isEmpty() || !((req = stack.getItem()) instanceof ICyberwareItem) || (cap = (item = (ICyberwareItem)req).getEnergyCapacity(player, stack, cyberwareSlot)) <= 0) continue;
                totalCapacity += cap;
            }
        }
        if (stats != null) {
            stats.capacityTotal = totalCapacity;
        }
        int tickGenerated = 0;
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
            CyberwareSlot cyberwareSlot = entry.getKey();
            InstalledCyberware[] arr3 = entry.getValue();
            if (arr3 == null) continue;
            for (int idx3 = 0; idx3 < arr3.length; ++idx3) {
                ICyberwareItem item5;
                int gen;
                Item item6;
                ItemStack stack3;
                InstalledCyberware cw3 = arr3[idx3];
                if (cw3 == null || (stack3 = cw3.getItem()) == null || stack3.isEmpty() || !((item6 = stack3.getItem()) instanceof ICyberwareItem) || (gen = (item5 = (ICyberwareItem)item6).getEnergyGeneratedPerTick(player, stack3, cyberwareSlot)) <= 0 || !EnergyController.shouldGenerate(item5, player, stack3, cyberwareSlot)) continue;
                tickGenerated += gen;
            }
        }
        MutableInt mutableInt = new MutableInt(tickGenerated);
        if (stats != null) {
            stats.generated = tickGenerated;
        }
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
            CyberwareSlot slot4 = entry.getKey();
            InstalledCyberware[] arr4 = entry.getValue();
            if (arr4 == null) continue;
            for (int idx4 = 0; idx4 < arr4.length; ++idx4) {
                Item item7;
                ItemStack stack4;
                InstalledCyberware cw4 = arr4[idx4];
                if (cw4 == null || (stack4 = cw4.getItem()) == null || stack4.isEmpty() || !((item7 = stack4.getItem()) instanceof ICyberwareItem)) continue;
                ICyberwareItem item8 = (ICyberwareItem)item7;
                boolean powered = true;
                int use = item8.getEnergyUsedPerTick(player, stack4, slot4);
                if (use > 0) {
                    if (stats != null) {
                        stats.requestedUse += use;
                    }
                    powered = EnergyController.tryPayEnergy(data, mutableInt, use, stats);
                }
                if (powered && item8.shouldConsumeActivationEnergyThisTick(player, stack4, slot4)) {
                    int actCost = item8.getEnergyActivationCost(player, stack4, slot4);
                    if (actCost > 0) {
                        String paidKey = item8.getActivationPaidNbtKey(player, stack4, slot4);
                        if (paidKey == null || paidKey.isBlank()) {
                            if (stats != null) {
                                stats.requestedActivation += actCost;
                            }
                            powered = EnergyController.tryPayEnergy(data, mutableInt, actCost, stats);
                        } else {
                            String persistentKey = EnergyController.buildActivationPersistentKey(paidKey, slot4, idx4);
                            CompoundTag ptag = player.getPersistentData();
                            boolean alreadyPaid = ptag.getBoolean(persistentKey);
                            if (!alreadyPaid) {
                                if (stats != null) {
                                    stats.requestedActivation += actCost;
                                }
                                if (EnergyController.tryPayEnergy(data, mutableInt, actCost, stats)) {
                                    ptag.putBoolean(persistentKey, true);
                                } else {
                                    powered = false;
                                }
                            }
                        }
                    }
                } else {
                    String paidKey = item8.getActivationPaidNbtKey(player, stack4, slot4);
                    if (paidKey != null && !paidKey.isBlank()) {
                        String persistentKey = EnergyController.buildActivationPersistentKey(paidKey, slot4, idx4);
                        player.getPersistentData().remove(persistentKey);
                    }
                }
                if (!powered && stats != null) {
                    ++stats.unpoweredCount;
                }
                cw4.setPowered(powered);
            }
        }
        int n = mutableInt.value;
        if (n > 0) {
            if (EnergyController.canAcceptGeneratedSurplus(player, data)) {
                if (stats != null) {
                    stats.surplusDeposited = n;
                }
                data.receiveEnergy(player, n);
            } else if (stats != null) {
                stats.surplusDeposited = 0;
            }
        }
        data.clampEnergyToCapacity(player);
        if (stats != null) {
            stats.storedEnd = EnergyController.readStoredEnergySafe(data);
            EnergyController.maybeSendDebug(player, stats);
        }
    }

    private static boolean tryPayEnergy(PlayerCyberwareData data, MutableInt tickPool, int amount, TickStats stats) {
        if (amount <= 0) {
            return true;
        }
        int fromPool = Math.min(tickPool.value, amount);
        tickPool.value -= fromPool;
        amount -= fromPool;
        if (stats != null) {
            stats.usedFromPool += fromPool;
        }
        if (amount <= 0) {
            return true;
        }
        boolean ok = data.tryConsumeEnergy(amount);
        if (ok) {
            if (stats != null) {
                stats.usedFromStored += amount;
            }
            return true;
        }
        if (stats != null) {
            stats.failedSpend += amount;
        }
        return false;
    }

    private static boolean canAcceptGeneratedSurplus(Player player, PlayerCyberwareData data) {
        for (Map.Entry<CyberwareSlot, InstalledCyberware[]> entry : data.getAll().entrySet()) {
            CyberwareSlot slot = entry.getKey();
            InstalledCyberware[] arr = entry.getValue();
            if (arr == null) continue;
            for (int idx = 0; idx < arr.length; ++idx) {
                ICyberwareItem item;
                Item item2;
                ItemStack stack;
                InstalledCyberware cw = arr[idx];
                if (cw == null || (stack = cw.getItem()) == null || stack.isEmpty() || !((item2 = stack.getItem()) instanceof ICyberwareItem) || !(item = (ICyberwareItem)item2).acceptsGeneratedEnergy(player, stack, slot)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldGenerate(ICyberwareItem item, Player player, ItemStack stack, CyberwareSlot slot) {
        if (!EnergyController.overridesShouldGenerate(item.getClass())) {
            return true;
        }
        return item.shouldGenerateEnergyThisTick(player, stack, slot);
    }

    private static boolean overridesShouldGenerate(Class<?> cls) {
        return OVERRIDES_SHOULD_GENERATE.computeIfAbsent(cls, c -> {
            try {
                Method m = c.getMethod("shouldGenerateEnergyThisTick", Player.class, ItemStack.class, CyberwareSlot.class);
                return m.getDeclaringClass() != ICyberwareItem.class;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        });
    }

    private static String buildActivationPersistentKey(String key, CyberwareSlot slot, int index) {
        return "cc_energy_actpaid_" + key + "_" + slot.name() + "_" + index;
    }

    private static boolean isOnChargerBlock(Player player) {
        Level level = player.level();
        BlockPos below = player.blockPosition().below();
        return level.getBlockState(below).is((Block)ModBlocks.CHARGING_BLOCK.get());
    }

    private static void maybeSendDebug(Player player, TickStats s) {
        if (!player.getTags().contains(DEBUG_TAG)) {
            return;
        }
        int usedTotal = s.usedFromPool + s.usedFromStored;
        int requestedTotal = s.requestedUse + s.requestedActivation;
        int net = s.generated - usedTotal;
        String text = "Energy " + s.storedEnd + "/" + s.capacityTotal + " | +" + s.generated + " -" + usedTotal + " = " + net + " | Req " + requestedTotal + " | Dep " + s.surplusDeposited + " | Unp " + s.unpoweredCount;
        player.displayClientMessage((Component)Component.literal((String)text), true);
    }

    private static int readStoredEnergySafe(PlayerCyberwareData data) {
        try {
            Field f;
            Method m = ENERGY_GETTER_CACHE.computeIfAbsent(data.getClass(), cls -> {
                Method found = EnergyController.findNoArgIntGetter(cls, "getEnergyStored", "getStoredEnergy", "getEnergy", "getEnergyAmount");
                if (found != null) {
                    found.setAccessible(true);
                    return found;
                }
                return null;
            });
            if (m != null) {
                Object v = m.invoke((Object)data, new Object[0]);
                if (v instanceof Integer) {
                    Integer i = (Integer)v;
                    return i;
                }
                if (v instanceof Number) {
                    Number n = (Number)v;
                    return n.intValue();
                }
            }
            if ((f = ENERGY_FIELD_CACHE.computeIfAbsent(data.getClass(), cls -> {
                Field ff = EnergyController.findIntField(cls, "energyStored", "storedEnergy", "energy", "power", "currentEnergy");
                if (ff != null) {
                    ff.setAccessible(true);
                }
                return ff;
            })) != null) {
                return f.getInt(data);
            }
            return 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static Method findNoArgIntGetter(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Method m = cls.getMethod(name, new Class[0]);
                Class<?> rt = m.getReturnType();
                if (rt != Integer.TYPE && !Number.class.isAssignableFrom(rt)) continue;
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Field findIntField(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Field f = cls.getDeclaredField(name);
                if (f.getType() != Integer.TYPE) continue;
                return f;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean hasEmpEffect(Player player) {
        return player.hasEffect(ModEffects.EMP);
    }

    private static final class TickStats {
        int generated;
        int requestedUse;
        int requestedActivation;
        int usedFromPool;
        int usedFromStored;
        int surplusDeposited;
        int storedStart;
        int storedEnd;
        int capacityTotal;
        int unpoweredCount;
        int failedSpend;

        private TickStats() {
        }
    }

    private static final class MutableInt {
        int value;

        MutableInt(int value) {
            this.value = value;
        }
    }
}

