/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.effect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class BreathlessEffect
extends MobEffect {
    private static final String NBT_NO_AIR_AIR = "cc_no_air_air";

    public BreathlessEffect() {
        super(MobEffectCategory.HARMFUL, 0);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        int air;
        if (!(entity instanceof Player)) {
            return true;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return true;
        }
        if (player.isCreative() || player.isSpectator()) {
            return true;
        }
        CompoundTag pd = player.getPersistentData();
        int n = air = pd.contains(NBT_NO_AIR_AIR, 3) ? pd.getInt(NBT_NO_AIR_AIR) : player.getAirSupply();
        if (--air <= -20) {
            player.hurt(player.damageSources().drown(), 2.0f);
            air = 0;
        }
        pd.putInt(NBT_NO_AIR_AIR, air);
        player.setAirSupply(air);
        return true;
    }

    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.level().isClientSide) {
            return;
        }
        player.getPersistentData().remove(NBT_NO_AIR_AIR);
        player.setAirSupply(player.getMaxAirSupply());
    }
}

