/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.event.custom;

import com.perigrine3.createcybernetics.common.attributes.ModAttributes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME)
public final class CraftingSkillHandler {
    private CraftingSkillHandler() {
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        int space;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        double mult = player2.getAttributeValue(ModAttributes.CRAFTING_OUTPUT);
        if (!Double.isFinite(mult) || mult <= 1.0) {
            return;
        }
        ItemStack crafted = event.getCrafting();
        if (crafted.isEmpty()) {
            return;
        }
        int baseCount = crafted.getCount();
        if (baseCount <= 0) {
            return;
        }
        int extraTotal = (int)Math.floor((double)baseCount * (mult - 1.0));
        if (extraTotal <= 0) {
            return;
        }
        AbstractContainerMenu menu = player2.containerMenu;
        ItemStack carried = menu.getCarried();
        if (!carried.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)crafted) && (space = carried.getMaxStackSize() - carried.getCount()) > 0) {
            int add = Math.min(space, extraTotal);
            carried.grow(add);
            menu.setCarried(carried);
            menu.broadcastChanges();
            extraTotal -= add;
        }
        while (extraTotal > 0) {
            int give = Math.min(extraTotal, crafted.getMaxStackSize());
            ItemStack extra = crafted.copy();
            extra.setCount(give);
            player2.addItem(extra);
            extraTotal -= give;
        }
    }
}

