/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.item.cyberware;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.util.ModTags;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ArterialTurbineItem
extends Item
implements ICyberwareItem {
    private final int humanityCost;
    private static final int ENERGY_STILL = 3;
    private static final int ENERGY_WALK = 10;
    private static final int ENERGY_EXERTION = 25;
    private static final int ENERGY_FEAR = 50;
    private static final float FEAR_FALL_DISTANCE_THRESHOLD = 8.0f;
    private static final double WALKING_SPEED_SQR_EPS = 1.0E-4;

    public ArterialTurbineItem(Item.Properties props, int humanityCost) {
        super(props);
        this.humanityCost = humanityCost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createcybernetics.humanity", (Object[])new Object[]{this.humanityCost}).withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.literal((String)"Adds 3/10/25/50 Energy From Blood Pressure").withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    @Override
    public boolean shouldGenerateEnergyThisTick(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return true;
    }

    @Override
    public int getEnergyGeneratedPerTick(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return ArterialTurbineItem.computeEnergy(player);
    }

    private static int computeEnergy(Player player) {
        boolean meaningfulFalling;
        boolean attacked = player.hurtTime > 0;
        boolean bl = meaningfulFalling = !player.onGround() && !player.isSwimming() && !player.isFallFlying() && !player.getAbilities().flying && player.getDeltaMovement().y < 0.0 && player.fallDistance >= 8.0f;
        if (attacked || meaningfulFalling) {
            return 50;
        }
        if (player.isSprinting() || player.isSwimming()) {
            return 25;
        }
        double horizontalSpeedSqr = player.getDeltaMovement().horizontalDistanceSqr();
        if (horizontalSpeedSqr > 1.0E-4) {
            return 10;
        }
        return 3;
    }

    @Override
    public int getHumanityCost() {
        return this.humanityCost;
    }

    @Override
    public Set<TagKey<Item>> requiresCyberwareTags(ItemStack installedStack, CyberwareSlot slot) {
        return Set.of(ModTags.Items.SKIN_ITEMS);
    }

    @Override
    public Set<CyberwareSlot> getSupportedSlots() {
        return Set.of(CyberwareSlot.SKIN);
    }

    @Override
    public boolean replacesOrgan() {
        return false;
    }

    @Override
    public Set<CyberwareSlot> getReplacedOrgans() {
        return Set.of();
    }

    @Override
    public int maxStacksPerSlotType(ItemStack stack, CyberwareSlot slotType) {
        return 3;
    }

    @Override
    public void onInstalled(Player player) {
    }

    @Override
    public void onRemoved(Player player) {
    }

    @Override
    public void onTick(Player player) {
    }
}

