/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.item.cyberware;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.ModItems;
import com.perigrine3.createcybernetics.sound.MetalDetectorLoopSound;
import com.perigrine3.createcybernetics.sound.ModSounds;
import com.perigrine3.createcybernetics.util.ModTags;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MetalDetectorItem
extends Item
implements ICyberwareItem {
    private final int humanityCost;
    private static final int ENERGY_PER_TICK = 3;
    private static MetalDetectorLoopSound activeLoop;

    public MetalDetectorItem(Item.Properties props, int humanityCost) {
        super(props);
        this.humanityCost = humanityCost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createcybernetics.humanity", (Object[])new Object[]{this.humanityCost}).withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.literal((String)"Costs 3 Energy").withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public int getHumanityCost() {
        return this.humanityCost;
    }

    @Override
    public int getEnergyUsedPerTick(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return 3;
    }

    @Override
    public boolean requiresEnergyToFunction(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return true;
    }

    @Override
    public Set<Item> requiresCyberware(ItemStack installedStack, CyberwareSlot slot) {
        return switch (slot) {
            case CyberwareSlot.RLEG -> Set.of((Item)ModItems.BASECYBERWARE_RIGHTLEG.get());
            case CyberwareSlot.LLEG -> Set.of((Item)ModItems.BASECYBERWARE_LEFTLEG.get());
            default -> Set.of();
        };
    }

    @Override
    public Set<CyberwareSlot> getSupportedSlots() {
        return Set.of(CyberwareSlot.RLEG, CyberwareSlot.LLEG);
    }

    @Override
    public boolean replacesOrgan() {
        return false;
    }

    @Override
    public Set<CyberwareSlot> getReplacedOrgans() {
        return Set.of();
    }

    @Override
    public void onInstalled(Player player) {
    }

    @Override
    public void onRemoved(Player player) {
        MetalDetectorItem.stopLoopIfPlaying();
    }

    @Override
    public void onTick(Player player) {
        boolean detectedAny;
        Level level = player.level();
        if (!level.isClientSide) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.player != player) {
            return;
        }
        if (!this.isAnyMetalDetectorPowered(player)) {
            MetalDetectorItem.stopLoopIfPlaying();
            return;
        }
        BlockPos onPos = BlockPos.containing((double)player.getX(), (double)(player.getY() - 0.05), (double)player.getZ());
        int bestDy = Integer.MAX_VALUE;
        boolean bestDirectColumn = false;
        BlockPos firstHitPos = null;
        BlockState firstHitState = null;
        for (int dy = 0; dy <= 15; ++dy) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    boolean direct;
                    BlockPos checkPos = onPos.offset(dx, -dy, dz);
                    BlockState state = level.getBlockState(checkPos);
                    if (!state.is(ModTags.Blocks.METAL_DETECTABLE)) continue;
                    if (firstHitPos == null) {
                        firstHitPos = checkPos;
                        firstHitState = state;
                    }
                    boolean bl = direct = dx == 0 && dz == 0;
                    if (dy >= bestDy && (dy != bestDy || !direct || bestDirectColumn)) continue;
                    bestDy = dy;
                    bestDirectColumn = direct;
                }
            }
            if (bestDy == 0 && bestDirectColumn) break;
        }
        boolean bl = detectedAny = bestDy != Integer.MAX_VALUE;
        if (detectedAny) {
            MetalDetectorItem.startLoopIfNeeded(player);
            if (activeLoop != null) {
                float maxVol = 1.0f;
                float minVol = 0.2f;
                float t = 1.0f - (float)bestDy / 15.0f;
                float volume = minVol + (maxVol - minVol) * t;
                if (!bestDirectColumn) {
                    volume *= 0.5f;
                }
                activeLoop.setTargetVolume(volume);
            }
        } else {
            MetalDetectorItem.stopLoopIfPlaying();
        }
    }

    private boolean isAnyMetalDetectorPowered(Player player) {
        if (!player.hasData(ModAttachments.CYBERWARE)) {
            return false;
        }
        PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
        if (data == null) {
            return false;
        }
        for (CyberwareSlot slot : this.getSupportedSlots()) {
            for (int i = 0; i < slot.size; ++i) {
                ItemStack st;
                InstalledCyberware cw = data.get(slot, i);
                if (cw == null || (st = cw.getItem()) == null || st.isEmpty() || st.getItem() != this || !cw.isPowered()) continue;
                return true;
            }
        }
        return false;
    }

    private static void startLoopIfNeeded(Player player) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getSoundManager() == null) {
            return;
        }
        if (activeLoop != null && mc.getSoundManager().isActive((SoundInstance)activeLoop)) {
            return;
        }
        activeLoop = new MetalDetectorLoopSound(player, ModSounds.METAL_DETECTOR_BEEPS.get());
        mc.getSoundManager().play((SoundInstance)activeLoop);
    }

    private static void stopLoopIfPlaying() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getSoundManager() == null) {
            return;
        }
        if (activeLoop != null) {
            mc.getSoundManager().stop((SoundInstance)activeLoop);
            activeLoop = null;
        }
    }
}

