/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.item.cyberware;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.ModItems;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;

@EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME)
public class OcelotPawsItem
extends Item
implements ICyberwareItem {
    private final int humanityCost;

    public OcelotPawsItem(Item.Properties props, int humanityCost) {
        super(props);
        this.humanityCost = humanityCost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createcybernetics.humanity", (Object[])new Object[]{this.humanityCost}).withStyle(ChatFormatting.GOLD));
        }
    }

    @Override
    public int getHumanityCost() {
        return this.humanityCost;
    }

    @Override
    public Set<Item> requiresCyberware(ItemStack installedStack, CyberwareSlot slot) {
        return switch (slot) {
            case CyberwareSlot.RLEG -> Set.of((Item)ModItems.BASECYBERWARE_RIGHTLEG.get());
            case CyberwareSlot.LLEG -> Set.of((Item)ModItems.BASECYBERWARE_LEFTLEG.get());
            default -> Set.of();
        };
    }

    @Override
    public Set<CyberwareSlot> getSupportedSlots() {
        return Set.of(CyberwareSlot.RLEG, CyberwareSlot.LLEG);
    }

    @Override
    public boolean replacesOrgan() {
        return false;
    }

    @Override
    public Set<CyberwareSlot> getReplacedOrgans() {
        return Set.of();
    }

    @Override
    public void onInstalled(Player player) {
    }

    @Override
    public void onRemoved(Player player) {
    }

    @Override
    public void onTick(Player player) {
        ICyberwareItem.super.onTick(player);
    }

    public static boolean shouldSuppressVibration(Player player, Holder<GameEvent> event, GameEvent.Context context) {
        if (player.level().isClientSide) {
            return false;
        }
        if (!OcelotPawsItem.isInstalled(player)) {
            return false;
        }
        return event == GameEvent.STEP || event == GameEvent.HIT_GROUND;
    }

    public static boolean cancelFeetSounds(Player player, Holder<SoundEvent> sound, SoundSource source) {
        if (!OcelotPawsItem.isInstalled(player)) {
            return false;
        }
        if (source != SoundSource.PLAYERS) {
            return false;
        }
        ResourceLocation id = sound.unwrapKey().map(ResourceKey::location).orElse(null);
        if (id == null) {
            return false;
        }
        String path = id.getPath();
        boolean isFootstep = path.contains(".step");
        boolean isLanding = path.contains(".fall") || path.contains("small_fall") || path.contains("big_fall");
        return isFootstep || isLanding;
    }

    @SubscribeEvent
    public static void onPlayLevelSoundAtEntity(PlayLevelSoundEvent.AtEntity event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (OcelotPawsItem.cancelFeetSounds(player, (Holder<SoundEvent>)event.getSound(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    private static boolean isInstalled(Player player) {
        PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
        if (data == null) {
            return false;
        }
        return data.hasSpecificItem((Item)ModItems.LEGUPGRADES_OCELOTPAWS.get(), CyberwareSlot.RLEG) && data.hasSpecificItem((Item)ModItems.LEGUPGRADES_OCELOTPAWS.get(), CyberwareSlot.LLEG);
    }
}

