/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.item.cyberware;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.ModItems;
import com.perigrine3.createcybernetics.util.ModTags;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class OxygenTankItem
extends Item
implements ICyberwareItem {
    private final int humanityCost;
    private static final int ENERGY_PER_TICK_UNDERWATER = 3;

    public OxygenTankItem(Item.Properties props, int humanityCost) {
        super(props);
        this.humanityCost = humanityCost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createcybernetics.humanity", (Object[])new Object[]{this.humanityCost}).withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.literal((String)"Costs 3 Energy").withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public int getHumanityCost() {
        return this.humanityCost;
    }

    @Override
    public Set<TagKey<Item>> requiresCyberwareTags(ItemStack installedStack, CyberwareSlot slot) {
        return Set.of(ModTags.Items.LUNGS_ITEMS);
    }

    @Override
    public Set<CyberwareSlot> getSupportedSlots() {
        return Set.of(CyberwareSlot.LUNGS);
    }

    @Override
    public boolean replacesOrgan() {
        return false;
    }

    @Override
    public Set<CyberwareSlot> getReplacedOrgans() {
        return Set.of();
    }

    @Override
    public int getEnergyUsedPerTick(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return player != null && player.isEyeInFluid(FluidTags.WATER) ? 3 : 0;
    }

    @Override
    public boolean requiresEnergyToFunction(Player player, ItemStack installedStack, CyberwareSlot slot) {
        return true;
    }

    @Override
    public void onInstalled(Player player) {
        if (!player.level().isClientSide) {
            AirHandler.resetOxygenTankTracking(player);
        }
    }

    @Override
    public void onRemoved(Player player) {
        if (!player.level().isClientSide) {
            AirHandler.resetOxygenTankTracking(player);
        }
    }

    @EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME)
    public static final class AirHandler {
        private static final String KEY_HAS_PREV = "cc_o2tank_has_prev";
        private static final String KEY_PREV_AIR = "cc_o2tank_prev_air";
        private static final String KEY_DECREMENT_COUNT = "cc_o2tank_dec_count";

        private AirHandler() {
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (player.level().isClientSide) {
                return;
            }
            if (!AirHandler.hasOxygenTankInstalled(player)) {
                AirHandler.resetOxygenTankTracking(player);
                return;
            }
            boolean eyesInWater = player.isEyeInFluid(FluidTags.WATER);
            if (!eyesInWater || !AirHandler.isOxygenTankPowered(player)) {
                CompoundTag data = player.getPersistentData();
                data.putBoolean(KEY_HAS_PREV, true);
                data.putInt(KEY_PREV_AIR, player.getAirSupply());
                data.putInt(KEY_DECREMENT_COUNT, 0);
                return;
            }
            int air = player.getAirSupply();
            int maxAir = player.getMaxAirSupply();
            CompoundTag data = player.getPersistentData();
            if (air >= maxAir) {
                data.putBoolean(KEY_HAS_PREV, true);
                data.putInt(KEY_PREV_AIR, air);
                data.putInt(KEY_DECREMENT_COUNT, 0);
                return;
            }
            if (!data.contains(KEY_HAS_PREV, 1)) {
                data.putBoolean(KEY_HAS_PREV, true);
                data.putInt(KEY_PREV_AIR, air);
                data.putInt(KEY_DECREMENT_COUNT, 0);
                return;
            }
            int prevAir = data.getInt(KEY_PREV_AIR);
            int decCount = data.getInt(KEY_DECREMENT_COUNT);
            if (air < prevAir) {
                int delta = prevAir - air;
                int refund = 0;
                for (int i = 0; i < delta; ++i) {
                    if (++decCount % 4 == 0) continue;
                    ++refund;
                }
                if (refund > 0) {
                    int newAir = Math.min(maxAir, air + refund);
                    player.setAirSupply(newAir);
                    air = newAir;
                }
                data.putInt(KEY_DECREMENT_COUNT, decCount);
            }
            data.putInt(KEY_PREV_AIR, air);
        }

        public static void resetOxygenTankTracking(Player player) {
            CompoundTag data = player.getPersistentData();
            data.remove(KEY_HAS_PREV);
            data.remove(KEY_PREV_AIR);
            data.remove(KEY_DECREMENT_COUNT);
        }

        private static boolean hasOxygenTankInstalled(Player player) {
            PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
            if (data == null) {
                return false;
            }
            return data.hasSpecificItem((Item)ModItems.LUNGSUPGRADES_OXYGEN.get(), CyberwareSlot.LUNGS);
        }

        private static boolean isOxygenTankPowered(Player player) {
            if (!player.hasData(ModAttachments.CYBERWARE)) {
                return false;
            }
            PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
            if (data == null) {
                return false;
            }
            Item target = (Item)ModItems.LUNGSUPGRADES_OXYGEN.get();
            for (int i = 0; i < CyberwareSlot.LUNGS.size; ++i) {
                ItemStack st;
                InstalledCyberware cw = data.get(CyberwareSlot.LUNGS, i);
                if (cw == null || (st = cw.getItem()) == null || st.isEmpty() || st.getItem() != target) continue;
                return cw.isPowered();
            }
            return false;
        }
    }
}

