/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.item.cyberware;

import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.api.ICyberwareItem;
import com.perigrine3.createcybernetics.api.InstalledCyberware;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.effect.ModEffects;
import com.perigrine3.createcybernetics.item.ModItems;
import com.perigrine3.createcybernetics.util.CyberwareAttributeHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class PneumaticCalvesItem
extends Item
implements ICyberwareItem {
    private final int humanityCost;
    private static final int ENERGY_SPRINT_JUMP = 3;
    private static final int ENERGY_CROUCH_JUMP = 5;
    private static final String NBT_LAST_JUMP_CHARGE_TICK = "cc_calves_last_jump_charge_tick";

    public PneumaticCalvesItem(Item.Properties props, int humanityCost) {
        super(props);
        this.humanityCost = humanityCost;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.createcybernetics.humanity", (Object[])new Object[]{this.humanityCost}).withStyle(ChatFormatting.GOLD));
            tooltip.add((Component)Component.literal((String)"Costs 3-5 Energy").withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public int getHumanityCost() {
        return this.humanityCost;
    }

    @Override
    public Set<Item> requiresCyberware(ItemStack installedStack, CyberwareSlot slot) {
        return switch (slot) {
            case CyberwareSlot.RLEG -> Set.of((Item)ModItems.BASECYBERWARE_RIGHTLEG.get());
            case CyberwareSlot.LLEG -> Set.of((Item)ModItems.BASECYBERWARE_LEFTLEG.get());
            default -> Set.of();
        };
    }

    @Override
    public Set<CyberwareSlot> getSupportedSlots() {
        return Set.of(CyberwareSlot.RLEG, CyberwareSlot.LLEG);
    }

    @Override
    public boolean replacesOrgan() {
        return false;
    }

    @Override
    public Set<CyberwareSlot> getReplacedOrgans() {
        return Set.of();
    }

    @Override
    public void onInstalled(Player player) {
    }

    @Override
    public void onRemoved(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        CyberwareAttributeHelper.removeModifier(player, "calves_sprint");
        player.removeEffect(ModEffects.PNEUMATIC_CALVES_EFFECT);
        player.getPersistentData().remove(NBT_LAST_JUMP_CHARGE_TICK);
    }

    @Override
    public void onTick(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        player.addEffect(new MobEffectInstance(ModEffects.PNEUMATIC_CALVES_EFFECT, 100, 0, false, false, false));
        if (player.isSprinting()) {
            CyberwareAttributeHelper.applyModifier(player, "calves_sprint");
        } else {
            CyberwareAttributeHelper.removeModifier(player, "calves_sprint");
        }
    }

    @EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.GAME)
    public static final class Events {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
            int cost;
            boolean sprintJump;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            if (player.level().isClientSide) {
                return;
            }
            if (!player.isAlive()) {
                return;
            }
            if (player.isCreative() || player.isSpectator()) {
                return;
            }
            if (!player.hasData(ModAttachments.CYBERWARE)) {
                return;
            }
            PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
            if (data == null) {
                return;
            }
            if (!Events.hasPneumaticCalvesInstalled(data)) {
                return;
            }
            boolean crouchJump = player.isCrouching();
            boolean bl = sprintJump = !crouchJump && player.isSprinting();
            int n = crouchJump ? 5 : (cost = sprintJump ? 3 : 0);
            if (cost <= 0) {
                return;
            }
            long now = player.level().getGameTime();
            CompoundTag ptag = player.getPersistentData();
            if (ptag.getLong(PneumaticCalvesItem.NBT_LAST_JUMP_CHARGE_TICK) == now) {
                return;
            }
            ptag.putLong(PneumaticCalvesItem.NBT_LAST_JUMP_CHARGE_TICK, now);
            if (!data.tryConsumeEnergy(cost)) {
                player.removeEffect(ModEffects.PNEUMATIC_CALVES_EFFECT);
                return;
            }
            data.setDirty();
            player.syncData(ModAttachments.CYBERWARE);
        }

        private static boolean hasPneumaticCalvesInstalled(PlayerCyberwareData data) {
            for (CyberwareSlot slot : new CyberwareSlot[]{CyberwareSlot.RLEG, CyberwareSlot.LLEG}) {
                for (int i = 0; i < slot.size; ++i) {
                    ItemStack st;
                    InstalledCyberware cw = data.get(slot, i);
                    if (cw == null || (st = cw.getItem()) == null || st.isEmpty() || !(st.getItem() instanceof PneumaticCalvesItem)) continue;
                    return true;
                }
            }
            return false;
        }

        private Events() {
        }
    }
}

