/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.screen.custom.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import com.perigrine3.createcybernetics.api.CyberwareSlot;
import com.perigrine3.createcybernetics.common.capabilities.ModAttachments;
import com.perigrine3.createcybernetics.common.capabilities.PlayerCyberwareData;
import com.perigrine3.createcybernetics.item.ModItems;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="createcybernetics", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class CyberwareHudLayer {
    public static final ResourceLocation LAYER_ID = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberware_hud");
    public static final ResourceLocation CROSSHAIR_LAYER_ID = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberware_hud_crosshair");
    private static final ResourceLocation FRAME = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batteryframe.png");
    private static final ResourceLocation FRAME_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batteryframe_empty.png");
    private static final ResourceLocation BARS1 = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batterybars1.png");
    private static final ResourceLocation BARS1_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batterybars1_empty.png");
    private static final ResourceLocation BARS2 = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batterybars2.png");
    private static final ResourceLocation BARS2_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_batterybars2_empty.png");
    private static final ResourceLocation CENTER_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_overlay.png");
    private static final ResourceLocation CENTER_SPINNER = ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"textures/gui/hud/hud_overlay_circle.png");
    private static final int OVERLAY_W = 2048;
    private static final int OVERLAY_H = 1055;
    private static final int SPINNER_W = 2048;
    private static final int SPINNER_H = 1055;
    private static final float OVERLAY_MAX_SCREEN_FRACTION = 0.95f;
    private static final float OVERLAY_ALPHA = 0.5f;
    private static final boolean OVERLAY_DRAW_BEHIND_BATTERY = true;
    private static final float SPINNER_MAX_SCREEN_FRACTION = 1.25f;
    private static final float SPINNER_ALPHA = 0.1f;
    private static float SPINNER_OFFSET_X_PX = -0.5f;
    private static float SPINNER_OFFSET_Y_PX = -0.5f;
    private static float SPINNER_DEG_PER_SECOND = 10.0f;
    private static final int TEX_W = 13;
    private static final int TEX_H = 25;
    private static final int INNER_X = 1;
    private static final int INNER_Y = 2;
    private static final int INNER_W = 10;
    private static final int INNER_H = 21;
    private static final int MARGIN_X = 122;
    private static final int MARGIN_Y = 2;
    private static final float BATTERY_SCALE = 1.5f;
    private static final float VALUE_SCALE = 0.8f;
    private static final int VALUE_PADDING_PX = 2;
    private static final int VALUE_COLOR = 0xFFFFFF;
    private static final int VALUE_COLOR_LOW = 0xFF5555;
    private static final boolean VALUE_SHADOW = true;
    private static final float LOW_THRESHOLD = 0.25f;

    @SubscribeEvent
    public static void onRegisterGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.HOTBAR, LAYER_ID, CyberwareHudLayer::renderHud);
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, CROSSHAIR_LAYER_ID, CyberwareHudLayer::renderCrosshairOverlay);
    }

    private static void renderHud(GuiGraphics gg, DeltaTracker delta) {
        int net;
        int capacity;
        int current;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (mc.options.hideGui) {
            return;
        }
        if (!Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        if (!CyberwareInstallQueries.hasHudAccess(player)) {
            return;
        }
        int screenW = gg.guiWidth();
        int screenH = gg.guiHeight();
        CyberwareHudLayer.renderCenteredImageAutoFit(gg, CENTER_OVERLAY, 2048, 1055, screenW, screenH, 0.95f, 0.5f);
        TickSnapshot s = ClientEnergyState.getSnapshot();
        if (s != null) {
            current = s.storedAfter();
            capacity = s.capacity();
            net = s.netDeltaPerTick();
        } else {
            PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
            current = data != null ? data.getEnergyStored() : 0;
            capacity = data != null ? data.getTotalEnergyCapacity((Player)player) : 0;
            net = 0;
        }
        int capForPct = Math.max(1, capacity);
        float pct = Mth.clamp((float)((float)current / (float)capForPct), (float)0.0f, (float)1.0f);
        boolean low = pct <= 0.25f;
        int scaledW = Math.round(19.5f);
        int scaledH = Math.round(37.5f);
        int x = 122;
        int y = screenH - scaledH - 2;
        CyberwareHudLayer.renderEnergyValueAboveBattery(gg, mc, current, capacity, x, y, scaledW, low);
        CyberwareHudLayer.renderBatteryScaled(gg, x, y, current, capForPct, net);
    }

    private static void renderCrosshairOverlay(GuiGraphics gg, DeltaTracker delta) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (mc.options.hideGui) {
            return;
        }
        if (!Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        if (!CyberwareInstallQueries.hasHudAccess(player)) {
            return;
        }
        int screenW = gg.guiWidth();
        int screenH = gg.guiHeight();
        float partialTick = 0.0f;
        try {
            partialTick = delta.getGameTimeDeltaPartialTick(true);
        }
        catch (Throwable ignored) {
            partialTick = 0.0f;
        }
        CyberwareHudLayer.renderSpinningCenteredImageAutoFit(gg, CENTER_SPINNER, 2048, 1055, screenW, screenH, 1.25f, 0.1f, player.tickCount, partialTick, SPINNER_DEG_PER_SECOND, SPINNER_OFFSET_X_PX, SPINNER_OFFSET_Y_PX);
    }

    private static void renderCenteredImageAutoFit(GuiGraphics gg, ResourceLocation tex, int texW, int texH, int screenW, int screenH, float maxScreenFraction, float alpha) {
        float sx = (float)screenW * maxScreenFraction / (float)texW;
        float sy = (float)screenH * maxScreenFraction / (float)texH;
        float scale = Math.min(sx, sy);
        scale = Math.min(scale, 1.0f);
        int drawW = Math.round((float)texW * scale);
        int drawH = Math.round((float)texH * scale);
        int x = (screenW - drawW) / 2;
        int y = (screenH - drawH) / 2;
        gg.pose().pushPose();
        gg.pose().translate((float)x, (float)y, 0.0f);
        gg.pose().scale(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gg.blit(tex, 0, 0, 0.0f, 0.0f, texW, texH, texW, texH);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        gg.pose().popPose();
    }

    private static void renderSpinningCenteredImageAutoFit(GuiGraphics gg, ResourceLocation tex, int texW, int texH, int screenW, int screenH, float maxScreenFraction, float alpha, int tickCount, float partialTick, float degPerSecond, float offsetXPx, float offsetYPx) {
        float sx = (float)screenW * maxScreenFraction / (float)texW;
        float sy = (float)screenH * maxScreenFraction / (float)texH;
        float scale = Math.min(sx, sy);
        scale = Math.min(scale, 1.0f);
        float timeSeconds = ((float)tickCount + partialTick) / 20.0f;
        float angleDeg = timeSeconds * degPerSecond % 360.0f;
        gg.pose().pushPose();
        gg.pose().translate((float)screenW / 2.0f + offsetXPx, (float)screenH / 2.0f + offsetYPx, 0.0f);
        gg.pose().mulPose(Axis.ZP.rotationDegrees(angleDeg));
        gg.pose().scale(scale, scale, 1.0f);
        gg.pose().translate((float)(-texW) / 2.0f, (float)(-texH) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gg.blit(tex, 0, 0, 0.0f, 0.0f, texW, texH, texW, texH);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        gg.pose().popPose();
    }

    private static void renderEnergyValueAboveBattery(GuiGraphics gg, Minecraft mc, int current, int capacity, int batteryX, int batteryY, int scaledBatteryW, boolean low) {
        String text = current + "/" + capacity;
        Objects.requireNonNull(mc.font);
        int scaledTextH = Math.round(9.0f * 0.8f);
        int textY = batteryY - 2 - scaledTextH;
        int scaledTextW = Math.round((float)mc.font.width(text) * 0.8f);
        int textX = batteryX + scaledBatteryW / 2 - scaledTextW / 2;
        int color = low ? 0xFF5555 : 0xFFFFFF;
        gg.pose().pushPose();
        gg.pose().translate((float)textX, (float)textY, 0.0f);
        gg.pose().scale(0.8f, 0.8f, 1.0f);
        gg.drawString(mc.font, text, 0, 0, color, true);
        gg.pose().popPose();
    }

    private static void renderBatteryScaled(GuiGraphics gg, int x, int y, int currentPower, int maxPower, int netPowerPerTick) {
        gg.pose().pushPose();
        gg.pose().translate((float)x, (float)y, 0.0f);
        gg.pose().scale(1.5f, 1.5f, 1.0f);
        CyberwareHudLayer.renderBattery(gg, 0, 0, currentPower, maxPower, netPowerPerTick);
        gg.pose().popPose();
    }

    private static void renderBattery(GuiGraphics gg, int x, int y, int currentPower, int maxPower, int netPowerPerTick) {
        ResourceLocation bars2;
        float pct = maxPower <= 0 ? 0.0f : (float)currentPower / (float)maxPower;
        pct = Mth.clamp((float)pct, (float)0.0f, (float)1.0f);
        int fillPx = Math.round(pct * 21.0f);
        fillPx = Mth.clamp((int)fillPx, (int)0, (int)21);
        int usedPx = 21 - fillPx;
        boolean low = pct <= 0.25f;
        ResourceLocation frame = low ? FRAME_EMPTY : FRAME;
        ResourceLocation bars1 = low ? BARS1_EMPTY : BARS1;
        ResourceLocation resourceLocation = bars2 = low ? BARS2_EMPTY : BARS2;
        if (fillPx > 0) {
            int dstX = x + 1;
            int dstY = y + 2 + usedPx;
            int srcU = 1;
            int srcV = 2 + usedPx;
            CyberwareHudLayer.blit(gg, bars2, dstX, dstY, srcU, srcV, 10, fillPx);
            CyberwareHudLayer.blit(gg, bars1, dstX, dstY, srcU, srcV, 10, fillPx);
        }
        CyberwareHudLayer.blit(gg, frame, x, y, 0, 0, 13, 25);
    }

    private static void blit(GuiGraphics gg, ResourceLocation tex, int x, int y, int u, int v, int w, int h) {
        gg.blit(tex, x, y, (float)u, (float)v, w, h, 13, 25);
    }

    public static final class CyberwareInstallQueries {
        private CyberwareInstallQueries() {
        }

        public static boolean hasHudAccess(LocalPlayer player) {
            PlayerCyberwareData data = (PlayerCyberwareData)player.getData(ModAttachments.CYBERWARE);
            if (data == null) {
                return false;
            }
            return data.hasSpecificItem((Item)ModItems.EYEUPGRADES_HUDLENS.get(), CyberwareSlot.EYES) || data.hasSpecificItem((Item)ModItems.EYEUPGRADES_HUDJACK.get(), CyberwareSlot.EYES);
        }
    }

    public static final class ClientEnergyState {
        private static volatile TickSnapshot LAST = null;

        private ClientEnergyState() {
        }

        public static void update(TickSnapshot snapshot) {
            LAST = snapshot;
        }

        public static TickSnapshot getSnapshot() {
            return LAST;
        }
    }

    public record TickSnapshot(int generatedPerTick, int consumedPerTick, int storedBefore, int storedAfter, int capacity, int netDeltaPerTick) {
    }
}

