/*
 * Decompiled with CFR 0.152.
 */
package com.perigrine3.createcybernetics.util;

import com.perigrine3.createcybernetics.CreateCybernetics;
import com.perigrine3.createcybernetics.common.attributes.ModAttributes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class CyberwareAttributeHelper {
    private static final Map<String, AttributeModifierData> MODIFIER_REGISTRY = new HashMap<String, AttributeModifierData>();

    public static void registerModifier(String id, AttributeModifierData data) {
        MODIFIER_REGISTRY.put(id, data);
    }

    public static void applyModifier(Player player, String modifierId) {
        AttributeModifierData data = MODIFIER_REGISTRY.get(modifierId);
        if (data == null) {
            CreateCybernetics.LOGGER.error("Attempted to apply unknown modifier: " + modifierId);
            return;
        }
        CyberwareAttributeHelper.removeModifier(player, modifierId);
        player.getAttribute(data.attribute).addOrReplacePermanentModifier(new AttributeModifier(data.name, data.amount, data.operation));
    }

    public static void removeModifier(Player player, String modifierId) {
        AttributeModifierData data = MODIFIER_REGISTRY.get(modifierId);
        if (data == null) {
            CreateCybernetics.LOGGER.error("Attempted to remove unknown modifier: " + modifierId);
            return;
        }
        player.getAttribute(data.attribute).removeModifier(data.name);
    }

    public static boolean hasModifier(Player player, String modifierId) {
        AttributeModifierData data = MODIFIER_REGISTRY.get(modifierId);
        if (data == null) {
            return false;
        }
        return player.getAttribute(data.attribute).getModifier(data.name) != null;
    }

    static {
        Holder maxHealthAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.MAX_HEALTH.getKey()).orElseThrow(() -> new IllegalStateException("Max health attribute not found in registry"));
        Holder armorAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ARMOR.getKey()).orElseThrow(() -> new IllegalStateException("Armor attribute not found in registry"));
        Holder armorToughnessAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ARMOR_TOUGHNESS.getKey()).orElseThrow(() -> new IllegalStateException("Armor toughness attribute not found in registry"));
        Holder oxygenBonusAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.OXYGEN_BONUS.getKey()).orElseThrow(() -> new IllegalStateException("Oxygen bonus attribute not found in registry"));
        Holder speedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.MOVEMENT_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Movement speed attribute not found in registry"));
        Holder knockbackResistAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.KNOCKBACK_RESISTANCE.getKey()).orElseThrow(() -> new IllegalStateException("Knockback resistance attribute not found in registry"));
        Holder jumpStrengthAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.JUMP_STRENGTH.getKey()).orElseThrow(() -> new IllegalStateException("Jump strength attribute not found in registry"));
        Holder attackDamageAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ATTACK_DAMAGE.getKey()).orElseThrow(() -> new IllegalStateException("Attack damage attribute not found in registry"));
        Holder attackSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ATTACK_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Attack speed attribute not found in registry"));
        Holder attackKnockbackAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ATTACK_KNOCKBACK.getKey()).orElseThrow(() -> new IllegalStateException("Attack knockback attribute not found in registry"));
        Holder luckAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.LUCK.getKey()).orElseThrow(() -> new IllegalStateException("Luck attribute not found in registry"));
        Holder blockReachAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.BLOCK_INTERACTION_RANGE.getKey()).orElseThrow(() -> new IllegalStateException("Block reach attribute not found in registry"));
        Holder entityReachAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.ENTITY_INTERACTION_RANGE.getKey()).orElseThrow(() -> new IllegalStateException("Entity reach attribute not found in registry"));
        Holder stepHeightAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.STEP_HEIGHT.getKey()).orElseThrow(() -> new IllegalStateException("Step height attribute not found in registry"));
        Holder swimSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.WATER_MOVEMENT_EFFICIENCY.getKey()).orElseThrow(() -> new IllegalStateException("Swim speed attribute not found in registry"));
        Holder gravityAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.GRAVITY.getKey()).orElseThrow(() -> new IllegalStateException("Gravity attribute not found in registry"));
        Holder scaleAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.SCALE.getKey()).orElseThrow(() -> new IllegalStateException("Scale attribute not found in registry"));
        Holder flyingSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.FLYING_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Flying speed attribute not found in registry"));
        Holder blockBreakSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.BLOCK_BREAK_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Block break speed attribute not found in registry"));
        Holder safeFallDistanceAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.SAFE_FALL_DISTANCE.getKey()).orElseThrow(() -> new IllegalStateException("Safe fall distance attribute not found in registry"));
        Holder burningTimeAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.BURNING_TIME.getKey()).orElseThrow(() -> new IllegalStateException("Burning time attribute not found in registry"));
        Holder underwaterMiningAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.SUBMERGED_MINING_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Underwater mining attribute not found in registry"));
        Holder underwaterMovementAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.WATER_MOVEMENT_EFFICIENCY.getKey()).orElseThrow(() -> new IllegalStateException("Underwater movement attribute not found in registry"));
        Holder miningSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.MINING_EFFICIENCY.getKey()).orElseThrow(() -> new IllegalStateException("Mining speed attribute not found in registry"));
        Holder crouchSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(Attributes.SNEAKING_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Crouch speed attribute not found in registry"));
        Holder xpMultiplierAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.XP_GAIN_MULTIPLIER.getKey()).orElseThrow(() -> new IllegalStateException("XP multiplier attribute not found in registry"));
        Holder oreMultiplierAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.ORE_DROP_MULTIPLIER.getKey()).orElseThrow(() -> new IllegalStateException("Ore drop multiplier attribute not found in registry"));
        Holder hagglingAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.HAGGLING.getKey()).orElseThrow(() -> new IllegalStateException("Haggling attribute not found in registry"));
        Holder craftingOutputAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.CRAFTING_OUTPUT.getKey()).orElseThrow(() -> new IllegalStateException("Crafting output attribute not found in registry"));
        Holder arrowInaccuracyAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.ARROW_INACCURACY.getKey()).orElseThrow(() -> new IllegalStateException("Arrow inaccuracy attribute not found in registry"));
        Holder breedingMultiplierAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.BREEDING_MULTIPLIER.getKey()).orElseThrow(() -> new IllegalStateException("Breeding multiplier attribute not found in registry"));
        Holder cropMultiplierAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.CROP_MULTIPLIER.getKey()).orElseThrow(() -> new IllegalStateException("Crop multiplier attribute not found in registry"));
        Holder elytraSpeedAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.ELYTRA_SPEED.getKey()).orElseThrow(() -> new IllegalStateException("Elytra speed attribute not found in registry"));
        Holder elytraHandlingAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.ELYTRA_HANDLING.getKey()).orElseThrow(() -> new IllegalStateException("Elytra speed attribute not found in registry"));
        Holder insomniaAttribute = (Holder)BuiltInRegistries.ATTRIBUTE.getHolder(ModAttributes.INSOMNIA.getKey()).orElseThrow(() -> new IllegalStateException("Insomnia attribute not found in registry"));
        CyberwareAttributeHelper.registerModifier("cyberleg_speed", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberleg_speed_boost"), 0.01, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyberleg_jump", new AttributeModifierData((Holder<Attribute>)jumpStrengthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberleg_jump_boost"), 0.05, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyberarm_strength", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberarm_strength_boost"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyberarm_blockbreak", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberarm_blockbreak_speed"), 0.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("linear_frame_health", new AttributeModifierData((Holder<Attribute>)maxHealthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"linear_frame_health_boost"), 8.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("linear_frame_knockback_resist", new AttributeModifierData((Holder<Attribute>)knockbackResistAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"linear_frame_knockback_resistance"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("linear_frame_blockbreak", new AttributeModifierData((Holder<Attribute>)blockBreakSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"linear_frame_blockbreak_speed"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("linear_frame_speed", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"linear_frame_speed_stifle"), -0.02, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("subdermalarmor_armor", new AttributeModifierData((Holder<Attribute>)armorAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"subdermal_armor_boost"), 6.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("bonelacing_health_1", new AttributeModifierData((Holder<Attribute>)maxHealthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"bonelacing_health_boost_1"), 4.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("bonelacing_health_2", new AttributeModifierData((Holder<Attribute>)maxHealthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"bonelacing_health_boost_2"), 4.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("bonelacing_health_3", new AttributeModifierData((Holder<Attribute>)maxHealthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"bonelacing_health_boost_3"), 4.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("boneflex_fall_1", new AttributeModifierData((Holder<Attribute>)safeFallDistanceAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"boneflex_fall_save_1"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("boneflex_fall_2", new AttributeModifierData((Holder<Attribute>)safeFallDistanceAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"boneflex_fall_save_2"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("boneflex_fall_3", new AttributeModifierData((Holder<Attribute>)safeFallDistanceAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"boneflex_fall_save_3"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("fall_bracer_fall_1", new AttributeModifierData((Holder<Attribute>)safeFallDistanceAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"fall_bracer_fall_save_1"), 11.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("fall_bracer_fall_2", new AttributeModifierData((Holder<Attribute>)safeFallDistanceAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"fall_bracer_fall_save_2"), 11.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("pneumatic_wrist_block", new AttributeModifierData((Holder<Attribute>)blockReachAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"pneumatic_wrist_block_reach"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("pneumatic_wrist_entity", new AttributeModifierData((Holder<Attribute>)entityReachAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"pneumatic_wrist_entity_reach"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("pneumatic_wrist_knockback", new AttributeModifierData((Holder<Attribute>)attackKnockbackAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"pneumatic_wrist_knockback_bonus"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("oxygen_tank_oxygen", new AttributeModifierData((Holder<Attribute>)oxygenBonusAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"oxygen_tank_oxygen_bonus"), 10.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("propeller_swim_1", new AttributeModifierData((Holder<Attribute>)swimSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"propeller_swim_speed_1"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("propeller_swim_2", new AttributeModifierData((Holder<Attribute>)swimSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"propeller_swim_speed_2"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("isothermal_burning", new AttributeModifierData((Holder<Attribute>)burningTimeAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"isothermal_burning_time"), -0.95, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("ravager_tendons_size", new AttributeModifierData((Holder<Attribute>)scaleAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"ravager_tendons_size_increase"), 0.2, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("ravager_tendons_strength", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"ravager_tendons_attack_boost"), 5.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("ravager_tendons_knockback_resist", new AttributeModifierData((Holder<Attribute>)knockbackResistAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"ravager_tendons_knockback_resistance"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("ravager_tendons_knockback", new AttributeModifierData((Holder<Attribute>)attackKnockbackAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"ravager_tendons_attack_knockback"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("hyperoxygenation_speed_1", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"hyperoxygenation_speed_boost_1"), 0.03, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("hyperoxygenation_speed_2", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"hyperoxygenation_speed_boost_2"), 0.03, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("hyperoxygenation_speed_3", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"hyperoxygenation_speed_boost_3"), 0.03, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_strength", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_strength_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_size", new AttributeModifierData((Holder<Attribute>)scaleAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_size_boost"), 0.1, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_knockback_resist", new AttributeModifierData((Holder<Attribute>)knockbackResistAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_knockback_resistance"), 1.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_knockback", new AttributeModifierData((Holder<Attribute>)attackKnockbackAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_attack_knockback"), 1.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_speed", new AttributeModifierData((Holder<Attribute>)attackKnockbackAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_speed_boost"), 0.15, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("synthmuscle_jump", new AttributeModifierData((Holder<Attribute>)jumpStrengthAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"synthmuscle_jump_boost"), 0.1, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("reinforced_knuckles_damage", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"reinforced_knuckles_damage_boost"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("calves_sprint", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"calves_sprint_boost"), 0.05, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("gyrobladder_speed", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"gyrobladder_speed_stifle"), -0.75, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("claws_attack", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"claws_attack_boost"), 5.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("sandevistan_speed", new AttributeModifierData((Holder<Attribute>)speedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"sandevistan_speed_boost"), 0.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("sandevistan_stepheight", new AttributeModifierData((Holder<Attribute>)stepHeightAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"sandevistan_stepheight_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("sandevistan_jump", new AttributeModifierData((Holder<Attribute>)stepHeightAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"sandevistan_jump_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyberbrain_learn", new AttributeModifierData((Holder<Attribute>)xpMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberbrain_learn_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyberbrain_insomnia", new AttributeModifierData((Holder<Attribute>)xpMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyberbrain_insomnia"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("redshard_strength", new AttributeModifierData((Holder<Attribute>)attackDamageAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"redshard_strength_boost"), 5.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("redshard_speed", new AttributeModifierData((Holder<Attribute>)attackSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"redshard_speed_boost"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("redshard_knockback", new AttributeModifierData((Holder<Attribute>)attackSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"redshard_knockback_boost"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("orangeshard_ore", new AttributeModifierData((Holder<Attribute>)oreMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"orangeshard_ore_multiplier"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("orangeshard_mining", new AttributeModifierData((Holder<Attribute>)miningSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"orangeshard_mining_speed"), 0.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("yellowshard_haggling", new AttributeModifierData((Holder<Attribute>)hagglingAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"yellowshard_haggling_boost"), 2.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("greenshard_xp", new AttributeModifierData((Holder<Attribute>)xpMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"greenshard_xp_multiplier"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("cyanshard_aim", new AttributeModifierData((Holder<Attribute>)arrowInaccuracyAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"cyanshard_aim_bot"), -1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("blueshard_swim", new AttributeModifierData((Holder<Attribute>)swimSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blueshard_swim_speed"), 3.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("blueshard_mining", new AttributeModifierData((Holder<Attribute>)underwaterMiningAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blueshard_mining_speed"), 1.5, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("blueshard_movement", new AttributeModifierData((Holder<Attribute>)underwaterMovementAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blueshard_movement_speed"), 4.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("blueshard_oxygen", new AttributeModifierData((Holder<Attribute>)oxygenBonusAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blueshard_oxygen_boost"), 7.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("purpleshard_crafting", new AttributeModifierData((Holder<Attribute>)craftingOutputAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"purpleshard_crafting_output"), 1.0, AttributeModifier.Operation.ADD_VALUE));
        CyberwareAttributeHelper.registerModifier("pinkshard_breeding", new AttributeModifierData((Holder<Attribute>)breedingMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"pinkshard_breeding_multiplier"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("brownshard_crops", new AttributeModifierData((Holder<Attribute>)cropMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"brownshard_crops_multiplier"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("grayshard_speed", new AttributeModifierData((Holder<Attribute>)cropMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"grayshard_speed_boost"), 5.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("grayshard_handling", new AttributeModifierData((Holder<Attribute>)cropMultiplierAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"grayshard_handling_boost"), 5.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("blackshard_crouch", new AttributeModifierData((Holder<Attribute>)crouchSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blackshard_crouch_speed"), 2.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        CyberwareAttributeHelper.registerModifier("blackshard_sprint", new AttributeModifierData((Holder<Attribute>)crouchSpeedAttribute, ResourceLocation.fromNamespaceAndPath((String)"createcybernetics", (String)"blackshard_crouch_sprint"), 3.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    }

    private static class AttributeModifierData {
        final Holder<Attribute> attribute;
        final ResourceLocation name;
        final double amount;
        final AttributeModifier.Operation operation;

        AttributeModifierData(Holder<Attribute> attribute, ResourceLocation name, double amount, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.name = name;
            this.amount = amount;
            this.operation = operation;
        }
    }
}

