/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.AbstractModRender;
import com.dgneos.sound_visualizer.ModMath;
import java.util.Locale;

public abstract class AbstractBetterSubtitle {
    private final String _source;
    private final String _text;
    private final String _prefix;
    private final String _suffix;
    private final String _volumeText;
    private final String _pitchText;
    private final double _posX;
    private final double _posY;
    private final double _posZ;
    private final double _inWorldPosX;
    private final double _inWorldPosY;
    private final double _inWorldPosZ;
    private final int _height;
    private final int _priority;
    private final int _backgroundOpacity;
    private final int _textOpacity;
    private final int _finalBackgroundOpacity;
    private final int _finalTextOpacity;
    private final int _colorR;
    private final int _colorG;
    private final int _colorB;
    private final int _finalColorR;
    private final int _finalColorG;
    private final int _finalColorB;
    private final int _affixesColorR;
    private final int _affixesColorG;
    private final int _affixesColorB;
    private final int _finalAffixesColorR;
    private final int _finalAffixesColorG;
    private final int _finalAffixesColorB;
    private final int _characteristicsColorR;
    private final int _characteristicsColorG;
    private final int _characteristicsColorB;
    private final int _finalCharacteristicsColorR;
    private final int _finalCharacteristicsColorG;
    private final int _finalCharacteristicsColorB;
    private final float _lifeTime;
    protected long _time;
    private int _width = 0;
    private int _textWidth = 0;
    private boolean _loaded = false;

    public AbstractBetterSubtitle(Object sound, String source, String text, double posX, double posY, double posZ, double inWorldPosX, double inWorldPosY, double inWorldPosZ) {
        boolean showPitch;
        this.Resurrect();
        this._source = source;
        this._posX = posX;
        this._posY = posY;
        this._posZ = posZ;
        this._inWorldPosX = inWorldPosX;
        this._inWorldPosY = inWorldPosY;
        this._inWorldPosZ = inWorldPosZ;
        String soundLocation = AbstractModLogic.GetSoundLocation(sound);
        String textReplace = (String)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.ReplacedText);
        if (!textReplace.isEmpty()) {
            text = textReplace;
        }
        if (text == null) {
            text = "";
        }
        this._text = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ReplaceNameWithLocation) == 1 || AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ShowAll) == 1 && text.isEmpty() ? soundLocation : text;
        this._prefix = (String)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.Prefix);
        this._suffix = (String)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.Suffix);
        boolean characteristicsHint = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.CharacteristicsHint) == 1;
        String volumeText = characteristicsHint ? "V: " : "";
        this._volumeText = volumeText + String.format(Locale.ROOT, "%.2f", Float.valueOf(AbstractModLogic.GetSoundVolume(sound)));
        String pitchText = characteristicsHint ? "P: " : "";
        this._pitchText = pitchText + String.format(Locale.ROOT, "%.2f", Float.valueOf(AbstractModLogic.GetSoundPitch(sound)));
        int characteristicsLocation = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.CharacteristicsLocation);
        boolean showVolume = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.VolumeCharacteristic) == 1;
        boolean bl = showPitch = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.PitchCharacteristic) == 1;
        if (AbstractModLogic.IsGameVersionLaterOrEqual("1.21.9")) {
            AbstractModRender.RecordCall(() -> {
                int width;
                this._textWidth = width = AbstractModLogic.GetTextWidth(this._prefix + this._text + this._suffix);
                width = characteristicsLocation >= 2 ? Math.max(width, AbstractModLogic.GetTextWidth((String)(showVolume ? this._volumeText + " " : "") + (String)(showPitch ? this._pitchText + " " : ""))) : (width += AbstractModLogic.GetTextWidth((String)(showVolume ? this._volumeText + " " : "") + (String)(showPitch ? this._pitchText + " " : "")));
                if (AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.DirectionArrows) == 1) {
                    width += AbstractModLogic.GetTextWidth("<  >");
                }
                this._width = width;
                this._loaded = true;
            });
        } else {
            int width;
            this._textWidth = width = AbstractModLogic.GetTextWidth(this._prefix + this._text + this._suffix);
            width = characteristicsLocation >= 2 ? Math.max(width, AbstractModLogic.GetTextWidth((String)(showVolume ? this._volumeText + " " : "") + (String)(showPitch ? this._pitchText + " " : ""))) : (width += AbstractModLogic.GetTextWidth((String)(showVolume ? this._volumeText + " " : "") + (String)(showPitch ? this._pitchText + " " : "")));
            if (AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.DirectionArrows) == 1) {
                width += AbstractModLogic.GetTextWidth("<  >");
            }
            this._width = width;
            this._loaded = true;
        }
        this._height = characteristicsLocation >= 2 && (showVolume || showPitch) ? AbstractModLogic.GetTextHeight() * 2 + 2 : AbstractModLogic.GetTextHeight() + 1;
        this._priority = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.Priority);
        this._backgroundOpacity = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.BackgroundOpacity);
        this._textOpacity = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.TextOpacity);
        this._finalBackgroundOpacity = Math.clamp((long)((int)((float)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalBackgroundOpacityPercent)).intValue() / 100.0f * (float)this._backgroundOpacity)), AbstractConfig.SubtitleConfig.BackgroundOpacity.GetMinValue(), AbstractConfig.SubtitleConfig.BackgroundOpacity.GetMaxValue());
        this._finalTextOpacity = Math.clamp((long)((int)((float)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextOpacityPercent)).intValue() / 100.0f * (float)this._textOpacity)), AbstractConfig.SubtitleConfig.TextOpacity.GetMinValue(), AbstractConfig.SubtitleConfig.TextOpacity.GetMaxValue());
        this._colorR = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.TextColorR);
        this._colorG = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.TextColorG);
        this._colorB = (Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.TextColorB);
        double normalizedColorR = (double)this._colorR / 255.0;
        double normalizedColorG = (double)this._colorG / 255.0;
        double normalizedColorB = (double)this._colorB / 255.0;
        double maxColor = Math.max(Math.max(normalizedColorR, normalizedColorG), normalizedColorB);
        double minColor = Math.min(Math.min(normalizedColorR, normalizedColorG), normalizedColorB);
        double colorDifference = maxColor - minColor;
        double hue = 0.0;
        double saturation = 0.0;
        double brightness = (maxColor + minColor) / 2.0;
        if (colorDifference != 0.0) {
            if (maxColor == normalizedColorR) {
                hue = (normalizedColorG - normalizedColorB) / colorDifference % 6.0 * 60.0;
            } else if (maxColor == normalizedColorG) {
                hue = ((normalizedColorB - normalizedColorR) / colorDifference + 2.0) * 60.0;
            } else if (maxColor == normalizedColorB) {
                hue = ((normalizedColorR - normalizedColorG) / colorDifference + 4.0) * 60.0;
            }
            saturation = colorDifference / (1.0 - Math.abs(2.0 * brightness - 1.0));
        }
        double newSaturation = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextSaturationPercent)).intValue() / 100.0 * saturation, 0.0, 1.0);
        double newBrightness = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextBrightnessPercent)).intValue() / 100.0 * brightness, 0.0, 1.0);
        int[] hsvColor = AbstractBetterSubtitle.HSVToRGB(hue, newSaturation, newBrightness);
        this._finalColorR = hsvColor[0];
        this._finalColorG = hsvColor[1];
        this._finalColorB = hsvColor[2];
        newSaturation = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.AffixesSaturationPercent)).intValue() / 100.0 * saturation, 0.0, 1.0);
        newBrightness = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.AffixesBrightnessPercent)).intValue() / 100.0 * brightness, 0.0, 1.0);
        hsvColor = AbstractBetterSubtitle.HSVToRGB(hue, newSaturation, newBrightness);
        this._affixesColorR = hsvColor[0];
        this._affixesColorG = hsvColor[1];
        this._affixesColorB = hsvColor[2];
        newSaturation = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextSaturationPercent)).intValue() / 100.0 * newSaturation, 0.0, 1.0);
        newBrightness = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextBrightnessPercent)).intValue() / 100.0 * newBrightness, 0.0, 1.0);
        hsvColor = AbstractBetterSubtitle.HSVToRGB(hue, newSaturation, newBrightness);
        this._finalAffixesColorR = hsvColor[0];
        this._finalAffixesColorG = hsvColor[1];
        this._finalAffixesColorB = hsvColor[2];
        newSaturation = Math.clamp((double)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.CharacteristicsSaturationPercent) / 100.0 * saturation, 0.0, 1.0);
        newBrightness = Math.clamp((double)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.CharacteristicsBrightnessPercent) / 100.0 * brightness, 0.0, 1.0);
        hsvColor = AbstractBetterSubtitle.HSVToRGB(hue, newSaturation, newBrightness);
        this._characteristicsColorR = hsvColor[0];
        this._characteristicsColorG = hsvColor[1];
        this._characteristicsColorB = hsvColor[2];
        newSaturation = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextSaturationPercent)).intValue() / 100.0 * newSaturation, 0.0, 1.0);
        newBrightness = Math.clamp((double)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.FinalTextBrightnessPercent)).intValue() / 100.0 * newBrightness, 0.0, 1.0);
        hsvColor = AbstractBetterSubtitle.HSVToRGB(hue, newSaturation, newBrightness);
        this._finalCharacteristicsColorR = hsvColor[0];
        this._finalCharacteristicsColorG = hsvColor[1];
        this._finalCharacteristicsColorB = hsvColor[2];
        this._lifeTime = (float)((Integer)AbstractConfig.GetSubtitleConfigValue(soundLocation, this._source, AbstractConfig.SubtitleConfig.LifeTime)).intValue() * 50.0f;
    }

    protected static int[] HSVToRGB(double hue, double saturation, double brightness) {
        double finalColorB;
        double finalColorG;
        double finalColorR;
        double chroma = (1.0 - Math.abs(2.0 * brightness - 1.0)) * saturation;
        while (hue < 0.0) {
            hue += 360.0;
        }
        hue = hue % 360.0 / 60.0;
        double chromaIntermediate = chroma * (1.0 - Math.abs(hue % 2.0 - 1.0));
        double brightnessMatch = brightness - chroma / 2.0;
        if (0.0 <= hue && hue < 1.0) {
            finalColorR = chroma;
            finalColorG = chromaIntermediate;
            finalColorB = 0.0;
        } else if (1.0 <= hue && hue < 2.0) {
            finalColorR = chromaIntermediate;
            finalColorG = chroma;
            finalColorB = 0.0;
        } else if (2.0 <= hue && hue < 3.0) {
            finalColorR = 0.0;
            finalColorG = chroma;
            finalColorB = chromaIntermediate;
        } else if (3.0 <= hue && hue < 4.0) {
            finalColorR = 0.0;
            finalColorG = chromaIntermediate;
            finalColorB = chroma;
        } else if (4.0 <= hue && hue < 5.0) {
            finalColorR = chromaIntermediate;
            finalColorG = 0.0;
            finalColorB = chroma;
        } else {
            finalColorR = chroma;
            finalColorG = 0.0;
            finalColorB = chromaIntermediate;
        }
        return new int[]{(int)Math.clamp(Math.floor((finalColorR + brightnessMatch) * 255.0), 0.0, 255.0), (int)Math.clamp(Math.floor((finalColorG + brightnessMatch) * 255.0), 0.0, 255.0), (int)Math.clamp(Math.floor((finalColorB + brightnessMatch) * 255.0), 0.0, 255.0)};
    }

    public long GetTime() {
        return this._time;
    }

    public double GetPosX() {
        return this._posX;
    }

    public double GetPosY() {
        return this._posY;
    }

    public double GetPosZ() {
        return this._posZ;
    }

    public double GetInWorldPosX() {
        return this._inWorldPosX;
    }

    public double GetInWorldPosY() {
        return this._inWorldPosY;
    }

    public double GetInWorldPosZ() {
        return this._inWorldPosZ;
    }

    public String GetSource() {
        return this._source;
    }

    public String GetText() {
        return this._text;
    }

    public String GetPrefix() {
        return this._prefix;
    }

    public String GetSuffix() {
        return this._suffix;
    }

    public String GetVolumeText() {
        return this._volumeText;
    }

    public String GetPitchText() {
        return this._pitchText;
    }

    public int GetWidth() {
        return this._width;
    }

    public int GetTextWidth() {
        return this._textWidth;
    }

    public int GetHeight() {
        return this._height;
    }

    public int GetPriority() {
        return this._priority;
    }

    public int GetBackgroundOpacity() {
        return this._backgroundOpacity;
    }

    public int GetTextOpacity() {
        return this._textOpacity;
    }

    public int GetFinalBackgroundOpacity() {
        return this._finalBackgroundOpacity;
    }

    public int GetFinalTextOpacity() {
        return this._finalTextOpacity;
    }

    public int GetColorR() {
        return this._colorR;
    }

    public int GetColorG() {
        return this._colorG;
    }

    public int GetColorB() {
        return this._colorB;
    }

    public int GetFinalColorR() {
        return this._finalColorR;
    }

    public int GetFinalColorG() {
        return this._finalColorG;
    }

    public int GetFinalColorB() {
        return this._finalColorB;
    }

    public int GetCurrentColorHash(float weight) {
        return 0xFF000000 | (Math.clamp((long)ModMath.LerpInt(weight, this._colorR, this._finalColorR), 0, 255) & 0xFF) << 16 | (Math.clamp((long)ModMath.LerpInt(weight, this._colorG, this._finalColorG), 0, 255) & 0xFF) << 8 | Math.clamp((long)ModMath.LerpInt(weight, this._colorB, this._finalColorB), 0, 255) & 0xFF;
    }

    public int GetAffixesColorR() {
        return this._affixesColorR;
    }

    public int GetAffixesColorG() {
        return this._affixesColorG;
    }

    public int GetAffixesColorB() {
        return this._affixesColorB;
    }

    public int GetFinalAffixesColorR() {
        return this._finalAffixesColorR;
    }

    public int GetFinalAffixesColorG() {
        return this._finalAffixesColorG;
    }

    public int GetFinalAffixesColorB() {
        return this._finalAffixesColorB;
    }

    public int GetCurrentAffixesColorHash(float weight) {
        return 0xFF000000 | (Math.clamp((long)ModMath.LerpInt(weight, this._affixesColorR, this._finalAffixesColorR), 0, 255) & 0xFF) << 16 | (Math.clamp((long)ModMath.LerpInt(weight, this._affixesColorG, this._finalAffixesColorG), 0, 255) & 0xFF) << 8 | Math.clamp((long)ModMath.LerpInt(weight, this._affixesColorB, this._finalAffixesColorB), 0, 255) & 0xFF;
    }

    public int GetCharacteristicsColorR() {
        return this._characteristicsColorR;
    }

    public int GetCharacteristicsColorG() {
        return this._characteristicsColorG;
    }

    public int GetCharacteristicsColorB() {
        return this._characteristicsColorB;
    }

    public int GetFinalCharacteristicsColorR() {
        return this._finalCharacteristicsColorR;
    }

    public int GetFinalCharacteristicsColorG() {
        return this._finalCharacteristicsColorG;
    }

    public int GetFinalCharacteristicsColorB() {
        return this._finalCharacteristicsColorB;
    }

    public int GetCurrentCharacteristicsColorHash(float weight) {
        return 0xFF000000 | (Math.clamp((long)ModMath.LerpInt(weight, this._characteristicsColorR, this._finalCharacteristicsColorR), 0, 255) & 0xFF) << 16 | (Math.clamp((long)ModMath.LerpInt(weight, this._characteristicsColorG, this._finalCharacteristicsColorG), 0, 255) & 0xFF) << 8 | Math.clamp((long)ModMath.LerpInt(weight, this._characteristicsColorB, this._finalCharacteristicsColorB), 0, 255) & 0xFF;
    }

    public float GetLifeTime() {
        return this._lifeTime;
    }

    public float GetWeight() {
        return Math.clamp((float)(AbstractModLogic.GetMillis() - this._time) / this.GetLifeTime(), 0.0f, 1.0f);
    }

    public void Resurrect() {
        this._time = AbstractModLogic.GetMillis();
    }

    public boolean IsLoaded() {
        return this._loaded;
    }
}

