/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractClientData;
import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.AbstractModRender;
import com.dgneos.sound_visualizer.ISoundVisualizerConfigScreen;
import com.dgneos.sound_visualizer.ModMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractClientRenderEvents {
    protected static final List<AbstractDirectionalSoundIndicator> DSI_TO_DRAW = new ArrayList<AbstractDirectionalSoundIndicator>(255);
    protected static final List<AbstractBetterSubtitle> SUBTITLE_TO_DRAW = new ArrayList<AbstractBetterSubtitle>(255);
    protected static final List<AbstractBetterSubtitle> IN_WORLD_SUBTITLE_TO_DRAW = new ArrayList<AbstractBetterSubtitle>(255);
    protected static final Map<String, int[]> DSI_CONFIGS = new HashMap<String, int[]>();
    protected static final Map<String, String[]> DSI_TEXT_CONFIGS = new HashMap<String, String[]>();
    protected static final List<Integer> DSI_GLOBAL_CONFIGS = new ArrayList<Integer>();
    protected static final Map<String, int[]> SUBTITLE_CONFIGS = new HashMap<String, int[]>();
    protected static final Map<String, String[]> SUBTITLE_TEXT_CONFIGS = new HashMap<String, String[]>();
    protected static final List<Integer> SUBTITLE_GLOBAL_CONFIGS = new ArrayList<Integer>();
    protected static final List<String> IC_SOUNDS = new ArrayList<String>();
    protected static final Map<String, int[]> IC_SOUNDS_DSI_CONFIGS = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_DSI_TEXT_CONFIGS = new HashMap<String, String[]>();
    protected static final Map<String, int[]> IC_SOUNDS_SUBTITLE_CONFIGS = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_SUBTITLE_TEXT_CONFIGS = new HashMap<String, String[]>();
    protected static final List<String> IGNORABLE_SOURCES = new ArrayList<String>();
    protected static final List<String> IGNORABLE_SOUNDS = new ArrayList<String>();
    protected static final List<String> FAVORITE_SOUNDS = new ArrayList<String>();
    private static AbstractClientRenderEvents _instance = null;

    public static AbstractClientRenderEvents SetupInstance(AbstractClientRenderEvents instance) {
        _instance = instance;
        return _instance;
    }

    public static void RenderDirectionalSoundIndicator(AbstractDirectionalSoundIndicator dsi, Object guiGraphics, float rotation, float lifeTimeWeight) {
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, ModMath.Lerp(lifeTimeWeight, dsi.GetOpacity(), 0.0f));
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        int diametr = dsi.GetDiametr();
        AbstractModRender.PushPose(pose, (double)AbstractModRender.GetGuiWidth(guiGraphics) / 2.0, (double)AbstractModRender.GetGuiHeight(guiGraphics) / 2.0, 0.0, true, 0.0f, 0.0f, rotation, 1.0f, 1.0f, 1.0f);
        AbstractModRender.RenderRawTexture(guiGraphics, dsi.GetLocation(), -diametr / 2, -diametr / 2, 0, 0, diametr, diametr, diametr, diametr);
        AbstractModRender.PopPose(pose);
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void RenderSubtitle(AbstractBetterSubtitle subtitle, Object guiGraphics, float x, float y, int width, float lifeTimeWeight, double dot1, double dot2) {
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        String text = subtitle.GetText();
        String prefix = subtitle.GetPrefix();
        String suffix = subtitle.GetSuffix();
        String volumeText = subtitle.GetVolumeText();
        String pitchText = subtitle.GetPitchText();
        int halfWidth = width / 2;
        int textHalfWidth = subtitle.GetTextWidth() / 2;
        int halfHeight = subtitle.GetHeight() / 2;
        int textHalfHeight = AbstractModLogic.GetTextHeight() / 2;
        boolean directionArrows = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.DirectionArrows) == 1;
        int characteristicsLocation = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.CharacteristicsLocation);
        boolean showVolume = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.VolumeCharacteristic) == 1;
        boolean showPitch = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.PitchCharacteristic) == 1;
        int characteristicsHalfWidth = 0;
        boolean addSpaceWidth = false;
        if (showVolume) {
            characteristicsHalfWidth += AbstractModLogic.GetTextWidth(volumeText);
            addSpaceWidth = true;
        }
        if (showPitch) {
            characteristicsHalfWidth += AbstractModLogic.GetTextWidth(pitchText + (addSpaceWidth ? " " : ""));
        }
        characteristicsHalfWidth /= 2;
        int textColorHash = subtitle.GetCurrentColorHash(lifeTimeWeight);
        int affixesColorHash = subtitle.GetCurrentAffixesColorHash(lifeTimeWeight);
        int characteristicsColorHash = subtitle.GetCurrentCharacteristicsColorHash(lifeTimeWeight);
        float scale = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.Scale) / 100.0f;
        AbstractModRender.PushPose(pose, x, y, 0.0, false, 0.0f, 0.0f, 0.0f, scale, scale, 1.0f);
        AbstractModRender.PushBuffer();
        AbstractModRender.RenderRect(guiGraphics, -halfWidth - 1, -halfHeight, halfWidth + 1, halfHeight, AbstractModRender.GetBackgroundColor(ModMath.Lerp(lifeTimeWeight, subtitle.GetBackgroundOpacity(), subtitle.GetFinalBackgroundOpacity()) / 255.0f));
        AbstractModRender.PushBufferEnd();
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, ModMath.Lerp(lifeTimeWeight, subtitle.GetTextOpacity(), subtitle.GetFinalTextOpacity()) / 255.0f);
        if (characteristicsLocation >= 2) {
            int offsetY;
            int offsetX = -textHalfWidth;
            int n = offsetY = characteristicsLocation == 2 && (showVolume || showPitch) ? 1 : -halfHeight + 1;
            if ((dot2 <= 0.5 && dot1 < 0.0 || dot2 == 4.0) && directionArrows) {
                AbstractModRender.RenderGUIText(guiGraphics, "<", -halfWidth, -textHalfHeight, textColorHash, false, false);
            }
            AbstractModRender.RenderGUIText(guiGraphics, prefix, offsetX, offsetY, affixesColorHash, false, false);
            AbstractModRender.RenderGUIText(guiGraphics, text, offsetX += AbstractModLogic.GetTextWidth(prefix), offsetY, textColorHash, false, false);
            AbstractModRender.RenderGUIText(guiGraphics, suffix, offsetX += AbstractModLogic.GetTextWidth(text), offsetY, affixesColorHash, false, false);
            if ((dot2 <= 0.5 && dot1 > 0.0 || dot2 == 4.0) && directionArrows) {
                AbstractModRender.RenderGUIText(guiGraphics, ">", halfWidth - AbstractModLogic.GetTextWidth(">") + 1, -textHalfHeight, textColorHash, false, false);
            }
            if (showVolume) {
                AbstractModRender.RenderGUIText(guiGraphics, volumeText, -characteristicsHalfWidth, characteristicsLocation == 2 ? -halfHeight + 1 : 1, characteristicsColorHash, false, false);
            }
            if (showPitch) {
                AbstractModRender.RenderGUIText(guiGraphics, pitchText, characteristicsHalfWidth - AbstractModLogic.GetTextWidth(pitchText), characteristicsLocation == 2 ? -halfHeight + 1 : 1, characteristicsColorHash, false, false);
            }
        } else {
            int offsetX = -textHalfWidth - characteristicsHalfWidth;
            int offsetY = -halfHeight + 1;
            if ((dot2 <= 0.5 && dot1 < 0.0 || dot2 == 4.0) && directionArrows) {
                AbstractModRender.RenderGUIText(guiGraphics, "<", -halfWidth, offsetY, textColorHash, false, false);
            }
            if (showVolume || showPitch) {
                offsetX -= AbstractModLogic.GetTextWidth(" ") / 2;
            }
            if (characteristicsLocation == 0) {
                if (showVolume) {
                    AbstractModRender.RenderGUIText(guiGraphics, volumeText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(volumeText + " ");
                }
                if (showPitch) {
                    AbstractModRender.RenderGUIText(guiGraphics, pitchText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(pitchText + " ");
                }
            }
            AbstractModRender.RenderGUIText(guiGraphics, prefix, offsetX, offsetY, affixesColorHash, false, false);
            AbstractModRender.RenderGUIText(guiGraphics, text, offsetX += AbstractModLogic.GetTextWidth(prefix), offsetY, textColorHash, false, false);
            AbstractModRender.RenderGUIText(guiGraphics, suffix, offsetX += AbstractModLogic.GetTextWidth(text), offsetY, affixesColorHash, false, false);
            offsetX += AbstractModLogic.GetTextWidth(suffix);
            if (characteristicsLocation == 1) {
                offsetX += AbstractModLogic.GetTextWidth(" ");
                if (showVolume) {
                    AbstractModRender.RenderGUIText(guiGraphics, volumeText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(volumeText + " ");
                }
                if (showPitch) {
                    AbstractModRender.RenderGUIText(guiGraphics, pitchText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(pitchText + " ");
                }
            }
            if ((dot2 <= 0.5 && dot1 > 0.0 || dot2 == 4.0) && directionArrows) {
                AbstractModRender.RenderGUIText(guiGraphics, ">", halfWidth - AbstractModLogic.GetTextWidth(">") + 1, offsetY, textColorHash, false, false);
            }
        }
        AbstractModRender.PushBufferEnd();
        AbstractModRender.PopPose(pose);
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void RenderSubtitleInWorld(AbstractBetterSubtitle subtitle, Object pose, float lifeTimeWeight, double cameraPosX, double cameraPosY, double cameraPosZ) {
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float opacityFadeMinDistance = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.InWorldOpacityFadeMinDistance) / 20.0f;
        float opacityFadeMaxDistance = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.InWorldOpacityFadeMaxDistance) / 20.0f;
        float opacityFadePercent = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.InWorldOpacityFadePercent) / 100.0f;
        float distanceToSubtitle = (float)new ModMath.Vec3(AbstractModLogic.GetCameraPosX(), AbstractModLogic.GetCameraPosY(), AbstractModLogic.GetCameraPosZ()).DistanceTo(new ModMath.Vec3(subtitle.GetInWorldPosX(), subtitle.GetInWorldPosY(), subtitle.GetInWorldPosZ()));
        if (opacityFadeMinDistance > opacityFadeMaxDistance) {
            float oldOpacityFadeMinDistance = opacityFadeMinDistance;
            opacityFadeMinDistance = opacityFadeMaxDistance;
            opacityFadeMaxDistance = oldOpacityFadeMinDistance;
        }
        float opacityFadeDistanceWeight = distanceToSubtitle <= opacityFadeMinDistance ? 1.0f : (distanceToSubtitle >= opacityFadeMaxDistance ? 0.0f : 1.0f - (distanceToSubtitle - opacityFadeMinDistance) / (opacityFadeMaxDistance - opacityFadeMinDistance));
        float lifeTimeOpacityWeight = ModMath.Lerp(lifeTimeWeight, subtitle.GetBackgroundOpacity(), subtitle.GetFinalBackgroundOpacity()) / 255.0f;
        int hashColor = AbstractModRender.GetBackgroundColor(Math.clamp(ModMath.Lerp(opacityFadeDistanceWeight, lifeTimeOpacityWeight, lifeTimeOpacityWeight * opacityFadePercent), 0.0f, 1.0f));
        int halfWidth = (subtitle.GetWidth() - (AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.DirectionArrows) == 1 ? AbstractModLogic.GetTextWidth("<  >") : 0)) / 2;
        int halfHeight = subtitle.GetHeight() / 2;
        float[] rotations = AbstractModLogic.GetCameraRotations();
        float scale = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.InWorldScale) / 100.0f * 0.02f;
        AbstractModRender.PushPose(pose, subtitle.GetInWorldPosX() - cameraPosX, subtitle.GetInWorldPosY() - cameraPosY, subtitle.GetInWorldPosZ() - cameraPosZ, true, rotations[0], rotations[1], rotations[2], AbstractModLogic.IsGameVersionLaterOrEqual("1.21") ? scale : -scale, -scale, scale);
        AbstractModRender.PushBuffer();
        AbstractModRender.PushVertexConsumer();
        AbstractModRender.PushMatrix(pose);
        AbstractModRender.AddVertex(-halfWidth - 1, -halfHeight, 0.0f, 0.0f, 0.0f, hashColor);
        AbstractModRender.AddVertex(halfWidth + 1, -halfHeight, 0.0f, 0.0f, 1.0f, hashColor);
        AbstractModRender.AddVertex(halfWidth + 1, halfHeight, 0.0f, 1.0f, 1.0f, hashColor);
        AbstractModRender.AddVertex(-halfWidth - 1, halfHeight, 0.0f, 1.0f, 0.0f, hashColor);
        AbstractModRender.PushBufferEnd();
        String text = subtitle.GetText();
        String prefix = subtitle.GetPrefix();
        String suffix = subtitle.GetSuffix();
        String volumeText = subtitle.GetVolumeText();
        String pitchText = subtitle.GetPitchText();
        float textLifeTimeOpacityWeight = ModMath.Lerp(lifeTimeWeight, subtitle.GetTextOpacity(), subtitle.GetFinalTextOpacity()) / 255.0f;
        int textColorHash = subtitle.GetCurrentColorHash(lifeTimeWeight);
        int affixesColorHash = subtitle.GetCurrentAffixesColorHash(lifeTimeWeight);
        int characteristicsColorHash = subtitle.GetCurrentCharacteristicsColorHash(lifeTimeWeight);
        int textHalfWidth = subtitle.GetTextWidth() / 2;
        int characteristicsLocation = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.CharacteristicsLocation);
        boolean showVolume = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.VolumeCharacteristic) == 1;
        boolean showPitch = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.PitchCharacteristic) == 1;
        int characteristicsHalfWidth = 0;
        boolean addSpaceWidth = false;
        if (showVolume) {
            characteristicsHalfWidth += AbstractModLogic.GetTextWidth(volumeText);
            addSpaceWidth = true;
        }
        if (showPitch) {
            characteristicsHalfWidth += AbstractModLogic.GetTextWidth(pitchText + (addSpaceWidth ? " " : ""));
        }
        characteristicsHalfWidth /= 2;
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, Math.clamp(ModMath.Lerp(opacityFadeDistanceWeight, textLifeTimeOpacityWeight, textLifeTimeOpacityWeight * opacityFadePercent), 0.0f, 1.0f));
        if (characteristicsLocation >= 2) {
            int offsetX = -textHalfWidth;
            int offsetY = characteristicsLocation == 2 && (showVolume || showPitch) ? 1 : -halfHeight + 1;
            AbstractModRender.RenderText(pose, prefix, offsetX, offsetY, affixesColorHash, false, false);
            AbstractModRender.RenderText(pose, text, offsetX += AbstractModLogic.GetTextWidth(prefix), offsetY, textColorHash, false, false);
            AbstractModRender.RenderText(pose, suffix, offsetX += AbstractModLogic.GetTextWidth(text), offsetY, affixesColorHash, false, false);
            if (showVolume) {
                AbstractModRender.RenderText(pose, volumeText, -characteristicsHalfWidth, characteristicsLocation == 2 ? -halfHeight + 1 : 1, characteristicsColorHash, false, false);
            }
            if (showPitch) {
                AbstractModRender.RenderText(pose, pitchText, characteristicsHalfWidth - AbstractModLogic.GetTextWidth(pitchText), characteristicsLocation == 2 ? -halfHeight + 1 : 1, characteristicsColorHash, false, false);
            }
        } else {
            int offsetX = -textHalfWidth - characteristicsHalfWidth;
            int offsetY = -halfHeight + 1;
            if (showVolume || showPitch) {
                offsetX -= AbstractModLogic.GetTextWidth(" ") / 2;
            }
            if (characteristicsLocation == 0) {
                if (showVolume) {
                    AbstractModRender.RenderText(pose, volumeText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(volumeText + " ");
                }
                if (showPitch) {
                    AbstractModRender.RenderText(pose, pitchText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(pitchText + " ");
                }
            }
            AbstractModRender.RenderText(pose, prefix, offsetX, offsetY, affixesColorHash, false, false);
            AbstractModRender.RenderText(pose, text, offsetX += AbstractModLogic.GetTextWidth(prefix), offsetY, textColorHash, false, false);
            AbstractModRender.RenderText(pose, suffix, offsetX += AbstractModLogic.GetTextWidth(text), offsetY, affixesColorHash, false, false);
            offsetX += AbstractModLogic.GetTextWidth(suffix);
            if (characteristicsLocation == 1) {
                offsetX += AbstractModLogic.GetTextWidth(" ");
                if (showVolume) {
                    AbstractModRender.RenderText(pose, volumeText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(volumeText + " ");
                }
                if (showPitch) {
                    AbstractModRender.RenderText(pose, pitchText, offsetX, offsetY, characteristicsColorHash, false, false);
                    offsetX += AbstractModLogic.GetTextWidth(pitchText + " ");
                }
            }
        }
        AbstractModRender.PushBufferEnd();
        AbstractModRender.PopPose(pose);
        AbstractModRender.SetShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchDirectionalSoundIndicatorRenderConfigs(Map<String, int[]> values) {
        DSI_CONFIGS.clear();
        Map<String, int[]> map = values;
        synchronized (map) {
            DSI_CONFIGS.putAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchDirectionalSoundIndicatorRenderTextConfigs(Map<String, String[]> values) {
        DSI_TEXT_CONFIGS.clear();
        Map<String, String[]> map = values;
        synchronized (map) {
            DSI_TEXT_CONFIGS.putAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchDirectionalSoundIndicatorRenderGlobalConfigs(List<Integer> values) {
        DSI_GLOBAL_CONFIGS.clear();
        List<Integer> list = values;
        synchronized (list) {
            DSI_GLOBAL_CONFIGS.addAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchSubtitleRenderConfigs(Map<String, int[]> values) {
        SUBTITLE_CONFIGS.clear();
        Map<String, int[]> map = values;
        synchronized (map) {
            SUBTITLE_CONFIGS.putAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchSubtitleRenderTextConfigs(Map<String, String[]> values) {
        SUBTITLE_TEXT_CONFIGS.clear();
        Map<String, String[]> map = values;
        synchronized (map) {
            SUBTITLE_TEXT_CONFIGS.putAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchSubtitleRenderGlobalConfigs(List<Integer> values) {
        SUBTITLE_GLOBAL_CONFIGS.clear();
        List<Integer> list = values;
        synchronized (list) {
            SUBTITLE_GLOBAL_CONFIGS.addAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchIndividuallyConfiguredSoundsRenderConfigs(List<String> sounds, Map<String, int[]> dsiValues, Map<String, String[]> dsiTextValues, Map<String, int[]> subtitleValues, Map<String, String[]> subtitleTextValues) {
        IC_SOUNDS.clear();
        Map<String, Object[]> map = sounds;
        synchronized (map) {
            IC_SOUNDS.addAll(sounds);
        }
        IC_SOUNDS_DSI_CONFIGS.clear();
        map = dsiValues;
        synchronized (map) {
            IC_SOUNDS_DSI_CONFIGS.putAll(dsiValues);
        }
        IC_SOUNDS_DSI_TEXT_CONFIGS.clear();
        map = dsiTextValues;
        synchronized (map) {
            IC_SOUNDS_DSI_TEXT_CONFIGS.putAll(dsiTextValues);
        }
        IC_SOUNDS_SUBTITLE_CONFIGS.clear();
        map = subtitleValues;
        synchronized (map) {
            IC_SOUNDS_SUBTITLE_CONFIGS.putAll(subtitleValues);
        }
        IC_SOUNDS_SUBTITLE_TEXT_CONFIGS.clear();
        map = subtitleTextValues;
        synchronized (map) {
            IC_SOUNDS_SUBTITLE_TEXT_CONFIGS.putAll(subtitleTextValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchIgnorableSourcesRender(List<String> values) {
        IGNORABLE_SOURCES.clear();
        List<String> list = values;
        synchronized (list) {
            IGNORABLE_SOURCES.addAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchIgnorableSoundsRender(List<String> values) {
        IGNORABLE_SOUNDS.clear();
        List<String> list = values;
        synchronized (list) {
            IGNORABLE_SOUNDS.addAll(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SynchFavoriteSoundsRender(List<String> values) {
        FAVORITE_SOUNDS.clear();
        List<String> list = values;
        synchronized (list) {
            FAVORITE_SOUNDS.addAll(values);
        }
    }

    protected static void CancelEvent(Object event) {
        _instance.InstanceCancelEvent(event);
    }

    protected abstract void InstanceCancelEvent(Object var1);

    protected static void OnGuiLayerPreRender(Object event, Object screen, String layerName, String crosshairLayerName, String subtitleOverlayLayerName) {
        if (screen instanceof ISoundVisualizerConfigScreen) {
            ISoundVisualizerConfigScreen configScreen = (ISoundVisualizerConfigScreen)screen;
            if (Objects.equals(layerName, crosshairLayerName)) {
                if (ISoundVisualizerConfigScreen.DoesRenderSubtitle(configScreen.GetData())) {
                    AbstractClientRenderEvents.CancelEvent(event);
                }
            } else {
                AbstractClientRenderEvents.CancelEvent(event);
            }
        }
        if (Objects.equals(layerName, subtitleOverlayLayerName)) {
            AbstractClientRenderEvents.CancelEvent(event);
        }
    }

    protected static void OnHandRender(Object event, Object screen) {
        if (screen instanceof ISoundVisualizerConfigScreen) {
            AbstractClientRenderEvents.CancelEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void OnLevelRender(Object event, Object screen, Object pose, String currentStage, String renderStage) {
        if (!Objects.equals(currentStage, renderStage) || pose == null || AbstractModLogic.IsTransparencyImproved()) {
            return;
        }
        AbstractModRender.SetRenderOptions(true, false, false, false, true);
        if (AbstractModLogic.ShowSubtitles()) {
            ModMath.Vec3 cameraPos = new ModMath.Vec3(AbstractModLogic.GetCameraPosX(), AbstractModLogic.GetCameraPosY(), AbstractModLogic.GetCameraPosZ());
            if (screen instanceof ISoundVisualizerConfigScreen) {
                ISoundVisualizerConfigScreen configScreen = (ISoundVisualizerConfigScreen)screen;
                if (ISoundVisualizerConfigScreen.DoesRenderSubtitle(configScreen.GetData()) && ISoundVisualizerConfigScreen.CanRenderSubtitle(configScreen.GetData()) && AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.ShowInWorld) >= 2) {
                    AbstractClientRenderEvents.RenderSubtitleInWorld(AbstractClientData.ConfigScreenSubtitle, pose, AbstractClientData.ConfigScreenSubtitleDeathFrame ? 1.0f : (AbstractClientData.AnimateConfigScreenSubtitleLife ? AbstractClientData.ConfigScreenSubtitle.GetWeight() : 0.0f), cameraPos.X, cameraPos.Y, cameraPos.Z);
                }
            } else {
                IN_WORLD_SUBTITLE_TO_DRAW.clear();
                ArrayList<AbstractBetterSubtitle> arrayList = AbstractClientData.InWorldSubtitles;
                synchronized (arrayList) {
                    IN_WORLD_SUBTITLE_TO_DRAW.addAll(AbstractClientData.InWorldSubtitles);
                }
                if (!IN_WORLD_SUBTITLE_TO_DRAW.isEmpty() && AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.ShowInWorld) > 0) {
                    for (AbstractBetterSubtitle subtitle : IN_WORLD_SUBTITLE_TO_DRAW) {
                        if (subtitle == null || !subtitle.IsLoaded()) continue;
                        AbstractClientRenderEvents.RenderSubtitleInWorld(subtitle, pose, subtitle.GetWeight(), cameraPos.X, cameraPos.Y, cameraPos.Z);
                    }
                }
            }
        }
        AbstractModRender.SetRenderOptions(false, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void OnDSILayerRender(Object guiGraphics, Object screen, float partialTick) {
        AbstractModRender.SetRenderOptions(true, false, false, true, false);
        if (AbstractModLogic.ShowDSIs()) {
            ModMath.Vec3 playerPos = new ModMath.Vec3(AbstractModLogic.GetPlayerPosX(partialTick), AbstractModLogic.GetPlayerPosY(partialTick), AbstractModLogic.GetPlayerPosZ(partialTick));
            if (!(screen instanceof ISoundVisualizerConfigScreen)) {
                DSI_TO_DRAW.clear();
                ArrayList<AbstractDirectionalSoundIndicator> arrayList = AbstractClientData.DirectionalSoundIndicators;
                synchronized (arrayList) {
                    DSI_TO_DRAW.addAll(AbstractClientData.DirectionalSoundIndicators);
                }
                if (!DSI_TO_DRAW.isEmpty()) {
                    boolean dynamicRotation = AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(DSI_GLOBAL_CONFIGS, AbstractConfig.DirectionalSoundIndicatorConfig.DynamicRotation) == 1;
                    for (AbstractDirectionalSoundIndicator dsi : DSI_TO_DRAW) {
                        if (dsi == null || !dsi.IsLoaded()) continue;
                        double soundPosX = dsi.GetPosX();
                        double soundPosZ = dsi.GetPosZ();
                        float rotation = dynamicRotation ? (float)Math.atan2(-(playerPos.X - soundPosX), playerPos.Z - soundPosZ) - (float)Math.toRadians(AbstractModLogic.GetPlayerRotY(partialTick)) : dsi.GetFixedRotation();
                        AbstractClientRenderEvents.RenderDirectionalSoundIndicator(dsi, guiGraphics, rotation, dsi.GetWeight());
                    }
                }
            }
        }
        AbstractModRender.SetRenderOptions(false, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void OnBetterSubtitleOverlayLayerRender(Object guiGraphics, Object screen, ModMath.Vec3 eyePos, ModMath.Vec3 forward, ModMath.Vec3 right, float partialTick) {
        AbstractModRender.SetRenderOptions(true, false, false, true, true);
        if (AbstractModLogic.ShowSubtitles() && !(screen instanceof ISoundVisualizerConfigScreen)) {
            SUBTITLE_TO_DRAW.clear();
            ArrayList<AbstractBetterSubtitle> arrayList = AbstractClientData.Subtitles;
            synchronized (arrayList) {
                SUBTITLE_TO_DRAW.addAll(AbstractClientData.Subtitles);
            }
            if (!SUBTITLE_TO_DRAW.isEmpty() && AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.ShowInWorld) < 2) {
                float scale = (float)AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.Scale) / 100.0f;
                int width = 0;
                for (AbstractBetterSubtitle subtitle : SUBTITLE_TO_DRAW) {
                    if (!subtitle.IsLoaded()) continue;
                    width = Math.max(width, subtitle.GetWidth());
                }
                if (width <= 0) {
                    return;
                }
                float halfWidth = (float)(width / 2 + 2) * scale;
                boolean isRightAnchor = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.HorizontalLocation) == 1;
                boolean isDownAnchor = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.VerticalLocation) == 1;
                int offsetX = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.HorizontalOffset);
                int offsetY = AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS, AbstractConfig.SubtitleConfig.VerticalOffset);
                int subtitlesDrawed = 0;
                for (AbstractBetterSubtitle subtitle : SUBTITLE_TO_DRAW) {
                    if (subtitle == null || !subtitle.IsLoaded()) continue;
                    ModMath.Vec3 direction = new ModMath.Vec3(subtitle.GetPosX(), subtitle.GetPosY(), subtitle.GetPosZ()).Subtract(eyePos).Normalize();
                    double dot1 = right.Dot(direction);
                    double dot2 = forward.Dot(direction);
                    float height = (float)subtitle.GetHeight() * scale;
                    float halfHeight = height / 2.0f;
                    float x = isRightAnchor ? (float)(AbstractModRender.GetGuiWidth(guiGraphics) - offsetX) - halfWidth + scale : (float)offsetX + halfWidth - scale;
                    float y = isDownAnchor ? (float)(AbstractModRender.GetGuiHeight(guiGraphics) - offsetY) - (float)subtitlesDrawed * height - halfHeight : (float)offsetY + (float)subtitlesDrawed * height + halfHeight;
                    AbstractClientRenderEvents.RenderSubtitle(subtitle, guiGraphics, x, y, width, subtitle.GetWeight(), dot1, dot2);
                    ++subtitlesDrawed;
                }
            }
        }
        AbstractModRender.SetRenderOptions(false, true, true, true, false);
    }
}

