/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.ModMath;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractDirectionalSoundIndicator {
    public static final AtomicInteger ID = new AtomicInteger();
    private final String _source;
    private final double _posX;
    private final double _posY;
    private final double _posZ;
    private final float _fixedRotation;
    private final int _radius;
    private final int _thickness;
    private final int _diametr;
    private final int _width;
    private final int _colorR;
    private final int _colorG;
    private final int _colorB;
    private final float _opacity;
    private final float _lifeTime;
    private final String _textureLocationText;
    private long _time;
    protected boolean _loaded = false;

    public AbstractDirectionalSoundIndicator(Object sound, String source, double posX, double posY, double posZ, float fixedRotation, float distanceWeight) {
        float hDiametr;
        float cX;
        this.Resurrect();
        this._source = source;
        this._posX = posX;
        this._posY = posY;
        this._posZ = posZ;
        this._fixedRotation = fixedRotation;
        String soundLocation = AbstractModLogic.GetSoundLocation(sound);
        this._radius = Math.max((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.Radius), 1);
        this._thickness = Math.max((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.Thickness), 1);
        this._diametr = (this._radius + this._thickness) * 2;
        this._width = Math.clamp((long)Math.round((float)ModMath.LerpInt(distanceWeight, 100.0f, (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.WidthMDP)).intValue()) / 100.0f * (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.Width)).intValue()), AbstractConfig.DirectionalSoundIndicatorConfig.Width.GetMinValue(), AbstractConfig.DirectionalSoundIndicatorConfig.Width.GetMaxValue());
        this._colorR = (Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.ColorR);
        this._colorG = (Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.ColorG);
        this._colorB = (Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.ColorB);
        this._opacity = (float)Math.clamp((long)Math.round((float)ModMath.LerpInt(distanceWeight, 100.0f, (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.OpacityMDP)).intValue()) / 100.0f * (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.Opacity)).intValue()), AbstractConfig.DirectionalSoundIndicatorConfig.Opacity.GetMinValue(), AbstractConfig.DirectionalSoundIndicatorConfig.Opacity.GetMaxValue()) / 255.0f;
        this._lifeTime = Math.clamp((long)Math.round((float)ModMath.LerpInt(distanceWeight, 100.0f, (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.LifeTimeMDP)).intValue()) / 2.0f * (float)((Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, this._source, AbstractConfig.DirectionalSoundIndicatorConfig.LifeTime)).intValue()), AbstractConfig.DirectionalSoundIndicatorConfig.LifeTime.GetMinValue() * 50, AbstractConfig.DirectionalSoundIndicatorConfig.LifeTime.GetMaxValue() * 50);
        this.SetupNativeImage();
        float cY = cX = (hDiametr = (float)this._diametr / 2.0f);
        float hWidth = (float)Math.toRadians((float)this._width / 2.0f);
        boolean radialDirectionReversed = AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(AbstractConfig.DirectionalSoundIndicatorConfig.RadialDirection) == 1;
        float radialFade = (float)AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(AbstractConfig.DirectionalSoundIndicatorConfig.RadialFade) / 100.0f;
        float conicFade = (float)AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(AbstractConfig.DirectionalSoundIndicatorConfig.ConicFade) / 100.0f;
        float distinctEdge = (float)AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(AbstractConfig.DirectionalSoundIndicatorConfig.DistinctEdge) / 100.0f;
        for (int x = 0; x < this._diametr; ++x) {
            for (int y = 0; y < this._diametr; ++y) {
                float pX = (float)x + 0.5f;
                float dX = pX - cX;
                float pY = (float)y + 0.5f;
                float dY = pY - cY;
                float pRadius = (float)Math.sqrt(dX * dX + dY * dY);
                if (pRadius < (float)this._radius || pRadius > hDiametr) {
                    this.SetPixelRGBA(x, y, 0);
                    continue;
                }
                float pAlpha = radialDirectionReversed ? Math.clamp(ModMath.Lerp((pRadius - (float)this._radius) / (float)this._thickness, 1.0f / (radialFade + 1.0E-4f), 1.0f - radialFade), 0.0f, 1.0f) : Math.clamp(ModMath.Lerp((pRadius - (float)this._radius) / (float)this._thickness, 1.0f - radialFade, 1.0f / (radialFade + 1.0E-4f)), 0.0f, 1.0f);
                float pRotation = (float)Math.atan2(-dX, dY);
                if (Math.abs(pRotation) > hWidth) {
                    this.SetPixelRGBA(x, y, 0);
                    continue;
                }
                pAlpha = Math.clamp(ModMath.Lerp(Math.abs(pRotation) / hWidth * conicFade, pAlpha, Math.min(1.0f - conicFade, pAlpha)), 0.0f, 1.0f);
                pAlpha = radialDirectionReversed ? (pAlpha *= pRadius - (float)this._radius <= 2.0f ? distinctEdge : 1.0f) : (pAlpha *= hDiametr - pRadius <= 2.0f ? distinctEdge : 1.0f);
                this.SetPixelRGBA(x, y, ((int)Math.clamp(pAlpha * 255.0f, 0.0f, 255.0f) & 0xFF) << 24 | (this._colorB & 0xFF) << 16 | (this._colorG & 0xFF) << 8 | this._colorR & 0xFF);
            }
        }
        this._textureLocationText = "textures/temp/dsi_texture_" + ID.incrementAndGet();
    }

    public long GetTime() {
        return this._time;
    }

    public String GetSource() {
        return this._source;
    }

    public double GetPosX() {
        return this._posX;
    }

    public double GetPosY() {
        return this._posY;
    }

    public double GetPosZ() {
        return this._posZ;
    }

    public float GetFixedRotation() {
        return this._fixedRotation;
    }

    public int GetRadius() {
        return this._radius;
    }

    public int GetThickness() {
        return this._thickness;
    }

    public int GetDiametr() {
        return this._diametr;
    }

    public int GetWidth() {
        return this._width;
    }

    public int GetColorR() {
        return this._colorR;
    }

    public int GetColorG() {
        return this._colorG;
    }

    public int GetColorB() {
        return this._colorB;
    }

    public float GetOpacity() {
        return this._opacity;
    }

    public float GetLifeTime() {
        return this._lifeTime;
    }

    public float GetWeight() {
        return Math.clamp((float)(AbstractModLogic.GetMillis() - this._time) / this.GetLifeTime(), 0.0f, 1.0f);
    }

    public void Resurrect() {
        this._time = AbstractModLogic.GetMillis();
    }

    public String GetLocation() {
        return this._textureLocationText;
    }

    public boolean IsLoaded() {
        return this._loaded;
    }

    public abstract void Kill();

    protected abstract void SetupNativeImage();

    protected abstract void SetPixelRGBA(int var1, int var2, int var3);
}

