/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.ModMath;
import com.dgneos.sound_visualizer.client.ClientData;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Util;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ModLogic
extends AbstractModLogic {
    @Override
    protected String InstanceGetGameVersion() {
        return Minecraft.getInstance().getLaunchedVersion();
    }

    @Override
    protected String InstanceGetGameLocaleLanguage() {
        return Minecraft.getInstance().getLocale().getLanguage();
    }

    @Override
    protected boolean InstanceIsLevelExist() {
        return Minecraft.getInstance().level != null;
    }

    @Override
    protected boolean InstanceIsPlayerExist() {
        return Minecraft.getInstance().player != null;
    }

    @Override
    protected boolean InstanceIsCameraExist() {
        return Minecraft.getInstance().getEntityRenderDispatcher().camera != null;
    }

    @Override
    protected boolean InstanceShowDSIs() {
        return (Boolean)ClientData.SHOW_DIRECTIONAL_SOUND_INDICATORS.get();
    }

    @Override
    protected boolean InstanceShowSubtitles() {
        return (Boolean)Minecraft.getInstance().options.showSubtitles().get();
    }

    @Override
    protected boolean InstanceIsTransparencyImproved() {
        return (Boolean)Minecraft.getInstance().options.improvedTransparency().get();
    }

    @Override
    protected double InstanceGetPlayerPosX(float partialTick) {
        return Minecraft.getInstance().player.getPosition((float)partialTick).x;
    }

    @Override
    protected double InstanceGetPlayerPosY(float partialTick) {
        return Minecraft.getInstance().player.getPosition((float)partialTick).y;
    }

    @Override
    protected double InstanceGetPlayerPosZ(float partialTick) {
        return Minecraft.getInstance().player.getPosition((float)partialTick).z;
    }

    @Override
    protected float InstanceGetPlayerRotY(float partialTick) {
        return Minecraft.getInstance().player.getViewYRot(partialTick);
    }

    @Override
    protected float InstanceGetPlayerRotX(float partialTick) {
        return Minecraft.getInstance().player.getViewXRot(partialTick);
    }

    @Override
    protected ModMath.Vec3 InstanceGetListenerPosition() {
        Vec3 eyePos = Minecraft.getInstance().getSoundManager().getListenerTransform().position();
        return new ModMath.Vec3(eyePos.x, eyePos.y, eyePos.z);
    }

    @Override
    protected Object InstanceGetScreen() {
        return Minecraft.getInstance().screen;
    }

    @Override
    protected boolean InstanceScreenIsOptionsScreen(Object screen) {
        return screen instanceof OptionsScreen;
    }

    @Override
    protected boolean InstanceScreenIsAccessibilityOptionsScreen(Object screen) {
        return screen instanceof AccessibilityOptionsScreen;
    }

    @Override
    protected boolean InstanceScreenIsSoundOptionsScreen(Object screen) {
        return screen instanceof SoundOptionsScreen;
    }

    @Override
    protected double InstanceGetCameraPosX() {
        return Minecraft.getInstance().getEntityRenderDispatcher().camera.position().x;
    }

    @Override
    protected double InstanceGetCameraPosY() {
        return Minecraft.getInstance().getEntityRenderDispatcher().camera.position().y;
    }

    @Override
    protected double InstanceGetCameraPosZ() {
        return Minecraft.getInstance().getEntityRenderDispatcher().camera.position().z;
    }

    @Override
    protected float[] InstanceGetCameraRotations() {
        Vector3f rotations = new Vector3f();
        Minecraft.getInstance().getEntityRenderDispatcher().camera.rotation().getEulerAnglesYXZ(rotations);
        return new float[]{rotations.y, rotations.x, rotations.z};
    }

    @Override
    protected ModMath.Vec3 InstanceGetRotatedVector(ModMath.Vec3 vector, float rotY, float rotX, float rotZ) {
        Vector3f rotatedVector = new Quaternionf().rotateY(rotY).rotateX(rotX).rotateZ(rotZ).transform(new Vector3f((float)vector.X, (float)vector.Y, (float)vector.Z));
        return new ModMath.Vec3(rotatedVector.x, rotatedVector.y, rotatedVector.z);
    }

    @Override
    protected String InstanceGetSoundSourceName(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getSource().getName();
        }
        return "";
    }

    @Override
    protected String InstanceGetSoundLocation(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getIdentifier().toString();
        }
        return "";
    }

    @Override
    protected String InstanceGetSoundSubtitleText(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            Component subtitleText = Minecraft.getInstance().getSoundManager().getSoundEvent(identifiedSound.getIdentifier()).getSubtitle();
            return subtitleText != null ? subtitleText.getString() : "";
        }
        return "";
    }

    @Override
    protected double InstanceGetSoundPosX(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getX();
        }
        return 0.0;
    }

    @Override
    protected double InstanceGetSoundPosY(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getY();
        }
        return 0.0;
    }

    @Override
    protected double InstanceGetSoundPosZ(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getZ();
        }
        return 0.0;
    }

    @Override
    protected float InstanceGetSoundVolume(Object sound) {
        SoundInstance identifiedSound;
        if (sound instanceof SoundInstance && (identifiedSound = (SoundInstance)sound).getSound() != null) {
            return identifiedSound.getVolume();
        }
        return 1.0f;
    }

    @Override
    protected float InstanceGetSoundPitch(Object sound) {
        SoundInstance identifiedSound;
        if (sound instanceof SoundInstance && (identifiedSound = (SoundInstance)sound).getSound() != null) {
            return identifiedSound.getPitch();
        }
        return 1.0f;
    }

    @Override
    protected boolean InstanceIsSoundVolumeAbsolute(Object sound) {
        if (sound instanceof SoundInstance) {
            SoundInstance identifiedSound = (SoundInstance)sound;
            return identifiedSound.getAttenuation() == SoundInstance.Attenuation.NONE;
        }
        return false;
    }

    @Override
    protected List<String> InstanceGetSoundsLocation(Object soundManager) {
        SoundManager manager = soundManager == null ? Minecraft.getInstance().getSoundManager() : (SoundManager)soundManager;
        return manager.getAvailableSounds().stream().map(location -> location.toString()).toList();
    }

    @Override
    protected List<String> InstanceGetSoundsSubtitleText(Object soundManager) {
        SoundManager manager = soundManager == null ? Minecraft.getInstance().getSoundManager() : (SoundManager)soundManager;
        return manager.getAvailableSounds().stream().map(location -> {
            Component subtitleText = manager.getSoundEvent(location).getSubtitle();
            if (subtitleText != null) {
                return subtitleText.getString();
            }
            return "";
        }).toList();
    }

    @Override
    protected long InstanceGetMillis() {
        return Util.getMillis();
    }

    @Override
    protected int InstanceGetTextWidth(String text) {
        return Minecraft.getInstance().font.width(text);
    }

    @Override
    protected int InstanceGetTextHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    @Override
    protected String InstanceGetTextTranslate(String textKey) {
        return Component.translatable((String)textKey).getString();
    }

    @Override
    protected String InstanceGetFilteredText(String text) {
        return StringUtil.filterText((String)text);
    }

    @Override
    protected String InstanceGetPlainTextByWidth(String text, int maxWidth) {
        return Minecraft.getInstance().font.plainSubstrByWidth(text, maxWidth);
    }

    @Override
    protected int InstanceOffsetByCodepoints(String text, int cursorPos, int direction) {
        return Util.offsetByCodepoints((String)text, (int)cursorPos, (int)direction);
    }
}

