/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

public class ModMath {
    public static float Lerp(float weight, float start, float end) {
        return start + weight * (end - start);
    }

    public static float Lerp(float weight, int start, int end) {
        return (float)start + weight * (float)(end - start);
    }

    public static double LerpDouble(float weight, double start, double end) {
        return start + (double)weight * (end - start);
    }

    public static double LerpDouble(float weight, int start, int end) {
        return (double)start + (double)weight * (double)(end - start);
    }

    public static int LerpInt(float weight, float start, float end) {
        return (int)(start + weight * (end - start));
    }

    public static int LerpInt(float weight, int start, int end) {
        return (int)((float)start + weight * (float)(end - start));
    }

    public static class Vec3 {
        public static final Vec3 ZERO = new Vec3(0.0, 0.0, 0.0);
        public final double X;
        public final double Y;
        public final double Z;

        public Vec3(double x, double y, double z) {
            this.X = x;
            this.Y = y;
            this.Z = z;
        }

        public Vec3 Normalize() {
            double length = Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
            return length < 1.0E-4 ? ZERO : new Vec3(this.X / length, this.Y / length, this.Z / length);
        }

        public double Dot(Vec3 vector) {
            return this.X * vector.X + this.Y * vector.Y + this.Z * vector.Z;
        }

        public Vec3 Cross(Vec3 vector) {
            return new Vec3(this.Y * this.Z - this.Z * vector.Y, this.Z * vector.X - this.X * vector.Z, this.X * vector.Y - this.Y * vector.X);
        }

        public Vec3 Subtract(Vec3 vector) {
            return this.Subtract(vector.X, vector.Y, vector.Z);
        }

        public Vec3 Subtract(double x, double y, double z) {
            return this.Add(-x, -y, -z);
        }

        public Vec3 Add(Vec3 vector) {
            return this.Add(vector.X, vector.Y, vector.Z);
        }

        public Vec3 Add(double x, double y, double z) {
            return new Vec3(this.X + x, this.Y + y, this.Z + z);
        }

        public double DistanceTo(Vec3 vector) {
            return Math.sqrt(Math.pow(vector.X - this.X, 2.0) + Math.pow(vector.Y - this.Y, 2.0) + Math.pow(vector.Z - this.Z, 2.0));
        }
    }
}

