/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer.client;

import com.dgneos.sound_visualizer.AbstractClientEvents;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ScreenEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents
extends AbstractClientEvents {
    @Override
    protected AbstractClientEvents.IConfigScreenButton InstanceAddConfigScreenButton(Object event, Object screen) {
        ConfigScreenButton configScreenButton = new ConfigScreenButton(screen);
        ((ScreenEvent.Init.Post)event).addListener((GuiEventListener)configScreenButton);
        return configScreenButton;
    }

    protected static class ConfigScreenButton
    extends Button
    implements AbstractClientEvents.IConfigScreenButton {
        private final Object _lastScreen;

        public ConfigScreenButton(Object lastScreen) {
            super(new Button.Builder((Component)Component.empty(), button -> {}));
            this._lastScreen = lastScreen;
        }

        public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            AbstractClientEvents.IConfigScreenButton.Render(graphics, this, this.getX(), this.getY(), this.getWidth(), this.getHeight(), mouseX, mouseY, partialTick);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return AbstractClientEvents.IConfigScreenButton.MouseClicked(this, this._lastScreen, event.x(), event.y(), event.button());
        }

        @Override
        public AbstractClientEvents.IConfigScreenButton SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            return this;
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderDefaultSprite((GuiGraphics)guiGraphics);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }
    }

    protected static class Listener
    implements AbstractClientEvents.IListener {
        private final Object _listener;

        public Listener(Object listener) {
            this._listener = listener;
        }

        @Override
        public int GetX() {
            Object object = this._listener;
            if (object instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)object;
                return widget.getX();
            }
            return 0;
        }

        @Override
        public int GetY() {
            Object object = this._listener;
            if (object instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)object;
                return widget.getY();
            }
            return 0;
        }

        @Override
        public int GetWidth() {
            Object object = this._listener;
            if (object instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)object;
                return widget.getWidth();
            }
            return 20;
        }

        @Override
        public int GetHeight() {
            Object object = this._listener;
            if (object instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)object;
                return widget.getHeight();
            }
            return 20;
        }

        @Override
        public boolean IsButton() {
            return this._listener instanceof Button;
        }

        @Override
        public String GetMessage() {
            MutableComponent message = Component.empty();
            Object object = this._listener;
            if (object instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)object;
                message = widget.getMessage();
            }
            return message != null ? message.getString() : "";
        }

        @Override
        public boolean IsList() {
            return this._listener instanceof OptionsList;
        }

        @Override
        public void AddSmall(Object optionInstance) {
            Object object = this._listener;
            if (object instanceof OptionsList) {
                OptionsList list = (OptionsList)object;
                if (optionInstance instanceof OptionInstance) {
                    OptionInstance identifiedOptionInstance = (OptionInstance)optionInstance;
                    list.addSmall(new OptionInstance[]{identifiedOptionInstance});
                }
            }
        }

        @Override
        public void AddBig(Object optionInstance) {
            Object object = this._listener;
            if (object instanceof OptionsList) {
                OptionsList list = (OptionsList)object;
                if (optionInstance instanceof OptionInstance) {
                    OptionInstance identifiedOptionInstance = (OptionInstance)optionInstance;
                    list.addBig(identifiedOptionInstance);
                }
            }
        }
    }
}

