/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer.client;

import com.dgneos.sound_visualizer.ModMath;
import com.dgneos.sound_visualizer.ModRender;
import com.dgneos.sound_visualizer.client.ClientRenderEvents;
import com.mojang.blaze3d.audio.ListenerTransform;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@OnlyIn(value=Dist.CLIENT)
public final class ClientSpecificRenderEvents
extends ClientRenderEvents {
    @SubscribeEvent
    public static void OnGuiLayersRegister(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.CROSSHAIR, Identifier.fromNamespaceAndPath((String)"sound_visualizer", (String)"directional_sound_indicator"), new GuiLayer(){

            public void render(GuiGraphics graphics, DeltaTracker tracker) {
                ClientSpecificRenderEvents.OnDSILayerRender(graphics, Minecraft.getInstance().screen, tracker.getGameTimeDeltaPartialTick(true));
            }
        });
        event.registerAbove(VanillaGuiLayers.SUBTITLE_OVERLAY, Identifier.fromNamespaceAndPath((String)"sound_visualizer", (String)"better_subtitle_overlay"), new GuiLayer(){

            public void render(GuiGraphics graphics, DeltaTracker tracker) {
                ListenerTransform transform = Minecraft.getInstance().getSoundManager().getListenerTransform();
                Vec3 eyePos = transform.position();
                Vec3 forward = transform.forward();
                Vec3 right = transform.right();
                ClientSpecificRenderEvents.OnBetterSubtitleOverlayLayerRender(graphics, Minecraft.getInstance().screen, new ModMath.Vec3(eyePos.x, eyePos.y, eyePos.z), new ModMath.Vec3(forward.x, forward.y, forward.z), new ModMath.Vec3(right.x, right.y, right.z), tracker.getGameTimeDeltaPartialTick(true));
            }
        });
    }

    @SubscribeEvent
    public static void OnRenderPipelinesRegisterEvent(RegisterRenderPipelinesEvent event) {
        RenderPipeline bufferRenderPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.TEXT_SNIPPET}).withLocation("pipeline/sound_visualizer_position_color").withVertexShader("core/rendertype_text_background_see_through").withFragmentShader("core/rendertype_text_background_see_through").withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(BlendFunction.TRANSLUCENT).withCull(false).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).build();
        event.registerPipeline(bufferRenderPipeline);
        ModRender.BufferRenderType = RenderType.create((String)"sound_visualizer", (RenderSetup)RenderSetup.builder((RenderPipeline)bufferRenderPipeline).bufferSize(1536).affectsCrumbling().createRenderSetup());
        ModRender.BufferTextureRenderPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_TEXTURED_SNIPPET}).withLocation("pipeline/sound_visualizer_texture_position_tex_color").withDepthWrite(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withBlend(BlendFunction.TRANSLUCENT).withCull(false).build();
        event.registerPipeline(ModRender.BufferTextureRenderPipeline);
    }
}

