/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer.screen;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.ISoundVisualizerConfigScreen;
import com.dgneos.sound_visualizer.client.ClientData;
import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SoundVisualizerConfigScreen
extends Screen
implements ISoundVisualizerConfigScreen {
    protected static final Map<String, CursorType> CURSOR_TYPES = List.of(CursorTypes.ARROW, CursorTypes.CROSSHAIR, CursorTypes.IBEAM, CursorTypes.NOT_ALLOWED, CursorTypes.POINTING_HAND, CursorTypes.RESIZE_ALL, CursorTypes.RESIZE_EW, CursorTypes.RESIZE_NS).stream().collect(Collectors.toMap(cursorType -> cursorType.toString(), cursorType -> cursorType));
    private final ISoundVisualizerConfigScreen.SoundVisualizerConfigScreenData _data = new ISoundVisualizerConfigScreen.SoundVisualizerConfigScreenData(this);

    public SoundVisualizerConfigScreen() {
        super((Component)Component.empty());
        ISoundVisualizerConfigScreen.BaseSetup(this._data);
    }

    public void render(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this._data.HasShiftDown = Minecraft.getInstance().hasShiftDown();
        this._data.HasControlDown = Minecraft.getInstance().hasControlDown();
        this._data.HasAltDown = Minecraft.getInstance().hasAltDown();
        ISoundVisualizerConfigScreen.Render(graphics, mouseX, mouseY, partialTick, this._data);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        ISoundVisualizerConfigScreen.MouseMoved(mouseX, mouseY, this._data);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        return ISoundVisualizerConfigScreen.MouseClicked(event.x(), event.y(), event.button(), this._data);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        return ISoundVisualizerConfigScreen.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY, this._data);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        return ISoundVisualizerConfigScreen.MouseReleased(event.x(), event.y(), event.button(), this._data);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return ISoundVisualizerConfigScreen.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
    }

    public boolean keyPressed(KeyEvent event) {
        return ISoundVisualizerConfigScreen.KeyPressed(event.key(), event.scancode(), event.modifiers(), this._data);
    }

    public boolean keyReleased(KeyEvent event) {
        return super.keyReleased(event);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        return ISoundVisualizerConfigScreen.GetChildAt(mouseX, mouseY, this._data).stream().map(child -> (GuiEventListener)child).findFirst();
    }

    public GuiEventListener getFocused() {
        return (GuiEventListener)ISoundVisualizerConfigScreen.GetFocused(this._data);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener instanceof ISoundVisualizerConfigScreen.IConfigScreenChild) {
            ISoundVisualizerConfigScreen.IConfigScreenChild child = (ISoundVisualizerConfigScreen.IConfigScreenChild)listener;
            ISoundVisualizerConfigScreen.SetFocused(child, this._data);
        }
    }

    public boolean isFocused() {
        return ISoundVisualizerConfigScreen.IsFocused(this._data);
    }

    public void onClose() {
        ISoundVisualizerConfigScreen.OnClose(this._data);
    }

    protected void init() {
        super.init();
        this._data.Width = this.width;
        this._data.Height = this.height;
        ISoundVisualizerConfigScreen.Init(this._data);
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        GuiEventListener addebleChild = super.addRenderableWidget(widget);
        this._data.Children = this.children().stream().filter(child -> child instanceof ISoundVisualizerConfigScreen.IConfigScreenChild).map(child -> (ISoundVisualizerConfigScreen.IConfigScreenChild)child).collect(Collectors.toList());
        return (T)addebleChild;
    }

    @Override
    public ISoundVisualizerConfigScreen.IConfigsList CreateConfigsList(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String headlineTextKey) {
        return new ConfigsList(screen, category, headlineTextKey);
    }

    @Override
    public ISoundVisualizerConfigScreen.ISoundsSelectableList CreateSoundsSelectableList(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category) {
        return new SoundsSelectableList(screen, category);
    }

    @Override
    public ISoundVisualizerConfigScreen.IRect CreateRect(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, int direction) {
        return new Rect(screen, category, direction);
    }

    @Override
    public ISoundVisualizerConfigScreen.ITab CreateTab(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey) {
        return new Tab(screen, category, textKey);
    }

    @Override
    public ISoundVisualizerConfigScreen.IConfigButton CreateConfigButton(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey, int configID, int values, ISoundVisualizerConfigScreen.IConfigButton.IOnPress onPress, ISoundVisualizerConfigScreen.IConfigButton.IOnRender onRender) {
        return new ConfigButton(screen, category, textKey, configID, values, onPress, onRender);
    }

    @Override
    public ISoundVisualizerConfigScreen.IConfigSliderButton CreateConfigSliderButton(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey, int configID, int color, float textValueMultiplier, int minValue, int maxValue) {
        return new ConfigSliderButton(screen, category, textKey, configID, color, textValueMultiplier, minValue, maxValue);
    }

    @Override
    public ISoundVisualizerConfigScreen.IConfigEditBox CreateConfigEditBox(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String hintTextKey, int configID, int maxLength, Consumer<String> responder, Predicate<String> filter) {
        return new ConfigEditBox(screen, category, hintTextKey, configID, maxLength, responder, filter);
    }

    @Override
    public AbstractDirectionalSoundIndicator CreateDSI(String soundLocation, float distanceWeight) {
        RandomSource random = RandomSource.create((long)42L);
        Identifier definedSoundLocation = Identifier.tryParse((String)soundLocation);
        Sound sound = Minecraft.getInstance().getSoundManager().getSoundEvent(definedSoundLocation).getSound(random);
        return new ClientData.DirectionalSoundIndicator((SoundInstance)new SimpleSoundInstance(definedSoundLocation, SoundSource.values()[this._data.Source], sound.getVolume().sample(random), sound.getPitch().sample(random), random, false, 0, SoundInstance.Attenuation.LINEAR, 0.0, 0.0, 0.0, true), Vec3.ZERO, this._data.DSIRotation, distanceWeight);
    }

    @Override
    public AbstractBetterSubtitle CreateBetterSubtitle(String soundLocation, String text, double posX, double posY, double posZ) {
        RandomSource random = RandomSource.create((long)42L);
        Identifier definedSoundLocation = Identifier.tryParse((String)soundLocation);
        Sound sound = Minecraft.getInstance().getSoundManager().getSoundEvent(definedSoundLocation).getSound(random);
        return new ClientData.BetterSubtitle((SoundInstance)new SimpleSoundInstance(definedSoundLocation, SoundSource.values()[this._data.Source], sound.getVolume().sample(random), sound.getPitch().sample(random), random, false, 0, SoundInstance.Attenuation.LINEAR, 0.0, 0.0, 0.0, true), (Component)Component.literal((String)text), new Vec3(posX, posY, posZ));
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.IConfigsList child) {
        this.addRenderableWidget((ConfigsList)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.ISoundsSelectableList child) {
        this.addRenderableWidget((SoundsSelectableList)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.IRect child) {
        this.addRenderableWidget((Rect)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.ITab child) {
        this.addRenderableWidget((Tab)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.IConfigButton child) {
        this.addRenderableWidget((ConfigButton)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.IConfigSliderButton child) {
        this.addRenderableWidget((ConfigSliderButton)child);
    }

    @Override
    public void AddRenderableChild(ISoundVisualizerConfigScreen.IConfigEditBox child) {
        this.addRenderableWidget((ConfigEditBox)child);
    }

    @Override
    public void SetScreen(Object screen) {
        Minecraft.getInstance().setScreen((Screen)screen);
    }

    @Override
    public void RequestCursor(Object guiGraphics, String cursorType) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            if (CURSOR_TYPES.containsKey(cursorType)) {
                graphics.requestCursor(CURSOR_TYPES.get(cursorType));
            }
        }
    }

    @Override
    public ISoundVisualizerConfigScreen.SoundVisualizerConfigScreenData GetData() {
        return this._data;
    }

    @Override
    public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render((GuiGraphics)guiGraphics, mouseX, mouseY, partialTick);
    }

    private static class ConfigsList
    extends ObjectSelectionList<ConfigsListEntry>
    implements ISoundVisualizerConfigScreen.IConfigsList {
        private final ISoundVisualizerConfigScreen.ConfigsListData _data;

        public ConfigsList(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String headline) {
            super(Minecraft.getInstance(), 0, 0, 0, 20);
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.ConfigsListData(screen, this, category);
            ISoundVisualizerConfigScreen.IConfigsList.BaseSetup(this._data);
            this._data.ScrollbarWidth = 6;
            this._data.HeadlineTextKey = headline;
        }

        public void renderWidget(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.Render(graphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public int getRight() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRight(this._data);
        }

        public int getBottom() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetBottom(this._data);
        }

        public int getRowWidth() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowWidth(this._data);
        }

        public int getRowLeft() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowLeft(this._data);
        }

        public int getRowRight() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowRight(this._data);
        }

        public int getRowTop(int entryIndex) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowTop(entryIndex, this._data);
        }

        public int getRowBottom(int entryIndex) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowBottom(entryIndex, this._data);
        }

        public int maxScrollAmount() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetMaxScroll(this._data);
        }

        protected double scrollRate() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollRate(this._data);
        }

        protected int scrollBarX() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollbarX(this._data);
        }

        protected int scrollBarY() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollbarY(this._data);
        }

        public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetChildAt(mouseX, mouseY, this._data).stream().map(child -> (GuiEventListener)child).findFirst();
        }

        public ConfigsListEntry getFocused() {
            return (ConfigsListEntry)ISoundVisualizerConfigScreen.IConfigScreenList.GetFocused(this._data);
        }

        @Nullable
        protected ConfigsListEntry getHovered() {
            return (ConfigsListEntry)ISoundVisualizerConfigScreen.IConfigScreenList.GetHovered(this._data);
        }

        protected void enableScissor(@Nonnull GuiGraphics graphics) {
            ISoundVisualizerConfigScreen.IConfigScreenList.EnableScissor(graphics, this._data);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.getHovered() != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IConfigScreenList.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            for (ConfigsListEntry entry : this.children()) {
                entry.Unfocus();
            }
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IConfigsList.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IConfigsList.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigsList.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IConfigsList.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigsList.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IConfigsList.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IConfigsList.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigsList.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget((GuiGraphics)guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }

        @Override
        public double GetScroll() {
            return super.scrollAmount();
        }

        @Override
        public void SetScroll(double scroll) {
            this.setScrollAmount(scroll);
        }

        @Override
        public void UpdateScrollingState(double mouseX, double mouseY, int button) {
            this.updateScrolling(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public void AddWidget(ISoundVisualizerConfigScreen.IConfigScreenWidget widget) {
            this.addEntry((AbstractSelectionList.Entry)new ConfigsListEntry(this._data.Screen, this, widget));
            this._data.AllEntries = new ArrayList(this.children());
            this._data.VisibleEntries = this._data.AllEntries;
        }
    }

    private static class SoundsSelectableList
    extends ObjectSelectionList<SoundsSelectableListEntry>
    implements ISoundVisualizerConfigScreen.ISoundsSelectableList {
        private final ISoundVisualizerConfigScreen.SoundsSelectableListData _data;

        public SoundsSelectableList(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category) {
            super(Minecraft.getInstance(), 0, 0, 0, 12);
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.SoundsSelectableListData(screen, this, category);
            ISoundVisualizerConfigScreen.ISoundsSelectableList.BaseSetup(this._data);
            this._data.ScrollbarWidth = 6;
        }

        public void renderWidget(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.Render(graphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.IsMouseOver(mouseX, mouseY);
        }

        public int getRight() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRight(this._data);
        }

        public int getBottom() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetBottom(this._data);
        }

        public int getRowWidth() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowWidth(this._data);
        }

        public int getRowLeft() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowLeft(this._data);
        }

        public int getRowRight() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowRight(this._data);
        }

        public int getRowTop(int entryIndex) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowTop(entryIndex, this._data);
        }

        public int getRowBottom(int entryIndex) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetRowBottom(entryIndex, this._data);
        }

        public int maxScrollAmount() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetMaxScroll(this._data);
        }

        protected double scrollRate() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollRate(this._data);
        }

        protected int scrollBarX() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollbarX(this._data);
        }

        protected int scrollBarY() {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetScrollbarY(this._data);
        }

        public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigScreenList.GetChildAt(mouseX, mouseY, this._data).stream().map(child -> (GuiEventListener)child).findFirst();
        }

        public SoundsSelectableListEntry getFocused() {
            return (SoundsSelectableListEntry)ISoundVisualizerConfigScreen.IConfigScreenList.GetFocused(this._data);
        }

        @Nullable
        protected SoundsSelectableListEntry getHovered() {
            return (SoundsSelectableListEntry)ISoundVisualizerConfigScreen.IConfigScreenList.GetHovered(this._data);
        }

        protected void enableScissor(@Nonnull GuiGraphics graphics) {
            ISoundVisualizerConfigScreen.IConfigScreenList.EnableScissor(graphics, this._data);
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return this.getHovered() != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.ISoundsSelectableList.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            this._data.SearchBox.Unfocus();
            this._data.FilterTypeSwitch.Unfocus();
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.ISoundsSelectableList.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.ISoundsSelectableList.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableList.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget((GuiGraphics)guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }

        @Override
        public double GetScroll() {
            return super.scrollAmount();
        }

        @Override
        public void SetScroll(double scroll) {
            this.setScrollAmount(scroll);
        }

        @Override
        public void UpdateScrollingState(double mouseX, double mouseY, int button) {
            this.updateScrolling(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public void AddSound(String sound, String subtitleText, boolean visible, boolean favorite, boolean configured) {
            this.addEntry((AbstractSelectionList.Entry)new SoundsSelectableListEntry(this._data.Screen, this, sound, subtitleText, visible, favorite, configured));
            this._data.AllEntries = new ArrayList(this.children());
        }
    }

    private static final class Rect
    extends AbstractWidget
    implements ISoundVisualizerConfigScreen.IRect {
        private final ISoundVisualizerConfigScreen.RectData _data;

        public Rect(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, int direction) {
            super(0, 0, 0, 0, (Component)Component.empty());
            this._data = new ISoundVisualizerConfigScreen.RectData(screen, this, category);
            this._data.Direction = direction;
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        protected void updateWidgetNarration(@Nonnull NarrationElementOutput output) {
        }

        public int getX() {
            return ISoundVisualizerConfigScreen.IRect.GetX(this._data);
        }

        public int getY() {
            return ISoundVisualizerConfigScreen.IRect.GetY(this._data);
        }

        public int getWidth() {
            return ISoundVisualizerConfigScreen.IRect.GetWidth(this._data);
        }

        public int getHeight() {
            return ISoundVisualizerConfigScreen.IRect.GetHeight(this._data);
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IRect.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IRect.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
        }

        @Override
        public void SetHover(boolean isHovered) {
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IRect.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IRect.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IRect.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IRect.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IRect.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IRect.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IRect.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IRect.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }
    }

    private static class Tab
    extends AbstractButton
    implements ISoundVisualizerConfigScreen.ITab {
        private final ISoundVisualizerConfigScreen.TabData _data;

        public Tab(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey) {
            super(0, 0, 19, 19, (Component)Component.empty());
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.TabData(screen, this, category);
            this._data.Visible = true;
            this._data.TextKey = textKey;
        }

        public void onPress(InputWithModifiers input) {
        }

        public void renderContents(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        protected void updateWidgetNarration(@Nonnull NarrationElementOutput output) {
        }

        public int getX() {
            return ISoundVisualizerConfigScreen.ITab.GetX(this._data);
        }

        public int getY() {
            return ISoundVisualizerConfigScreen.ITab.GetY(this._data);
        }

        public int getWidth() {
            return ISoundVisualizerConfigScreen.ITab.GetWidth(this._data);
        }

        public int getHeight() {
            return ISoundVisualizerConfigScreen.ITab.GetHeight(this._data);
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.ITab.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.ITab.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.ITab.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ITab.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.ITab.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ITab.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.ITab.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.ITab.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.ITab.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderDefaultSprite((GuiGraphics)guiGraphics);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.ITab.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }
    }

    private static class ConfigButton
    extends AbstractButton
    implements ISoundVisualizerConfigScreen.IConfigButton {
        private final ISoundVisualizerConfigScreen.ConfigButtonData _data;

        public ConfigButton(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey, int configID, int values, ISoundVisualizerConfigScreen.IConfigButton.IOnPress onPress, ISoundVisualizerConfigScreen.IConfigButton.IOnRender onRender) {
            super(0, 0, 20, 20, (Component)Component.empty());
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.ConfigButtonData(screen, this, category);
            this._data.ConfigID = configID;
            this._data.TextKey = textKey;
            this._data.Values = values;
            this._data.OnPress = onPress;
            this._data.OnRender = onRender;
            ISoundVisualizerConfigScreen.IConfigButton.SynchValue(this._data);
        }

        public void onPress(InputWithModifiers input) {
        }

        public void renderContents(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public boolean isFocused() {
            return this._data.Focused;
        }

        protected void updateWidgetNarration(@Nonnull NarrationElementOutput output) {
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IConfigButton.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IConfigButton.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            this._data.Focused = false;
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IConfigButton.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IConfigButton.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigButton.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IConfigButton.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigButton.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IConfigButton.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IConfigButton.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigButton.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderDefaultSprite((GuiGraphics)guiGraphics);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }
    }

    private static class ConfigSliderButton
    extends AbstractSliderButton
    implements ISoundVisualizerConfigScreen.IConfigSliderButton {
        private final ISoundVisualizerConfigScreen.ConfigSliderButtonData _data;

        public ConfigSliderButton(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String textKey, int configID, int color, float textValueMultiplier, int minValue, int maxValue) {
            super(0, 0, 20, 20, (Component)Component.empty(), 0.0);
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.ConfigSliderButtonData(screen, this, category);
            this._data.ConfigID = configID;
            this._data.TextKey = textKey;
            this._data.TextColor = color;
            this._data.TextValueMultiplier = textValueMultiplier;
            this._data.MinValue = minValue;
            this._data.MaxValue = maxValue;
            ISoundVisualizerConfigScreen.IConfigSliderButton.SynchValue(this._data);
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public boolean isFocused() {
            return this._data.Focused;
        }

        protected void updateMessage() {
        }

        protected void applyValue() {
            ISoundVisualizerConfigScreen.IConfigSliderButton.ApplyValue(this.value, this._data);
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IConfigSliderButton.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            this._data.Focused = false;
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IConfigSliderButton.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IConfigSliderButton.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigSliderButton.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget((GuiGraphics)guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }

        @Override
        public double GetValue() {
            return this.value;
        }

        @Override
        public void SetValue(double newValue) {
            this.value = newValue;
        }
    }

    private static class ConfigEditBox
    extends EditBox
    implements ISoundVisualizerConfigScreen.IConfigEditBox {
        private final ISoundVisualizerConfigScreen.ConfigEditBoxData _data;

        public ConfigEditBox(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.VisibilityCategory category, String hintTextKey, int configID, int maxLength, Consumer<String> responder, Predicate<String> filter) {
            super(Minecraft.getInstance().font, 0, 0, 20, 20, (Component)Component.empty());
            this.visible = true;
            this._data = new ISoundVisualizerConfigScreen.ConfigEditBoxData(screen, this, category);
            ISoundVisualizerConfigScreen.IConfigEditBox.BaseSetup(responder, filter, this._data);
            this._data.ConfigID = configID;
            this._data.HintTextKey = hintTextKey;
            this._data.MaxLength = maxLength;
            ISoundVisualizerConfigScreen.IConfigEditBox.SynchValue(this._data);
        }

        public void renderWidget(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public boolean isFocused() {
            return this._data.Focused;
        }

        protected MutableComponent createNarrationMessage() {
            return Component.empty();
        }

        public void setValue(@Nonnull String text) {
            ISoundVisualizerConfigScreen.IConfigEditBox.SetValue(text, this._data);
        }

        public String getHighlighted() {
            return ISoundVisualizerConfigScreen.IConfigEditBox.GetHighlighted(this._data);
        }

        public void insertText(@Nonnull String text) {
            ISoundVisualizerConfigScreen.IConfigEditBox.InsertText(text, this._data);
        }

        public void deleteWords(int word) {
            ISoundVisualizerConfigScreen.IConfigEditBox.DeleteWords(word, this._data);
        }

        public void deleteChars(int position) {
            ISoundVisualizerConfigScreen.IConfigEditBox.DeleteChars(position, this._data);
        }

        public void moveCursorTo(int position, boolean ignoreHighlight) {
            ISoundVisualizerConfigScreen.IConfigEditBox.MoveCursorTo(position, ignoreHighlight, this._data);
        }

        public void moveCursor(int steps, boolean ignoreHighlight) {
            ISoundVisualizerConfigScreen.IConfigEditBox.MoveCursor(steps, ignoreHighlight, this._data);
        }

        public void setCursorPosition(int position) {
            ISoundVisualizerConfigScreen.IConfigEditBox.SetCursorPosition(position, this._data);
        }

        public void moveCursorToEnd(boolean ignoreHighlight) {
            ISoundVisualizerConfigScreen.IConfigEditBox.MoveCursorToEnd(ignoreHighlight, this._data);
        }

        public String getValue() {
            return this._data.Value;
        }

        public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
            ISoundVisualizerConfigScreen.IConfigEditBox.OnClick(event.x(), event.y(), this._data);
        }

        public void setHighlightPos(int position) {
            ISoundVisualizerConfigScreen.IConfigEditBox.SetHighlightPos(position, this._data);
        }

        public int getWordPosition(int position) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.GetWordPosition(position, this._data);
        }

        public boolean canConsumeInput() {
            return ISoundVisualizerConfigScreen.IConfigEditBox.CanConsumeInput(this._data);
        }

        public int getCursorPosition() {
            return ISoundVisualizerConfigScreen.IConfigEditBox.GetCursorPosition(this._data);
        }

        public int getScreenX(int maxLength) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.GetScreenX(maxLength, this._data);
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IConfigEditBox.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IConfigEditBox.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this.setPosition(x, y);
            this.setWidth(newWidth);
            this.setHeight(newHeight);
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            super.setFocused(false);
            this._data.Focused = false;
        }

        @Override
        public void SetHover(boolean isHovered) {
            this.isHovered = isHovered;
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IConfigEditBox.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IConfigEditBox.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigEditBox.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget((GuiGraphics)guiGraphics, mouseX, mouseY, partialTick);
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }
    }

    private static class SoundsSelectableListEntry
    extends ObjectSelectionList.Entry<SoundsSelectableListEntry>
    implements ISoundVisualizerConfigScreen.ISoundsSelectableListEntry {
        private final ISoundVisualizerConfigScreen.SoundsSelectableListEntryData _data;

        public SoundsSelectableListEntry(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.ISoundsSelectableList list, String sound, String subtitleText, boolean visible, boolean favorite, boolean configured) {
            this._data = new ISoundVisualizerConfigScreen.SoundsSelectableListEntryData(screen, list, this, ISoundVisualizerConfigScreen.VisibilityCategory.Eternal);
            this._data.Sound = sound;
            this._data.SubtitleText = subtitleText;
            this._data.Visible = visible;
            this._data.Favorite = favorite;
            this._data.Configured = configured;
        }

        public void renderContent(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.Render(graphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public Component getNarration() {
            return Component.empty();
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this;
        }

        @Override
        public void Unfocus() {
            ISoundVisualizerConfigScreen.ISoundsSelectableList.RemoveSelected(this, (ISoundVisualizerConfigScreen.SoundsSelectableListData)this._data.List.GetData());
        }

        @Override
        public void SetHover(boolean isHovered) {
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.ISoundsSelectableListEntry.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }

        @Override
        public void PlayClickSound() {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
    }

    private static class ConfigsListEntry
    extends ObjectSelectionList.Entry<ConfigsListEntry>
    implements ISoundVisualizerConfigScreen.IConfigsListEntry {
        private final ISoundVisualizerConfigScreen.ConfigsListEntryData _data;

        public ConfigsListEntry(ISoundVisualizerConfigScreen screen, ISoundVisualizerConfigScreen.IConfigsList list, ISoundVisualizerConfigScreen.IConfigScreenWidget widget) {
            this._data = new ISoundVisualizerConfigScreen.ConfigsListEntryData(screen, list, this, ISoundVisualizerConfigScreen.VisibilityCategory.Eternal);
            this._data.Widget = widget;
        }

        public void renderContent(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, boolean isHovered, float partialTick) {
            this.Render(graphics, mouseX, mouseY, partialTick);
        }

        public void mouseMoved(double mouseX, double mouseY) {
            this.MouseMoved(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
            return this.MouseClicked(event.x(), event.y(), event.button());
        }

        public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
            return this.MouseDragged(event.x(), event.y(), event.button(), dragX, dragY);
        }

        public boolean mouseReleased(MouseButtonEvent event) {
            return this.MouseReleased(event.x(), event.y(), event.button());
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return this.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public boolean keyPressed(KeyEvent event) {
            return this.KeyPressed(event.key(), event.scancode(), event.modifiers());
        }

        public Component getNarration() {
            return Component.empty();
        }

        @Override
        public boolean UpdateVisibility() {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.UpdateVisibility(this._data);
        }

        @Override
        public void UpdateVisibility(boolean isVisible) {
            ISoundVisualizerConfigScreen.IConfigsListEntry.UpdateVisibility(isVisible, this._data);
        }

        @Override
        public Object SetBase(int x, int y, int newWidth, int newHeight) {
            this._data.X = x;
            this._data.Y = y;
            this._data.Width = newWidth;
            this._data.Height = newHeight;
            return this._data.Widget.SetBase(x, y, newWidth, newHeight);
        }

        @Override
        public void Unfocus() {
            this._data.Widget.Unfocus();
        }

        @Override
        public void SetHover(boolean isHovered) {
        }

        @Override
        public ISoundVisualizerConfigScreen.ConfigScreenChildData GetData() {
            return this._data;
        }

        @Override
        public void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
            ISoundVisualizerConfigScreen.IConfigsListEntry.Render(guiGraphics, mouseX, mouseY, partialTick, this._data);
        }

        @Override
        public void MouseMoved(double mouseX, double mouseY) {
            ISoundVisualizerConfigScreen.IConfigsListEntry.MouseMoved(mouseX, mouseY, this._data);
        }

        @Override
        public boolean MouseClicked(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.MouseClicked(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.MouseDragged(mouseX, mouseY, button, dragX, dragY, this._data);
        }

        @Override
        public boolean MouseReleased(double mouseX, double mouseY, int button) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.MouseReleased(mouseX, mouseY, button, this._data);
        }

        @Override
        public boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.MouseScrolled(mouseX, mouseY, scrollX, scrollY, this._data);
        }

        @Override
        public boolean KeyPressed(int keyCode, int scanCode, int modifiers) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.KeyPressed(keyCode, scanCode, modifiers, this._data);
        }

        @Override
        public boolean IsMouseOver(double mouseX, double mouseY) {
            return ISoundVisualizerConfigScreen.IConfigsListEntry.IsMouseOver(mouseX, mouseY, this._data);
        }

        @Override
        public void SuperRender(Object guiGraphics, int mouseX, int mouseY, float partialTick) {
        }

        @Override
        public boolean SuperMouseClicked(double mouseX, double mouseY, int button) {
            return super.mouseClicked(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), false);
        }

        @Override
        public boolean SuperMouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            return super.mouseDragged(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)), dragX, dragY);
        }

        @Override
        public boolean SuperMouseReleased(double mouseX, double mouseY, int button) {
            return super.mouseReleased(new MouseButtonEvent(mouseX, mouseY, new MouseButtonInfo(button, 0)));
        }

        @Override
        public boolean SuperMouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        @Override
        public boolean SuperKeyPressed(int keyCode, int scanCode, int modifiers) {
            return super.keyPressed(new KeyEvent(keyCode, scanCode, modifiers));
        }
    }
}

