/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.ModMath;
import java.util.List;

public abstract class AbstractModLogic {
    public static final String MODID = "sound_visualizer";
    private static AbstractModLogic _instance = null;

    public static AbstractModLogic SetupInstance(AbstractModLogic instance) {
        _instance = instance;
        return _instance;
    }

    public static float GetSoundDistanceWeight(Object sound) {
        if (AbstractModLogic.IsSoundVolumeAbsolute(sound)) {
            return 0.0f;
        }
        ModMath.Vec3 soundPos = new ModMath.Vec3(AbstractModLogic.GetSoundPosX(sound), AbstractModLogic.GetSoundPosY(sound), AbstractModLogic.GetSoundPosZ(sound));
        float volume = AbstractModLogic.GetSoundVolume(sound);
        float soundRange = Math.max(volume * 16.0f, 16.0f);
        return Math.clamp((float)soundPos.DistanceTo(AbstractModLogic.GetListenerPosition()) / soundRange, 0.0f, 1.0f);
    }

    public static boolean IsSoundInRange(Object sound) {
        if (AbstractModLogic.IsSoundVolumeAbsolute(sound)) {
            return true;
        }
        ModMath.Vec3 soundPos = new ModMath.Vec3(AbstractModLogic.GetSoundPosX(sound), AbstractModLogic.GetSoundPosY(sound), AbstractModLogic.GetSoundPosZ(sound));
        float volume = AbstractModLogic.GetSoundVolume(sound);
        float soundRange = Math.max(volume * 16.0f, 16.0f);
        return (float)soundPos.DistanceTo(AbstractModLogic.GetListenerPosition()) <= soundRange;
    }

    public static String GetGameVersion() {
        return _instance.InstanceGetGameVersion();
    }

    protected abstract String InstanceGetGameVersion();

    public static float GetGameVersionID(String version) {
        float id = 0.0f;
        float versionNumberMultiplier = 1000000.0f;
        for (String versionNumberText : version.split("\\.")) {
            try {
                float versionNumber = Float.parseFloat(versionNumberText);
                id += versionNumberMultiplier * versionNumber;
                versionNumberMultiplier /= 1000.0f;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return id;
    }

    public static boolean IsGameVersionEarlier(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        return AbstractModLogic.GetGameVersionID(AbstractModLogic.GetGameVersion()) < AbstractModLogic.GetGameVersionID(version);
    }

    public static boolean IsGameVersionEarlierOrEqual(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        return AbstractModLogic.GetGameVersionID(AbstractModLogic.GetGameVersion()) <= AbstractModLogic.GetGameVersionID(version);
    }

    public static boolean IsGameVersionLater(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        return AbstractModLogic.GetGameVersionID(AbstractModLogic.GetGameVersion()) > AbstractModLogic.GetGameVersionID(version);
    }

    public static boolean IsGameVersionLaterOrEqual(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        return AbstractModLogic.GetGameVersionID(AbstractModLogic.GetGameVersion()) >= AbstractModLogic.GetGameVersionID(version);
    }

    public static String GetGameLocaleLanguage() {
        return _instance.InstanceGetGameLocaleLanguage();
    }

    protected abstract String InstanceGetGameLocaleLanguage();

    public static boolean IsLevelExist() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceIsLevelExist();
    }

    protected abstract boolean InstanceIsLevelExist();

    public static boolean IsPlayerExist() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceIsPlayerExist();
    }

    protected abstract boolean InstanceIsPlayerExist();

    public static boolean IsCameraExist() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceIsCameraExist();
    }

    protected abstract boolean InstanceIsCameraExist();

    public static boolean ShowDSIs() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceShowDSIs();
    }

    protected abstract boolean InstanceShowDSIs();

    public static boolean ShowSubtitles() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceShowSubtitles();
    }

    protected abstract boolean InstanceShowSubtitles();

    public static boolean IsTransparencyImproved() {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceIsTransparencyImproved();
    }

    protected abstract boolean InstanceIsTransparencyImproved();

    public static double GetPlayerPosX(float partialTick) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetPlayerPosX(partialTick);
    }

    protected abstract double InstanceGetPlayerPosX(float var1);

    public static double GetPlayerPosY(float partialTick) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetPlayerPosY(partialTick);
    }

    protected abstract double InstanceGetPlayerPosY(float var1);

    public static double GetPlayerPosZ(float partialTick) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetPlayerPosZ(partialTick);
    }

    protected abstract double InstanceGetPlayerPosZ(float var1);

    public static float GetPlayerRotY(float partialTick) {
        if (_instance == null) {
            return 0.0f;
        }
        return _instance.InstanceGetPlayerRotY(partialTick);
    }

    protected abstract float InstanceGetPlayerRotY(float var1);

    public static float GetPlayerRotX(float partialTick) {
        if (_instance == null) {
            return 0.0f;
        }
        return _instance.InstanceGetPlayerRotX(partialTick);
    }

    protected abstract float InstanceGetPlayerRotX(float var1);

    public static ModMath.Vec3 GetListenerPosition() {
        if (_instance == null) {
            return ModMath.Vec3.ZERO;
        }
        return _instance.InstanceGetListenerPosition();
    }

    protected abstract ModMath.Vec3 InstanceGetListenerPosition();

    public static Object GetScreen() {
        if (_instance == null) {
            return null;
        }
        return _instance.InstanceGetScreen();
    }

    protected abstract Object InstanceGetScreen();

    public static boolean ScreenIsOptionsScreen(Object screen) {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceScreenIsOptionsScreen(screen);
    }

    protected abstract boolean InstanceScreenIsOptionsScreen(Object var1);

    public static boolean ScreenIsAccessibilityOptionsScreen(Object screen) {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceScreenIsAccessibilityOptionsScreen(screen);
    }

    protected abstract boolean InstanceScreenIsAccessibilityOptionsScreen(Object var1);

    public static boolean ScreenIsSoundOptionsScreen(Object screen) {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceScreenIsSoundOptionsScreen(screen);
    }

    protected abstract boolean InstanceScreenIsSoundOptionsScreen(Object var1);

    public static double GetCameraPosX() {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetCameraPosX();
    }

    protected abstract double InstanceGetCameraPosX();

    public static double GetCameraPosY() {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetCameraPosY();
    }

    protected abstract double InstanceGetCameraPosY();

    public static double GetCameraPosZ() {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetCameraPosZ();
    }

    protected abstract double InstanceGetCameraPosZ();

    public static float[] GetCameraRotations() {
        if (_instance == null) {
            return new float[0];
        }
        return _instance.InstanceGetCameraRotations();
    }

    protected abstract float[] InstanceGetCameraRotations();

    public static ModMath.Vec3 GetRotatedVector(ModMath.Vec3 vector, float rotY, float rotX, float rotZ) {
        if (_instance == null) {
            return ModMath.Vec3.ZERO;
        }
        return _instance.InstanceGetRotatedVector(vector, rotY, rotX, rotZ);
    }

    protected abstract ModMath.Vec3 InstanceGetRotatedVector(ModMath.Vec3 var1, float var2, float var3, float var4);

    public static String GetSoundSourceName(Object sound) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetSoundSourceName(sound);
    }

    protected abstract String InstanceGetSoundSourceName(Object var1);

    public static String GetSoundLocation(Object sound) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetSoundLocation(sound);
    }

    protected abstract String InstanceGetSoundLocation(Object var1);

    public static String GetSoundSubtitleText(Object sound) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetSoundSubtitleText(sound);
    }

    protected abstract String InstanceGetSoundSubtitleText(Object var1);

    public static double GetSoundPosX(Object sound) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetSoundPosX(sound);
    }

    protected abstract double InstanceGetSoundPosX(Object var1);

    public static double GetSoundPosY(Object sound) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetSoundPosY(sound);
    }

    protected abstract double InstanceGetSoundPosY(Object var1);

    public static double GetSoundPosZ(Object sound) {
        if (_instance == null) {
            return 0.0;
        }
        return _instance.InstanceGetSoundPosZ(sound);
    }

    protected abstract double InstanceGetSoundPosZ(Object var1);

    public static float GetSoundVolume(Object sound) {
        if (_instance == null) {
            return 0.0f;
        }
        return _instance.InstanceGetSoundVolume(sound);
    }

    protected abstract float InstanceGetSoundVolume(Object var1);

    public static float GetSoundPitch(Object sound) {
        if (_instance == null) {
            return 0.0f;
        }
        return _instance.InstanceGetSoundPitch(sound);
    }

    protected abstract float InstanceGetSoundPitch(Object var1);

    public static boolean IsSoundVolumeAbsolute(Object sound) {
        if (_instance == null) {
            return false;
        }
        return _instance.InstanceIsSoundVolumeAbsolute(sound);
    }

    protected abstract boolean InstanceIsSoundVolumeAbsolute(Object var1);

    public static List<String> GetSoundsLocation(Object soundManager) {
        return _instance.InstanceGetSoundsLocation(soundManager);
    }

    protected abstract List<String> InstanceGetSoundsLocation(Object var1);

    public static List<String> GetSoundsSubtitleText(Object soundManager) {
        return _instance.InstanceGetSoundsSubtitleText(soundManager);
    }

    protected abstract List<String> InstanceGetSoundsSubtitleText(Object var1);

    public static long GetMillis() {
        if (_instance == null) {
            return 0L;
        }
        return _instance.InstanceGetMillis();
    }

    protected abstract long InstanceGetMillis();

    public static int GetTextWidth(String text) {
        if (_instance == null) {
            return 0;
        }
        return _instance.InstanceGetTextWidth(text);
    }

    protected abstract int InstanceGetTextWidth(String var1);

    public static int GetTextHeight() {
        if (_instance == null) {
            return 0;
        }
        return _instance.InstanceGetTextHeight();
    }

    protected abstract int InstanceGetTextHeight();

    public static String GetTextTranslate(String textKey) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetTextTranslate(textKey);
    }

    protected abstract String InstanceGetTextTranslate(String var1);

    public static String GetFilteredText(String text) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetFilteredText(text);
    }

    protected abstract String InstanceGetFilteredText(String var1);

    public static String GetPlainTextByWidth(String text, int maxWidth) {
        if (_instance == null) {
            return "";
        }
        return _instance.InstanceGetPlainTextByWidth(text, maxWidth);
    }

    protected abstract String InstanceGetPlainTextByWidth(String var1, int var2);

    public static int OffsetByCodepoints(String text, int cursorPos, int direction) {
        if (_instance == null) {
            return 0;
        }
        return _instance.InstanceOffsetByCodepoints(text, cursorPos, direction);
    }

    protected abstract int InstanceOffsetByCodepoints(String var1, int var2, int var3);
}

