/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.ModTexture;
import java.util.ArrayList;

public abstract class AbstractModRender {
    protected static final ArrayList<Runnable> RENDER_CALLS = new ArrayList();
    protected static final int PACKED_LIGHT_COORDS = 0xF000F0;
    protected static final float[] SHADER_COLORS = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected static AbstractModRender _instance;

    public static final AbstractModRender SetupInstance(AbstractModRender instance) {
        _instance = instance;
        return _instance;
    }

    public static void RenderLeftScrollingText(Object guiGraphics, String text, int scissorX0, int scissorX1, int textY, float scale, int color, boolean dropShadow, boolean italic) {
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        int textWidth = (int)Math.ceil(scale * (float)AbstractModLogic.GetTextWidth(text));
        int scissorWidth = scissorX1 - scissorX0;
        AbstractModRender.EnableScissor(guiGraphics, scissorX0, 0, scissorX1, AbstractModRender.GetGuiHeight(guiGraphics));
        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, scale, scale, 1.0f);
        if (textWidth > scissorWidth) {
            int widthDifference = textWidth - scissorWidth;
            double time = (double)AbstractModLogic.GetMillis() / 800.0;
            double offsetX = Math.floor((double)widthDifference / 2.0 * (Math.sin(time) + 1.0));
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)((double)(1.0f / scale) * ((double)scissorX0 - offsetX)), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        } else {
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)(1.0f / scale * (float)scissorX0), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        }
        AbstractModRender.PopPose(pose);
        AbstractModRender.DisableScissor(guiGraphics);
    }

    public static void RenderRightScrollingText(Object guiGraphics, String text, int scissorX0, int scissorX1, int textY, float scale, int color, boolean dropShadow, boolean italic) {
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        int textWidth = (int)Math.ceil(scale * (float)AbstractModLogic.GetTextWidth(text));
        int scissorWidth = scissorX1 - scissorX0;
        AbstractModRender.EnableScissor(guiGraphics, scissorX0, 0, scissorX1, AbstractModRender.GetGuiHeight(guiGraphics));
        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, scale, scale, 1.0f);
        if (textWidth > scissorWidth) {
            int widthDifference = textWidth - scissorWidth;
            double time = (double)AbstractModLogic.GetMillis() / 800.0;
            double offsetX = Math.floor((double)widthDifference / 2.0 * (Math.sin(time) + 1.0));
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)((double)(1.0f / scale) * ((double)scissorX0 - offsetX)), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        } else {
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)Math.ceil(1.0f / scale * (float)(scissorX1 - textWidth)), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        }
        AbstractModRender.PopPose(pose);
        AbstractModRender.DisableScissor(guiGraphics);
    }

    public static void RenderCenterScrollingText(Object guiGraphics, String text, int scissorX0, int scissorX1, int textY, float scale, int color, boolean dropShadow, boolean italic) {
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        int textWidth = (int)Math.ceil(scale * (float)AbstractModLogic.GetTextWidth(text));
        int scissorWidth = scissorX1 - scissorX0;
        AbstractModRender.EnableScissor(guiGraphics, scissorX0, 0, scissorX1, AbstractModRender.GetGuiHeight(guiGraphics));
        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, scale, scale, 1.0f);
        if (textWidth > scissorWidth) {
            int widthDifference = textWidth - scissorWidth;
            double time = (double)AbstractModLogic.GetMillis() / 800.0;
            double offsetX = Math.floor((double)widthDifference / 2.0 * Math.sin(time)) + (double)textWidth / 2.0;
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)((double)(1.0f / scale) * ((double)(scissorX0 + (int)Math.floor((double)scissorWidth / 2.0)) - offsetX)), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        } else {
            AbstractModRender.RenderGUIText(guiGraphics, text, (int)Math.ceil(1.0f / scale * ((float)(scissorX0 + (int)Math.floor((double)scissorWidth / 2.0)) - (float)textWidth / 2.0f)), (int)(1.0f / scale * (float)textY), color, dropShadow, italic);
        }
        AbstractModRender.PopPose(pose);
        AbstractModRender.DisableScissor(guiGraphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RecordCall(Runnable call) {
        if (_instance.InstanceIsOnRenderThread()) {
            call.run();
        } else {
            ArrayList<Runnable> arrayList = RENDER_CALLS;
            synchronized (arrayList) {
                RENDER_CALLS.add(call);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ProcessAllCalls() {
        if (RENDER_CALLS.isEmpty() || !_instance.InstanceIsOnRenderThread()) {
            return;
        }
        ArrayList<Runnable> arrayList = RENDER_CALLS;
        synchronized (arrayList) {
            for (Runnable call : RENDER_CALLS) {
                call.run();
            }
            RENDER_CALLS.clear();
        }
    }

    public static boolean IsOnRenderThread() {
        return _instance.InstanceIsOnRenderThread();
    }

    protected abstract boolean InstanceIsOnRenderThread();

    public static Object GetPoseFromGraphics(Object guiGraphics) {
        return _instance.InstanceGetPoseFromGraphics(guiGraphics);
    }

    protected abstract Object InstanceGetPoseFromGraphics(Object var1);

    public static void SetShaderColor(float r, float g, float b, float a) {
        AbstractModRender.SHADER_COLORS[0] = r;
        AbstractModRender.SHADER_COLORS[1] = g;
        AbstractModRender.SHADER_COLORS[2] = b;
        AbstractModRender.SHADER_COLORS[3] = a;
        _instance.InstanceSetShaderColor(r, g, b, a);
    }

    protected abstract void InstanceSetShaderColor(float var1, float var2, float var3, float var4);

    public static void SetRenderOptions(boolean blend, boolean depthTest, boolean depthMask, boolean cull, boolean colorShader) {
        _instance.InstanceSetRenderOptions(blend, depthTest, depthMask, cull, colorShader);
    }

    protected abstract void InstanceSetRenderOptions(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public static void EnableScissor(Object guiGraphics, int x0, int y0, int x1, int y1) {
        _instance.InstanceEnableScissor(guiGraphics, x0, y0, x1, y1);
    }

    protected abstract void InstanceEnableScissor(Object var1, int var2, int var3, int var4, int var5);

    public static void DisableScissor(Object guiGraphics) {
        _instance.InstanceDisableScissor(guiGraphics);
    }

    protected abstract void InstanceDisableScissor(Object var1);

    public static void PushPose(Object pose, double x, double y, double z, boolean rotate, float yaw, float pitch, float roll, float scaleX, float scaleY, float scaleZ) {
        _instance.InstancePushPose(pose, x, y, z, rotate, yaw, pitch, roll, scaleX, scaleY, scaleZ);
    }

    protected abstract void InstancePushPose(Object var1, double var2, double var4, double var6, boolean var8, float var9, float var10, float var11, float var12, float var13, float var14);

    public static void PopPose(Object pose) {
        _instance.InstancePopPose(pose);
    }

    protected abstract void InstancePopPose(Object var1);

    public static void PushBuffer() {
        _instance.InstancePushBuffer();
    }

    protected abstract void InstancePushBuffer();

    public static void PushMatrix(Object pose) {
        _instance.InstancePushMatrix(pose);
    }

    protected abstract void InstancePushMatrix(Object var1);

    public static void PushVertexConsumer() {
        _instance.InstancePushVertexConsumer();
    }

    protected abstract void InstancePushVertexConsumer();

    public static void AddVertex(float x, float y, float z, float u, float v, int color) {
        _instance.InstanceAddVertex(x, y, z, u, v, color);
    }

    protected abstract void InstanceAddVertex(float var1, float var2, float var3, float var4, float var5, int var6);

    public static void PushBufferEnd() {
        _instance.InstancePushBufferEnd();
    }

    protected abstract void InstancePushBufferEnd();

    public static int GetGuiWidth(Object guiGraphics) {
        return _instance.InstanceGetGuiWidth(guiGraphics);
    }

    protected abstract int InstanceGetGuiWidth(Object var1);

    public static int GetGuiHeight(Object guiGraphics) {
        return _instance.InstanceGetGuiHeight(guiGraphics);
    }

    protected abstract int InstanceGetGuiHeight(Object var1);

    public static int GetBackgroundColor(float alpha) {
        return _instance.InstanceGetBackgroundColor(alpha);
    }

    protected abstract int InstanceGetBackgroundColor(float var1);

    public static void RenderTexture(Object guiGraphics, ModTexture texture, int x, int y, int uOffset, int vOffset, int width, int height) {
        _instance.InstanceRenderTexture(guiGraphics, texture.GetLocation(), x, y, uOffset, vOffset, width, height, texture.GetWidth(), texture.GetHeight());
    }

    protected abstract void InstanceRenderTexture(Object var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public static void RenderRawTexture(Object guiGraphics, String location, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight) {
        _instance.InstanceRenderTexture(guiGraphics, location, x, y, uOffset, vOffset, width, height, width, height);
    }

    public static void RenderTextureWithBorder(Object guiGraphics, ModTexture texture, int x, int y, int uOffset, int vOffset, int width, int height, int borderSize) {
        int edgeOffset;
        int i;
        String location = texture.GetLocation();
        int doubleBorderSize = borderSize * 2;
        int borderlessWidth = width - doubleBorderSize;
        int textureWidth = texture.GetWidth();
        int borderlessTextureWidth = textureWidth - doubleBorderSize;
        int borderlessHeight = height - doubleBorderSize;
        int textureHeight = texture.GetHeight();
        int borderlessTextureHeight = textureHeight - doubleBorderSize;
        _instance.InstanceRenderTexture(guiGraphics, location, x, y, uOffset, vOffset, borderSize, borderSize, textureWidth, textureHeight);
        _instance.InstanceRenderTexture(guiGraphics, location, x + width - borderSize, y, uOffset + textureWidth - borderSize, vOffset, borderSize, borderSize, textureWidth, textureHeight);
        _instance.InstanceRenderTexture(guiGraphics, location, x, y + height - borderSize, uOffset, vOffset + textureHeight - borderSize, borderSize, borderSize, textureWidth, textureHeight);
        _instance.InstanceRenderTexture(guiGraphics, location, x + width - borderSize, y + height - borderSize, uOffset + textureWidth - borderSize, vOffset + textureHeight - borderSize, borderSize, borderSize, textureWidth, textureHeight);
        for (i = 0; i < (int)Math.ceil((double)borderlessWidth / (double)borderlessTextureWidth); ++i) {
            edgeOffset = i * borderlessTextureWidth;
            _instance.InstanceRenderTexture(guiGraphics, location, x + borderSize + edgeOffset, y, uOffset + borderSize, vOffset, Math.min(borderlessTextureWidth, borderlessWidth - edgeOffset), borderSize, textureWidth, textureHeight);
            _instance.InstanceRenderTexture(guiGraphics, location, x + borderSize + edgeOffset, y + height - borderSize, uOffset + borderSize, vOffset + textureHeight - borderSize, Math.min(borderlessTextureWidth, borderlessWidth - edgeOffset), borderSize, textureWidth, textureHeight);
            for (int j = 0; j < (int)Math.ceil((double)borderlessHeight / (double)borderlessTextureHeight); ++j) {
                _instance.InstanceRenderTexture(guiGraphics, location, x + borderSize + edgeOffset, y + borderSize + j * borderlessTextureHeight, uOffset + borderSize, vOffset + borderSize, Math.min(borderlessTextureWidth, borderlessWidth - edgeOffset), Math.min(borderlessTextureHeight, borderlessHeight - j * borderlessTextureHeight), textureWidth, textureHeight);
            }
        }
        for (i = 0; i < (int)Math.ceil((double)borderlessHeight / (double)borderlessTextureHeight); ++i) {
            edgeOffset = i * borderlessTextureHeight;
            _instance.InstanceRenderTexture(guiGraphics, location, x, y + borderSize + edgeOffset, uOffset, vOffset + borderSize, borderSize, Math.min(borderlessTextureHeight, borderlessHeight - edgeOffset), textureWidth, textureHeight);
            _instance.InstanceRenderTexture(guiGraphics, location, x + width - borderSize, y + borderSize + edgeOffset, uOffset + textureWidth - borderSize, vOffset + borderSize, borderSize, Math.min(borderlessTextureHeight, borderlessHeight - edgeOffset), textureWidth, textureHeight);
        }
    }

    public static void RenderTextureWithHorizontalBorder(Object guiGraphics, ModTexture texture, int x, int y, int uOffset, int vOffset, int width, int height, int borderSize) {
        String location = texture.GetLocation();
        int doubleBorderSize = borderSize * 2;
        int borderlessWidth = width - doubleBorderSize;
        int textureWidth = texture.GetWidth();
        int borderlessTextureWidth = textureWidth - doubleBorderSize;
        int textureHeight = texture.GetHeight();
        _instance.InstanceRenderTexture(guiGraphics, location, x, y, uOffset, vOffset, borderSize, height, textureWidth, textureHeight);
        _instance.InstanceRenderTexture(guiGraphics, location, x + width - borderSize, y, uOffset + textureWidth - borderSize, vOffset, borderSize, height, textureWidth, textureHeight);
        for (int i = 0; i < (int)Math.ceil((double)borderlessWidth / (double)borderlessTextureWidth); ++i) {
            int edgeOffset = i * borderlessTextureWidth;
            _instance.InstanceRenderTexture(guiGraphics, location, x + borderSize + edgeOffset, y, uOffset + borderSize, vOffset, Math.min(borderlessTextureWidth, borderlessWidth - edgeOffset), height, textureWidth, textureHeight);
        }
    }

    public static void RenderTextureWithVerticalBorder(Object guiGraphics, ModTexture texture, int x, int y, int uOffset, int vOffset, int width, int height, int borderSize) {
        String location = texture.GetLocation();
        int doubleBorderSize = borderSize * 2;
        int textureWidth = texture.GetWidth();
        int borderlessHeight = height - doubleBorderSize;
        int textureHeight = texture.GetHeight();
        int borderlessTextureHeight = textureHeight - doubleBorderSize;
        _instance.InstanceRenderTexture(guiGraphics, location, x, y, uOffset, vOffset, width, borderSize, textureWidth, textureHeight);
        _instance.InstanceRenderTexture(guiGraphics, location, x, y + height - borderSize, uOffset, vOffset + textureHeight - borderSize, width, borderSize, textureWidth, textureHeight);
        for (int i = 0; i < (int)Math.ceil((double)borderlessHeight / (double)borderlessTextureHeight); ++i) {
            int edgeOffset = i * borderlessTextureHeight;
            _instance.InstanceRenderTexture(guiGraphics, location, x, y + borderSize + edgeOffset, uOffset, vOffset + borderSize, width, Math.min(borderlessTextureHeight, borderlessHeight - edgeOffset), textureWidth, textureHeight);
        }
    }

    public static void RenderRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        _instance.InstanceRenderRect(guiGraphics, x0, y0, x1, y1, color);
    }

    protected abstract void InstanceRenderRect(Object var1, int var2, int var3, int var4, int var5, int var6);

    public static void RenderHighlightRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        _instance.InstanceRenderHighlightRect(guiGraphics, x0, y0, x1, y1, color);
    }

    protected abstract void InstanceRenderHighlightRect(Object var1, int var2, int var3, int var4, int var5, int var6);

    public static void RenderGUIText(Object guiGraphics, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        AbstractModRender.PushBuffer();
        AbstractModRender.PushMatrix(_instance.InstanceGetPoseFromGraphics(guiGraphics));
        _instance.InstanceRenderGUIText(guiGraphics, text, x, y, color, dropShadow, italic);
    }

    protected abstract void InstanceRenderGUIText(Object var1, String var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public static void RenderText(Object pose, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        AbstractModRender.PushBuffer();
        AbstractModRender.PushMatrix(pose);
        _instance.InstanceRenderText(pose, text, x, y, color, dropShadow, italic);
    }

    protected abstract void InstanceRenderText(Object var1, String var2, int var3, int var4, int var5, boolean var6, boolean var7);

    public static void ProcessBlurEffect(float partialTick) {
        _instance.InstanceProcessBlurEffect(partialTick);
    }

    protected abstract void InstanceProcessBlurEffect(float var1);

    public static void BindMainRenderTargetWrite(boolean setViewport) {
        _instance.InstanceBindMainRenderTargetWrite(setViewport);
    }

    protected abstract void InstanceBindMainRenderTargetWrite(boolean var1);
}

