/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractClientData;
import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.AbstractKeyMappings;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.AbstractModRender;
import com.dgneos.sound_visualizer.ISoundVisualizerConfigScreen;
import com.dgneos.sound_visualizer.ModTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractClientEvents {
    protected static AbstractClientEvents _instance = null;
    protected static IListener _soundOptionsScreenButton = null;
    protected static IConfigScreenButton _configScreenbutton = null;

    public static AbstractClientEvents SetupInstance(AbstractClientEvents instance) {
        _instance = instance;
        return _instance;
    }

    protected static IConfigScreenButton AddConfigScreenButton(Object event, Object screen) {
        return _instance.InstanceAddConfigScreenButton(event, screen);
    }

    protected abstract IConfigScreenButton InstanceAddConfigScreenButton(Object var1, Object var2);

    protected static void OnSoundEngineLoad(Object soundManager) {
        ISoundVisualizerConfigScreen.SoundVisualizerConfigScreenData screenData = AbstractClientData.ConfigScreen.GetData();
        ISoundVisualizerConfigScreen.SoundsSelectableListData soundsListData = (ISoundVisualizerConfigScreen.SoundsSelectableListData)screenData.SoundsList.GetData();
        soundsListData.AllEntries.clear();
        String[] configuredSounds = AbstractConfig.GetIndividuallyConfiguredSounds();
        List<String> soundsLocation = AbstractModLogic.GetSoundsLocation(soundManager);
        List<String> soundsSubtitleText = AbstractModLogic.GetSoundsSubtitleText(soundManager);
        for (int i = 0; i < soundsLocation.size(); ++i) {
            screenData.SoundsList.AddSound(soundsLocation.get(i), soundsSubtitleText.get(i), !AbstractConfig.ContainsInIgnorableSounds(soundsLocation.get(i)), AbstractConfig.ContainsInFavoriteSounds(soundsLocation.get(i)), Arrays.stream(configuredSounds).collect(Collectors.toList()).contains(soundsLocation.get(i)));
        }
    }

    protected static void OnScreenInit(Object event, Object screen, List<IListener> listenersList) {
        block4: {
            block5: {
                block3: {
                    if (!AbstractModLogic.IsLevelExist() || !AbstractModLogic.ScreenIsOptionsScreen(screen)) break block3;
                    for (IListener widget : listenersList) {
                        if (!widget.IsButton() || !Objects.equals(widget.GetMessage(), AbstractModLogic.GetTextTranslate("options.sounds"))) continue;
                        _soundOptionsScreenButton = widget;
                        _configScreenbutton = AbstractClientEvents.AddConfigScreenButton(event, screen).SetBase(widget.GetX() + widget.GetWidth() + 4, widget.GetY(), 20, 20);
                        return;
                    }
                    break block4;
                }
                if (!AbstractModLogic.ScreenIsAccessibilityOptionsScreen(screen)) break block5;
                for (IListener widget : listenersList) {
                    if (!widget.IsList()) continue;
                    widget.AddBig(AbstractClientData.GetShowDSIsOptionInstance());
                }
                break block4;
            }
            if (!AbstractModLogic.ScreenIsSoundOptionsScreen(screen)) break block4;
            for (IListener widget : listenersList) {
                if (!widget.IsList()) continue;
                widget.AddBig(AbstractClientData.GetShowDSIsOptionInstance());
            }
        }
    }

    protected static void OnScreenTick(Object screen) {
        if (AbstractModLogic.ScreenIsOptionsScreen(screen) && _soundOptionsScreenButton != null && _configScreenbutton != null) {
            _configScreenbutton.SetBase(_soundOptionsScreenButton.GetX() + _soundOptionsScreenButton.GetWidth() + 4, _soundOptionsScreenButton.GetY(), 20, 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void OnClientTick() {
        ArrayList<AbstractBetterSubtitle> subtitlesToRemove;
        long time = AbstractModLogic.GetMillis();
        if (AbstractModLogic.IsLevelExist()) {
            if (AbstractClientData.ConfigScreenDSI != null && AbstractClientData.AnimateConfigScreenDSILife && AbstractClientData.ConfigScreenDSI.GetWeight() == 1.0f) {
                AbstractClientData.ConfigScreenDSI.Resurrect();
                AbstractClientData.AnimateConfigScreenDSILife = false;
            }
            if (AbstractClientData.ConfigScreenSubtitle != null && AbstractClientData.AnimateConfigScreenSubtitleLife && AbstractClientData.ConfigScreenSubtitle.GetWeight() == 1.0f) {
                AbstractClientData.ConfigScreenSubtitle.Resurrect();
                AbstractClientData.AnimateConfigScreenSubtitleLife = false;
            }
        }
        ArrayList<Object> arrayList = AbstractClientData.DirectionalSoundIndicators;
        synchronized (arrayList) {
            if (!AbstractClientData.DirectionalSoundIndicators.isEmpty()) {
                ArrayList<AbstractDirectionalSoundIndicator> dsisToRemove = new ArrayList<AbstractDirectionalSoundIndicator>();
                for (AbstractDirectionalSoundIndicator dsi : AbstractClientData.DirectionalSoundIndicators) {
                    if (dsi == null || !((double)dsi.GetTime() + (double)dsi.GetLifeTime() <= (double)time)) continue;
                    dsi.Kill();
                    dsisToRemove.add(dsi);
                }
                if (!dsisToRemove.isEmpty()) {
                    AbstractClientData.DirectionalSoundIndicators.removeAll(dsisToRemove);
                }
            }
        }
        arrayList = AbstractClientData.Subtitles;
        synchronized (arrayList) {
            if (!AbstractClientData.Subtitles.isEmpty()) {
                subtitlesToRemove = new ArrayList<AbstractBetterSubtitle>();
                for (AbstractBetterSubtitle subtitle : AbstractClientData.Subtitles) {
                    if (subtitle == null || !((double)subtitle.GetTime() + (double)subtitle.GetLifeTime() <= (double)time)) continue;
                    subtitlesToRemove.add(subtitle);
                }
                if (!subtitlesToRemove.isEmpty()) {
                    AbstractClientData.Subtitles.removeAll(subtitlesToRemove);
                }
            }
        }
        arrayList = AbstractClientData.InWorldSubtitles;
        synchronized (arrayList) {
            if (!AbstractClientData.InWorldSubtitles.isEmpty()) {
                subtitlesToRemove = new ArrayList();
                for (AbstractBetterSubtitle subtitle : AbstractClientData.InWorldSubtitles) {
                    if (subtitle == null || !((double)subtitle.GetTime() + (double)subtitle.GetLifeTime() <= (double)time)) continue;
                    subtitlesToRemove.add(subtitle);
                }
                if (!subtitlesToRemove.isEmpty()) {
                    AbstractClientData.InWorldSubtitles.removeAll(subtitlesToRemove);
                }
            }
        }
        Object screen = AbstractModLogic.GetScreen();
        if (screen == null && AbstractKeyMappings.ConsumeClick(AbstractKeyMappings.ModKeyMapping.OpenConfigScreen) && AbstractConfig.CheckDirectionalSoundIndicatorConfigs() && AbstractConfig.CheckDirectionalSoundIndicatorGlobalConfigs() && AbstractConfig.CheckSubtitleConfigs() && AbstractConfig.CheckSubtitleGlobalConfigs()) {
            ISoundVisualizerConfigScreen.Open(screen, AbstractClientData.ConfigScreen.GetData());
        }
    }

    protected static void OnGameShuttingDown() {
        AbstractConfig.SetDirectionalSoundIndicatorGlobalConfigNewValue(AbstractConfig.DirectionalSoundIndicatorConfig.Show, AbstractModLogic.ShowDSIs() ? 1 : 0);
        AbstractConfig.SaveDirectionalSoundIndicatorConfigNewValues();
        AbstractConfig.SaveDirectionalSoundIndicatorGlobalConfigNewValues();
        AbstractConfig.SaveSubtitleConfigNewValues();
        AbstractConfig.SaveSubtitleGlobalConfigNewValues();
        AbstractConfig.SaveIndividuallyConfiguredSoundsConfigs();
        AbstractConfig.SaveIgnorableSources();
        AbstractConfig.SaveIgnorableSounds();
        AbstractConfig.SaveFavoriteSounds();
        AbstractConfig.SaveConfig();
    }

    protected static interface IConfigScreenButton {
        public static void Render(Object guiGraphics, IConfigScreenButton instance, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
            instance.SuperRender(guiGraphics, mouseX, mouseY, partialTick);
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
            ModTexture texture = ModTexture.ConfigScreenButton;
            AbstractModRender.RenderTexture(guiGraphics, texture, x + (width - texture.GetWidth()) / 2, y + (height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
        }

        public static boolean MouseClicked(IConfigScreenButton instance, Object screen, double mouseX, double mouseY, int button) {
            if (AbstractConfig.CheckDirectionalSoundIndicatorConfigs() && AbstractConfig.CheckDirectionalSoundIndicatorGlobalConfigs() && AbstractConfig.CheckSubtitleConfigs() && AbstractConfig.CheckSubtitleGlobalConfigs()) {
                ISoundVisualizerConfigScreen.Open(screen, AbstractClientData.ConfigScreen.GetData());
            }
            return instance.SuperMouseClicked(mouseX, mouseY, button);
        }

        public IConfigScreenButton SetBase(int var1, int var2, int var3, int var4);

        public void SuperRender(Object var1, int var2, int var3, float var4);

        public boolean SuperMouseClicked(double var1, double var3, int var5);
    }

    protected static interface IListener {
        public int GetX();

        public int GetY();

        public int GetWidth();

        public int GetHeight();

        public boolean IsButton();

        public String GetMessage();

        public boolean IsList();

        public void AddSmall(Object var1);

        public void AddBig(Object var1);
    }
}

