/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractClientData;
import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.AbstractModRender;
import com.dgneos.sound_visualizer.ModMath;
import java.util.ArrayList;

public abstract class AbstractClientSoundEvents {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void OnPlaySound(Object sound) {
        Object newDSI;
        if (!(AbstractModLogic.IsLevelExist() && AbstractModLogic.IsPlayerExist() && AbstractModLogic.IsCameraExist())) {
            return;
        }
        if (!AbstractModLogic.IsSoundInRange(sound)) {
            return;
        }
        ModMath.Vec3 soundPos = new ModMath.Vec3(AbstractModLogic.GetSoundPosX(sound), AbstractModLogic.GetSoundPosY(sound), AbstractModLogic.GetSoundPosZ(sound));
        ModMath.Vec3 playerPos = new ModMath.Vec3(AbstractModLogic.GetPlayerPosX(1.0f), AbstractModLogic.GetPlayerPosY(1.0f), AbstractModLogic.GetPlayerPosZ(1.0f));
        if (playerPos.Add(0.0, 0.45, 0.0).DistanceTo(soundPos) <= 0.6 || playerPos.Add(0.0, 1.35, 0.0).DistanceTo(soundPos) <= 0.6) {
            return;
        }
        String source = AbstractModLogic.GetSoundSourceName(sound);
        String location = AbstractModLogic.GetSoundLocation(sound);
        String subtitleText = AbstractModLogic.GetSoundSubtitleText(sound);
        if (AbstractConfig.ContainsInIgnorableSources(source) || AbstractConfig.ContainsInIgnorableSounds(location)) {
            return;
        }
        if (AbstractModLogic.ShowDSIs()) {
            ModMath.Vec3 cameraPos = new ModMath.Vec3(AbstractModLogic.GetCameraPosX(), AbstractModLogic.GetCameraPosY(), AbstractModLogic.GetCameraPosZ());
            float fixedRotation = (float)Math.atan2(-(cameraPos.X - soundPos.X), cameraPos.Z - soundPos.Z) - (float)Math.toRadians(AbstractModLogic.GetPlayerRotY(1.0f));
            float distanceWeight = AbstractModLogic.GetSoundDistanceWeight(sound);
            newDSI = AbstractClientData.CreateDirectionalSoundIndicator(sound, fixedRotation, distanceWeight);
            ArrayList<AbstractDirectionalSoundIndicator> arrayList = AbstractClientData.DirectionalSoundIndicators;
            synchronized (arrayList) {
                AbstractClientData.DirectionalSoundIndicators.add((AbstractDirectionalSoundIndicator)newDSI);
            }
        }
        if (AbstractModLogic.ShowSubtitles()) {
            AbstractBetterSubtitle subtitle;
            String text;
            if (AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ShowAll) == 0) {
                if (subtitleText == null || subtitleText.isEmpty()) {
                    return;
                }
                text = subtitleText;
            } else {
                text = subtitleText != null && !subtitleText.isEmpty() ? subtitleText : location;
            }
            ModMath.Vec3 soundInWorldPos = soundPos.Add(new ModMath.Vec3(0.0, (float)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.InWorldOffsetY) / 20.0f, 0.0));
            AbstractBetterSubtitle newSubtitle = AbstractClientData.CreateBetterSubtitle(sound, text, soundInWorldPos.X, soundInWorldPos.Y, soundInWorldPos.Z);
            if (AbstractModLogic.IsGameVersionLaterOrEqual("1.21.9")) {
                AbstractModRender.RecordCall(() -> {
                    ArrayList<AbstractBetterSubtitle> arrayList = AbstractClientData.Subtitles;
                    synchronized (arrayList) {
                        if (!AbstractClientData.Subtitles.isEmpty()) {
                            boolean defaultPriorityOrder = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.PriorityOrder) == 0;
                            boolean newSubtitleAdded = false;
                            for (int i = 0; i < AbstractClientData.Subtitles.size(); ++i) {
                                AbstractBetterSubtitle subtitle = AbstractClientData.Subtitles.get(i);
                                if (subtitle.GetText().equals(newSubtitle.GetText())) {
                                    AbstractClientData.Subtitles.add(i, newSubtitle);
                                    AbstractClientData.Subtitles.remove(i + 1);
                                    newSubtitleAdded = true;
                                    break;
                                }
                                if ((!defaultPriorityOrder || newSubtitle.GetPriority() >= subtitle.GetPriority()) && (defaultPriorityOrder || newSubtitle.GetPriority() < subtitle.GetPriority())) continue;
                                AbstractClientData.Subtitles.add(i, newSubtitle);
                                newSubtitleAdded = true;
                                break;
                            }
                            if (!newSubtitleAdded) {
                                AbstractClientData.Subtitles.add(newSubtitle);
                            }
                        } else {
                            AbstractClientData.Subtitles.add(newSubtitle);
                        }
                    }
                });
            } else {
                newDSI = AbstractClientData.Subtitles;
                synchronized (newDSI) {
                    if (!AbstractClientData.Subtitles.isEmpty()) {
                        boolean defaultPriorityOrder = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.PriorityOrder) == 0;
                        boolean newSubtitleAdded = false;
                        for (int i = 0; i < AbstractClientData.Subtitles.size(); ++i) {
                            subtitle = AbstractClientData.Subtitles.get(i);
                            if (subtitle.GetText().equals(newSubtitle.GetText())) {
                                AbstractClientData.Subtitles.add(i, newSubtitle);
                                AbstractClientData.Subtitles.remove(i + 1);
                                newSubtitleAdded = true;
                                break;
                            }
                            if ((!defaultPriorityOrder || newSubtitle.GetPriority() >= subtitle.GetPriority()) && (defaultPriorityOrder || newSubtitle.GetPriority() < subtitle.GetPriority())) continue;
                            AbstractClientData.Subtitles.add(i, newSubtitle);
                            newSubtitleAdded = true;
                            break;
                        }
                        if (!newSubtitleAdded) {
                            AbstractClientData.Subtitles.add(newSubtitle);
                        }
                    } else {
                        AbstractClientData.Subtitles.add(newSubtitle);
                    }
                }
            }
            AbstractBetterSubtitle newInWorldSubtitle = AbstractClientData.CreateBetterSubtitle(sound, text, soundInWorldPos.X, soundInWorldPos.Y, soundInWorldPos.Z);
            ModMath.Vec3 newInWorldSubtitlePos = new ModMath.Vec3(newInWorldSubtitle.GetPosX(), newInWorldSubtitle.GetPosY(), newInWorldSubtitle.GetPosZ());
            if (AbstractModLogic.IsGameVersionLaterOrEqual("1.21.9")) {
                AbstractModRender.RecordCall(() -> {
                    ArrayList<AbstractBetterSubtitle> arrayList = AbstractClientData.InWorldSubtitles;
                    synchronized (arrayList) {
                        if (!AbstractClientData.InWorldSubtitles.isEmpty()) {
                            boolean newSubtitleAdded = false;
                            for (int i = 0; i < AbstractClientData.InWorldSubtitles.size(); ++i) {
                                AbstractBetterSubtitle subtitle = AbstractClientData.InWorldSubtitles.get(i);
                                ModMath.Vec3 subtitlePos = new ModMath.Vec3(subtitle.GetPosX(), subtitle.GetPosY(), subtitle.GetPosZ());
                                if (!subtitle.GetText().equals(newInWorldSubtitle.GetText()) || !(subtitlePos.DistanceTo(newInWorldSubtitlePos) <= (double)((float)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.InWorldRefreshDistance) / 20.0f))) continue;
                                AbstractClientData.InWorldSubtitles.add(i, newInWorldSubtitle);
                                AbstractClientData.InWorldSubtitles.remove(i + 1);
                                newSubtitleAdded = true;
                                break;
                            }
                            if (!newSubtitleAdded) {
                                AbstractClientData.InWorldSubtitles.add(newInWorldSubtitle);
                            }
                        } else {
                            AbstractClientData.InWorldSubtitles.add(newInWorldSubtitle);
                        }
                    }
                });
            } else {
                ArrayList<AbstractBetterSubtitle> arrayList = AbstractClientData.InWorldSubtitles;
                synchronized (arrayList) {
                    if (!AbstractClientData.InWorldSubtitles.isEmpty()) {
                        boolean newSubtitleAdded = false;
                        for (int i = 0; i < AbstractClientData.InWorldSubtitles.size(); ++i) {
                            subtitle = AbstractClientData.InWorldSubtitles.get(i);
                            ModMath.Vec3 subtitlePos = new ModMath.Vec3(subtitle.GetPosX(), subtitle.GetPosY(), subtitle.GetPosZ());
                            if (!subtitle.GetText().equals(newInWorldSubtitle.GetText()) || !(subtitlePos.DistanceTo(newInWorldSubtitlePos) <= (double)((float)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.InWorldRefreshDistance) / 20.0f))) continue;
                            AbstractClientData.InWorldSubtitles.add(i, newInWorldSubtitle);
                            AbstractClientData.InWorldSubtitles.remove(i + 1);
                            newSubtitleAdded = true;
                            break;
                        }
                        if (!newSubtitleAdded) {
                            AbstractClientData.InWorldSubtitles.add(newInWorldSubtitle);
                        }
                    } else {
                        AbstractClientData.InWorldSubtitles.add(newInWorldSubtitle);
                    }
                }
            }
        }
    }
}

