/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractModRender;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.joml.Matrix3x2f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ModRender
extends AbstractModRender {
    protected static final ArrayList<Matrix3x2f> PREPUSHED_POSES = new ArrayList();
    public static RenderType BufferRenderType = null;
    public static RenderPipeline BufferTextureRenderPipeline = null;
    protected static MultiBufferSource.BufferSource _buffer = null;
    protected static Matrix4f _matrix = null;
    protected static VertexConsumer _consumer = null;

    @Override
    protected boolean InstanceIsOnRenderThread() {
        return RenderSystem.isOnRenderThread();
    }

    @Override
    protected Object InstanceGetPoseFromGraphics(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.pose();
        }
        return null;
    }

    @Override
    protected void InstanceSetShaderColor(float r, float g, float b, float a) {
    }

    @Override
    protected void InstanceSetRenderOptions(boolean blend, boolean depthTest, boolean depthMask, boolean cull, boolean colorShader) {
    }

    @Override
    protected void InstanceEnableScissor(Object guiGraphics, int x0, int y0, int x1, int y1) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.enableScissor(x0, y0, x1, y1);
        }
    }

    @Override
    protected void InstanceDisableScissor(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.disableScissor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InstancePushPose(Object pose, double x, double y, double z, boolean rotate, float rotY, float rotX, float rotZ, float scaleX, float scaleY, float scaleZ) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            identifiedPose.pushPose();
            identifiedPose.translate(x, y, z);
            if (rotate) {
                identifiedPose.mulPose((Quaternionfc)new Quaternionf().rotateY(rotY).rotateX(rotX).rotateZ(rotZ));
            }
            identifiedPose.scale(scaleX, scaleY, scaleZ);
        } else if (pose instanceof Matrix3x2f) {
            Matrix3x2f identifiedPose = (Matrix3x2f)pose;
            ArrayList<Matrix3x2f> arrayList = PREPUSHED_POSES;
            synchronized (arrayList) {
                PREPUSHED_POSES.add(identifiedPose.get(new Matrix3x2f()));
                identifiedPose.translate((float)x, (float)y);
                if (rotate) {
                    identifiedPose.rotate(rotZ);
                }
                identifiedPose.scale(scaleX, scaleY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void InstancePopPose(Object pose) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            identifiedPose.popPose();
        } else if (pose instanceof Matrix3x2f) {
            Matrix3x2f identifiedPose = (Matrix3x2f)pose;
            ArrayList<Matrix3x2f> arrayList = PREPUSHED_POSES;
            synchronized (arrayList) {
                if (!PREPUSHED_POSES.isEmpty()) {
                    PREPUSHED_POSES.getLast().get(identifiedPose);
                    PREPUSHED_POSES.removeLast();
                }
            }
        }
    }

    @Override
    protected void InstancePushBuffer() {
        _buffer = Minecraft.getInstance().renderBuffers().bufferSource();
    }

    @Override
    protected void InstancePushMatrix(Object pose) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            _matrix = identifiedPose.last().pose();
        } else if (pose instanceof Matrix3x2f) {
            Matrix3x2f identifiedPose = (Matrix3x2f)pose;
            _matrix = new Matrix4f(identifiedPose.m00(), identifiedPose.m01(), 0.0f, 0.0f, identifiedPose.m10(), identifiedPose.m11(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, identifiedPose.m20(), identifiedPose.m21(), 0.0f, 1.0f);
        }
    }

    @Override
    protected void InstancePushVertexConsumer() {
        _consumer = _buffer.getBuffer(BufferRenderType == null ? RenderType.textBackgroundSeeThrough() : BufferRenderType);
    }

    @Override
    protected void InstanceAddVertex(float x, float y, float z, float u, float v, int color) {
        _consumer.addVertex(_matrix, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    @Override
    protected void InstancePushBufferEnd() {
        _buffer.endBatch();
    }

    @Override
    protected int InstanceGetGuiWidth(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.guiWidth();
        }
        return 0;
    }

    @Override
    protected int InstanceGetGuiHeight(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.guiHeight();
        }
        return 0;
    }

    @Override
    protected int InstanceGetBackgroundColor(float alpha) {
        return Minecraft.getInstance().options.getBackgroundColor(alpha);
    }

    @Override
    protected void InstanceRenderTexture(Object guiGraphics, String location, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            int color = ((int)Math.clamp(SHADER_COLORS[3] * 255.0f, 0.0f, 255.0f) & 0xFF) << 24 | ((int)Math.clamp(SHADER_COLORS[2] * 255.0f, 0.0f, 255.0f) & 0xFF) << 16 | ((int)Math.clamp(SHADER_COLORS[1] * 255.0f, 0.0f, 255.0f) & 0xFF) << 8 | (int)Math.clamp(SHADER_COLORS[0] * 255.0f, 0.0f, 255.0f) & 0xFF;
            graphics.blit(BufferTextureRenderPipeline == null ? RenderPipelines.GUI_TEXTURED : BufferTextureRenderPipeline, ResourceLocation.fromNamespaceAndPath((String)"sound_visualizer", (String)location), x, y, (float)uOffset, (float)vOffset, width, height, textureWidth, textureHeight, color);
        }
    }

    @Override
    protected void InstanceRenderRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.fill(x0, y0, x1, y1, color);
        }
    }

    @Override
    protected void InstanceRenderHighlightRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.fill(RenderPipelines.GUI_TEXT_HIGHLIGHT, x0, y0, x1, y1, color);
        }
    }

    @Override
    protected void InstanceRenderGUIText(Object guiGraphics, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            int newColor = ((int)Math.clamp(SHADER_COLORS[3] * (float)ARGB.alpha((int)color), 0.0f, 255.0f) & 0xFF) << 24 | ((int)Math.clamp(SHADER_COLORS[2] * (float)ARGB.red((int)color), 0.0f, 255.0f) & 0xFF) << 16 | ((int)Math.clamp(SHADER_COLORS[1] * (float)ARGB.green((int)color), 0.0f, 255.0f) & 0xFF) << 8 | (int)Math.clamp(SHADER_COLORS[0] * (float)ARGB.blue((int)color), 0.0f, 255.0f) & 0xFF;
            graphics.drawString(Minecraft.getInstance().font, (Component)MutableComponent.create((ComponentContents)Component.literal((String)text).getContents()).withStyle(italic ? ChatFormatting.ITALIC : ChatFormatting.RESET), x, y, newColor, dropShadow);
            _buffer.endBatch();
        }
    }

    @Override
    protected void InstanceRenderText(Object pose, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        int newColor = ((int)Math.clamp(SHADER_COLORS[3] * (float)ARGB.alpha((int)color), 0.0f, 255.0f) & 0xFF) << 24 | ((int)Math.clamp(SHADER_COLORS[2] * (float)ARGB.red((int)color), 0.0f, 255.0f) & 0xFF) << 16 | ((int)Math.clamp(SHADER_COLORS[1] * (float)ARGB.green((int)color), 0.0f, 255.0f) & 0xFF) << 8 | (int)Math.clamp(SHADER_COLORS[0] * (float)ARGB.blue((int)color), 0.0f, 255.0f) & 0xFF;
        Minecraft.getInstance().font.drawInBatch((Component)MutableComponent.create((ComponentContents)Component.literal((String)text).getContents()).withStyle(italic ? ChatFormatting.ITALIC : ChatFormatting.RESET), (float)x, (float)y, newColor, dropShadow, _matrix.get(new Matrix4f()), (MultiBufferSource)_buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    @Override
    protected void InstanceProcessBlurEffect(float partialTick) {
    }

    @Override
    protected void InstanceBindMainRenderTargetWrite(boolean setViewport) {
    }
}

