/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractClientData;
import com.dgneos.sound_visualizer.AbstractClientRenderEvents;
import com.dgneos.sound_visualizer.AbstractConfig;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.AbstractKeyMappings;
import com.dgneos.sound_visualizer.AbstractModLogic;
import com.dgneos.sound_visualizer.AbstractModRender;
import com.dgneos.sound_visualizer.ModMath;
import com.dgneos.sound_visualizer.ModTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface ISoundVisualizerConfigScreen {
    public static final int BACKGROUND_COLOR = 0x40000000;
    public static final int DARK_SEPARATOR_COLOR = -1090519040;
    public static final int LIGHT_SEPARATOR_COLOR = 0x33FFFFFF;

    public static void BaseSetup(SoundVisualizerConfigScreenData data) {
        data.SoundsList = data.Instance.CreateSoundsSelectableList(data.Instance, VisibilityCategory.SoundsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, SoundVisualizerConfigScreenData data) {
        if (data.Focused != null && !data.Focused.GetData().Visible) {
            data.Focused = null;
        }
        Object pose = AbstractModRender.GetPoseFromGraphics(guiGraphics);
        String[] sources = AbstractConfig.GetSources();
        int sourcesAmount = sources.length;
        int mainButtonsWidth = Math.max((int)Math.floor((data.Width - 16) / 4), 135);
        int scissorX0 = mainButtonsWidth + 31;
        int scissorX1 = data.Width - mainButtonsWidth - 31;
        int textY = data.Height - 19;
        int extraTextY = data.Height * 2 - 31;
        if (!data.BlurAreas.isEmpty()) {
            for (Object blurArea : data.BlurAreas) {
                AbstractModRender.EnableScissor(guiGraphics, blurArea[0], blurArea[1], blurArea[2], blurArea[3]);
                AbstractModRender.ProcessBlurEffect(partialTick);
                AbstractModRender.DisableScissor(guiGraphics);
            }
            AbstractModRender.BindMainRenderTargetWrite(false);
        }
        if (ISoundVisualizerConfigScreen.DoesRenderDirectionalSoundIndicator(data) && ISoundVisualizerConfigScreen.CanRenderDirectionalSoundIndicator(data) && AbstractModLogic.ShowDSIs()) {
            AbstractModRender.SetRenderOptions(true, false, false, false, false);
            AbstractClientRenderEvents.RenderDirectionalSoundIndicator(AbstractClientData.ConfigScreenDSI, guiGraphics, data.DSIRotation, AbstractClientData.AnimateConfigScreenDSILife ? AbstractClientData.ConfigScreenDSI.GetWeight() : 0.0f);
        }
        if (ISoundVisualizerConfigScreen.DoesRenderSubtitle(data) && ISoundVisualizerConfigScreen.CanRenderSubtitle(data) && AbstractModLogic.ShowSubtitles()) {
            int showInWorldSubtitles = AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ShowInWorld);
            AbstractModRender.SetRenderOptions(true, false, false, false, true);
            if (showInWorldSubtitles < 2) {
                AbstractClientRenderEvents.RenderSubtitle(AbstractClientData.ConfigScreenSubtitle, guiGraphics, AbstractModRender.GetGuiWidth(guiGraphics) / 2, AbstractModRender.GetGuiHeight(guiGraphics) / 2 - AbstractClientData.ConfigScreenSubtitle.GetHeight() / 2, AbstractClientData.ConfigScreenSubtitle.GetWidth(), AbstractClientData.ConfigScreenSubtitleDeathFrame ? 1.0f : (AbstractClientData.AnimateConfigScreenSubtitleLife ? AbstractClientData.ConfigScreenSubtitle.GetWeight() : 0.0f), 0.0, 4.0);
            }
        }
        AbstractModRender.SetRenderOptions(false, true, true, false, false);
        if (mouseX != data.OldMouseX || mouseY != data.OldMouseY) {
            if (AbstractModLogic.IsGameVersionEarlier("1.21.9")) {
                ISoundVisualizerConfigScreen.MouseMoved(mouseX, mouseY, data);
            }
            data.OldMouseX = mouseX;
            data.OldMouseY = mouseY;
        }
        data.Instance.SuperRender(guiGraphics, mouseX, mouseY, partialTick);
        if (data.CursorTypeRequest != null && !data.CursorTypeRequest.isEmpty()) {
            data.Instance.RequestCursor(guiGraphics, data.CursorTypeRequest);
        }
        ArrayList<Warning> showInWorldSubtitles = data.CurrentWarnings;
        synchronized (showInWorldSubtitles) {
            Object blurArea;
            ArrayList<VisibilityCategory> arrayList = data.CurrentVisibleCategories;
            blurArea = arrayList;
            synchronized (arrayList) {
                if (!data.CurrentWarnings.isEmpty()) {
                    Warning currentWarning = null;
                    int currentMostPriority = 0;
                    block7: for (Warning warning : data.CurrentWarnings) {
                        for (VisibilityCategory warningCategory : warning.GetCategories()) {
                            int warningPriority;
                            if (!data.CurrentVisibleCategories.contains((Object)warningCategory) || (warningPriority = warning.GetPriority()) <= currentMostPriority) continue;
                            currentWarning = warning;
                            currentMostPriority = warningPriority;
                            continue block7;
                        }
                    }
                    if (currentWarning != null) {
                        int outOfScissor = (int)Math.floor((data.Width - 4) / 4) + 4;
                        ArrayList<String> textLines = new ArrayList<String>();
                        int textLinesAmount = 0;
                        String textKey = currentWarning.GetTextKey() + "_" + AbstractModLogic.GetGameLocaleLanguage() + "_";
                        String textTranslate = AbstractModLogic.GetTextTranslate(textKey + String.valueOf(textLinesAmount));
                        while (!Objects.equals(textKey + String.valueOf(textLinesAmount), textTranslate)) {
                            textLines.add(textTranslate);
                            textTranslate = AbstractModLogic.GetTextTranslate(textKey + String.valueOf(++textLinesAmount));
                        }
                        if (textLinesAmount > 0) {
                            int maxTextWidth = 0;
                            for (String textLine : textLines) {
                                maxTextWidth = Math.max(maxTextWidth, AbstractModLogic.GetTextWidth(textLine));
                            }
                            int textHeight = AbstractModLogic.GetTextHeight();
                            int textColor = 0xFFFF0000 | (Math.clamp((long)(85 + (int)Math.round((Math.sin((float)AbstractModLogic.GetMillis() / 400.0f) + 1.0) * 42.5)), 0, 255) & 0xFF) << 8 | 0x55;
                            AbstractModRender.RenderRect(guiGraphics, Math.max(outOfScissor, data.Width / 2 - maxTextWidth / 2) - 1, 3, Math.min(data.Width - outOfScissor, data.Width / 2 + maxTextWidth / 2) + 1, 4 + textHeight * textLinesAmount, -872415232);
                            for (int i = 0; i < textLinesAmount; ++i) {
                                AbstractModRender.RenderCenterScrollingText(guiGraphics, (String)textLines.get(i), outOfScissor, data.Width - outOfScissor, 4 + textHeight * i, 1.0f, textColor, false, false);
                            }
                        }
                    }
                }
                // ** MonitorExit[blurArea /* !! */ ] (shouldn't be in output)
            }
        }
        {
            AbstractModRender.EnableScissor(guiGraphics, scissorX0, 0, scissorX1, data.Height);
            SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
            if (soundsListData.Selected.size() > 0) {
                String soundText = ((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound;
                int soundTextWidth = AbstractModLogic.GetTextWidth(soundText) + 2;
                String extraSoundsAmountText = "+" + String.valueOf(soundsListData.Selected.size() - 1) + " more";
                int extraSoundsAmountTextWidth = (int)((double)AbstractModLogic.GetTextWidth(extraSoundsAmountText) / 2.0 + 5.0);
                boolean showExtraSoundsAmountText = soundsListData.Selected.size() > 1;
                int scissorWidth = scissorX1 - scissorX0;
                double d = (double)soundTextWidth / 2.0;
                int n = showExtraSoundsAmountText ? extraSoundsAmountTextWidth : 0;
                if (d + (double)n > (double)scissorWidth / 2.0) {
                    int fullTextWidth = showExtraSoundsAmountText ? soundTextWidth + extraSoundsAmountTextWidth : soundTextWidth;
                    int widthDifference = fullTextWidth - scissorWidth;
                    double time = (double)AbstractModLogic.GetMillis() / 800.0;
                    double offsetX = Math.floor((double)widthDifference / 2.0 * Math.sin(time)) + (double)fullTextWidth / 2.0;
                    AbstractModRender.RenderGUIText(guiGraphics, soundText, (int)((double)(scissorX0 + (int)Math.ceil((double)scissorWidth / 2.0)) - offsetX), textY, -1, true, false);
                    if (showExtraSoundsAmountText) {
                        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
                        AbstractModRender.RenderGUIText(guiGraphics, extraSoundsAmountText, (int)((double)(scissorX0 + (int)Math.ceil((double)scissorWidth / 2.0)) - offsetX + (double)soundTextWidth + 5.0) * 2, extraTextY, -3355444, true, false);
                        AbstractModRender.PopPose(pose);
                    }
                } else {
                    AbstractModRender.RenderGUIText(guiGraphics, soundText, (int)((double)(scissorX0 + (int)Math.ceil((double)scissorWidth / 2.0)) - (double)soundTextWidth / 2.0), textY, -1, true, false);
                    if (showExtraSoundsAmountText) {
                        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
                        AbstractModRender.RenderGUIText(guiGraphics, extraSoundsAmountText, (int)((double)scissorX0 + Math.ceil((double)scissorWidth / 2.0) + (double)soundTextWidth / 2.0 + 5.0) * 2, extraTextY, -3355444, true, false);
                        AbstractModRender.PopPose(pose);
                    }
                }
            } else {
                int scissorWidth;
                String sourceText = AbstractModLogic.GetTextTranslate("screen.sound_visualizer.configs_rect_" + sources[data.Source]);
                int sourceTextWidth = AbstractModLogic.GetTextWidth(sourceText);
                if (sourceTextWidth > (scissorWidth = scissorX1 - scissorX0)) {
                    int widthDifference = sourceTextWidth - scissorWidth;
                    double time = (double)AbstractModLogic.GetMillis() / 800.0;
                    double offsetX = Math.floor((double)widthDifference / 2.0 * Math.sin(time)) + (double)sourceTextWidth / 2.0;
                    AbstractModRender.RenderGUIText(guiGraphics, sourceText, (int)((double)scissorX0 + Math.ceil((double)scissorWidth / 2.0) - offsetX), textY, -1, true, false);
                } else {
                    AbstractModRender.RenderGUIText(guiGraphics, sourceText, (int)((double)scissorX0 + Math.ceil((double)scissorWidth / 2.0) - (double)(sourceTextWidth / 2)), textY, -1, true, false);
                    String extraLeftSourceText = AbstractModLogic.GetTextTranslate("screen.sound_visualizer.configs_rect_" + sources[((data.Source - 1) % sourcesAmount + sourcesAmount) % sourcesAmount]);
                    int extraLeftSourceTextWidth = AbstractModLogic.GetTextWidth(extraLeftSourceText);
                    String extraRightSourceText = AbstractModLogic.GetTextTranslate("screen.sound_visualizer.configs_rect_" + sources[((data.Source + 1) % sourcesAmount + sourcesAmount) % sourcesAmount]);
                    int extraRightSourceTextWidth = AbstractModLogic.GetTextWidth(extraRightSourceText);
                    if (scissorWidth - sourceTextWidth >= data.ExtraSourceTextsWidth + 6) {
                        AbstractModRender.PushPose(pose, 0.0, 0.0, 0.0, false, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
                        AbstractModRender.RenderGUIText(guiGraphics, extraLeftSourceText, (int)((double)scissorX0 + (double)data.ExtraSourceTextsWidth / 4.0 + 3.0 - (double)extraLeftSourceTextWidth / 4.0) * 2, extraTextY, -3355444, true, false);
                        AbstractModRender.RenderGUIText(guiGraphics, extraRightSourceText, (int)((double)scissorX1 - (double)data.ExtraSourceTextsWidth / 4.0 - 3.0 - (double)extraRightSourceTextWidth / 4.0) * 2, extraTextY, -3355444, true, false);
                        AbstractModRender.PopPose(pose);
                    }
                }
            }
            AbstractModRender.DisableScissor(guiGraphics);
            return;
        }
    }

    public static void MouseMoved(double mouseX, double mouseY, SoundVisualizerConfigScreenData data) {
        if (data.IsMouseDragging) {
            ISoundVisualizerConfigScreen.HoverWidget(null, data);
            return;
        }
        boolean isSomethingHovered = false;
        for (IConfigScreenChild child : data.Children) {
            if (!child.GetData().Visible || !child.IsMouseOver(mouseX, mouseY)) continue;
            isSomethingHovered = true;
            child.MouseMoved(mouseX, mouseY);
        }
        if (!isSomethingHovered) {
            data.CursorTypeRequest = "arrow";
        }
    }

    public static boolean MouseClicked(double mouseX, double mouseY, int button, SoundVisualizerConfigScreenData data) {
        boolean isSomethingClicked = false;
        for (IConfigScreenChild child : data.Children) {
            if (!child.IsMouseOver(mouseX, mouseY) || !child.GetData().Visible) continue;
            isSomethingClicked = isSomethingClicked || child.MouseClicked(mouseX, mouseY, button);
        }
        if (!isSomethingClicked) {
            ISoundsSelectableList.Select(null, (SoundsSelectableListData)data.SoundsList.GetData());
            ISoundVisualizerConfigScreen.SynchWidgets(data);
            ISoundVisualizerConfigScreen.FocusWidget(null, data);
        }
        return isSomethingClicked;
    }

    public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, SoundVisualizerConfigScreenData data) {
        if (data.Focused != null) {
            data.Focused.MouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public static boolean MouseReleased(double mouseX, double mouseY, int button, SoundVisualizerConfigScreenData data) {
        data.IsMouseDragging = false;
        ISoundVisualizerConfigScreen.MouseMoved(mouseX, mouseY, data);
        boolean isSomethingReleased = false;
        for (IConfigScreenChild child : data.Children) {
            if (!child.IsMouseOver(mouseX, mouseY) || !child.GetData().Visible) continue;
            isSomethingReleased = isSomethingReleased || child.MouseReleased(mouseX, mouseY, button);
        }
        return isSomethingReleased;
    }

    public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, SoundVisualizerConfigScreenData data) {
        if (data.HasShiftDown) {
            scrollX *= 10.0;
            scrollY *= 10.0;
        }
        boolean isSomethingScrolled = false;
        for (IConfigScreenChild child : data.Children) {
            if (!child.IsMouseOver(mouseX, mouseY) || !child.GetData().Visible) continue;
            isSomethingScrolled = isSomethingScrolled || child.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        return isSomethingScrolled;
    }

    public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, SoundVisualizerConfigScreenData data) {
        IConfigScreenChild iConfigScreenChild;
        if (keyCode == 256 && ISoundVisualizerConfigScreen.ShouldCloseOnEsc(data)) {
            ISoundVisualizerConfigScreen.OnClose(data);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (ISoundVisualizerConfigScreen.IsFocused(data)) {
                ISoundVisualizerConfigScreen.FocusWidget(null, data);
                return true;
            }
            if (((SoundsSelectableListData)data.SoundsList.GetData()).Selected.size() > 0) {
                ISoundsSelectableList.Select(null, (SoundsSelectableListData)data.SoundsList.GetData());
                ISoundVisualizerConfigScreen.SynchWidgets(data);
                return true;
            }
        }
        if ((iConfigScreenChild = data.Focused) instanceof IConfigEditBox) {
            IConfigEditBox editBox = (IConfigEditBox)iConfigScreenChild;
            return editBox.KeyPressed(keyCode, scanCode, modifiers);
        }
        boolean globalKeyPressed = false;
        if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.LeftSourceSwitch, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.SwitchSource(-1, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.RightSourceSwitch, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.SwitchSource(1, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.AllColorConfigsCopy, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.CopyConfigsValues(true, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.AllColorConfigsPaste, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.PasteConfigsValues(true, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.AllConfigsCopy, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.CopyConfigsValues(false, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.AllConfigsPaste, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.PasteConfigsValues(false, data);
            globalKeyPressed = true;
        } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.SourceIgnorabilitySwitch, keyCode, scanCode, modifiers)) {
            ISoundVisualizerConfigScreen.SwitchIgnorability(data);
            globalKeyPressed = true;
        }
        if (globalKeyPressed) {
            ISoundVisualizerConfigScreen.FocusWidget(null, data);
            return true;
        }
        boolean isSomethingPressed = false;
        for (IConfigScreenChild child : data.Children) {
            isSomethingPressed = isSomethingPressed || child.KeyPressed(keyCode, scanCode, modifiers);
        }
        return isSomethingPressed;
    }

    public static void Open(Object lastScreen, SoundVisualizerConfigScreenData data) {
        data.LastScreen = lastScreen;
        data.OldMouseX = -16;
        data.OldMouseY = -16;
        data.IsMouseDragging = false;
        data.CursorTypeRequest = "arrow";
        data.CurrentVisibleCategories.clear();
        data.CurrentWarnings.clear();
        if (data.SoundsList == null) {
            ISoundVisualizerConfigScreen.BaseSetup(data);
        }
        AbstractConfig.SaveValuesForRollback();
        for (String source : AbstractConfig.GetSources()) {
            data.ExtraSourceTextsWidth = Math.max(data.ExtraSourceTextsWidth, AbstractModLogic.GetTextWidth(AbstractModLogic.GetTextTranslate("screen.sound_visualizer.configs_rect_" + source)));
        }
        ISoundVisualizerConfigScreen.CheckWarnings(data);
        ArrayList<String> soundsLocation = new ArrayList<String>(AbstractModLogic.GetSoundsLocation(null));
        ArrayList<String> soundsSubtitleText = new ArrayList<String>(AbstractModLogic.GetSoundsSubtitleText(null));
        for (int i = 0; i < soundsLocation.size(); ++i) {
            String soundSubtitleText = soundsSubtitleText.get(i);
            if (!soundSubtitleText.isEmpty()) continue;
            soundsLocation.remove(i);
            soundsSubtitleText.remove(i);
        }
        if (!soundsLocation.isEmpty()) {
            int randomSoundIndex = new Random().nextInt(soundsLocation.size());
            data.RandomSoundLocation = soundsLocation.get(randomSoundIndex);
            data.RandomSoundSubtitleText = soundsSubtitleText.get(randomSoundIndex);
        }
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        IConfigEditBox.SetValue("", (ConfigEditBoxData)soundsListData.SearchBox.GetData());
        soundsListData.FilterType = 0;
        ISoundVisualizerConfigScreen.FocusWidget(null, data);
        ISoundVisualizerConfigScreen.HoverWidget(null, data);
        ISoundVisualizerConfigScreen.SwitchTab(VisibilityCategory.DirectionalSoundIndicatorConfigs, data);
        ISoundVisualizerConfigScreen.SwitchSource(-data.Source, data);
        ISoundVisualizerConfigScreen.SynchWidgets(data);
        data.Instance.SetScreen(data.Instance);
    }

    public static void Init(SoundVisualizerConfigScreenData data) {
        int mainButtonsWidth = Math.max((int)Math.floor((data.Width - 16) / 4), 135);
        int rectsWidth = (int)Math.floor((data.Width - 4) / 4);
        int tabsWidth = (data.Width - (int)Math.floor(rectsWidth * 2 + 4)) / 2;
        int[] columnsOffset = new int[]{data.Height - 96, data.Height - 73, data.Height - 50, data.Height - 25, data.Height - 5};
        IRect newRect = (IRect)data.Instance.CreateRect(data.Instance, VisibilityCategory.Eternal, 0).SetBase(0, data.Height - 101, data.Width, 101);
        data.Instance.AddRenderableChild(newRect);
        RectData newRectData = (RectData)newRect.GetData();
        newRectData.ListWindow = true;
        newRectData.ListWindowCorners = new int[]{mainButtonsWidth + 8, columnsOffset[3], data.Width - mainButtonsWidth - 8, columnsOffset[4]};
        ITab newTab = (ITab)data.Instance.CreateTab(data.Instance, VisibilityCategory.DirectionalSoundIndicatorConfigs, "screen.sound_visualizer.config_screens_directional_sound_indicator_configs_tab").SetBase(rectsWidth + 1, data.Height - 119, tabsWidth, 18);
        data.Instance.AddRenderableChild(newTab);
        TabData newTabData = (TabData)newTab.GetData();
        newRectData.StreamlinedTabs.add(newTab);
        newRectData.StreamlinedTabsCorners.add(new int[]{newTabData.X, newTabData.Y, newTabData.X + newTabData.Width, newTabData.Y + newTabData.Height});
        newTab = (ITab)data.Instance.CreateTab(data.Instance, VisibilityCategory.SubtitleConfigs, "screen.sound_visualizer.config_screens_subtitle_configs_tab").SetBase(data.Width - rectsWidth - tabsWidth - 1, data.Height - 119, tabsWidth, 18);
        data.Instance.AddRenderableChild(newTab);
        newTabData = (TabData)newTab.GetData();
        newRectData.StreamlinedTabs.add(newTab);
        newRectData.StreamlinedTabsCorners.add(new int[]{newTabData.X, newTabData.Y, newTabData.X + newTabData.Width, newTabData.Y + newTabData.Height});
        int defaultTextColor = -1;
        VisibilityCategory category = VisibilityCategory.DirectionalSoundIndicatorGlobalConfigs;
        newRect = (IRect)data.Instance.CreateRect(data.Instance, category, 1).SetBase(0, 0, rectsWidth, data.Height - 101);
        data.Instance.AddRenderableChild(newRect);
        IConfigsList newConfigsList = (IConfigsList)data.Instance.CreateConfigsList(data.Instance, category, "screen.sound_visualizer.config_screens_list_dsi_global_configs_headline").SetBase(5, 5, rectsWidth - 10, data.Height - 111);
        data.Instance.AddRenderableChild(newConfigsList);
        newRectData = (RectData)newRect.GetData();
        ConfigsListData newConfigsListData = (ConfigsListData)newConfigsList.GetData();
        newRectData.ListWindow = true;
        newRectData.ListWindowCorners = new int[]{IConfigScreenList.GetLeft(newConfigsListData), IConfigScreenList.GetTop(newConfigsListData) - 2, IConfigScreenList.GetRight(newConfigsListData), IConfigScreenList.GetBottom(newConfigsListData) + 2};
        AbstractConfig.DirectionalSoundIndicatorConfig dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.DynamicRotation;
        IConfigButton newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_dsi_dynamic_rotation_message", dsiConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.ConicFade;
        IConfigSliderButton newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_conic_fade_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.RadialFade;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_radial_fade_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.DistinctEdge;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_distinct_edge_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.RadialDirection;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_dsi_radial_direction_message", dsiConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        category = VisibilityCategory.SubtitleExtraConfigs;
        newRect = (IRect)data.Instance.CreateRect(data.Instance, category, 1).SetBase(0, 0, rectsWidth, data.Height - 101);
        data.Instance.AddRenderableChild(newRect);
        newConfigsList = (IConfigsList)data.Instance.CreateConfigsList(data.Instance, category, "screen.sound_visualizer.config_screens_list_subtitle_extra_configs_headline").SetBase(5, 5, rectsWidth - 10, data.Height - 111);
        data.Instance.AddRenderableChild(newConfigsList);
        newRectData = (RectData)newRect.GetData();
        newConfigsListData = (ConfigsListData)newConfigsList.GetData();
        newRectData.ListWindow = true;
        newRectData.ListWindowCorners = new int[]{IConfigScreenList.GetLeft(newConfigsListData), IConfigScreenList.GetTop(newConfigsListData) - 2, IConfigScreenList.GetRight(newConfigsListData), IConfigScreenList.GetBottom(newConfigsListData) + 2};
        AbstractConfig.SubtitleConfig subtitleConfig = AbstractConfig.SubtitleConfig.ReplacedText;
        IConfigEditBox newEditBox = data.Instance.CreateConfigEditBox(data.Instance, category, "screen.sound_visualizer.config_screens_edit_box_subtitle_replaced_text_hint", subtitleConfig.GetNum(), subtitleConfig.GetMaxValue(), null, null);
        newConfigsList.AddWidget(newEditBox);
        subtitleConfig = AbstractConfig.SubtitleConfig.Prefix;
        newEditBox = data.Instance.CreateConfigEditBox(data.Instance, category, "screen.sound_visualizer.config_screens_edit_box_subtitle_prefix_hint", subtitleConfig.GetNum(), subtitleConfig.GetMaxValue(), null, null);
        newConfigsList.AddWidget(newEditBox);
        subtitleConfig = AbstractConfig.SubtitleConfig.Suffix;
        newEditBox = data.Instance.CreateConfigEditBox(data.Instance, category, "screen.sound_visualizer.config_screens_edit_box_subtitle_suffix_hint", subtitleConfig.GetNum(), subtitleConfig.GetMaxValue(), null, null);
        newConfigsList.AddWidget(newEditBox);
        subtitleConfig = AbstractConfig.SubtitleConfig.AffixesSaturationPercent;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_affixes_saturation_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.AffixesBrightnessPercent;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_affixes_brightness_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        category = VisibilityCategory.SubtitleGlobalConfigs;
        newRect = (IRect)data.Instance.CreateRect(data.Instance, category, 1).SetBase(0, 0, rectsWidth, data.Height - 101);
        data.Instance.AddRenderableChild(newRect);
        newConfigsList = (IConfigsList)data.Instance.CreateConfigsList(data.Instance, category, "screen.sound_visualizer.config_screens_list_subtitle_global_configs_headline").SetBase(5, 5, rectsWidth - 10, data.Height - 111);
        data.Instance.AddRenderableChild(newConfigsList);
        newRectData = (RectData)newRect.GetData();
        newConfigsListData = (ConfigsListData)newConfigsList.GetData();
        newRectData.ListWindow = true;
        newRectData.ListWindowCorners = new int[]{IConfigScreenList.GetLeft(newConfigsListData), IConfigScreenList.GetTop(newConfigsListData) - 2, IConfigScreenList.GetRight(newConfigsListData), IConfigScreenList.GetBottom(newConfigsListData) + 2};
        subtitleConfig = AbstractConfig.SubtitleConfig.HorizontalLocation;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_horizontal_location_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.VerticalLocation;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_vertical_location_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.HorizontalOffset;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_horizontal_offset_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.VerticalOffset;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_vertical_offset_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.Scale;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_scale_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.PriorityOrder;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_priority_order_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.VolumeCharacteristic;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_volume_characteristic_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.PitchCharacteristic;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_pitch_characteristic_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.CharacteristicsLocation;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_characteristics_location_message", subtitleConfig.GetNum(), 4, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.CharacteristicsHint;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_characteristics_hint_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.CharacteristicsSaturationPercent;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_characteristics_saturation_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.CharacteristicsBrightnessPercent;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_characteristics_brightness_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.ReplaceNameWithLocation;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_replace_name_with_location_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.ShowAll;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_show_all_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.DirectionArrows;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_direction_arrows_message", subtitleConfig.GetNum(), 2, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.ShowInWorld;
        newButton = data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_subtitle_show_in_world_message", subtitleConfig.GetNum(), 3, button -> {}, (button, graphics) -> {});
        newConfigsList.AddWidget(newButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldScale;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_scale_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldOffsetY;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_offset_y_message", subtitleConfig.GetNum(), defaultTextColor, 0.05f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldOpacityFadeMinDistance;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_opacity_fade_min_distance_message", subtitleConfig.GetNum(), defaultTextColor, 0.05f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldOpacityFadeMaxDistance;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_opacity_fade_max_distance_message", subtitleConfig.GetNum(), defaultTextColor, 0.05f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldOpacityFadePercent;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_opacity_fade_percent_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.InWorldRefreshDistance;
        newSliderButton = data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_in_world_refresh_distance_message", subtitleConfig.GetNum(), defaultTextColor, 0.05f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
        newConfigsList.AddWidget(newSliderButton);
        category = VisibilityCategory.SoundsList;
        newRect = (IRect)data.Instance.CreateRect(data.Instance, category, 3).SetBase(data.Width - rectsWidth, 0, rectsWidth, data.Height - 101);
        data.Instance.AddRenderableChild(newRect);
        data.SoundsList.SetBase(data.Width - rectsWidth + 5, 5, rectsWidth - 10, data.Height - 111);
        data.Instance.AddRenderableChild(data.SoundsList);
        newRectData = (RectData)newRect.GetData();
        SoundsSelectableListData newSoundsSelectableListData = (SoundsSelectableListData)data.SoundsList.GetData();
        newRectData.ListWindow = true;
        newRectData.ListWindowCorners = new int[]{IConfigScreenList.GetLeft(newSoundsSelectableListData), IConfigScreenList.GetTop(newSoundsSelectableListData) - 2, IConfigScreenList.GetRight(newSoundsSelectableListData), IConfigScreenList.GetBottom(newSoundsSelectableListData) + 2};
        category = VisibilityCategory.Eternal;
        IConfigButton newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "gui.cancel", -1, 0, button -> {
            AbstractConfig.RollbackValues();
            ISoundVisualizerConfigScreen.OnClose(data);
        }, (button, guiGraphics) -> {}).SetBase(5, columnsOffset[3], mainButtonsWidth, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "gui.done", -1, 0, button -> ISoundVisualizerConfigScreen.OnClose(data), (button, guiGraphics) -> {}).SetBase(data.Width - mainButtonsWidth - 5, columnsOffset[3], mainButtonsWidth, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_left_source_switch_message", -1, 0, button -> {
            if (data.HasShiftDown) {
                ISoundVisualizerConfigScreen.SwitchSource(-3, data);
            } else {
                ISoundVisualizerConfigScreen.SwitchSource(-1, data);
            }
        }, (button, guiGraphics) -> {}).SetBase(mainButtonsWidth + 8, columnsOffset[3], 20, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "screen.sound_visualizer.config_screens_button_right_source_switch_message", -1, 0, button -> {
            if (data.HasShiftDown) {
                ISoundVisualizerConfigScreen.SwitchSource(3, data);
            } else {
                ISoundVisualizerConfigScreen.SwitchSource(1, data);
            }
        }, (button, guiGraphics) -> {}).SetBase(data.Width - mainButtonsWidth - 28, columnsOffset[3], 20, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, VisibilityCategory.Eternal, "", -1, 0, button -> ISoundVisualizerConfigScreen.SwitchIgnorability(data), (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
            ModTexture texture = soundsListData.Selected.size() > 0 ? (AbstractConfig.ContainsInIgnorableSounds(((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound) ? ModTexture.IgnorabilitySwitchButtonIgnoreIcon : ModTexture.IgnorabilitySwitchButtonNotIgnoreIcon) : (AbstractConfig.ContainsInIgnorableSources(AbstractConfig.GetSources()[data.Source]) ? ModTexture.IgnorabilitySwitchButtonIgnoreIcon : ModTexture.IgnorabilitySwitchButtonNotIgnoreIcon);
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }).SetBase(data.Width - mainButtonsWidth - 28, columnsOffset[2], 20, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        int buttonsWidth = (int)Math.floor((data.Width - 19) / 4);
        int centerButtonsWidth = (int)Math.ceil((data.Width - 16) / 3);
        int[] rowOffset = new int[]{5, buttonsWidth + 8, data.Width - buttonsWidth * 2 - 8, data.Width - buttonsWidth - 5};
        int screenExtraWidth = data.Width % 2;
        category = VisibilityCategory.DirectionalSoundIndicatorConfigs;
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.Radius;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_radius_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.Width;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_width_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.LifeTime;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_life_time_message", dsiConfig.GetNum(), defaultTextColor, 0.05f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.Thickness;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_thickness_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[3], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        buttonsWidth = (int)Math.floor((data.Width - 16) / 3);
        rowOffset = new int[]{5, buttonsWidth + 8, data.Width - buttonsWidth - 5};
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.OpacityMDP;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_opacity_mdp_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.WidthMDP;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_width_mdp_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[1], centerButtonsWidth + screenExtraWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.LifeTimeMDP;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_life_time_mdp_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        int colorButtonsWidth = (int)Math.floor((data.Width - mainButtonsWidth * 2 - 45) / 3);
        rowOffset = new int[]{5, mainButtonsWidth + 8, mainButtonsWidth + colorButtonsWidth + 11, mainButtonsWidth + colorButtonsWidth * 2 + 14};
        screenExtraWidth = (colorButtonsWidth * 3 + 6) % 2;
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.Opacity;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_opacity_message", dsiConfig.GetNum(), defaultTextColor, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[2], mainButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.ColorR;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_color_r_message", dsiConfig.GetNum(), -43691, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[2], colorButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.ColorG;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_color_g_message", dsiConfig.GetNum(), -11141291, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[2], colorButtonsWidth + screenExtraWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        dsiConfig = AbstractConfig.DirectionalSoundIndicatorConfig.ColorB;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_dsi_color_b_message", dsiConfig.GetNum(), -11184641, 1.0f, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue()).SetBase(rowOffset[3] + screenExtraWidth, columnsOffset[2], colorButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        int toolButtonsWidth = (int)Math.floor((mainButtonsWidth - 15) / 6);
        int toolButtonsOffset = data.Width - mainButtonsWidth - 5;
        newButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "", -1, 0, button -> {
            if (!data.CurrentVisibleCategories.contains((Object)VisibilityCategory.DirectionalSoundIndicatorGlobalConfigs)) {
                data.CurrentVisibleCategories.add(VisibilityCategory.DirectionalSoundIndicatorGlobalConfigs);
            } else {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.DirectionalSoundIndicatorGlobalConfigs);
            }
            ISoundVisualizerConfigScreen.UpdateWidgetsVisibility(data);
        }, (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = ModTexture.GlobalConfigsListButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
        }).SetBase(data.Width - toolButtonsWidth - 5, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newButton);
        buttonsWidth = (int)Math.floor((data.Width - 16) / 3);
        rowOffset = new int[]{5, buttonsWidth + 8, data.Width - buttonsWidth - 5};
        screenExtraWidth = data.Width % 2;
        category = VisibilityCategory.SubtitleConfigs;
        subtitleConfig = AbstractConfig.SubtitleConfig.BackgroundOpacity;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_background_opacity_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.TextOpacity;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_text_opacity_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[0], centerButtonsWidth + screenExtraWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.Priority;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_priority_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[0], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        buttonsWidth = (int)Math.floor((data.Width - 19) / 4);
        rowOffset = new int[]{5, buttonsWidth + 8, data.Width - buttonsWidth * 2 - 8, data.Width - buttonsWidth - 5};
        subtitleConfig = AbstractConfig.SubtitleConfig.FinalBackgroundOpacityPercent;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_final_background_opacity_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.FinalTextOpacityPercent;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_final_text_opacity_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.FinalTextSaturationPercent;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_final_text_saturation_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.FinalTextBrightnessPercent;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_final_text_brightness_message", subtitleConfig.GetNum(), defaultTextColor, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[3], columnsOffset[1], buttonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        rowOffset = new int[]{5, mainButtonsWidth + 8, mainButtonsWidth + colorButtonsWidth + 11, mainButtonsWidth + colorButtonsWidth * 2 + 14};
        screenExtraWidth = (colorButtonsWidth * 3 + 6) % 2;
        subtitleConfig = AbstractConfig.SubtitleConfig.LifeTime;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_life_time_message", subtitleConfig.GetNum(), defaultTextColor, 0.05f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[0], columnsOffset[2], mainButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.TextColorR;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_color_r_message", subtitleConfig.GetNum(), -43691, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[1], columnsOffset[2], colorButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.TextColorG;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_color_g_message", subtitleConfig.GetNum(), -11141291, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[2], columnsOffset[2], colorButtonsWidth + screenExtraWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        subtitleConfig = AbstractConfig.SubtitleConfig.TextColorB;
        newSliderButton = (IConfigSliderButton)data.Instance.CreateConfigSliderButton(data.Instance, category, "screen.sound_visualizer.config_screens_slider_button_subtitle_color_b_message", subtitleConfig.GetNum(), -11184641, 1.0f, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue()).SetBase(rowOffset[3] + screenExtraWidth, columnsOffset[2], colorButtonsWidth, 20);
        data.Instance.AddRenderableChild(newSliderButton);
        newButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "", -1, 0, button -> {
            if (!data.CurrentVisibleCategories.contains((Object)VisibilityCategory.SubtitleExtraConfigs)) {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.SubtitleGlobalConfigs);
                data.CurrentVisibleCategories.add(VisibilityCategory.SubtitleExtraConfigs);
            } else {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.SubtitleExtraConfigs);
            }
            ISoundVisualizerConfigScreen.UpdateWidgetsVisibility(data);
        }, (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = ModTexture.ExtraConfigsListButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
        }).SetBase(data.Width - toolButtonsWidth * 2 - 8, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newButton);
        newButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "", -1, 0, button -> {
            if (!data.CurrentVisibleCategories.contains((Object)VisibilityCategory.SubtitleGlobalConfigs)) {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.SubtitleExtraConfigs);
                data.CurrentVisibleCategories.add(VisibilityCategory.SubtitleGlobalConfigs);
            } else {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.SubtitleGlobalConfigs);
            }
            ISoundVisualizerConfigScreen.UpdateWidgetsVisibility(data);
        }, (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = ModTexture.GlobalConfigsListButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
        }).SetBase(data.Width - toolButtonsWidth - 5, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newButton);
        category = VisibilityCategory.Eternal;
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, VisibilityCategory.Eternal, "", -1, 0, button -> ISoundVisualizerConfigScreen.CopyConfigsValues(data.HasAltDown, data), (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = data.HasAltDown ? ModTexture.CopyColorButtonIcon : ModTexture.CopyButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }).SetBase(toolButtonsOffset, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "", -1, 0, button -> ISoundVisualizerConfigScreen.PasteConfigsValues(data.HasAltDown, data), (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = data.HasAltDown ? ModTexture.PasteColorButtonIcon : ModTexture.PasteButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }).SetBase(toolButtonsOffset + toolButtonsWidth + 3, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        newDefaultButton = (IConfigButton)data.Instance.CreateConfigButton(data.Instance, category, "", -1, 0, button -> {
            if (!data.CurrentVisibleCategories.contains((Object)VisibilityCategory.SoundsList)) {
                data.CurrentVisibleCategories.add(VisibilityCategory.SoundsList);
            } else {
                data.CurrentVisibleCategories.remove((Object)VisibilityCategory.SoundsList);
                ISoundsSelectableList.Select(null, (SoundsSelectableListData)data.SoundsList.GetData());
            }
            ISoundVisualizerConfigScreen.UpdateWidgetsVisibility(data);
        }, (button, guiGraphics) -> {
            AbstractModRender.SetRenderOptions(false, false, false, false, false);
            ConfigButtonData buttonData = (ConfigButtonData)button.GetData();
            ModTexture texture = ModTexture.SoundsListButtonIcon;
            AbstractModRender.RenderTexture(guiGraphics, texture, buttonData.X + (buttonData.Width - texture.GetWidth()) / 2, buttonData.Y + (buttonData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
        }).SetBase(toolButtonsOffset + toolButtonsWidth * 2 + 6, columnsOffset[2], toolButtonsWidth, 20);
        data.Instance.AddRenderableChild(newDefaultButton);
        ISoundVisualizerConfigScreen.SwitchTab(VisibilityCategory.DirectionalSoundIndicatorConfigs, data);
        ISoundVisualizerConfigScreen.SynchWidgets(data);
    }

    public static void RenderBackground(Object guiGraphics, int mouseX, int mouseY, float partialTick, SoundVisualizerConfigScreenData data) {
    }

    public static Optional<IConfigScreenChild> GetChildAt(double mouseX, double mouseY, SoundVisualizerConfigScreenData data) {
        for (IConfigScreenChild child : data.Children) {
            if (!child.IsMouseOver(mouseX, mouseY) || !child.GetData().Visible) continue;
            return Optional.of(child);
        }
        return Optional.empty();
    }

    public static IConfigScreenChild GetFocused(SoundVisualizerConfigScreenData data) {
        return data.Focused;
    }

    public static void SetFocused(IConfigScreenChild child, SoundVisualizerConfigScreenData data) {
    }

    public static boolean IsFocused(SoundVisualizerConfigScreenData data) {
        return data.Focused != null;
    }

    public static boolean ShouldCloseOnEsc(SoundVisualizerConfigScreenData data) {
        return true;
    }

    public static void OnClose(SoundVisualizerConfigScreenData data) {
        for (AbstractDirectionalSoundIndicator removeableDSI : AbstractClientData.DirectionalSoundIndicators.stream().map(dsi -> dsi).collect(Collectors.toList())) {
            removeableDSI.Kill();
        }
        AbstractClientData.DirectionalSoundIndicators.clear();
        AbstractClientData.Subtitles.clear();
        AbstractClientData.InWorldSubtitles.clear();
        data.Instance.SetScreen(data.LastScreen);
    }

    public static boolean CanRenderDirectionalSoundIndicator(SoundVisualizerConfigScreenData data) {
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        return !(soundsListData.Selected.size() > 0 ? AbstractConfig.ContainsInIgnorableSounds(((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound) : AbstractConfig.ContainsInIgnorableSources(AbstractConfig.GetSources()[data.Source]));
    }

    public static boolean CanRenderSubtitle(SoundVisualizerConfigScreenData data) {
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        if (soundsListData.Selected.size() > 0) {
            if (AbstractConfig.ContainsInIgnorableSounds(((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound)) {
                return false;
            }
            String subtitleText = ((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).SubtitleText;
            if (AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ShowAll) == 0 && (subtitleText == null || subtitleText.isEmpty())) {
                return false;
            }
        } else if (AbstractConfig.ContainsInIgnorableSources(AbstractConfig.GetSources()[data.Source])) {
            return false;
        }
        return true;
    }

    public static boolean DoesRenderDirectionalSoundIndicator(SoundVisualizerConfigScreenData data) {
        if (AbstractClientData.ConfigScreenDSI != null) {
            for (VisibilityCategory category : data.CurrentVisibleCategories) {
                if (!category.IsDSI()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean DoesRenderSubtitle(SoundVisualizerConfigScreenData data) {
        if (AbstractClientData.ConfigScreenSubtitle != null) {
            for (VisibilityCategory category : data.CurrentVisibleCategories) {
                if (!category.IsSubtitle()) continue;
                return true;
            }
        }
        return false;
    }

    public static void UpdateConfigScreenDSI(boolean animateLife, boolean isMaxDistance, SoundVisualizerConfigScreenData data) {
        String soundLocation = null;
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        soundLocation = soundsListData.Selected.size() > 0 ? ((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound : data.RandomSoundLocation;
        AbstractClientData.ConfigScreenDSI = data.Instance.CreateDSI(soundLocation, isMaxDistance ? 1.0f : 0.0f);
        AbstractClientData.AnimateConfigScreenDSILife = animateLife;
    }

    public static void UpdateConfigScreenSubtitle(boolean animateLife, boolean deathFrame, SoundVisualizerConfigScreenData data) {
        String text;
        String soundLocation = null;
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        if (soundsListData.Selected.size() > 0) {
            SoundsSelectableListEntryData firstEntryData = (SoundsSelectableListEntryData)soundsListData.Selected.get(0).GetData();
            soundLocation = firstEntryData.Sound;
            text = firstEntryData.SubtitleText;
        } else {
            soundLocation = data.RandomSoundLocation;
            text = data.RandomSoundSubtitleText;
        }
        float[] cameraRotations = AbstractModLogic.GetCameraRotations();
        ModMath.Vec3 subtitlePos = new ModMath.Vec3(AbstractModLogic.GetCameraPosX(), AbstractModLogic.GetCameraPosY(), AbstractModLogic.GetCameraPosZ()).Add(AbstractModLogic.GetRotatedVector(new ModMath.Vec3(0.0, 0.0, AbstractModLogic.IsGameVersionLaterOrEqual("1.21") ? -5.0 : 5.0), cameraRotations[0], cameraRotations[1], cameraRotations[2])).Add(new ModMath.Vec3(0.0, (float)AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.InWorldOffsetY) / 20.0f, 0.0));
        AbstractClientData.ConfigScreenSubtitle = data.Instance.CreateBetterSubtitle(soundLocation, text, subtitlePos.X, subtitlePos.Y, subtitlePos.Z);
        AbstractClientData.AnimateConfigScreenSubtitleLife = animateLife;
        AbstractClientData.ConfigScreenSubtitleDeathFrame = deathFrame;
    }

    public static void UpdateWidgetsVisibility(SoundVisualizerConfigScreenData data) {
        data.BlurAreas.clear();
        for (IConfigScreenChild child : data.Children) {
            int y;
            int x;
            if (!child.UpdateVisibility()) continue;
            if (child instanceof IRect) {
                IRect rect = (IRect)child;
                RectData rectData = (RectData)rect.GetData();
                x = IRect.GetX(rectData);
                y = IRect.GetY(rectData);
                data.BlurAreas.add(new int[]{x, y, x + IRect.GetWidth(rectData), y + IRect.GetHeight(rectData)});
                continue;
            }
            if (!(child instanceof ITab)) continue;
            ITab tab = (ITab)child;
            TabData tabData = (TabData)tab.GetData();
            x = ITab.GetX(tabData);
            y = ITab.GetY(tabData);
            data.BlurAreas.add(new int[]{x, y, x + ITab.GetWidth(tabData), y + ITab.GetHeight(tabData)});
        }
    }

    public static void SynchWidgets(SoundVisualizerConfigScreenData data) {
        for (IConfigScreenChild child : data.Children) {
            if (child instanceof IConfigsList) {
                IConfigsList list = (IConfigsList)child;
                ConfigsListData listData = (ConfigsListData)list.GetData();
                for (IConfigScreenListEntry listEntry : listData.AllEntries) {
                    IConfigsListEntry.SynchValue((ConfigsListEntryData)listEntry.GetData());
                }
                continue;
            }
            if (child instanceof IConfigButton) {
                IConfigButton.SynchValue((ConfigButtonData)child.GetData());
                continue;
            }
            if (child instanceof IConfigSliderButton) {
                IConfigSliderButton.SynchValue((ConfigSliderButtonData)child.GetData());
                continue;
            }
            if (!(child instanceof IConfigEditBox)) continue;
            IConfigEditBox.SynchValue((ConfigEditBoxData)child.GetData());
        }
        ISoundVisualizerConfigScreen.UpdateConfigScreenDSI(false, false, data);
        ISoundVisualizerConfigScreen.UpdateConfigScreenSubtitle(false, false, data);
    }

    public static Object GetButtonsValue(VisibilityCategory category, int configID, SoundVisualizerConfigScreenData data) {
        Object value = 0;
        String source = AbstractConfig.GetSources()[data.Source];
        String soundLocation = null;
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        if (soundsListData.Selected.size() > 0) {
            soundLocation = ((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound;
        }
        if (category.IsDSI()) {
            if (category.IsGlobal()) {
                AbstractConfig.DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(configID, true);
                value = AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(config);
            } else {
                AbstractConfig.DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(configID, false);
                value = AbstractConfig.GetDirectionalSoundIndicatorConfigValue(soundLocation, source, config);
            }
        } else if (category.IsSubtitle()) {
            if (category.IsGlobal()) {
                AbstractConfig.SubtitleConfig config = AbstractConfig.GetSubtitleConfig(configID, true);
                value = AbstractConfig.GetSubtitleGlobalConfigValue(config);
            } else {
                AbstractConfig.SubtitleConfig config = AbstractConfig.GetSubtitleConfig(configID, false);
                value = AbstractConfig.GetSubtitleConfigValue(soundLocation, source, config);
            }
        }
        return value;
    }

    public static void SetButtonsValue(VisibilityCategory category, int configID, Object newValue, SoundVisualizerConfigScreenData data) {
        String source = AbstractConfig.GetSources()[data.Source];
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        if (category.IsDSI()) {
            AbstractConfig.DirectionalSoundIndicatorConfig config;
            if (category.IsGlobal() && newValue instanceof Integer) {
                Integer newIntValue = (Integer)newValue;
                config = AbstractConfig.GetDirectionalSoundIndicatorConfig(configID, true);
                AbstractConfig.SetDirectionalSoundIndicatorGlobalConfigNewValue(config, newIntValue);
            } else {
                config = AbstractConfig.GetDirectionalSoundIndicatorConfig(configID, false);
                if (soundsListData.Selected.size() > 0) {
                    for (ISoundsSelectableListEntry entry : soundsListData.Selected) {
                        SoundsSelectableListEntryData soundsListEntryData = (SoundsSelectableListEntryData)entry.GetData();
                        ISoundsSelectableListEntry.SetConfigured(true, soundsListEntryData);
                        if (!Arrays.stream(AbstractConfig.GetIndividuallyConfiguredSounds()).map(sounds -> sounds).collect(Collectors.toList()).contains(soundsListEntryData.Sound)) {
                            AbstractConfig.AddIndividuallyConfiguredSound(source, soundsListEntryData.Sound);
                        }
                        AbstractConfig.SetDirectionalSoundIndicatorConfigNewValue(soundsListEntryData.Sound, source, config, newValue);
                    }
                } else {
                    AbstractConfig.SetDirectionalSoundIndicatorConfigNewValue(null, source, config, newValue);
                }
            }
            ISoundVisualizerConfigScreen.UpdateConfigScreenDSI(config.IsLifeTime(), config.IsMaxDistancePercent(), data);
        } else if (category.IsSubtitle()) {
            AbstractConfig.SubtitleConfig config;
            if (category.IsGlobal() && newValue instanceof Integer) {
                Integer newIntValue = (Integer)newValue;
                config = AbstractConfig.GetSubtitleConfig(configID, true);
                AbstractConfig.SetSubtitleGlobalConfigNewValue(config, newIntValue);
            } else {
                config = AbstractConfig.GetSubtitleConfig(configID, false);
                if (soundsListData.Selected.size() > 0) {
                    for (ISoundsSelectableListEntry entry : soundsListData.Selected) {
                        SoundsSelectableListEntryData soundsListEntryData = (SoundsSelectableListEntryData)entry.GetData();
                        ISoundsSelectableListEntry.SetConfigured(true, soundsListEntryData);
                        if (!Arrays.stream(AbstractConfig.GetIndividuallyConfiguredSounds()).map(sounds -> sounds).collect(Collectors.toList()).contains(soundsListEntryData.Sound)) {
                            AbstractConfig.AddIndividuallyConfiguredSound(source, soundsListEntryData.Sound);
                        }
                        AbstractConfig.SetSubtitleConfigNewValue(soundsListEntryData.Sound, source, config, newValue);
                    }
                } else {
                    AbstractConfig.SetSubtitleConfigNewValue(null, source, config, newValue);
                }
            }
            ISoundVisualizerConfigScreen.UpdateConfigScreenSubtitle(config.IsLifeTime(), config.IsFinal(), data);
        }
        ISoundVisualizerConfigScreen.CheckWarnings(data);
    }

    public static void SwitchTab(VisibilityCategory category, SoundVisualizerConfigScreenData data) {
        for (IConfigScreenChild child : data.Children) {
            if (!(child instanceof ITab)) continue;
            ITab tab = (ITab)child;
            TabData tabData = (TabData)tab.GetData();
            if (tabData.Category == category) {
                tabData.Selected = true;
                continue;
            }
            tabData.Selected = false;
        }
        ArrayList<VisibilityCategory> removeableCategories = new ArrayList<VisibilityCategory>();
        for (VisibilityCategory checkableCategory : data.CurrentVisibleCategories) {
            if (checkableCategory.IsTabSwitchIgnorable()) continue;
            removeableCategories.add(checkableCategory);
        }
        data.CurrentVisibleCategories.removeAll(removeableCategories);
        data.CurrentVisibleCategories.add(category);
        ISoundVisualizerConfigScreen.UpdateWidgetsVisibility(data);
    }

    public static void SwitchSource(int steps, SoundVisualizerConfigScreenData data) {
        int source;
        ISoundsSelectableList.Select(null, (SoundsSelectableListData)data.SoundsList.GetData());
        int sourcesAmount = AbstractConfig.GetSources().length;
        for (source = (data.Source + steps) % sourcesAmount; source < 0; source += sourcesAmount) {
        }
        data.Source = source;
        ISoundVisualizerConfigScreen.SynchWidgets(data);
    }

    public static void SwitchIgnorability(SoundVisualizerConfigScreenData data) {
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        if (soundsListData.Selected.size() > 0) {
            boolean removeInstead = AbstractConfig.ContainsInIgnorableSounds(((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound);
            for (ISoundsSelectableListEntry entry : soundsListData.Selected) {
                SoundsSelectableListEntryData entryData = (SoundsSelectableListEntryData)entry.GetData();
                entryData.IsSoundIgnorable = !removeInstead;
                String sound = entryData.Sound;
                if (removeInstead) {
                    AbstractConfig.RemoveFromIgnorableSounds(sound);
                    continue;
                }
                AbstractConfig.AddInIgnorableSounds(sound);
            }
        } else {
            String source = AbstractConfig.GetSources()[data.Source];
            if (AbstractConfig.ContainsInIgnorableSources(source)) {
                AbstractConfig.RemoveFromIgnorableSources(source);
            } else {
                AbstractConfig.AddInIgnorableSources(source);
            }
        }
    }

    public static void CopyConfigsValues(boolean colors, SoundVisualizerConfigScreenData data) {
        String source = AbstractConfig.GetSources()[data.Source];
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        String sound = null;
        if (soundsListData.Selected.size() > 0) {
            sound = ((SoundsSelectableListEntryData)soundsListData.Selected.get((int)0).GetData()).Sound;
        }
        for (AbstractConfig.DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig : AbstractConfig.DirectionalSoundIndicatorConfig.values()) {
            if (directionalSoundIndicatorConfig.IsGlobal() || colors ^ directionalSoundIndicatorConfig.IsColor()) continue;
            data.DSIBuffer.put(directionalSoundIndicatorConfig, AbstractConfig.GetDirectionalSoundIndicatorConfigValue(sound, source, directionalSoundIndicatorConfig));
        }
        for (Enum enum_ : AbstractConfig.SubtitleConfig.values()) {
            if (((AbstractConfig.SubtitleConfig)enum_).IsGlobal() || colors ^ ((AbstractConfig.SubtitleConfig)enum_).IsColor()) continue;
            data.SubtitleBuffer.put((AbstractConfig.SubtitleConfig)enum_, AbstractConfig.GetSubtitleConfigValue(sound, source, (AbstractConfig.SubtitleConfig)enum_));
        }
    }

    public static void PasteConfigsValues(boolean colors, SoundVisualizerConfigScreenData data) {
        String source = AbstractConfig.GetSources()[data.Source];
        SoundsSelectableListData soundsListData = (SoundsSelectableListData)data.SoundsList.GetData();
        String sound = null;
        for (AbstractConfig.DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig : data.DSIBuffer.keySet()) {
            if (directionalSoundIndicatorConfig.IsGlobal() || colors ^ directionalSoundIndicatorConfig.IsColor() || !data.DSIBuffer.containsKey((Object)directionalSoundIndicatorConfig)) continue;
            if (soundsListData.Selected.size() > 0) {
                for (ISoundsSelectableListEntry entry : soundsListData.Selected) {
                    sound = ((SoundsSelectableListEntryData)entry.GetData()).Sound;
                    AbstractConfig.SetDirectionalSoundIndicatorConfigNewValue(sound, source, directionalSoundIndicatorConfig, data.DSIBuffer.get((Object)directionalSoundIndicatorConfig));
                }
                continue;
            }
            AbstractConfig.SetDirectionalSoundIndicatorConfigNewValue(null, source, directionalSoundIndicatorConfig, data.DSIBuffer.get((Object)directionalSoundIndicatorConfig));
        }
        for (AbstractConfig.SubtitleConfig subtitleConfig : data.SubtitleBuffer.keySet()) {
            if (subtitleConfig.IsGlobal() || colors ^ subtitleConfig.IsColor() || !data.SubtitleBuffer.containsKey((Object)subtitleConfig)) continue;
            if (soundsListData.Selected.size() > 0) {
                for (ISoundsSelectableListEntry entry : soundsListData.Selected) {
                    sound = ((SoundsSelectableListEntryData)entry.GetData()).Sound;
                    AbstractConfig.SetSubtitleConfigNewValue(sound, source, subtitleConfig, data.SubtitleBuffer.get((Object)subtitleConfig));
                }
                continue;
            }
            AbstractConfig.SetSubtitleConfigNewValue(null, source, subtitleConfig, data.SubtitleBuffer.get((Object)subtitleConfig));
        }
        ISoundVisualizerConfigScreen.SynchWidgets(data);
    }

    public static void FocusWidget(IConfigScreenChild child, SoundVisualizerConfigScreenData data) {
        if (data.Focused != null) {
            data.Focused.Unfocus();
        }
        if (child != null && child instanceof IConfigScreenWidget) {
            IConfigScreenWidget widget = (IConfigScreenWidget)child;
            ((ConfigScreenWidgetData)widget.GetData()).Focused = true;
        }
        data.Focused = child;
    }

    public static void HoverWidget(IConfigScreenChild child, SoundVisualizerConfigScreenData data) {
        if (data.Hovered != null) {
            data.Hovered.SetHover(false);
        }
        if (child != null) {
            child.SetHover(true);
        }
        data.Hovered = child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckWarnings(SoundVisualizerConfigScreenData data) {
        ArrayList<Warning> arrayList = data.CurrentWarnings;
        synchronized (arrayList) {
            data.CurrentWarnings.clear();
            for (Warning warning : Warning.values()) {
                if (!warning.CheckCondition()) continue;
                data.CurrentWarnings.add(warning);
            }
        }
    }

    public IConfigsList CreateConfigsList(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, String var3);

    public ISoundsSelectableList CreateSoundsSelectableList(ISoundVisualizerConfigScreen var1, VisibilityCategory var2);

    public IRect CreateRect(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, int var3);

    public ITab CreateTab(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, String var3);

    public IConfigButton CreateConfigButton(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, String var3, int var4, int var5, IConfigButton.IOnPress var6, IConfigButton.IOnRender var7);

    public IConfigSliderButton CreateConfigSliderButton(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, String var3, int var4, int var5, float var6, int var7, int var8);

    public IConfigEditBox CreateConfigEditBox(ISoundVisualizerConfigScreen var1, VisibilityCategory var2, String var3, int var4, int var5, Consumer<String> var6, Predicate<String> var7);

    public AbstractDirectionalSoundIndicator CreateDSI(String var1, float var2);

    public AbstractBetterSubtitle CreateBetterSubtitle(String var1, String var2, double var3, double var5, double var7);

    public void AddRenderableChild(IConfigsList var1);

    public void AddRenderableChild(ISoundsSelectableList var1);

    public void AddRenderableChild(IRect var1);

    public void AddRenderableChild(ITab var1);

    public void AddRenderableChild(IConfigButton var1);

    public void AddRenderableChild(IConfigSliderButton var1);

    public void AddRenderableChild(IConfigEditBox var1);

    public void SetScreen(Object var1);

    public void RequestCursor(Object var1, String var2);

    public SoundVisualizerConfigScreenData GetData();

    public void SuperRender(Object var1, int var2, int var3, float var4);

    public static class SoundVisualizerConfigScreenData {
        public final ISoundVisualizerConfigScreen Instance;
        public Object LastScreen = null;
        public List<IConfigScreenChild> Children = List.of();
        public boolean HasShiftDown = false;
        public boolean HasControlDown = false;
        public boolean HasAltDown = false;
        public int Width = 0;
        public int Height = 0;
        public int OldMouseX = -16;
        public int OldMouseY = -16;
        public boolean IsMouseDragging = false;
        public String CursorTypeRequest = "arrow";
        public int Source = 0;
        public int ExtraSourceTextsWidth = 0;
        public ISoundsSelectableList SoundsList = null;
        public ArrayList<VisibilityCategory> CurrentVisibleCategories = new ArrayList();
        public IConfigScreenChild Focused = null;
        public IConfigScreenChild Hovered = null;
        public ArrayList<Warning> CurrentWarnings = new ArrayList();
        public Map<AbstractConfig.DirectionalSoundIndicatorConfig, Object> DSIBuffer = new HashMap<AbstractConfig.DirectionalSoundIndicatorConfig, Object>();
        public Map<AbstractConfig.SubtitleConfig, Object> SubtitleBuffer = new HashMap<AbstractConfig.SubtitleConfig, Object>();
        public ArrayList<int[]> BlurAreas = new ArrayList();
        public String RandomSoundLocation = "";
        public String RandomSoundSubtitleText = "";
        public float DSIRotation = (float)(-Math.PI);

        public SoundVisualizerConfigScreenData(ISoundVisualizerConfigScreen instance) {
            this.Instance = instance;
        }
    }

    public static enum VisibilityCategory {
        Eternal("TabSwitchIgnore"),
        DirectionalSoundIndicatorConfigs("DSI"),
        DirectionalSoundIndicatorExtraConfigs("DSI"),
        DirectionalSoundIndicatorGlobalConfigs("DSI,Global"),
        SubtitleConfigs("Subtitle"),
        SubtitleExtraConfigs("Subtitle"),
        SubtitleGlobalConfigs("Subtitle,Global"),
        SoundsList("TabSwitchIgnore");

        private final String _types;

        private VisibilityCategory(String types) {
            this._types = types;
        }

        public boolean IsDSI() {
            return this._types.contains("DSI");
        }

        public boolean IsSubtitle() {
            return this._types.contains("Subtitle");
        }

        public boolean IsGlobal() {
            return this._types.contains("Global");
        }

        public boolean IsTabSwitchIgnorable() {
            return this._types.contains("TabSwitchIgnore");
        }
    }

    public static interface ISoundsSelectableList
    extends IConfigScreenList {
        public static void BaseSetup(SoundsSelectableListData data) {
            data.HeaderHeight = 25;
            data.HideFullScrollbar = false;
            data.ItemHeight = 12;
            data.ItemSplitHeight = 0;
            data.ScrollbarSplitWidth = 3;
            data.ScrollbarVisible = true;
        }

        public static boolean UpdateVisibility(SoundsSelectableListData data) {
            IConfigScreenList.UpdateVisibility(data);
            data.SearchBox.UpdateVisibility(data.Visible);
            data.FilterTypeSwitch.UpdateVisibility(data.Visible);
            data.ShowSubtitlesTextSwitch.UpdateVisibility(data.Visible);
            return data.Visible;
        }

        public static void UpdateVisibility(boolean isVisible, SoundsSelectableListData data) {
            IConfigScreenList.UpdateVisibility(isVisible, data);
            data.SearchBox.UpdateVisibility(data.Visible);
            data.FilterTypeSwitch.UpdateVisibility(data.Visible);
            data.ShowSubtitlesTextSwitch.UpdateVisibility(data.Visible);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, SoundsSelectableListData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            data.SearchBox.SetBase(data.X, data.Y, data.Width - 46, 20);
            data.SearchBox.Render(guiGraphics, mouseX, mouseY, partialTick);
            data.FilterTypeSwitch.SetBase(data.X + data.Width - 43, data.Y, 20, 20);
            data.FilterTypeSwitch.Render(guiGraphics, mouseX, mouseY, partialTick);
            data.ShowSubtitlesTextSwitch.SetBase(data.X + data.Width - 20, data.Y, 20, 20);
            data.ShowSubtitlesTextSwitch.Render(guiGraphics, mouseX, mouseY, partialTick);
            IConfigScreenList.Render(guiGraphics, mouseX, mouseY, partialTick, data);
            int top = IConfigScreenList.GetTop(data);
            int bottom = IConfigScreenList.GetBottom(data);
            int rowLeft = IConfigScreenList.GetRowLeft(data);
            int rowRight = IConfigScreenList.GetRowRight(data);
            boolean selectedBefore = false;
            AbstractModRender.EnableScissor(guiGraphics, IConfigScreenList.GetLeft(data), top, IConfigScreenList.GetRight(data), bottom);
            for (int i = 0; i < data.VisibleEntries.size(); ++i) {
                ISoundsSelectableListEntry entry = (ISoundsSelectableListEntry)data.VisibleEntries.get(i);
                int rowTop = IConfigScreenList.GetRowTop(i, data);
                int rowBottom = IConfigScreenList.GetRowBottom(i, data);
                if (rowBottom >= top - 1 && rowTop <= bottom + 1) {
                    if (ISoundsSelectableList.IsSelected(entry, data)) {
                        if (!selectedBefore) {
                            AbstractModRender.RenderRect(guiGraphics, rowLeft, rowTop, rowRight, rowTop + 1, -8355712);
                        }
                        AbstractModRender.RenderRect(guiGraphics, rowLeft, rowTop, rowLeft + 1, rowBottom, -8355712);
                        AbstractModRender.RenderRect(guiGraphics, rowRight - 1, rowTop, rowRight, rowBottom, -8355712);
                        if (data.VisibleEntries.size() <= i + 1 || !ISoundsSelectableList.IsSelected((ISoundsSelectableListEntry)data.VisibleEntries.get(i + 1), data)) {
                            AbstractModRender.RenderRect(guiGraphics, rowLeft, rowBottom - 1, rowRight, rowBottom, -8355712);
                        }
                    }
                    ISoundsSelectableListEntry.RenderIcons(guiGraphics, mouseX, mouseY, partialTick, (SoundsSelectableListEntryData)entry.GetData());
                }
                selectedBefore = ISoundsSelectableList.IsSelected(entry, data);
            }
            AbstractModRender.DisableScissor(guiGraphics);
        }

        public static void MouseMoved(double mouseX, double mouseY, SoundsSelectableListData data) {
            if (data.SearchBox.IsMouseOver(mouseX, mouseY)) {
                data.SearchBox.MouseMoved(mouseX, mouseY);
            } else if (data.FilterTypeSwitch.IsMouseOver(mouseX, mouseY)) {
                data.FilterTypeSwitch.MouseMoved(mouseX, mouseY);
            } else if (data.ShowSubtitlesTextSwitch.IsMouseOver(mouseX, mouseY)) {
                data.ShowSubtitlesTextSwitch.MouseMoved(mouseX, mouseY);
            } else {
                IConfigScreenList.MouseMoved(mouseX, mouseY, data);
            }
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, SoundsSelectableListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (data.SearchBox.MouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (data.FilterTypeSwitch.MouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (data.ShowSubtitlesTextSwitch.MouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (mouseY >= (double)IConfigScreenList.GetTop(data) && mouseY <= (double)IConfigScreenList.GetBottom(data)) {
                ((IConfigScreenList)data.Instance).UpdateScrollingState(mouseX, mouseY, button);
                ISoundsSelectableListEntry entry = (ISoundsSelectableListEntry)IConfigScreenList.GetEntryAtPosition(mouseX, mouseY, data);
                if (entry != null) {
                    return ISoundsSelectableListEntry.MouseClicked(mouseX, mouseY, button, (SoundsSelectableListEntryData)entry.GetData());
                }
                if (IConfigScreenList.IsMouseOverScrollbar(mouseX, mouseY, data)) {
                    SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
                    screenData.IsMouseDragging = true;
                    screenData.CursorTypeRequest = "resize_ns";
                    ISoundVisualizerConfigScreen.FocusWidget(data.Instance, screenData);
                    return true;
                }
            }
            return false;
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, SoundsSelectableListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            boolean isDragged = data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
            data.ScrollAmount = ((IConfigScreenList)data.Instance).GetScroll();
            return isDragged;
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, SoundsSelectableListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (data.SearchBox.IsMouseOver(mouseX, mouseY)) {
                return data.SearchBox.MouseReleased(mouseX, mouseY, button);
            }
            if (data.FilterTypeSwitch.IsMouseOver(mouseX, mouseY)) {
                return data.FilterTypeSwitch.MouseReleased(mouseX, mouseY, button);
            }
            if (data.ShowSubtitlesTextSwitch.IsMouseOver(mouseX, mouseY)) {
                return data.ShowSubtitlesTextSwitch.MouseReleased(mouseX, mouseY, button);
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, SoundsSelectableListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (data.SearchBox.IsMouseOver(mouseX, mouseY)) {
                return data.SearchBox.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
            if (data.FilterTypeSwitch.IsMouseOver(mouseX, mouseY)) {
                return data.FilterTypeSwitch.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
            if (data.ShowSubtitlesTextSwitch.IsMouseOver(mouseX, mouseY)) {
                return data.ShowSubtitlesTextSwitch.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
            }
            boolean isScrolled = data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
            data.ScrollAmount = ((IConfigScreenList)data.Instance).GetScroll();
            return isScrolled;
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, SoundsSelectableListData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (data.SearchBox.KeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (data.FilterTypeSwitch.KeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            if (data.ShowSubtitlesTextSwitch.KeyPressed(keyCode, scanCode, modifiers)) {
                return true;
            }
            boolean isSomethingPressed = false;
            if (!data.Selected.isEmpty()) {
                if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.FavoriteSwitch, keyCode, scanCode, modifiers)) {
                    for (ISoundsSelectableListEntry entry : data.Selected) {
                        ISoundsSelectableListEntry.SwitchFavorite((SoundsSelectableListEntryData)entry.GetData());
                    }
                    isSomethingPressed = true;
                } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.DeleteICSConfigs, keyCode, scanCode, modifiers)) {
                    for (ISoundsSelectableListEntry entry : data.Selected) {
                        ISoundsSelectableListEntry.SetConfigured(false, (SoundsSelectableListEntryData)entry.GetData());
                    }
                    isSomethingPressed = true;
                }
            }
            if (isSomethingPressed) {
                ISoundVisualizerConfigScreen.SynchWidgets(screenData);
            }
            return isSomethingPressed;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, SoundsSelectableListData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static boolean IsSelected(ISoundsSelectableListEntry entry, SoundsSelectableListData data) {
            return data.Selected.contains(entry);
        }

        public static void Select(ISoundsSelectableListEntry entry, SoundsSelectableListData data) {
            data.Selected.clear();
            if (entry != null && data.VisibleEntries.contains(entry)) {
                data.Selected.add(entry);
            }
            data.LastSelected = entry;
        }

        public static void SelectInRange(ISoundsSelectableListEntry toEntry, SoundsSelectableListData data) {
            int fromEntryIndex = 0;
            if (data.LastSelected != null) {
                fromEntryIndex = data.VisibleEntries.indexOf(data.LastSelected);
            }
            int toEntryIndex = data.VisibleEntries.indexOf(toEntry);
            boolean removeInstead = data.Selected.contains(toEntry);
            if (fromEntryIndex > -1 && toEntryIndex > -1) {
                if (fromEntryIndex < toEntryIndex) {
                    for (int i = fromEntryIndex; i <= toEntryIndex; ++i) {
                        ISoundsSelectableListEntry sortedEntry = (ISoundsSelectableListEntry)data.VisibleEntries.get(i);
                        if (data.Selected.contains(sortedEntry)) {
                            if (!removeInstead) continue;
                            data.Selected.remove(sortedEntry);
                            continue;
                        }
                        if (removeInstead) continue;
                        data.Selected.add(sortedEntry);
                    }
                } else {
                    for (int i = fromEntryIndex; i >= toEntryIndex; --i) {
                        ISoundsSelectableListEntry sortedEntry = (ISoundsSelectableListEntry)data.VisibleEntries.get(i);
                        if (data.Selected.contains(sortedEntry)) {
                            if (!removeInstead) continue;
                            data.Selected.remove(sortedEntry);
                            continue;
                        }
                        if (removeInstead) continue;
                        data.Selected.add(sortedEntry);
                    }
                }
            }
            data.LastSelected = toEntry;
        }

        public static void AddSelected(ISoundsSelectableListEntry entry, SoundsSelectableListData data) {
            if (!ISoundsSelectableList.IsSelected(entry, data)) {
                data.Selected.add(entry);
                data.LastSelected = entry;
            }
        }

        public static void RemoveSelected(ISoundsSelectableListEntry entry, SoundsSelectableListData data) {
            if (ISoundsSelectableList.IsSelected(entry, data)) {
                data.Selected.remove(entry);
                if (Objects.equals(data.LastSelected, entry)) {
                    data.LastSelected = null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void Filter(String searchText, SoundsSelectableListData data) {
            if (searchText != null && !searchText.isEmpty()) {
                searchText = searchText.toLowerCase();
                ArrayList<ISoundsSelectableListEntry> mostFavoritePriority = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> defaultFavoritePriority = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> mostPriority = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> defaultPriority = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> removableSelected = new ArrayList<ISoundsSelectableListEntry>();
                for (ISoundsSelectableListEntry entry : data.AllEntries.stream().map(streamEntry -> (ISoundsSelectableListEntry)streamEntry).collect(Collectors.toList())) {
                    String text;
                    SoundsSelectableListEntryData entryData;
                    block23: {
                        entryData = (SoundsSelectableListEntryData)entry.GetData();
                        if (data.FilterType == 1) {
                            if (entryData.SubtitleText != null && !entryData.SubtitleText.isEmpty()) {
                                text = data.ShowSubtitlesText ? entryData.SubtitleText : entryData.Sound;
                                break block23;
                            } else {
                                removableSelected.add(entry);
                                continue;
                            }
                        }
                        if (data.FilterType == 2) {
                            if (entryData.SubtitleText == null || entryData.SubtitleText.isEmpty()) {
                                text = entryData.Sound;
                                break block23;
                            } else {
                                removableSelected.add(entry);
                                continue;
                            }
                        }
                        text = data.ShowSubtitlesText && entryData.SubtitleText != null && !entryData.SubtitleText.isEmpty() ? entryData.SubtitleText : entryData.Sound;
                    }
                    if (text.toLowerCase().startsWith(searchText)) {
                        if (entryData.Favorite) {
                            mostFavoritePriority.add(entry);
                            continue;
                        }
                        mostPriority.add(entry);
                        continue;
                    }
                    if (text.toLowerCase().contains(searchText)) {
                        if (entryData.Favorite) {
                            defaultFavoritePriority.add(entry);
                            continue;
                        }
                        defaultPriority.add(entry);
                        continue;
                    }
                    removableSelected.add(entry);
                }
                data.VisibleEntries.clear();
                data.VisibleEntries.addAll(mostFavoritePriority);
                data.VisibleEntries.addAll(defaultFavoritePriority);
                data.VisibleEntries.addAll(mostPriority);
                data.VisibleEntries.addAll(defaultPriority);
                if (removableSelected.contains(data.LastSelected)) {
                    data.LastSelected = null;
                }
                data.Selected.removeAll(removableSelected);
            } else {
                ArrayList<ISoundsSelectableListEntry> favorites = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> noFavorites = new ArrayList<ISoundsSelectableListEntry>();
                ArrayList<ISoundsSelectableListEntry> removableSelected = new ArrayList<ISoundsSelectableListEntry>();
                for (ISoundsSelectableListEntry entry : data.AllEntries.stream().map(streamEntry -> (ISoundsSelectableListEntry)streamEntry).collect(Collectors.toList())) {
                    SoundsSelectableListEntryData entryData = (SoundsSelectableListEntryData)entry.GetData();
                    if (data.FilterType == 1) {
                        if (entryData.SubtitleText != null && !entryData.SubtitleText.isEmpty()) {
                            if (entryData.Favorite) {
                                favorites.add(entry);
                                continue;
                            }
                            noFavorites.add(entry);
                            continue;
                        }
                        removableSelected.add(entry);
                        continue;
                    }
                    if (data.FilterType == 2) {
                        if (entryData.SubtitleText == null || entryData.SubtitleText.isEmpty()) {
                            if (entryData.Favorite) {
                                favorites.add(entry);
                                continue;
                            }
                            noFavorites.add(entry);
                            continue;
                        }
                        removableSelected.add(entry);
                        continue;
                    }
                    if (entryData.Favorite) {
                        favorites.add(entry);
                        continue;
                    }
                    noFavorites.add(entry);
                }
                data.VisibleEntries.clear();
                data.VisibleEntries.addAll(favorites);
                data.VisibleEntries.addAll(noFavorites);
                if (removableSelected.contains(data.LastSelected)) {
                    data.LastSelected = null;
                }
                data.Selected.removeAll(removableSelected);
            }
            data.ScrollAmount = Math.clamp(data.ScrollAmount, 0.0, (double)IConfigScreenList.GetMaxScroll(data));
            ((IConfigScreenList)data.Instance).SetScroll(data.ScrollAmount);
        }

        public void AddSound(String var1, String var2, boolean var3, boolean var4, boolean var5);
    }

    public static interface IConfigScreenChild {
        public static boolean UpdateVisibility(ConfigScreenChildData data) {
            data.Visible = data.Category == VisibilityCategory.Eternal || data.Screen.GetData().CurrentVisibleCategories.contains((Object)data.Category);
            return data.Visible;
        }

        public static void UpdateVisibility(boolean isVisible, ConfigScreenChildData data) {
            data.Visible = isVisible;
        }

        public boolean UpdateVisibility();

        public void UpdateVisibility(boolean var1);

        public Object SetBase(int var1, int var2, int var3, int var4);

        public void Unfocus();

        public void SetHover(boolean var1);

        public ConfigScreenChildData GetData();

        public void Render(Object var1, int var2, int var3, float var4);

        public void MouseMoved(double var1, double var3);

        public boolean MouseClicked(double var1, double var3, int var5);

        public boolean MouseDragged(double var1, double var3, int var5, double var6, double var8);

        public boolean MouseReleased(double var1, double var3, int var5);

        public boolean MouseScrolled(double var1, double var3, double var5, double var7);

        public boolean KeyPressed(int var1, int var2, int var3);

        public boolean IsMouseOver(double var1, double var3);

        public void SuperRender(Object var1, int var2, int var3, float var4);

        public boolean SuperMouseClicked(double var1, double var3, int var5);

        public boolean SuperMouseDragged(double var1, double var3, int var5, double var6, double var8);

        public boolean SuperMouseReleased(double var1, double var3, int var5);

        public boolean SuperMouseScrolled(double var1, double var3, double var5, double var7);

        public boolean SuperKeyPressed(int var1, int var2, int var3);
    }

    public static class ConfigScreenChildData {
        public final ISoundVisualizerConfigScreen Screen;
        public final IConfigScreenChild Instance;
        public final VisibilityCategory Category;
        public int X = 0;
        public int Y = 0;
        public int Width = 0;
        public int Height = 0;
        public boolean Visible = false;

        public ConfigScreenChildData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            this.Screen = screen;
            this.Instance = instance;
            this.Category = category;
        }
    }

    public static enum Warning {
        DirectionalSoundIndicatorsDisabled(List.of(VisibilityCategory.DirectionalSoundIndicatorConfigs), 100, "screen.sound_visualizer.config_screens_directional_sound_indicators_disabled_warning", () -> !AbstractModLogic.ShowDSIs()),
        SubtitlesDisabled(List.of(VisibilityCategory.SubtitleConfigs), 100, "screen.sound_visualizer.config_screens_subtitles_disabled_warning", () -> !AbstractModLogic.ShowSubtitles()),
        ImprovedTransparencyEnabled(List.of(VisibilityCategory.SubtitleConfigs), 90, "screen.sound_visualizer.config_screens_improved_transparency_enabled_warning", () -> AbstractConfig.GetSubtitleGlobalConfigValue(AbstractConfig.SubtitleConfig.ShowInWorld) > 0 && AbstractModLogic.IsTransparencyImproved());

        private final List<VisibilityCategory> _categories;
        private final int _priority;
        private final String _textKey;
        private final Supplier<Boolean> _condition;

        private Warning(List<VisibilityCategory> categories, int priority, String textKey, Supplier<Boolean> condition) {
            this._categories = categories;
            this._priority = priority;
            this._textKey = textKey;
            this._condition = condition;
        }

        public List<VisibilityCategory> GetCategories() {
            return this._categories;
        }

        public int GetPriority() {
            return this._priority;
        }

        public String GetTextKey() {
            return this._textKey;
        }

        public boolean CheckCondition() {
            return this._condition.get();
        }
    }

    public static class SoundsSelectableListData
    extends ConfigScreenListData {
        public final IConfigEditBox SearchBox;
        public final IConfigButton FilterTypeSwitch;
        public final IConfigButton ShowSubtitlesTextSwitch;
        public int FilterType = 0;
        public boolean ShowSubtitlesText = false;
        public ArrayList<ISoundsSelectableListEntry> Selected = new ArrayList();
        public ISoundsSelectableListEntry LastSelected = null;

        public SoundsSelectableListData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
            this.SearchBox = screen.CreateConfigEditBox(screen, category, "screen.sound_visualizer.config_screens_sounds_list_search_box_hint", -1, 64, searchText -> ISoundsSelectableList.Filter(searchText, this), null);
            this.FilterTypeSwitch = screen.CreateConfigButton(screen, category, "", -1, 0, button -> {
                if (screen.GetData().HasControlDown) {
                    if (--this.FilterType < 0) {
                        this.FilterType = 2;
                    }
                } else {
                    ++this.FilterType;
                    this.FilterType %= 3;
                }
                ISoundsSelectableList.Filter(((ConfigEditBoxData)this.SearchBox.GetData()).Value, this);
            }, (button, guiGraphics) -> {
                AbstractModRender.SetRenderOptions(false, false, false, false, false);
                ConfigButtonData filterTypeSwitchData = (ConfigButtonData)button.GetData();
                ModTexture texture = this.FilterType == 1 ? ModTexture.SubtitleSoundsFilterTypeButtonIcon : (this.FilterType == 2 ? ModTexture.NotSubtitleSoundsFilterTypeButtonIcon : ModTexture.AllSoundsFilterTypeButtonIcon);
                AbstractModRender.RenderTexture(guiGraphics, texture, filterTypeSwitchData.X + (filterTypeSwitchData.Width - texture.GetWidth()) / 2, filterTypeSwitchData.Y + (filterTypeSwitchData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
                AbstractModRender.SetRenderOptions(false, true, true, false, false);
            });
            this.ShowSubtitlesTextSwitch = screen.CreateConfigButton(screen, category, "", -1, 0, button -> {
                this.ShowSubtitlesText = !this.ShowSubtitlesText;
                ISoundsSelectableList.Filter(((ConfigEditBoxData)this.SearchBox.GetData()).Value, this);
            }, (button, guiGraphics) -> {
                AbstractModRender.SetRenderOptions(false, false, false, false, false);
                ConfigButtonData showSubtitlesTextSwitchData = (ConfigButtonData)button.GetData();
                ModTexture texture = this.ShowSubtitlesText ? ModTexture.ShowSubtitleTextButtonIcon : ModTexture.NotShowSubtitleTextButtonIcon;
                AbstractModRender.RenderTexture(guiGraphics, texture, showSubtitlesTextSwitchData.X + (showSubtitlesTextSwitchData.Width - texture.GetWidth()) / 2, showSubtitlesTextSwitchData.Y + (showSubtitlesTextSwitchData.Height - texture.GetHeight()) / 2, 0, 0, texture.GetWidth(), texture.GetHeight());
                AbstractModRender.SetRenderOptions(false, true, true, false, false);
            });
        }
    }

    public static interface ISoundsSelectableListEntry
    extends IConfigScreenListEntry {
        public static boolean UpdateVisibility(SoundsSelectableListEntryData data) {
            return data.Visible;
        }

        public static void UpdateVisibility(boolean isVisible, SoundsSelectableListEntryData data) {
            data.Visible = isVisible;
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, SoundsSelectableListEntryData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            if (ISoundsSelectableList.IsSelected((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData())) {
                AbstractModRender.RenderRect(guiGraphics, data.X, data.Y, data.X + data.Width, data.Y + data.Height, -16777216);
            } else if (ISoundsSelectableListEntry.IsMouseOver(mouseX, mouseY, data)) {
                AbstractModRender.RenderRect(guiGraphics, data.X, data.Y, data.X + data.Width, data.Y + data.Height, 672141328);
            }
            String text = ((SoundsSelectableListData)data.List.GetData()).ShowSubtitlesText && data.SubtitleText != null && !data.SubtitleText.isEmpty() ? data.SubtitleText : data.Sound;
            AbstractModRender.RenderCenterScrollingText(guiGraphics, text, data.X + 13, data.X + data.Width - 13, data.Y + data.Height / 2 - AbstractModLogic.GetTextHeight() / 4, 0.5f, data.IsSoundIgnorable ? -3355444 : -1, true, data.IsSoundIgnorable);
        }

        public static void MouseMoved(double mouseX, double mouseY, SoundsSelectableListEntryData data) {
            data.Screen.GetData().CursorTypeRequest = "pointing_hand";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, SoundsSelectableListEntryData data) {
            ISoundVisualizerConfigScreen.FocusWidget(null, data.Screen.GetData());
            if (mouseX <= (double)(IConfigScreenList.GetRowLeft((SoundsSelectableListData)data.List.GetData()) + 12)) {
                ISoundsSelectableListEntry.SwitchFavorite(data);
                ((ISoundsSelectableListEntry)data.Instance).PlayClickSound();
            } else if (mouseX >= (double)(IConfigScreenList.GetRowRight((ConfigScreenListData)data.List.GetData()) - 12) && data.Configured) {
                ISoundsSelectableListEntry.SetConfigured(false, data);
                ((ISoundsSelectableListEntry)data.Instance).PlayClickSound();
            } else if (data.Screen.GetData().HasShiftDown) {
                ISoundsSelectableList.SelectInRange((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData());
            } else if (data.Screen.GetData().HasControlDown) {
                if (ISoundsSelectableList.IsSelected((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData())) {
                    ISoundsSelectableList.RemoveSelected((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData());
                } else {
                    ISoundsSelectableList.AddSelected((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData());
                }
            } else {
                ISoundsSelectableList.Select((ISoundsSelectableListEntry)data.Instance, (SoundsSelectableListData)data.List.GetData());
            }
            ISoundVisualizerConfigScreen.SynchWidgets(data.Screen.GetData());
            return true;
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, SoundsSelectableListEntryData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, SoundsSelectableListEntryData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, SoundsSelectableListEntryData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, SoundsSelectableListEntryData data) {
            return false;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, SoundsSelectableListEntryData data) {
            return mouseX >= (double)data.X && mouseX < (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY < (double)(data.Y + data.Height);
        }

        public static void RenderIcons(Object graphics, int mouseX, int mouseY, float partialTick, SoundsSelectableListEntryData data) {
            ModTexture texture;
            if (data.Instance == null || !data.Visible) {
                return;
            }
            SoundsSelectableListData listData = (SoundsSelectableListData)data.List.GetData();
            if (!listData.VisibleEntries.contains(data.Instance)) {
                return;
            }
            int entryIndex = listData.VisibleEntries.indexOf(data.Instance);
            boolean isHovered = ISoundsSelectableListEntry.IsMouseOver(mouseX, mouseY, data) && IConfigScreenList.GetRowTop(entryIndex, listData) < IConfigScreenList.GetBottom(listData) && IConfigScreenList.GetRowBottom(entryIndex, listData) > IConfigScreenList.GetTop(listData);
            int favoriteTexturesX = data.X;
            int favoriteTexturesY = data.Y;
            int configuredTexturesX = data.X + data.Width - ModTexture.ConfiguredSoundButton.GetWidth();
            int configuredTexturesY = data.Y;
            if (data.Favorite) {
                texture = ModTexture.FavoriteSoundButton;
                AbstractModRender.RenderTexture(graphics, texture, favoriteTexturesX, favoriteTexturesY, 0, 0, texture.GetWidth(), texture.GetHeight());
            } else if (isHovered) {
                texture = ModTexture.NotFavoriteSoundButton;
                AbstractModRender.RenderTexture(graphics, texture, favoriteTexturesX, favoriteTexturesY, 0, 0, texture.GetWidth(), texture.GetHeight());
            }
            if (isHovered && mouseX <= favoriteTexturesX + ModTexture.FavoriteSoundButton.GetWidth()) {
                texture = ModTexture.FavoriteSoundButtonsHighlight;
                AbstractModRender.RenderTexture(graphics, texture, favoriteTexturesX, favoriteTexturesY, 0, 0, texture.GetWidth(), texture.GetHeight());
            }
            if (data.Configured) {
                texture = ModTexture.ConfiguredSoundButton;
                AbstractModRender.RenderTexture(graphics, texture, configuredTexturesX, configuredTexturesY, 0, 0, texture.GetWidth(), texture.GetHeight());
                if (isHovered && mouseX >= configuredTexturesX) {
                    texture = ModTexture.ConfiguredSoundButtonHighlight;
                    AbstractModRender.RenderTexture(graphics, texture, configuredTexturesX, configuredTexturesY, 0, 0, texture.GetWidth(), texture.GetHeight());
                }
            }
        }

        public static void SwitchFavorite(SoundsSelectableListEntryData data) {
            if (AbstractConfig.ContainsInFavoriteSounds(data.Sound)) {
                AbstractConfig.RemoveFromFavoriteSounds(data.Sound);
                data.Favorite = false;
            } else {
                AbstractConfig.AddInFavoriteSounds(data.Sound);
                data.Favorite = true;
            }
            ISoundsSelectableList.Filter(((ConfigEditBoxData)((SoundsSelectableListData)data.List.GetData()).SearchBox.GetData()).Value, (SoundsSelectableListData)data.List.GetData());
        }

        public static void SetConfigured(boolean isConfigured, SoundsSelectableListEntryData data) {
            if (!isConfigured) {
                AbstractConfig.RemoveIndividuallyConfiguredSound(data.Sound);
            }
            data.Configured = isConfigured;
        }

        public void PlayClickSound();
    }

    public static class SoundsSelectableListEntryData
    extends ConfigScreenListEntryData {
        public String SubtitleText = "";
        public String Sound = "";
        public boolean IsSoundIgnorable = false;
        public boolean Favorite = false;
        public boolean Configured = false;

        public SoundsSelectableListEntryData(ISoundVisualizerConfigScreen screen, IConfigScreenList list, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, list, instance, category);
        }
    }

    public static interface IConfigEditBox
    extends IConfigScreenWidget {
        public static void BaseSetup(Consumer<String> responder, Predicate<String> filter, ConfigEditBoxData data) {
            if (responder != null) {
                data.Responder = responder;
            }
            if (filter != null) {
                data.Filter = filter;
            }
        }

        public static boolean UpdateVisibility(ConfigEditBoxData data) {
            return IConfigScreenChild.UpdateVisibility(data);
        }

        public static void UpdateVisibility(boolean isVisible, ConfigEditBoxData data) {
            IConfigScreenChild.UpdateVisibility(data);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigEditBoxData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            AbstractModRender.SetRenderOptions(true, false, false, false, false);
            int textColor = -1;
            int hintTextColor = -6250336;
            int innerWidth = IConfigEditBox.GetInnerWidth(data);
            int cursorDisplayPos = data.CursorPosition - data.DisplayPosition;
            String displayText = AbstractModLogic.GetPlainTextByWidth(data.Value.substring(data.DisplayPosition), innerWidth);
            boolean cursorBetweenDisplayText = cursorDisplayPos >= 0 && cursorDisplayPos <= displayText.length();
            boolean cursorBetweenText = data.CursorPosition < data.Value.length() || data.Value.length() >= data.MaxLength;
            boolean cursorVisible = data.Focused && cursorBetweenDisplayText && (AbstractModLogic.GetMillis() - data.FocusTime) % 600L < 300L;
            int textX = data.X + 4;
            int textY = data.Y + (data.Height - 8) / 2;
            int cursorX = textX;
            int cursorY = textY;
            int cursorEndY = textY + AbstractModLogic.GetTextHeight() + 1;
            int highlightDisplayPos = Math.clamp((long)(data.HighlightPosition - data.DisplayPosition), 0, displayText.length());
            AbstractModRender.RenderRect(guiGraphics, data.X, data.Y, data.X + data.Width, data.Y + data.Height, data.Focused ? -1 : -6250336);
            AbstractModRender.RenderRect(guiGraphics, data.X + 1, data.Y + 1, data.X + data.Width - 1, data.Y + data.Height - 1, -16777216);
            if (!displayText.isEmpty()) {
                AbstractModRender.RenderGUIText(guiGraphics, displayText, textX, textY, textColor, true, false);
                cursorX += AbstractModLogic.GetTextWidth(displayText.substring(0, Math.min(displayText.length(), cursorDisplayPos))) + 1;
            }
            if (data.HintTextKey != null && displayText.isEmpty() && !data.Focused) {
                AbstractModRender.RenderLeftScrollingText(guiGraphics, AbstractModLogic.GetTextTranslate(data.HintTextKey), textX, textX + innerWidth, textY, 1.0f, hintTextColor, true, false);
            }
            if (!cursorBetweenDisplayText) {
                cursorX = cursorDisplayPos > 0 ? textX + data.Width : textX;
            } else if (cursorBetweenText) {
                --cursorX;
                --cursorY;
            }
            if (cursorVisible) {
                if (cursorBetweenText) {
                    AbstractModRender.RenderRect(guiGraphics, cursorX, cursorY, cursorX + 1, cursorEndY, textColor);
                } else {
                    AbstractModRender.RenderGUIText(guiGraphics, "_", cursorX, cursorY, textColor, true, false);
                }
            }
            if (highlightDisplayPos != cursorDisplayPos) {
                int highlightDisplayEndPos = textX + AbstractModLogic.GetTextWidth(displayText.substring(0, highlightDisplayPos));
                IConfigEditBox.RenderHighlight(guiGraphics, cursorX, textY - 1, highlightDisplayEndPos - 1, cursorEndY - 1, data);
            }
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigEditBoxData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            ISoundVisualizerConfigScreen.HoverWidget(data.Instance, screenData);
            screenData.CursorTypeRequest = "ibeam";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, ConfigEditBoxData data) {
            if (data.Instance == null || !data.Visible || !IConfigEditBox.IsMouseOver(mouseX, mouseY, data)) {
                return false;
            }
            ISoundVisualizerConfigScreen.FocusWidget(data.Instance, data.Screen.GetData());
            return data.Instance.SuperMouseClicked(mouseX, mouseY, button);
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, ConfigEditBoxData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, ConfigEditBoxData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, ConfigEditBoxData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, ConfigEditBoxData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (data.Focused) {
                return data.Instance.SuperKeyPressed(keyCode, scanCode, modifiers);
            }
            if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigCopy, keyCode, scanCode, modifiers)) {
                if (data.Category.IsDSI()) {
                    AbstractConfig.DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    if (screenData.DSIBuffer.containsKey((Object)config)) {
                        screenData.DSIBuffer.replace(config, data.Value);
                    } else {
                        screenData.DSIBuffer.put(config, data.Value);
                    }
                    return true;
                }
                if (data.Category.IsSubtitle()) {
                    AbstractConfig.SubtitleConfig config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false);
                    if (screenData.SubtitleBuffer.containsKey((Object)config)) {
                        screenData.SubtitleBuffer.replace(config, data.Value);
                    } else {
                        screenData.SubtitleBuffer.put(config, data.Value);
                    }
                    return true;
                }
            } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigPaste, keyCode, scanCode, modifiers)) {
                Object object;
                AbstractConfig.SubtitleConfig config;
                if (data.Category.IsDSI()) {
                    Object object2;
                    AbstractConfig.DirectionalSoundIndicatorConfig config2 = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    if (screenData.DSIBuffer.containsKey((Object)config2) && (object2 = screenData.DSIBuffer.get((Object)config2)) instanceof String) {
                        String newValue;
                        data.Value = newValue = (String)object2;
                        return true;
                    }
                } else if (data.Category.IsSubtitle() && screenData.SubtitleBuffer.containsKey((Object)(config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false))) && (object = screenData.SubtitleBuffer.get((Object)config)) instanceof String) {
                    String newValue;
                    data.Value = newValue = (String)object;
                    return true;
                }
            }
            return false;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, ConfigEditBoxData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static void SetValue(String text, ConfigEditBoxData data) {
            if (text == null) {
                text = "";
            }
            if (data.Filter.test(text)) {
                data.Value = text.length() > data.MaxLength ? text.substring(0, data.MaxLength) : text;
                IConfigEditBox.MoveCursorToEnd(false, data);
                IConfigEditBox.SetHighlightPos(data.CursorPosition, data);
                IConfigEditBox.OnValueChange(text, data);
            }
        }

        public static String GetHighlighted(ConfigEditBoxData data) {
            int start = Math.min(data.CursorPosition, data.HighlightPosition);
            int end = Math.max(data.CursorPosition, data.HighlightPosition);
            return data.Value.substring(start, end);
        }

        public static void InsertText(String text, ConfigEditBoxData data) {
            String insertedText;
            String filteredText;
            int filteredTextLength;
            if (text == null) {
                text = "";
            }
            int start = Math.min(data.CursorPosition, data.HighlightPosition);
            int end = Math.max(data.CursorPosition, data.HighlightPosition);
            int emptyLength = data.MaxLength - data.Value.length() - (start - end);
            if (emptyLength < (filteredTextLength = (filteredText = AbstractModLogic.GetFilteredText(text)).length())) {
                filteredText = filteredText.substring(0, emptyLength);
                filteredTextLength = emptyLength;
            }
            if (data.Filter.test(insertedText = new StringBuilder(data.Value).replace(start, end, filteredText).toString())) {
                data.Value = insertedText;
                IConfigEditBox.SetCursorPosition(start + filteredTextLength, data);
                IConfigEditBox.SetHighlightPos(data.CursorPosition, data);
                IConfigEditBox.OnValueChange(data.Value, data);
            }
        }

        public static void DeleteWords(int word, ConfigEditBoxData data) {
            if (!data.Value.isEmpty()) {
                if (data.HighlightPosition != data.CursorPosition) {
                    IConfigEditBox.InsertText("", data);
                } else {
                    IConfigEditBox.DeleteChars(IConfigEditBox.GetWordPosition(word - data.CursorPosition, data), data);
                }
            }
        }

        public static void DeleteChars(int position, ConfigEditBoxData data) {
            if (!data.Value.isEmpty()) {
                if (data.HighlightPosition != data.CursorPosition) {
                    IConfigEditBox.InsertText("", data);
                } else {
                    String undeletedText;
                    int end;
                    int cursorPosititon = IConfigEditBox.GetCursorPos(position, data);
                    int start = Math.min(cursorPosititon, data.CursorPosition);
                    if (start != (end = Math.max(cursorPosititon, data.CursorPosition)) && data.Filter.test(undeletedText = new StringBuilder(data.Value).delete(start, end).toString())) {
                        data.Value = undeletedText;
                        IConfigEditBox.MoveCursorTo(start, false, data);
                        IConfigEditBox.OnValueChange(data.Value, data);
                    }
                }
            }
        }

        public static void MoveCursorTo(int position, boolean ignoreHighlight, ConfigEditBoxData data) {
            IConfigEditBox.SetCursorPosition(position, data);
            if (!data.Screen.GetData().HasShiftDown) {
                IConfigEditBox.SetHighlightPos(data.CursorPosition, data);
            }
        }

        public static void MoveCursor(int steps, boolean ignoreHighlight, ConfigEditBoxData data) {
            IConfigEditBox.MoveCursorTo(IConfigEditBox.GetCursorPos(steps, data), ignoreHighlight, data);
        }

        public static void SetCursorPosition(int position, ConfigEditBoxData data) {
            data.CursorPosition = Math.clamp((long)position, 0, data.Value.length());
        }

        public static void MoveCursorToEnd(boolean ignoreHighlight, ConfigEditBoxData data) {
            IConfigEditBox.MoveCursorTo(data.Value.length(), ignoreHighlight, data);
        }

        public static void OnClick(double mouseX, double mouseY, ConfigEditBoxData data) {
            String text = AbstractModLogic.GetPlainTextByWidth(data.Value.substring(data.DisplayPosition), IConfigEditBox.GetInnerWidth(data));
            IConfigEditBox.MoveCursorTo(AbstractModLogic.GetPlainTextByWidth(text, (int)mouseX - data.X - 4).length() + data.DisplayPosition, data.Screen.GetData().HasShiftDown, data);
        }

        public static void SetHighlightPos(int position, ConfigEditBoxData data) {
            data.HighlightPosition = Math.clamp((long)position, 0, data.Value.length());
            IConfigEditBox.ScrollTo(data.HighlightPosition, data);
        }

        public static int GetWordPosition(int position, ConfigEditBoxData data) {
            return IConfigEditBox.GetWordPosition(position, IConfigEditBox.GetCursorPosition(data), data);
        }

        public static boolean CanConsumeInput(ConfigEditBoxData data) {
            return data.Visible && data.Focused;
        }

        public static int GetCursorPosition(ConfigEditBoxData data) {
            return data.CursorPosition;
        }

        public static void OnValueChange(String text, ConfigEditBoxData data) {
            if (data.Responder != null) {
                data.Responder.accept(text);
            }
        }

        public static void ScrollTo(int position, ConfigEditBoxData data) {
            data.DisplayPosition = Math.min(data.DisplayPosition, data.Value.length());
            int innerWidth = IConfigEditBox.GetInnerWidth(data);
            String visibleText = AbstractModLogic.GetPlainTextByWidth(data.Value.substring(data.DisplayPosition), innerWidth);
            int visiblePosition = visibleText.length() + data.DisplayPosition;
            if (position == data.DisplayPosition) {
                data.DisplayPosition -= AbstractModLogic.GetPlainTextByWidth(data.Value, innerWidth).length();
            }
            if (position > visiblePosition) {
                data.DisplayPosition += position - visiblePosition;
            } else if (position <= data.DisplayPosition) {
                data.DisplayPosition -= data.DisplayPosition - position;
            }
            data.DisplayPosition = Math.clamp((long)data.DisplayPosition, 0, data.Value.length());
        }

        public static int GetWordPosition(int position, int index, ConfigEditBoxData data) {
            return IConfigEditBox.GetWordPosition(position, index, true, data);
        }

        public static int GetWordPosition(int position, int index, boolean allWords, ConfigEditBoxData data) {
            boolean flag = position < 0;
            position = Math.abs(position);
            for (int i = 0; i < position; ++i) {
                if (!flag) {
                    int valueLength = data.Value.length();
                    if ((index = data.Value.indexOf(32, index)) == -1) {
                        index = valueLength;
                        continue;
                    }
                    while (allWords && index < valueLength && data.Value.charAt(index) == ' ') {
                        ++index;
                    }
                    continue;
                }
                while (allWords && index > 0 && data.Value.charAt(index - 1) == ' ') {
                    --index;
                }
                while (index > 0 && data.Value.charAt(index - 1) != ' ') {
                    --index;
                }
            }
            return index;
        }

        public static int GetCursorPos(int delta, ConfigEditBoxData data) {
            return AbstractModLogic.OffsetByCodepoints(data.Value, data.CursorPosition, delta);
        }

        public static int GetScreenX(int maxLength, ConfigEditBoxData data) {
            return maxLength > data.Value.length() ? data.X : data.X + AbstractModLogic.GetTextWidth(data.Value.substring(0, maxLength));
        }

        public static void RenderHighlight(Object graphics, int minX, int minY, int maxX, int maxY, ConfigEditBoxData data) {
            int oldMin;
            if (minX < maxX) {
                oldMin = minX;
                minX = maxX;
                maxX = oldMin;
            }
            if (minY < maxY) {
                oldMin = minY;
                minY = maxY;
                maxY = oldMin;
            }
            if (maxX > data.X + data.Width - 1) {
                maxX = data.X + data.Width - 1;
            }
            if (minX > data.X + data.Width - 1) {
                minX = data.X + data.Width - 1;
            }
            AbstractModRender.RenderHighlightRect(graphics, minX, minY, maxX, maxY, -16776961);
        }

        public static int GetInnerWidth(ConfigEditBoxData data) {
            return Math.max(data.Width - 6, 0);
        }

        public static void SynchValue(ConfigEditBoxData data) {
            if (data.ConfigID >= 0) {
                Object newValue = ISoundVisualizerConfigScreen.GetButtonsValue(data.Category, data.ConfigID, data.Screen.GetData());
                data.Value = (String)newValue;
                data.DisplayPosition = 0;
                data.CursorPosition = data.Value.length();
                data.HighlightPosition = data.Value.length();
            }
        }
    }

    public static class ConfigEditBoxData
    extends ConfigScreenWidgetData {
        public String HintTextKey = "";
        public String Value = "";
        public int MaxLength = 16;
        public int DisplayPosition = 0;
        public int CursorPosition = 0;
        public int HighlightPosition = 0;
        public long FocusTime = 0L;
        public Consumer<String> Responder = value -> ISoundVisualizerConfigScreen.SetButtonsValue(this.Category, this.ConfigID, value, this.Screen.GetData());
        public Predicate<String> Filter = value -> true;

        public ConfigEditBoxData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static interface IRect
    extends IConfigScreenChild {
        public static boolean UpdateVisibility(RectData data) {
            return IConfigScreenChild.UpdateVisibility(data);
        }

        public static void UpdateVisibility(boolean isVisible, RectData data) {
            IConfigScreenChild.UpdateVisibility(data);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, RectData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            AbstractModRender.SetRenderOptions(true, true, true, false, false);
            int x = IRect.GetX(data);
            int y = IRect.GetY(data);
            int width = IRect.GetWidth(data);
            int height = IRect.GetHeight(data);
            int backGroundX0 = x;
            int backGroundY0 = y + 2;
            int backGroundX1 = x + width;
            int backGroundY1 = y + height;
            int separatorX0 = x;
            int separatorY0 = y;
            int separatorX1 = x + width;
            int separatorY1 = y + 2;
            boolean isDirectionVertical = data.Direction == 1 || data.Direction == 3;
            ModTexture separatorTexture = ModTexture.RectUpSeparator;
            ModTexture openedSeparatorTexture = ModTexture.RectUpOpenedSeparator;
            switch (data.Direction) {
                case 1: {
                    backGroundX0 = x;
                    backGroundY0 = y;
                    backGroundX1 = x + width - 2;
                    backGroundY1 = y + height;
                    separatorX0 = x + width - 2;
                    separatorY0 = y;
                    separatorX1 = x + width;
                    separatorY1 = y + height;
                    separatorTexture = ModTexture.RectRightSeparator;
                    openedSeparatorTexture = ModTexture.RectRightOpenedSeparator;
                    break;
                }
                case 2: {
                    backGroundX0 = x;
                    backGroundY0 = y;
                    backGroundX1 = x + width;
                    backGroundY1 = y + height - 2;
                    separatorX0 = x;
                    separatorY0 = y + height - 2;
                    separatorX1 = x + width;
                    separatorY1 = y + height;
                    separatorTexture = ModTexture.RectDownSeparator;
                    openedSeparatorTexture = ModTexture.RectDownOpenedSeparator;
                    break;
                }
                case 3: {
                    backGroundX0 = x + 2;
                    backGroundY0 = y;
                    backGroundX1 = x + width;
                    backGroundY1 = y + height;
                    separatorX0 = x;
                    separatorY0 = y;
                    separatorX1 = x + 2;
                    separatorY1 = y + height;
                    separatorTexture = ModTexture.RectLeftSeparator;
                    openedSeparatorTexture = ModTexture.RectLeftOpenedSeparator;
                }
            }
            if (data.ListWindow) {
                ModTexture texture = ModTexture.ListWindow;
                int listWindowX0 = data.ListWindowCorners[0];
                int listWindowY0 = data.ListWindowCorners[1];
                int listWindowX1 = data.ListWindowCorners[2];
                int listWindowY1 = data.ListWindowCorners[3];
                AbstractModRender.RenderTextureWithBorder(guiGraphics, texture, listWindowX0, listWindowY0, 0, 0, listWindowX1 - listWindowX0, listWindowY1 - listWindowY0, 4);
                AbstractModRender.RenderRect(guiGraphics, backGroundX0, backGroundY0, backGroundX1, listWindowY0, 0x40000000);
                AbstractModRender.RenderRect(guiGraphics, backGroundX0, listWindowY0, listWindowX0, listWindowY1, 0x40000000);
                AbstractModRender.RenderRect(guiGraphics, listWindowX1, listWindowY0, backGroundX1, listWindowY1, 0x40000000);
                AbstractModRender.RenderRect(guiGraphics, backGroundX0, listWindowY1, backGroundX1, backGroundY1, 0x40000000);
            } else {
                AbstractModRender.RenderRect(guiGraphics, backGroundX0, backGroundY0, backGroundX1, backGroundY1, 0x40000000);
            }
            AbstractModRender.SetRenderOptions(true, true, true, false, false);
            ArrayList<ITab> selectedTabs = new ArrayList<ITab>(data.StreamlinedTabs);
            selectedTabs.removeIf(tab -> !((TabData)tab.GetData()).Selected);
            if (selectedTabs.isEmpty()) {
                if (isDirectionVertical) {
                    AbstractModRender.RenderTextureWithVerticalBorder(guiGraphics, separatorTexture, separatorX0, separatorY0, 0, 0, separatorX1 - separatorX0, separatorY1 - separatorY0, 2);
                } else {
                    AbstractModRender.RenderTextureWithHorizontalBorder(guiGraphics, separatorTexture, separatorX0, separatorY0, 0, 0, separatorX1 - separatorX0, separatorY1 - separatorY0, 2);
                }
            } else {
                int selectedTabIndex = data.StreamlinedTabs.indexOf(selectedTabs.getFirst());
                int selectedTabX0 = data.StreamlinedTabsCorners.get(selectedTabIndex)[0];
                int selectedTabY0 = data.StreamlinedTabsCorners.get(selectedTabIndex)[1];
                int selectedTabX1 = data.StreamlinedTabsCorners.get(selectedTabIndex)[2];
                int selectedTabY1 = data.StreamlinedTabsCorners.get(selectedTabIndex)[3];
                if (isDirectionVertical) {
                    int separatorX = separatorX0;
                    int separatorWidth = separatorX1 - separatorX0;
                    AbstractModRender.RenderTextureWithVerticalBorder(guiGraphics, openedSeparatorTexture, separatorX, selectedTabY0, 0, 0, separatorWidth, selectedTabY1 - selectedTabY0, 2);
                    AbstractModRender.RenderTextureWithVerticalBorder(guiGraphics, separatorTexture, separatorX, separatorY0, 0, 0, separatorWidth, selectedTabY0 - separatorY0, 2);
                    AbstractModRender.RenderTextureWithVerticalBorder(guiGraphics, separatorTexture, separatorX, selectedTabY1, 0, 0, separatorWidth, separatorY1 - selectedTabY1, 2);
                } else {
                    int separatorY = separatorY0;
                    int separatorHeight = separatorY1 - separatorY0;
                    AbstractModRender.RenderTextureWithHorizontalBorder(guiGraphics, openedSeparatorTexture, selectedTabX0, separatorY, 0, 0, selectedTabX1 - selectedTabX0, separatorHeight, 2);
                    AbstractModRender.RenderTextureWithHorizontalBorder(guiGraphics, separatorTexture, separatorX0, separatorY, 0, 0, selectedTabX0 - separatorX0, separatorHeight, 2);
                    AbstractModRender.RenderTextureWithHorizontalBorder(guiGraphics, separatorTexture, selectedTabX1, separatorY, 0, 0, separatorX1 - selectedTabX1, separatorHeight, 2);
                }
            }
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, RectData data) {
            data.Screen.GetData().CursorTypeRequest = "arrow";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, RectData data) {
            return false;
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, RectData data) {
            return false;
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, RectData data) {
            return false;
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, RectData data) {
            return false;
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, RectData data) {
            return false;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, RectData data) {
            return false;
        }

        public static int GetX(RectData data) {
            return data.X;
        }

        public static int GetY(RectData data) {
            return data.Y;
        }

        public static int GetWidth(RectData data) {
            return data.Width;
        }

        public static int GetHeight(RectData data) {
            return data.Height;
        }
    }

    public static class RectData
    extends ConfigScreenChildData {
        public int Direction = 0;
        public ArrayList<ITab> StreamlinedTabs = new ArrayList();
        public ArrayList<int[]> StreamlinedTabsCorners = new ArrayList();
        public boolean ListWindow = false;
        public int[] ListWindowCorners = new int[]{0, 0, 0, 0};

        public RectData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static interface ITab
    extends IConfigScreenChild {
        public static boolean UpdateVisibility(TabData data) {
            return data.Visible;
        }

        public static void UpdateVisibility(boolean isVisible, TabData data) {
            data.Visible = isVisible;
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, TabData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            AbstractModRender.SetRenderOptions(true, true, true, false, false);
            String text = AbstractModLogic.GetTextTranslate(data.TextKey);
            int textWidth = AbstractModLogic.GetTextWidth(text);
            int x = ITab.GetX(data);
            int y = ITab.GetY(data);
            int width = ITab.GetWidth(data);
            int height = ITab.GetHeight(data);
            int fontUnderlineX0 = Math.max(x + width / 2 - textWidth / 2, x + 3);
            int fontUnderlineY0 = y + height;
            int fontUnderlineX1 = Math.min(fontUnderlineX0 + textWidth, x + width - 3);
            int fontUnderlineY1 = fontUnderlineY0 + 1;
            ModTexture texture = data.Selected ? ModTexture.SelectedTab : ModTexture.Tab;
            AbstractModRender.RenderTextureWithBorder(guiGraphics, texture, x, y, 0, 0, width, height, 4);
            if (ITab.IsMouseOver(mouseX, mouseY, data)) {
                texture = data.Selected ? ModTexture.SelectedTabHighlight : ModTexture.TabHighlight;
                AbstractModRender.RenderTextureWithBorder(guiGraphics, texture, x, y, 0, 0, width, height + 1, 4);
            }
            if (data.Selected) {
                AbstractModRender.RenderRect(guiGraphics, fontUnderlineX0, fontUnderlineY0, fontUnderlineX1, fontUnderlineY1, -1);
            }
            AbstractModRender.RenderCenterScrollingText(guiGraphics, text, x + 3, x + width - 3, y + (int)Math.ceil((double)(height - AbstractModLogic.GetTextHeight()) / 2.0) + 1, 1.0f, -1, true, false);
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, TabData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            ISoundVisualizerConfigScreen.HoverWidget(data.Instance, screenData);
            screenData.CursorTypeRequest = data.Selected ? "arrow" : "pointing_hand";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, TabData data) {
            if (data.Instance == null || !data.Visible || !ITab.IsMouseOver(mouseX, mouseY, data)) {
                return false;
            }
            if (data.Selected) {
                return true;
            }
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            screenData.CursorTypeRequest = "arrow";
            ISoundVisualizerConfigScreen.SwitchTab(data.Category, screenData);
            ISoundVisualizerConfigScreen.FocusWidget(data.Instance, screenData);
            return data.Instance.SuperMouseClicked(mouseX, mouseY, button);
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, TabData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, TabData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, TabData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, TabData data) {
            if (data.Instance == null || !data.Visible || !Objects.equals(data.Screen.GetData().Hovered, data.Instance)) {
                return false;
            }
            return data.Instance.SuperKeyPressed(keyCode, scanCode, modifiers);
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, TabData data) {
            boolean inHorizontal;
            boolean bl = inHorizontal = mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width);
            if (data.Selected) {
                return inHorizontal && mouseY >= (double)(data.Y - 4) && mouseY <= (double)(data.Y + data.Height + 4);
            }
            return inHorizontal && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static int GetX(TabData data) {
            return data.X;
        }

        public static int GetY(TabData data) {
            if (data.Selected) {
                return data.Y - 4;
            }
            return data.Y;
        }

        public static int GetWidth(TabData data) {
            return data.Width;
        }

        public static int GetHeight(TabData data) {
            if (data.Selected) {
                return data.Height + 4;
            }
            return data.Height;
        }
    }

    public static class TabData
    extends ConfigScreenChildData {
        public String TextKey = "";
        public boolean Selected = false;

        public TabData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static interface IConfigsList
    extends IConfigScreenList {
        public static void BaseSetup(ConfigsListData data) {
            data.HeaderHeight = AbstractModLogic.GetTextHeight() + 5;
            data.HideFullScrollbar = true;
            data.ItemHeight = 20;
            data.ItemSplitHeight = 3;
            data.ScrollbarSplitWidth = 3;
            data.ScrollbarVisible = true;
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigsListData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            if (data.HeadlineTextKey != null && !data.HeadlineTextKey.isEmpty()) {
                AbstractModRender.RenderCenterScrollingText(guiGraphics, AbstractModLogic.GetTextTranslate(data.HeadlineTextKey), data.X, data.X + data.Width, data.Y, 1.0f, -1, true, false);
            }
            IConfigScreenList.Render(guiGraphics, mouseX, mouseY, partialTick, data);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigsListData data) {
            IConfigScreenList.MouseMoved(mouseX, mouseY, data);
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, ConfigsListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (mouseY >= (double)IConfigScreenList.GetTop(data) && mouseY <= (double)IConfigScreenList.GetBottom(data)) {
                IConfigsListEntry entry;
                IConfigScreenChild iConfigScreenChild = data.Instance;
                if (iConfigScreenChild instanceof IConfigScreenList) {
                    IConfigScreenList list = (IConfigScreenList)iConfigScreenChild;
                    list.UpdateScrollingState(mouseX, mouseY, button);
                }
                if ((entry = (IConfigsListEntry)IConfigScreenList.GetEntryAtPosition(mouseX, mouseY, data)) != null) {
                    return entry.MouseClicked(mouseX, mouseY, button);
                }
                if (IConfigScreenList.IsMouseOverScrollbar(mouseX, mouseY, data)) {
                    SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
                    screenData.IsMouseDragging = true;
                    screenData.CursorTypeRequest = "resize_ns";
                    ISoundVisualizerConfigScreen.FocusWidget(data.Instance, screenData);
                    return true;
                }
            }
            return false;
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, ConfigScreenListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            boolean isSomethingDragged = data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
            for (IConfigScreenListEntry entry : data.VisibleEntries) {
                if (isSomethingDragged) break;
                isSomethingDragged = IConfigsListEntry.MouseDragged(mouseX, mouseY, button, dragX, dragY, (ConfigsListEntryData)entry.GetData());
            }
            data.ScrollAmount = ((IConfigScreenList)data.Instance).GetScroll();
            return isSomethingDragged;
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, ConfigScreenListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            boolean isSomethingRelased = false;
            for (IConfigScreenListEntry entry : data.VisibleEntries) {
                if (isSomethingRelased) break;
                isSomethingRelased = IConfigsListEntry.MouseReleased(mouseX, mouseY, button, (ConfigsListEntryData)entry.GetData());
            }
            return isSomethingRelased;
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, ConfigScreenListData data) {
            IConfigScreenListEntry entry;
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            if (!data.Screen.GetData().HasControlDown && (entry = IConfigScreenList.GetEntryAtPosition(mouseX, mouseY, data)) != null && IConfigsListEntry.MouseScrolled(mouseX, mouseY, scrollX, scrollY, (ConfigsListEntryData)entry.GetData())) {
                return true;
            }
            if (data.Screen.GetData().HasShiftDown) {
                scrollX *= 10.0;
                scrollY *= 10.0;
            }
            boolean isScrolled = data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
            data.ScrollAmount = ((IConfigScreenList)data.Instance).GetScroll();
            return isScrolled;
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, ConfigScreenListData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            boolean isSomethingPressed = false;
            for (IConfigScreenListEntry entry : data.VisibleEntries) {
                isSomethingPressed = isSomethingPressed || entry.KeyPressed(keyCode, scanCode, modifiers);
            }
            return isSomethingPressed;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, ConfigsListData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public void AddWidget(IConfigScreenWidget var1);
    }

    public static class ConfigsListData
    extends ConfigScreenListData {
        public String HeadlineTextKey = "";

        public ConfigsListData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static interface IConfigScreenList
    extends IConfigScreenChild {
        public static boolean UpdateVisibility(ConfigScreenListData data) {
            IConfigScreenChild.UpdateVisibility(data);
            data.AllEntries.forEach(entry -> entry.UpdateVisibility(data.Visible));
            return data.Visible;
        }

        public static void UpdateVisibility(boolean isVisible, ConfigScreenListData data) {
            IConfigScreenChild.UpdateVisibility(isVisible, data);
            data.AllEntries.forEach(entry -> entry.UpdateVisibility(data.Visible));
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigScreenListData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            IConfigScreenList.EnableScissor(guiGraphics, data);
            int top = IConfigScreenList.GetTop(data);
            int bottom = IConfigScreenList.GetBottom(data);
            int rowLeft = IConfigScreenList.GetRowLeft(data);
            int rowWidth = IConfigScreenList.GetRowWidth(data);
            for (int i = 0; i < data.VisibleEntries.size(); ++i) {
                int rowTop = IConfigScreenList.GetRowTop(i, data);
                int rowBottom = IConfigScreenList.GetRowBottom(i, data);
                IConfigScreenListEntry entry = data.VisibleEntries.get(i);
                if (rowBottom < top || rowTop > bottom) continue;
                entry.SetBase(rowLeft, rowTop, rowWidth, data.ItemHeight);
                entry.Render(guiGraphics, mouseX, mouseY, partialTick);
            }
            AbstractModRender.DisableScissor(guiGraphics);
            if (data.ScrollbarVisible && (IConfigScreenList.GetMaxScroll(data) > 0 || !data.HideFullScrollbar)) {
                int scrollbarX = IConfigScreenList.GetScrollbarX(data);
                AbstractModRender.RenderTextureWithBorder(guiGraphics, ModTexture.ListScrollbar, scrollbarX, top, 0, 0, data.ScrollbarWidth, bottom - top, 2);
                AbstractModRender.RenderTextureWithBorder(guiGraphics, ModTexture.ListScroller, scrollbarX, IConfigScreenList.GetScrollbarY(data), 0, 0, data.ScrollbarWidth, IConfigScreenList.GetScrollbarHeight(data), 2);
            }
            AbstractModRender.SetRenderOptions(false, true, true, true, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigScreenListData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (mouseX >= (double)IConfigScreenList.GetRowLeft(data) && mouseX <= (double)IConfigScreenList.GetRowRight(data) && mouseY >= (double)IConfigScreenList.GetTop(data) && mouseY <= (double)IConfigScreenList.GetBottom(data)) {
                IConfigScreenListEntry entry = IConfigScreenList.GetEntryAtPosition(mouseX, mouseY, data);
                if (entry != null) {
                    entry.MouseMoved(mouseX, mouseY);
                } else {
                    ISoundVisualizerConfigScreen.HoverWidget(null, screenData);
                    screenData.CursorTypeRequest = "arrow";
                }
            } else if (IConfigScreenList.IsMouseOverScrollbar(mouseX, mouseY, data)) {
                ISoundVisualizerConfigScreen.HoverWidget(data.Instance, screenData);
                screenData.CursorTypeRequest = "pointing_hand";
            } else {
                ISoundVisualizerConfigScreen.HoverWidget(null, screenData);
                screenData.CursorTypeRequest = "arrow";
            }
        }

        public static void EnableScissor(Object guiGraphics, ConfigScreenListData data) {
            AbstractModRender.EnableScissor(guiGraphics, IConfigScreenList.GetLeft(data), IConfigScreenList.GetTop(data), IConfigScreenList.GetRight(data), IConfigScreenList.GetBottom(data));
        }

        public static int GetLeft(ConfigScreenListData data) {
            return data.X;
        }

        public static int GetTop(ConfigScreenListData data) {
            return data.Y + data.HeaderHeight;
        }

        public static int GetRight(ConfigScreenListData data) {
            return data.X + data.Width;
        }

        public static int GetBottom(ConfigScreenListData data) {
            return data.Y + data.Height;
        }

        public static int GetRowWidth(ConfigScreenListData data) {
            if (IConfigScreenList.GetMaxScroll(data) == 0 && data.HideFullScrollbar) {
                return data.Width;
            }
            return data.Width - data.ScrollbarWidth - data.ScrollbarSplitWidth;
        }

        public static int GetRowLeft(ConfigScreenListData data) {
            return IConfigScreenList.GetLeft(data);
        }

        public static int GetRowRight(ConfigScreenListData data) {
            return IConfigScreenList.GetRowLeft(data) + IConfigScreenList.GetRowWidth(data);
        }

        public static int GetRowTop(int entryIndex, ConfigScreenListData data) {
            return IConfigScreenList.GetTop(data) - (int)data.ScrollAmount + entryIndex * (data.ItemHeight + data.ItemSplitHeight);
        }

        public static int GetRowBottom(int entryIndex, ConfigScreenListData data) {
            return IConfigScreenList.GetRowTop(entryIndex, data) + data.ItemHeight;
        }

        public static int GetScrollbarPosition(ConfigScreenListData data) {
            return data.X + data.Width - data.ScrollbarWidth;
        }

        public static int GetScrollbarX(ConfigScreenListData data) {
            return IConfigScreenList.GetScrollbarPosition(data);
        }

        public static int GetScrollbarY(ConfigScreenListData data) {
            int top = IConfigScreenList.GetTop(data);
            int bottom = IConfigScreenList.GetBottom(data);
            int maxScroll = IConfigScreenList.GetMaxScroll(data);
            if (maxScroll > 0) {
                return Math.max(top + (int)data.ScrollAmount * (bottom - top - IConfigScreenList.GetScrollbarHeight(data)) / maxScroll, top);
            }
            return top;
        }

        public static int GetScrollbarHeight(ConfigScreenListData data) {
            int top = IConfigScreenList.GetTop(data);
            int bottom = IConfigScreenList.GetBottom(data);
            int maxPosition = IConfigScreenList.GetMaxPosition(data);
            if (maxPosition > 0) {
                return Math.clamp((long)((int)(Math.pow(bottom - top, 2.0) / (double)maxPosition)), 32, bottom - top);
            }
            return bottom - top;
        }

        public static double GetScrollRate(ConfigScreenListData data) {
            return (double)(data.ItemHeight + data.ItemSplitHeight) / 2.0;
        }

        public static int GetMaxScroll(ConfigScreenListData data) {
            if (data.VisibleEntries.size() == 0) {
                return 0;
            }
            return Math.max(0, IConfigScreenList.GetMaxPosition(data) - (IConfigScreenList.GetBottom(data) - IConfigScreenList.GetTop(data)));
        }

        public static int GetMaxPosition(ConfigScreenListData data) {
            int visibleItemsSize = data.VisibleEntries.size();
            if (visibleItemsSize == 0) {
                return 0;
            }
            return visibleItemsSize * data.ItemHeight + (visibleItemsSize - 1) * data.ItemSplitHeight;
        }

        public static boolean IsMouseOverScrollbar(double mouseX, double mouseY, ConfigScreenListData data) {
            int scrollbarY = IConfigScreenList.GetScrollbarY(data);
            return data.ScrollbarVisible && mouseX >= (double)IConfigScreenList.GetScrollbarX(data) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + IConfigScreenList.GetScrollbarHeight(data));
        }

        public static IConfigScreenListEntry GetEntryAtPosition(double mouseX, double mouseY, ConfigScreenListData data) {
            int entryIndex = (int)(mouseY - (double)IConfigScreenList.GetTop(data) + data.ScrollAmount) / (data.ItemHeight + data.ItemSplitHeight);
            if (entryIndex >= 0 && data.VisibleEntries.size() > entryIndex && mouseX >= (double)IConfigScreenList.GetRowLeft(data) && mouseX <= (double)IConfigScreenList.GetRowRight(data) && mouseY >= (double)IConfigScreenList.GetRowTop(entryIndex, data) && mouseY <= (double)IConfigScreenList.GetRowBottom(entryIndex, data)) {
                return data.VisibleEntries.get(entryIndex);
            }
            return null;
        }

        public static Optional<Object> GetChildAt(double mouseX, double mouseY, ConfigScreenListData data) {
            IConfigScreenListEntry child = IConfigScreenList.GetEntryAtPosition(mouseX, mouseY, data);
            if (child != null) {
                return Optional.of(child);
            }
            return Optional.empty();
        }

        public static IConfigScreenListEntry GetFocused(ConfigScreenListData data) {
            IConfigScreenListEntry entry;
            IConfigScreenChild iConfigScreenChild = data.Screen.GetData().Focused;
            if (iConfigScreenChild instanceof IConfigScreenListEntry && data.VisibleEntries.contains(entry = (IConfigScreenListEntry)iConfigScreenChild)) {
                return entry;
            }
            return null;
        }

        public static IConfigScreenListEntry GetHovered(ConfigScreenListData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (data.VisibleEntries.contains(screenData.Hovered)) {
                return (IConfigScreenListEntry)screenData.Hovered;
            }
            return null;
        }

        public double GetScroll();

        public void SetScroll(double var1);

        public void UpdateScrollingState(double var1, double var3, int var5);
    }

    public static class ConfigScreenListData
    extends ConfigScreenChildData {
        public int HeaderHeight = 0;
        public int ItemHeight = 20;
        public int ItemSplitHeight = 3;
        public int ScrollbarWidth = 6;
        public int ScrollbarSplitWidth = 3;
        public double ScrollAmount = 0.0;
        public boolean ScrollbarVisible = true;
        public boolean HideFullScrollbar = true;
        public ArrayList<IConfigScreenListEntry> AllEntries = new ArrayList();
        public ArrayList<IConfigScreenListEntry> VisibleEntries = new ArrayList();

        public ConfigScreenListData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static interface IConfigButton
    extends IConfigScreenWidget {
        public static final int TEXT_COLOR = -1;

        public static boolean UpdateVisibility(ConfigButtonData data) {
            return IConfigScreenChild.UpdateVisibility(data);
        }

        public static void UpdateVisibility(boolean isVisible, ConfigButtonData data) {
            IConfigScreenChild.UpdateVisibility(data);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            AbstractModRender.SetRenderOptions(true, false, false, false, false);
            int halfWidthX = data.X + data.Width / 2;
            data.Instance.SuperRender(guiGraphics, mouseX, mouseY, partialTick);
            if (data.TextKey != null && !data.TextKey.isEmpty()) {
                int fullTextWidth;
                int textY = data.Y + data.Height / 2 - AbstractModLogic.GetTextHeight() / 2;
                String text = AbstractModLogic.GetTextTranslate(data.TextKey);
                int textWidth = AbstractModLogic.GetTextWidth(text);
                Object valueText = "";
                int valueTextWidth = 0;
                if (data.Values > 0) {
                    valueText = ": " + AbstractModLogic.GetTextTranslate(data.TextKey + "_" + data.Value);
                    valueTextWidth = AbstractModLogic.GetTextWidth((String)valueText);
                }
                if ((fullTextWidth = textWidth + valueTextWidth) <= data.Width - 6) {
                    AbstractModRender.RenderGUIText(guiGraphics, text + (String)valueText, halfWidthX - fullTextWidth / 2, textY, -1, true, false);
                } else if (data.Width - 7 - valueTextWidth >= 9) {
                    AbstractModRender.RenderRightScrollingText(guiGraphics, text, data.X + 3, data.X + data.Width - 4 - valueTextWidth, textY, 1.0f, -1, true, false);
                    AbstractModRender.RenderGUIText(guiGraphics, (String)valueText, data.X + data.Width - 3 - valueTextWidth, textY, -1, true, false);
                } else if (data.Width - 6 >= 9) {
                    AbstractModRender.RenderCenterScrollingText(guiGraphics, ((String)valueText).substring(2), data.X + 3, data.X + data.Width - 3, textY, 1.0f, -1, true, false);
                }
            }
            if (data.OnRender != null) {
                data.OnRender.OnRender((IConfigButton)data.Instance, guiGraphics);
            }
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigButtonData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            ISoundVisualizerConfigScreen.HoverWidget(data.Instance, screenData);
            screenData.CursorTypeRequest = "pointing_hand";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, ConfigButtonData data) {
            if (data.Instance == null || !data.Visible || !IConfigButton.IsMouseOver(mouseX, mouseY, data)) {
                return false;
            }
            if (data.OnPress != null) {
                data.OnPress.OnPress((IConfigButton)data.Instance);
            }
            if (data.Values > 0 && data.ConfigID >= 0) {
                data.Value = data.Value + (data.Screen.GetData().HasControlDown ? -1 : 1);
                data.Value = data.Value < 0 ? data.Values - 1 : (data.Value %= data.Values);
                ISoundVisualizerConfigScreen.SetButtonsValue(data.Category, data.ConfigID, data.Value, data.Screen.GetData());
            }
            ISoundVisualizerConfigScreen.FocusWidget(data.Instance, data.Screen.GetData());
            return data.Instance.SuperMouseClicked(mouseX, mouseY, button);
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, ConfigButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, ConfigButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, ConfigButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, ConfigButtonData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (data.Instance == null || !data.Visible || !Objects.equals(screenData.Hovered, data.Instance)) {
                return false;
            }
            boolean isPressed = false;
            if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigCopy, keyCode, scanCode, modifiers)) {
                if (data.Category.IsDSI()) {
                    AbstractConfig.DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    screenData.DSIBuffer.put(config, data.Value);
                    isPressed = true;
                } else if (data.Category.IsSubtitle()) {
                    AbstractConfig.SubtitleConfig config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false);
                    screenData.SubtitleBuffer.put(config, data.Value);
                    isPressed = true;
                }
            } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigPaste, keyCode, scanCode, modifiers)) {
                Object object;
                AbstractConfig.SubtitleConfig config;
                if (data.Category.IsDSI()) {
                    Object object2;
                    AbstractConfig.DirectionalSoundIndicatorConfig config2 = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    if (screenData.DSIBuffer.containsKey((Object)config2) && (object2 = screenData.DSIBuffer.get((Object)config2)) instanceof Integer) {
                        Integer newValue = (Integer)object2;
                        data.Value = newValue;
                        isPressed = true;
                    }
                } else if (data.Category.IsSubtitle() && screenData.SubtitleBuffer.containsKey((Object)(config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false))) && (object = screenData.SubtitleBuffer.get((Object)config)) instanceof Integer) {
                    Integer newValue = (Integer)object;
                    data.Value = newValue;
                    isPressed = true;
                }
            }
            if (isPressed) {
                ISoundVisualizerConfigScreen.FocusWidget(data.Instance, screenData);
                ISoundVisualizerConfigScreen.SynchWidgets(screenData);
                return true;
            }
            return false;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, ConfigButtonData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static void SynchValue(ConfigButtonData data) {
            if (data.ConfigID >= 0) {
                Object newValue = ISoundVisualizerConfigScreen.GetButtonsValue(data.Category, data.ConfigID, data.Screen.GetData());
                data.Value = (Integer)newValue;
            }
        }

        public static interface IOnRender {
            public void OnRender(IConfigButton var1, Object var2);
        }

        public static interface IOnPress {
            public void OnPress(IConfigButton var1);
        }
    }

    public static interface IConfigScreenWidget
    extends IConfigScreenChild {
    }

    public static interface IConfigSliderButton
    extends IConfigScreenWidget {
        public static boolean UpdateVisibility(ConfigSliderButtonData data) {
            return IConfigScreenChild.UpdateVisibility(data);
        }

        public static void UpdateVisibility(boolean isVisible, ConfigSliderButtonData data) {
            IConfigScreenChild.UpdateVisibility(data);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigSliderButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return;
            }
            AbstractModRender.SetRenderOptions(true, false, false, false, false);
            int halfWidthX = data.X + data.Width / 2;
            data.Instance.SuperRender(guiGraphics, mouseX, mouseY, partialTick);
            if (data.TextKey != null && !data.TextKey.isEmpty()) {
                String valueText;
                int valueTextWidth;
                int textY = data.Y + data.Height / 2 - AbstractModLogic.GetTextHeight() / 2;
                String text = AbstractModLogic.GetTextTranslate(data.TextKey);
                int textWidth = AbstractModLogic.GetTextWidth(text);
                int fullTextWidth = textWidth + (valueTextWidth = AbstractModLogic.GetTextWidth(valueText = ": " + IConfigSliderButton.TransformToText(data.Value, data) + AbstractModLogic.GetTextTranslate(data.TextKey + "_suffix")));
                if (fullTextWidth <= data.Width - 6) {
                    AbstractModRender.RenderGUIText(guiGraphics, text + valueText, halfWidthX - fullTextWidth / 2, textY, data.TextColor, true, false);
                } else if (data.Width - 7 - valueTextWidth >= 9) {
                    AbstractModRender.RenderRightScrollingText(guiGraphics, text, data.X + 3, data.X + data.Width - 4 - valueTextWidth, textY, 1.0f, data.TextColor, true, false);
                    AbstractModRender.RenderGUIText(guiGraphics, valueText, data.X + data.Width - 3 - valueTextWidth, textY, data.TextColor, true, false);
                } else if (data.Width - 6 >= 9) {
                    AbstractModRender.RenderCenterScrollingText(guiGraphics, valueText.substring(2), data.X + 3, data.X + data.Width - 3, textY, 1.0f, data.TextColor, true, false);
                }
            }
            AbstractModRender.SetRenderOptions(false, true, true, false, false);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigSliderButtonData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            ISoundVisualizerConfigScreen.HoverWidget(data.Instance, screenData);
            screenData.CursorTypeRequest = "pointing_hand";
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, ConfigSliderButtonData data) {
            if (data.Instance == null || !data.Visible || !IConfigSliderButton.IsMouseOver(mouseX, mouseY, data)) {
                return false;
            }
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            screenData.IsMouseDragging = true;
            screenData.CursorTypeRequest = "resize_ew";
            ISoundVisualizerConfigScreen.FocusWidget(data.Instance, screenData);
            return data.Instance.SuperMouseClicked(mouseX, mouseY, button);
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, ConfigSliderButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            data.Screen.GetData().IsMouseDragging = true;
            return data.Instance.SuperMouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, ConfigSliderButtonData data) {
            if (data.Instance == null || !data.Visible) {
                return false;
            }
            return data.Instance.SuperMouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, ConfigSliderButtonData data) {
            if (data.Instance == null || !data.Visible || !IConfigSliderButton.IsMouseOver(mouseX, mouseY, data)) {
                return false;
            }
            ISoundVisualizerConfigScreen.FocusWidget(data.Instance, data.Screen.GetData());
            data.Value = IConfigSliderButton.TransformToValue(IConfigSliderButton.TransformToValidValue(data.Value, data) + (int)scrollY, data);
            data.Value = Math.clamp(data.Value, 0.0, 1.0);
            ((IConfigSliderButton)data.Instance).SetValue(data.Value);
            IConfigSliderButton.ApplyValue(data.Value, data);
            return true;
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, ConfigSliderButtonData data) {
            SoundVisualizerConfigScreenData screenData = data.Screen.GetData();
            if (data.Instance == null || !data.Visible || !Objects.equals(screenData.Hovered, data.Instance)) {
                return false;
            }
            boolean isPressed = false;
            if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigMinValue, keyCode, scanCode, modifiers)) {
                data.Value = 0.0;
                isPressed = true;
            } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigMaxValue, keyCode, scanCode, modifiers)) {
                data.Value = 1.0;
                isPressed = true;
            } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigCopy, keyCode, scanCode, modifiers)) {
                if (data.Category.IsDSI()) {
                    AbstractConfig.DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    screenData.DSIBuffer.put(config, IConfigSliderButton.TransformToValidValue(data.Value, data));
                    isPressed = true;
                } else if (data.Category.IsSubtitle()) {
                    AbstractConfig.SubtitleConfig config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false);
                    screenData.SubtitleBuffer.put(config, IConfigSliderButton.TransformToValidValue(data.Value, data));
                    isPressed = true;
                }
            } else if (AbstractKeyMappings.IsKeyPressed(AbstractKeyMappings.ModKeyMapping.ConfigPaste, keyCode, scanCode, modifiers)) {
                Object object;
                AbstractConfig.SubtitleConfig config;
                if (data.Category.IsDSI()) {
                    Object object2;
                    AbstractConfig.DirectionalSoundIndicatorConfig config2 = AbstractConfig.GetDirectionalSoundIndicatorConfig(data.ConfigID, false);
                    if (screenData.DSIBuffer.containsKey((Object)config2) && (object2 = screenData.DSIBuffer.get((Object)config2)) instanceof Integer) {
                        Integer newValue = (Integer)object2;
                        data.Value = IConfigSliderButton.TransformToValue(newValue, data);
                        isPressed = true;
                    }
                } else if (data.Category.IsSubtitle() && screenData.SubtitleBuffer.containsKey((Object)(config = AbstractConfig.GetSubtitleConfig(data.ConfigID, false))) && (object = screenData.SubtitleBuffer.get((Object)config)) instanceof Integer) {
                    Integer newValue = (Integer)object;
                    data.Value = IConfigSliderButton.TransformToValue(newValue, data);
                    isPressed = true;
                }
            }
            if (isPressed) {
                ISoundVisualizerConfigScreen.FocusWidget(null, screenData);
                ((IConfigSliderButton)data.Instance).SetValue(data.Value);
                IConfigSliderButton.ApplyValue(data.Value, data);
                ISoundVisualizerConfigScreen.SynchWidgets(screenData);
                return true;
            }
            return false;
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, ConfigSliderButtonData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static void ApplyValue(double newValue, ConfigSliderButtonData data) {
            data.Value = newValue;
            ISoundVisualizerConfigScreen.SetButtonsValue(data.Category, data.ConfigID, IConfigSliderButton.TransformToValidValue(data.Value, data), data.Screen.GetData());
        }

        public static double TransformToValue(int tranformableValue, ConfigSliderButtonData data) {
            return ((double)tranformableValue - (double)data.MinValue) / (double)(data.MaxValue - data.MinValue);
        }

        public static int TransformToValidValue(double tranformableValue, ConfigSliderButtonData data) {
            return (int)Math.round(tranformableValue * (double)(data.MaxValue - data.MinValue) + (double)data.MinValue);
        }

        public static String TransformToText(double transformableValue, ConfigSliderButtonData data) {
            if (data.TextValueMultiplier != (float)((int)data.TextValueMultiplier)) {
                Object text = String.valueOf((float)IConfigSliderButton.TransformToValidValue(transformableValue, data) * data.TextValueMultiplier);
                text = ((String)text).substring(0, Math.min(3 + ((String)text).indexOf(46), ((String)text).length()));
                while (((String)text).substring(((String)text).indexOf(46), ((String)text).length()).length() <= 2) {
                    text = (String)text + "0";
                }
                return text;
            }
            return String.valueOf(IConfigSliderButton.TransformToValidValue(transformableValue, data) * (int)data.TextValueMultiplier);
        }

        public static void SynchValue(ConfigSliderButtonData data) {
            if (data.ConfigID >= 0) {
                Object newValue = ISoundVisualizerConfigScreen.GetButtonsValue(data.Category, data.ConfigID, data.Screen.GetData());
                data.Value = IConfigSliderButton.TransformToValue((Integer)newValue, data);
            }
            ((IConfigSliderButton)data.Instance).SetValue(data.Value);
        }

        public double GetValue();

        public void SetValue(double var1);
    }

    public static interface IConfigScreenListEntry
    extends IConfigScreenChild {
    }

    public static class ConfigsListEntryData
    extends ConfigScreenListEntryData {
        public IConfigScreenWidget Widget = null;

        public ConfigsListEntryData(ISoundVisualizerConfigScreen screen, IConfigScreenList list, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, list, instance, category);
        }
    }

    public static interface IConfigsListEntry
    extends IConfigScreenListEntry {
        public static boolean UpdateVisibility(ConfigsListEntryData data) {
            return data.Widget.UpdateVisibility();
        }

        public static void UpdateVisibility(boolean isVisible, ConfigsListEntryData data) {
            data.Widget.UpdateVisibility(isVisible);
        }

        public static void Render(Object guiGraphics, int mouseX, int mouseY, float partialTick, ConfigsListEntryData data) {
            data.Widget.Render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public static void MouseMoved(double mouseX, double mouseY, ConfigsListEntryData data) {
            data.Widget.MouseMoved(mouseX, mouseY);
        }

        public static boolean MouseClicked(double mouseX, double mouseY, int button, ConfigsListEntryData data) {
            return data.Widget.MouseClicked(mouseX, mouseY, button);
        }

        public static boolean MouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY, ConfigsListEntryData data) {
            return data.Widget.MouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public static boolean MouseReleased(double mouseX, double mouseY, int button, ConfigsListEntryData data) {
            return data.Widget.MouseReleased(mouseX, mouseY, button);
        }

        public static boolean MouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY, ConfigsListEntryData data) {
            return data.Widget.MouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }

        public static boolean KeyPressed(int keyCode, int scanCode, int modifiers, ConfigsListEntryData data) {
            return data.Widget.KeyPressed(keyCode, scanCode, modifiers);
        }

        public static boolean IsMouseOver(double mouseX, double mouseY, ConfigsListEntryData data) {
            return mouseX >= (double)data.X && mouseX <= (double)(data.X + data.Width) && mouseY >= (double)data.Y && mouseY <= (double)(data.Y + data.Height);
        }

        public static void SynchValue(ConfigsListEntryData data) {
            if (data.Widget instanceof IConfigButton) {
                IConfigButton.SynchValue((ConfigButtonData)data.Widget.GetData());
            } else if (data.Widget instanceof IConfigSliderButton) {
                IConfigSliderButton.SynchValue((ConfigSliderButtonData)data.Widget.GetData());
            } else if (data.Widget instanceof IConfigEditBox) {
                IConfigEditBox.SynchValue((ConfigEditBoxData)data.Widget.GetData());
            }
        }
    }

    public static class ConfigButtonData
    extends ConfigScreenWidgetData {
        public String TextKey = "";
        public int Values = 0;
        public int Value = 0;
        public IConfigButton.IOnPress OnPress = null;
        public IConfigButton.IOnRender OnRender = null;

        public ConfigButtonData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static class ConfigSliderButtonData
    extends ConfigScreenWidgetData {
        public String TextKey = "";
        public int TextColor = -1;
        public float TextValueMultiplier = 1.0f;
        public double Value = 0.0;
        public int MinValue = 0;
        public int MaxValue = 1;

        public ConfigSliderButtonData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static class ConfigScreenWidgetData
    extends ConfigScreenChildData {
        public int ConfigID = 0;
        public boolean Focused = false;

        public ConfigScreenWidgetData(ISoundVisualizerConfigScreen screen, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
        }
    }

    public static class ConfigScreenListEntryData
    extends ConfigScreenChildData {
        public final IConfigScreenList List;

        public ConfigScreenListEntryData(ISoundVisualizerConfigScreen screen, IConfigScreenList list, IConfigScreenChild instance, VisibilityCategory category) {
            super(screen, instance, category);
            this.List = list;
        }
    }
}

