/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractModRender;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ModRender
extends AbstractModRender {
    public static RenderType BufferRenderType = null;
    public static RenderPipeline BufferTextureRenderPipeline = null;
    protected static MultiBufferSource.BufferSource _buffer = null;
    protected static Matrix4f _matrix = null;
    protected static VertexConsumer _consumer = null;

    @Override
    protected boolean InstanceIsOnRenderThread() {
        return RenderSystem.isOnRenderThread();
    }

    @Override
    protected Object InstanceGetPoseFromGraphics(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.pose();
        }
        return null;
    }

    @Override
    protected void InstanceSetShaderColor(float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    protected void InstanceSetRenderOptions(boolean blend, boolean depthTest, boolean depthMask, boolean cull, boolean colorShader) {
    }

    @Override
    protected void InstanceEnableScissor(Object guiGraphics, int x0, int y0, int x1, int y1) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.enableScissor(x0, y0, x1, y1);
        }
    }

    @Override
    protected void InstanceDisableScissor(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.disableScissor();
        }
    }

    @Override
    protected void InstancePushPose(Object pose, double x, double y, double z, boolean rotate, float rotY, float rotX, float rotZ, float scaleX, float scaleY, float scaleZ) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            identifiedPose.pushPose();
            identifiedPose.translate(x, y, z);
            if (rotate) {
                identifiedPose.mulPose((Quaternionfc)new Quaternionf().rotateY(rotY).rotateX(rotX).rotateZ(rotZ));
            }
            identifiedPose.scale(scaleX, scaleY, scaleZ);
        }
    }

    @Override
    protected void InstancePopPose(Object pose) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            identifiedPose.popPose();
        }
    }

    @Override
    protected void InstancePushBuffer() {
        _buffer = Minecraft.getInstance().renderBuffers().bufferSource();
    }

    @Override
    protected void InstancePushMatrix(Object pose) {
        if (pose instanceof PoseStack) {
            PoseStack identifiedPose = (PoseStack)pose;
            _matrix = identifiedPose.last().pose();
        }
    }

    @Override
    protected void InstancePushVertexConsumer() {
        _consumer = _buffer.getBuffer(BufferRenderType == null ? RenderType.textBackgroundSeeThrough() : BufferRenderType);
    }

    @Override
    protected void InstanceAddVertex(float x, float y, float z, float u, float v, int color) {
        _consumer.addVertex(_matrix, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    @Override
    protected void InstancePushBufferEnd() {
        _buffer.endBatch();
    }

    @Override
    protected int InstanceGetGuiWidth(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.guiWidth();
        }
        return 0;
    }

    @Override
    protected int InstanceGetGuiHeight(Object guiGraphics) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            return graphics.guiHeight();
        }
        return 0;
    }

    @Override
    protected int InstanceGetBackgroundColor(float alpha) {
        return Minecraft.getInstance().options.getBackgroundColor(alpha);
    }

    @Override
    protected void InstanceRenderTexture(Object guiGraphics, String location, int x, int y, int uOffset, int vOffset, int width, int height, int textureWidth, int textureHeight) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            float[] shaderColors = RenderSystem.getShaderColor();
            int color = ((int)Math.clamp(shaderColors[3] * 255.0f, 0.0f, 255.0f) & 0xFF) << 24 | ((int)Math.clamp(shaderColors[2] * 255.0f, 0.0f, 255.0f) & 0xFF) << 16 | ((int)Math.clamp(shaderColors[1] * 255.0f, 0.0f, 255.0f) & 0xFF) << 8 | (int)Math.clamp(shaderColors[0] * 255.0f, 0.0f, 255.0f) & 0xFF;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.blit(renderTypeGetterLocation -> RenderType.guiTextured((ResourceLocation)renderTypeGetterLocation), ResourceLocation.fromNamespaceAndPath((String)"sound_visualizer", (String)location), x, y, (float)uOffset, (float)vOffset, width, height, textureWidth, textureHeight, color);
        }
    }

    @Override
    protected void InstanceRenderRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.fill(x0, y0, x1, y1, color);
        }
    }

    @Override
    protected void InstanceRenderHighlightRect(Object guiGraphics, int x0, int y0, int x1, int y1, int color) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.fill(RenderType.guiTextHighlight(), x0, y0, x1, y1, color);
        }
    }

    @Override
    protected void InstanceRenderGUIText(Object guiGraphics, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        if (guiGraphics instanceof GuiGraphics) {
            GuiGraphics graphics = (GuiGraphics)guiGraphics;
            graphics.drawString(Minecraft.getInstance().font, (Component)MutableComponent.create((ComponentContents)Component.literal((String)text).getContents()).withStyle(italic ? ChatFormatting.ITALIC : ChatFormatting.RESET), x, y, color, dropShadow);
            _buffer.endBatch();
        }
    }

    @Override
    protected void InstanceRenderText(Object pose, String text, int x, int y, int color, boolean dropShadow, boolean italic) {
        Minecraft.getInstance().font.drawInBatch((Component)MutableComponent.create((ComponentContents)Component.literal((String)text).getContents()).withStyle(italic ? ChatFormatting.ITALIC : ChatFormatting.RESET), (float)x, (float)y, color, dropShadow, _matrix, (MultiBufferSource)_buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    @Override
    protected void InstanceProcessBlurEffect(float partialTick) {
    }

    @Override
    protected void InstanceBindMainRenderTargetWrite(boolean setViewport) {
    }
}

