/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer;

import com.dgneos.sound_visualizer.AbstractClientRenderEvents;
import com.dgneos.sound_visualizer.ConfigBind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class AbstractConfig {
    protected static final Map<String, int[]> DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA = new HashMap<String, int[]>();
    protected static final Map<String, String[]> DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA = new HashMap<String, String[]>();
    protected static final ArrayList<Integer> DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA = new ArrayList();
    protected static final Map<String, int[]> SUBTITLE_CONFIGS_DATA = new HashMap<String, int[]>();
    protected static final Map<String, String[]> SUBTITLE_TEXT_CONFIGS_DATA = new HashMap<String, String[]>();
    protected static final ArrayList<Integer> SUBTITLE_GLOBAL_CONFIGS_DATA = new ArrayList();
    protected static final ArrayList<String> IC_SOUNDS_DATA = new ArrayList();
    protected static final Map<String, int[]> IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA = new HashMap<String, String[]>();
    protected static final Map<String, int[]> IC_SOUNDS_SUBTITLE_CONFIGS_DATA = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA = new HashMap<String, String[]>();
    protected static final ArrayList<String> IGNORABLE_SOURCES_DATA = new ArrayList();
    protected static final ArrayList<String> IGNORABLE_SOUNDS_DATA = new ArrayList();
    protected static final ArrayList<String> FAVORITE_SOUNDS_DATA = new ArrayList();
    protected static final Map<String, int[]> DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE = new HashMap<String, int[]>();
    protected static final Map<String, String[]> DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE = new HashMap<String, String[]>();
    protected static final ArrayList<Integer> DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA_SAVE = new ArrayList();
    protected static final Map<String, int[]> SUBTITLE_CONFIGS_DATA_SAVE = new HashMap<String, int[]>();
    protected static final Map<String, String[]> SUBTITLE_TEXT_CONFIGS_DATA_SAVE = new HashMap<String, String[]>();
    protected static final ArrayList<Integer> SUBTITLE_GLOBAL_CONFIGS_DATA_SAVE = new ArrayList();
    protected static final ArrayList<String> IC_SOUNDS_DATA_SAVE = new ArrayList();
    protected static final Map<String, int[]> IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE = new HashMap<String, String[]>();
    protected static final Map<String, int[]> IC_SOUNDS_SUBTITLE_CONFIGS_DATA_SAVE = new HashMap<String, int[]>();
    protected static final Map<String, String[]> IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA_SAVE = new HashMap<String, String[]>();
    protected static final ArrayList<String> IGNORABLE_SOURCES_DATA_SAVE = new ArrayList();
    protected static final ArrayList<String> IGNORABLE_SOUNDS_DATA_SAVE = new ArrayList();
    protected static final ArrayList<String> FAVORITE_SOUNDS_DATA_SAVE = new ArrayList();
    private static AbstractConfig _instance = null;

    static void OnLoad() {
        List savedTextConfigs;
        List savedConfigs;
        ConfigBind bind;
        String[] sources = AbstractConfig.GetSources();
        int dsiConfigsCount = AbstractConfig.GetDirectionalSoundIndicatorConfigsCount();
        int subtitleConfigsCount = AbstractConfig.GetSubtitleConfigsCount();
        for (int i = 0; i < sources.length; ++i) {
            String source = sources[i];
            int[] savedFullConfigs = new int[dsiConfigsCount];
            String[] savedTextFullConfigs = new String[dsiConfigsCount];
            bind = ConfigBind.DSIConfigBind(i);
            AbstractConfig.BindConfig(bind);
            savedConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList());
            bind = ConfigBind.DSITextConfigBind(i);
            AbstractConfig.BindConfig(bind);
            savedTextConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().map(value -> value.toString()).collect(Collectors.toList());
            int configsCounter = 0;
            int textConfigsCounter = 0;
            for (DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig : DirectionalSoundIndicatorConfig.values()) {
                if (directionalSoundIndicatorConfig.IsGlobal()) continue;
                if (directionalSoundIndicatorConfig.IsText()) {
                    savedTextFullConfigs[directionalSoundIndicatorConfig.GetNum()] = savedTextConfigs.size() > textConfigsCounter ? (String)savedTextConfigs.get(textConfigsCounter) : "";
                    ++textConfigsCounter;
                    continue;
                }
                savedFullConfigs[directionalSoundIndicatorConfig.GetNum()] = savedConfigs.size() > configsCounter ? (Integer)savedConfigs.get(configsCounter) : 0;
                ++configsCounter;
            }
            DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(source, (int[])savedFullConfigs.clone());
            DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(source, (String[])savedTextFullConfigs.clone());
            savedFullConfigs = new int[subtitleConfigsCount];
            savedTextFullConfigs = new String[subtitleConfigsCount];
            bind = ConfigBind.SubtitleConfigBind(i);
            AbstractConfig.BindConfig(bind);
            savedConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList());
            bind = ConfigBind.SubtitleTextConfigBind(i);
            AbstractConfig.BindConfig(bind);
            savedTextConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().map(value -> value.toString()).collect(Collectors.toList());
            configsCounter = 0;
            textConfigsCounter = 0;
            for (Enum enum_ : SubtitleConfig.values()) {
                if (((SubtitleConfig)enum_).IsGlobal()) continue;
                if (((SubtitleConfig)enum_).IsText()) {
                    savedTextFullConfigs[((SubtitleConfig)enum_).GetNum()] = savedTextConfigs.size() > textConfigsCounter ? (String)savedTextConfigs.get(textConfigsCounter) : "";
                    ++textConfigsCounter;
                    continue;
                }
                savedFullConfigs[((SubtitleConfig)enum_).GetNum()] = savedConfigs.size() > configsCounter ? (Integer)savedConfigs.get(configsCounter) : 0;
                ++configsCounter;
            }
            SUBTITLE_CONFIGS_DATA.put(source, (int[])savedFullConfigs.clone());
            SUBTITLE_TEXT_CONFIGS_DATA.put(source, (String[])savedTextFullConfigs.clone());
        }
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.clear();
        bind = ConfigBind.DSIGlobalConfigBind();
        AbstractConfig.BindConfig(bind);
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.addAll(AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList()));
        SUBTITLE_GLOBAL_CONFIGS_DATA.clear();
        bind = ConfigBind.SubtitleGlobalConfigBind();
        AbstractConfig.BindConfig(bind);
        SUBTITLE_GLOBAL_CONFIGS_DATA.addAll(AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList()));
        bind = ConfigBind.ICConfigBind();
        AbstractConfig.BindConfig(bind);
        List sounds = AbstractConfig.GetBindedConfigValue(bind).stream().map(sound -> sound.toString()).collect(Collectors.toList());
        bind = ConfigBind.ICDSIConfigBind();
        AbstractConfig.BindConfig(bind);
        savedConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList());
        ArrayList<int[]> dsiConfigs = new ArrayList<int[]>();
        int counter = 0;
        int[] dsiConfigValues = new int[AbstractConfig.GetDirectionalSoundIndicatorConfigsCount()];
        if (!savedConfigs.isEmpty()) {
            for (Integer configValue : savedConfigs) {
                if (AbstractConfig.GetDirectionalSoundIndicatorConfig(counter, false).IsText()) continue;
                dsiConfigValues[counter] = configValue;
                if (counter >= dsiConfigValues.length - 1) {
                    counter = 0;
                    dsiConfigs.add((int[])dsiConfigValues.clone());
                    continue;
                }
                ++counter;
            }
            if (counter > 0) {
                for (int i = counter; i < AbstractConfig.GetDirectionalSoundIndicatorConfigsCount(); ++i) {
                    DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig = AbstractConfig.GetDirectionalSoundIndicatorConfig(i, false);
                    if (directionalSoundIndicatorConfig.IsText()) continue;
                    dsiConfigValues[i] = (Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(null, sources[0], directionalSoundIndicatorConfig);
                }
                dsiConfigs.add(dsiConfigValues);
            }
        }
        bind = ConfigBind.ICDSITextConfigBind();
        AbstractConfig.BindConfig(bind);
        savedTextConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().map(value -> value.toString()).collect(Collectors.toList());
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        counter = 0;
        String[] dsiConfigTextValues = new String[AbstractConfig.GetDirectionalSoundIndicatorConfigsCount()];
        if (!savedTextConfigs.isEmpty()) {
            for (String configTextValue : savedTextConfigs) {
                if (!AbstractConfig.GetDirectionalSoundIndicatorConfig(counter, false).IsText()) continue;
                dsiConfigTextValues[counter] = configTextValue;
                if (counter >= dsiConfigTextValues.length - 1) {
                    counter = 0;
                    arrayList.add((String[])dsiConfigTextValues.clone());
                    continue;
                }
                ++counter;
            }
            if (counter > 0) {
                for (int i = counter; i < AbstractConfig.GetDirectionalSoundIndicatorConfigsCount(); ++i) {
                    DirectionalSoundIndicatorConfig config = AbstractConfig.GetDirectionalSoundIndicatorConfig(i, false);
                    if (!config.IsText()) continue;
                    dsiConfigTextValues[i] = (String)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(null, sources[0], config);
                }
                arrayList.add(dsiConfigTextValues);
            }
        }
        bind = ConfigBind.ICSubtitleConfigBind();
        AbstractConfig.BindConfig(bind);
        savedConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().mapToInt(value -> (Integer)value).boxed().collect(Collectors.toList());
        ArrayList<int[]> subtitleConfigs = new ArrayList<int[]>();
        counter = 0;
        int[] subtitleConfigValues = new int[AbstractConfig.GetSubtitleConfigsCount()];
        if (!savedConfigs.isEmpty()) {
            for (Integer configValue : savedConfigs) {
                if (AbstractConfig.GetSubtitleConfig(counter, false).IsText()) continue;
                subtitleConfigValues[counter] = configValue;
                if (counter >= subtitleConfigValues.length - 1) {
                    counter = 0;
                    subtitleConfigs.add((int[])subtitleConfigValues.clone());
                    continue;
                }
                ++counter;
            }
            if (counter > 0) {
                for (int i = counter; i < AbstractConfig.GetSubtitleConfigsCount(); ++i) {
                    SubtitleConfig config = AbstractConfig.GetSubtitleConfig(i, false);
                    if (config.IsText()) continue;
                    subtitleConfigValues[i] = (Integer)AbstractConfig.GetSubtitleConfigValue(null, sources[0], config);
                }
                subtitleConfigs.add(subtitleConfigValues);
            }
        }
        bind = ConfigBind.ICSubtitleTextConfigBind();
        AbstractConfig.BindConfig(bind);
        savedTextConfigs = AbstractConfig.GetBindedConfigValue(bind).stream().map(value -> value.toString()).collect(Collectors.toList());
        ArrayList<String[]> subtitleTextConfigs = new ArrayList<String[]>();
        counter = 0;
        String[] subtitleConfigTextValues = new String[AbstractConfig.GetSubtitleConfigsCount()];
        if (!savedTextConfigs.isEmpty()) {
            for (String configTextValue : savedTextConfigs) {
                if (!AbstractConfig.GetSubtitleConfig(counter, false).IsText()) continue;
                subtitleConfigTextValues[counter] = configTextValue;
                if (counter >= subtitleConfigTextValues.length - 1) {
                    counter = 0;
                    subtitleTextConfigs.add((String[])subtitleConfigTextValues.clone());
                    continue;
                }
                ++counter;
            }
            if (counter > 0) {
                for (int i = counter; i < AbstractConfig.GetSubtitleConfigsCount(); ++i) {
                    SubtitleConfig config = AbstractConfig.GetSubtitleConfig(i, false);
                    if (!config.IsText()) continue;
                    subtitleConfigTextValues[i] = (String)AbstractConfig.GetSubtitleConfigValue(null, sources[0], config);
                }
                subtitleTextConfigs.add(subtitleConfigTextValues);
            }
        }
        if (!sounds.isEmpty()) {
            for (int i = 0; i < sounds.size(); ++i) {
                String sound2 = (String)sounds.get(i);
                IC_SOUNDS_DATA.add(sound2);
                if (dsiConfigs.size() > i) {
                    IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(sound2, (int[])((int[])dsiConfigs.get(i)).clone());
                }
                if (arrayList.size() > i) {
                    IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(sound2, (String[])((String[])arrayList.get(i)).clone());
                }
                if (subtitleConfigs.size() > i) {
                    IC_SOUNDS_SUBTITLE_CONFIGS_DATA.put(sound2, (int[])((int[])subtitleConfigs.get(i)).clone());
                }
                if (subtitleTextConfigs.size() <= i) continue;
                IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.put(sound2, (String[])((String[])subtitleTextConfigs.get(i)).clone());
            }
        }
        AbstractConfig.CheckDirectionalSoundIndicatorConfigs();
        AbstractConfig.CheckDirectionalSoundIndicatorGlobalConfigs();
        AbstractConfig.CheckSubtitleConfigs();
        AbstractConfig.CheckSubtitleGlobalConfigs();
        bind = ConfigBind.IgnorableSourcesConfigBind();
        AbstractConfig.BindConfig(bind);
        IGNORABLE_SOURCES_DATA.addAll(AbstractConfig.GetBindedConfigValue(bind).stream().map(ignSource -> ignSource.toString()).collect(Collectors.toList()));
        bind = ConfigBind.IgnorableSoundsConfigBind();
        AbstractConfig.BindConfig(bind);
        IGNORABLE_SOUNDS_DATA.addAll(AbstractConfig.GetBindedConfigValue(bind).stream().map(ignSound -> ignSound.toString()).collect(Collectors.toList()));
        bind = ConfigBind.FavoriteSoundsConfigBind();
        AbstractConfig.BindConfig(bind);
        FAVORITE_SOUNDS_DATA.addAll(AbstractConfig.GetBindedConfigValue(bind).stream().map(favSound -> favSound.toString()).collect(Collectors.toList()));
        AbstractConfig.SaveValuesForRollback();
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderConfigs(AbstractConfig.GetDirectionalSoundIndicatorConfigValues());
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderTextConfigs(AbstractConfig.GetDirectionalSoundIndicatorTextConfigValues());
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderGlobalConfigs(AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderConfigs(AbstractConfig.GetSubtitleConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderTextConfigs(AbstractConfig.GetSubtitleTextConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderGlobalConfigs(AbstractConfig.GetSubtitleGlobalConfigValues());
        AbstractClientRenderEvents.SynchIndividuallyConfiguredSoundsRenderConfigs(new ArrayList<String>(IC_SOUNDS_DATA), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleTextConfigs());
        AbstractClientRenderEvents.SynchIgnorableSourcesRender(new ArrayList<String>(IGNORABLE_SOURCES_DATA));
        AbstractClientRenderEvents.SynchIgnorableSoundsRender(new ArrayList<String>(IGNORABLE_SOUNDS_DATA));
        AbstractClientRenderEvents.SynchFavoriteSoundsRender(new ArrayList<String>(FAVORITE_SOUNDS_DATA));
    }

    public static void SaveValuesForRollback() {
        DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.clear();
        DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.putAll(DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.clear();
        DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.putAll(DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA_SAVE.clear();
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA_SAVE.addAll(DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA);
        SUBTITLE_CONFIGS_DATA_SAVE.clear();
        SUBTITLE_CONFIGS_DATA_SAVE.putAll(SUBTITLE_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        SUBTITLE_TEXT_CONFIGS_DATA_SAVE.clear();
        SUBTITLE_TEXT_CONFIGS_DATA_SAVE.putAll(SUBTITLE_TEXT_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        SUBTITLE_GLOBAL_CONFIGS_DATA_SAVE.clear();
        SUBTITLE_GLOBAL_CONFIGS_DATA_SAVE.addAll(SUBTITLE_GLOBAL_CONFIGS_DATA);
        IC_SOUNDS_DATA_SAVE.clear();
        IC_SOUNDS_DATA_SAVE.addAll(IC_SOUNDS_DATA);
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.clear();
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.putAll(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.clear();
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.putAll(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        IC_SOUNDS_SUBTITLE_CONFIGS_DATA_SAVE.clear();
        IC_SOUNDS_SUBTITLE_CONFIGS_DATA_SAVE.putAll(IC_SOUNDS_SUBTITLE_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA_SAVE.clear();
        IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA_SAVE.putAll(IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        IGNORABLE_SOURCES_DATA_SAVE.clear();
        IGNORABLE_SOURCES_DATA_SAVE.addAll(IGNORABLE_SOURCES_DATA);
        IGNORABLE_SOUNDS_DATA_SAVE.clear();
        IGNORABLE_SOUNDS_DATA_SAVE.addAll(IGNORABLE_SOUNDS_DATA);
        FAVORITE_SOUNDS_DATA_SAVE.clear();
        FAVORITE_SOUNDS_DATA_SAVE.addAll(FAVORITE_SOUNDS_DATA);
    }

    public static void RollbackValues() {
        DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.clear();
        DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.putAll(DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.clear();
        DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.putAll(DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.clear();
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.addAll(DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA_SAVE);
        SUBTITLE_CONFIGS_DATA.clear();
        SUBTITLE_CONFIGS_DATA.putAll(SUBTITLE_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        SUBTITLE_TEXT_CONFIGS_DATA.clear();
        SUBTITLE_TEXT_CONFIGS_DATA.putAll(SUBTITLE_TEXT_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        SUBTITLE_GLOBAL_CONFIGS_DATA.clear();
        SUBTITLE_GLOBAL_CONFIGS_DATA.addAll(SUBTITLE_GLOBAL_CONFIGS_DATA_SAVE);
        IC_SOUNDS_DATA.clear();
        IC_SOUNDS_DATA.addAll(IC_SOUNDS_DATA_SAVE);
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.clear();
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.putAll(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.clear();
        IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.putAll(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        IC_SOUNDS_SUBTITLE_CONFIGS_DATA.clear();
        IC_SOUNDS_SUBTITLE_CONFIGS_DATA.putAll(IC_SOUNDS_SUBTITLE_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (int[])((int[])entry.getValue()).clone())));
        IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.clear();
        IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.putAll(IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA_SAVE.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String[])((String[])entry.getValue()).clone())));
        IGNORABLE_SOURCES_DATA.clear();
        IGNORABLE_SOURCES_DATA.addAll(IGNORABLE_SOURCES_DATA_SAVE);
        IGNORABLE_SOUNDS_DATA.clear();
        IGNORABLE_SOUNDS_DATA.addAll(IGNORABLE_SOUNDS_DATA_SAVE);
        FAVORITE_SOUNDS_DATA.clear();
        FAVORITE_SOUNDS_DATA.addAll(FAVORITE_SOUNDS_DATA_SAVE);
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderConfigs(AbstractConfig.GetDirectionalSoundIndicatorConfigValues());
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderTextConfigs(AbstractConfig.GetDirectionalSoundIndicatorTextConfigValues());
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderGlobalConfigs(AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderConfigs(AbstractConfig.GetSubtitleConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderTextConfigs(AbstractConfig.GetSubtitleTextConfigValues());
        AbstractClientRenderEvents.SynchSubtitleRenderGlobalConfigs(AbstractConfig.GetSubtitleGlobalConfigValues());
        AbstractClientRenderEvents.SynchIndividuallyConfiguredSoundsRenderConfigs(new ArrayList<String>(IC_SOUNDS_DATA), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleTextConfigs());
        AbstractClientRenderEvents.SynchIgnorableSourcesRender(new ArrayList<String>(IGNORABLE_SOURCES_DATA));
        AbstractClientRenderEvents.SynchIgnorableSoundsRender(new ArrayList<String>(IGNORABLE_SOUNDS_DATA));
        AbstractClientRenderEvents.SynchFavoriteSoundsRender(new ArrayList<String>(FAVORITE_SOUNDS_DATA));
    }

    public static String GetDirectionalSoundIndicatorConfigDescription(String source, boolean isTextConfig, boolean configsList) {
        if (source == null || ((String)source).isEmpty()) {
            return "";
        }
        if (((String)source).length() < 2) {
            return ((String)source).toUpperCase();
        }
        source = Objects.equals(source = ((String)source).toLowerCase(), "ui") ? ((String)source).toUpperCase() : ((String)source).substring(0, 1).toUpperCase() + ((String)source).substring(1);
        String description = "Defines various directional sound indicator" + (isTextConfig ? " text" : "") + " configs for " + (String)source + " sound sources.";
        if (configsList) {
            if (!isTextConfig) {
                String configsListText = " Configs:\n1: Radius    %d ~ %d\n2: Thickness    %d ~ %d\n3: Width    %d ~ %d\n4: Red Color    %d ~ %d\n5: Green Color    %d ~ %d\n6: Blue Color    %d ~ %d\n7: Opacity    %d ~ %d\n8: Life Time    %d ~ %d (%.2f ~ %.2f seconds)\n9: Opacity Max Distance Percent    %d ~ %d\n10: Width Max Distance Percent    %d ~ %d\n11: Life Time Max Distance Percent    %d ~ %d";
                description = description + String.format(configsListText, DirectionalSoundIndicatorConfig.Radius.GetMinValue(), DirectionalSoundIndicatorConfig.Radius.GetMaxValue(), DirectionalSoundIndicatorConfig.Thickness.GetMinValue(), DirectionalSoundIndicatorConfig.Thickness.GetMaxValue(), DirectionalSoundIndicatorConfig.Width.GetMinValue(), DirectionalSoundIndicatorConfig.Width.GetMaxValue(), DirectionalSoundIndicatorConfig.ColorR.GetMinValue(), DirectionalSoundIndicatorConfig.ColorR.GetMaxValue(), DirectionalSoundIndicatorConfig.ColorG.GetMinValue(), DirectionalSoundIndicatorConfig.ColorG.GetMaxValue(), DirectionalSoundIndicatorConfig.ColorB.GetMinValue(), DirectionalSoundIndicatorConfig.ColorB.GetMaxValue(), DirectionalSoundIndicatorConfig.Opacity.GetMinValue(), DirectionalSoundIndicatorConfig.Opacity.GetMaxValue(), DirectionalSoundIndicatorConfig.LifeTime.GetMinValue(), DirectionalSoundIndicatorConfig.LifeTime.GetMaxValue(), Float.valueOf((float)DirectionalSoundIndicatorConfig.LifeTime.GetMinValue() / 20.0f), Float.valueOf((float)DirectionalSoundIndicatorConfig.LifeTime.GetMaxValue() / 20.0f), DirectionalSoundIndicatorConfig.OpacityMDP.GetMinValue(), DirectionalSoundIndicatorConfig.OpacityMDP.GetMaxValue(), DirectionalSoundIndicatorConfig.WidthMDP.GetMinValue(), DirectionalSoundIndicatorConfig.WidthMDP.GetMaxValue(), DirectionalSoundIndicatorConfig.LifeTimeMDP.GetMinValue(), DirectionalSoundIndicatorConfig.LifeTimeMDP.GetMaxValue());
            } else {
                String configsListText = "Configs:";
                description = description + String.format(configsListText, new Object[0]);
            }
        }
        return description;
    }

    public static String GetDirectionalSoundIndicatorConfigPath(String source, boolean isTextConfig) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        return source.toLowerCase() + "SourceDSI" + (isTextConfig ? "Text" : "") + "Configs";
    }

    public static List<Integer> GetDirectionalSoundIndicatorConfigsDefaultValues(int sourceIndex) {
        int colorG;
        int colorR;
        int radius = 100;
        int thickness = 16;
        int width = 45;
        int opacity = 125;
        int lifeTime = 40;
        int maxDistancePercent = 50;
        return List.of(radius, thickness, width, colorR, colorG, switch (sourceIndex) {
            case 0 -> {
                colorR = 255;
                colorG = 255;
                yield 255;
            }
            case 1 -> {
                colorR = 205;
                colorG = 205;
                yield 205;
            }
            case 2 -> {
                colorR = 255;
                colorG = 205;
                yield 155;
            }
            case 3 -> {
                colorR = 155;
                colorG = 155;
                yield 255;
            }
            case 4 -> {
                colorR = 255;
                colorG = 155;
                yield 255;
            }
            case 5 -> {
                colorR = 255;
                colorG = 155;
                yield 155;
            }
            case 6 -> {
                colorR = 155;
                colorG = 255;
                yield 155;
            }
            case 7 -> {
                colorR = 255;
                colorG = 255;
                yield 155;
            }
            case 8 -> {
                colorR = 155;
                colorG = 255;
                yield 255;
            }
            case 9 -> {
                colorR = 155;
                colorG = 155;
                yield 155;
            }
            case 10 -> {
                colorR = 205;
                colorG = 205;
                yield 205;
            }
            default -> {
                colorR = 255;
                colorG = 255;
                yield 255;
            }
        }, opacity, lifeTime, maxDistancePercent, maxDistancePercent, maxDistancePercent);
    }

    public static List<String> GetDirectionalSoundIndicatorTextConfigsDefaultValues(int sourceIndex) {
        return List.of();
    }

    public static DirectionalSoundIndicatorConfig GetDirectionalSoundIndicatorConfig(int index, boolean isGlobal) {
        for (DirectionalSoundIndicatorConfig config : DirectionalSoundIndicatorConfig.values()) {
            if (config.GetNum() != index || config.IsGlobal() != isGlobal) continue;
            return config;
        }
        return null;
    }

    public static int GetDirectionalSoundIndicatorConfigsCount() {
        int count = 0;
        for (DirectionalSoundIndicatorConfig config : DirectionalSoundIndicatorConfig.values()) {
            if (config.IsGlobal()) continue;
            ++count;
        }
        return count;
    }

    public static int GetDirectionalSoundIndicatorConfigsCount(boolean textOnly) {
        int count = 0;
        for (DirectionalSoundIndicatorConfig config : DirectionalSoundIndicatorConfig.values()) {
            if (config.IsGlobal() || config.IsText() != textOnly) continue;
            ++count;
        }
        return count;
    }

    public static boolean CheckDirectionalSoundIndicatorConfigs() {
        String[] sources = AbstractConfig.GetSources();
        int configsCount = AbstractConfig.GetDirectionalSoundIndicatorConfigsCount();
        for (int i = 0; i < sources.length; ++i) {
            int j;
            String source = sources[i];
            int[] defaultValues = AbstractConfig.GetDirectionalSoundIndicatorConfigsDefaultValues(i).stream().mapToInt(Integer::intValue).toArray();
            String[] defaultTextValues = (String[])AbstractConfig.GetDirectionalSoundIndicatorTextConfigsDefaultValues(i).toArray(String[]::new);
            if (!DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(source)) {
                DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(source, defaultValues);
            } else if (DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source).length < configsCount) {
                int[] newValues = new int[configsCount];
                int[] currentValues = DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source);
                for (j = 0; j < defaultValues.length; ++j) {
                    newValues[j] = DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source).length > j ? currentValues[j] : defaultValues[j];
                }
                DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(source, newValues);
            }
            if (!DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(source)) {
                DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(source, defaultTextValues);
                continue;
            }
            if (DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source).length >= configsCount) continue;
            String[] newTextValues = new String[configsCount];
            String[] currentTextValues = DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source);
            for (j = 0; j < defaultTextValues.length; ++j) {
                newTextValues[j] = DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source).length > j ? currentTextValues[j] : defaultTextValues[j];
            }
            DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(source, newTextValues);
        }
        for (String checkableSource : sources) {
            int[] clampedValues = new int[configsCount];
            String[] clampedTextValues = new String[configsCount];
            if (!DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(checkableSource) || DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(checkableSource).length < configsCount) {
                return false;
            }
            if (!DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(checkableSource) || DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(checkableSource).length < configsCount) {
                return false;
            }
            for (DirectionalSoundIndicatorConfig config : DirectionalSoundIndicatorConfig.values()) {
                if (config.IsGlobal()) continue;
                if (config.IsText()) {
                    String textConfigValue = DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(checkableSource)[config.GetNum()];
                    clampedTextValues[config.GetNum()] = textConfigValue.substring(0, Math.min(config.GetMaxValue(), textConfigValue.length()));
                    continue;
                }
                clampedValues[config.GetNum()] = Math.clamp((long)DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(checkableSource)[config.GetNum()], config.GetMinValue(), config.GetMaxValue());
            }
            DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(checkableSource, (int[])clampedValues.clone());
            DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(checkableSource, (String[])clampedTextValues.clone());
        }
        return true;
    }

    public static Map<String, int[]> GetDirectionalSoundIndicatorConfigValues() {
        HashMap<String, int[]> values = new HashMap<String, int[]>();
        for (String source : AbstractConfig.GetSources()) {
            values.put(source, (int[])DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static Map<String, String[]> GetDirectionalSoundIndicatorTextConfigValues() {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String source : AbstractConfig.GetSources()) {
            values.put(source, (String[])DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static Object GetDirectionalSoundIndicatorConfigValue(String sound, String source, DirectionalSoundIndicatorConfig config) {
        return AbstractConfig.GetDirectionalSoundIndicatorConfigValue(DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source), DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source), IC_SOUNDS_DATA, sound, IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA, IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA, config);
    }

    public static Object GetDirectionalSoundIndicatorConfigValue(int[] configs, String[] textConfigs, List<String> icSounds, String sound, Map<String, int[]> icConfigs, Map<String, String[]> icTextConfigs, DirectionalSoundIndicatorConfig config) {
        if (config.IsText()) {
            if (icSounds.contains(sound) && icTextConfigs.containsKey(sound)) {
                return icTextConfigs.get(sound)[config.GetNum()];
            }
            if (textConfigs != null) {
                return textConfigs[config.GetNum()];
            }
            return "";
        }
        if (icSounds.contains(sound) && icConfigs.containsKey(sound)) {
            return icConfigs.get(sound)[config.GetNum()];
        }
        if (configs != null) {
            return configs[config.GetNum()];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetDirectionalSoundIndicatorConfigNewValue(String sound, String source, DirectionalSoundIndicatorConfig config, Object newValue) {
        if (config.IsText()) {
            String newStringValue = ((String)newValue).substring(0, Math.min(config.GetMaxValue(), ((String)newValue).length()));
            if (IC_SOUNDS_DATA.contains(sound) && IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(sound)) {
                Map<String, String[]> map = IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA;
                synchronized (map) {
                    AbstractConfig.IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get((Object)sound)[config.GetNum()] = (String)newValue;
                }
            }
            Map<String, String[]> map = DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA;
            synchronized (map) {
                AbstractConfig.DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get((Object)source)[config.GetNum()] = newStringValue;
            }
            AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderTextConfigs(AbstractConfig.GetDirectionalSoundIndicatorTextConfigValues());
        } else {
            int newIntValue = Math.clamp((long)((Integer)newValue).intValue(), AbstractConfig.GetDirectionalSoundIndicatorConfig(config.GetNum(), false).GetMinValue(), AbstractConfig.GetDirectionalSoundIndicatorConfig(config.GetNum(), false).GetMaxValue());
            if (IC_SOUNDS_DATA.contains(sound) && IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(sound)) {
                Map<String, int[]> map = IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA;
                synchronized (map) {
                    AbstractConfig.IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get((Object)sound)[config.GetNum()] = (Integer)newValue;
                }
            }
            Map<String, int[]> map = DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA;
            synchronized (map) {
                AbstractConfig.DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get((Object)source)[config.GetNum()] = newIntValue;
            }
            AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderConfigs(AbstractConfig.GetDirectionalSoundIndicatorConfigValues());
        }
    }

    public static void SaveDirectionalSoundIndicatorConfigNewValues() {
        String[] sources = AbstractConfig.GetSources();
        int configsCount = AbstractConfig.GetDirectionalSoundIndicatorConfigsCount(false);
        int textConfigsCount = AbstractConfig.GetDirectionalSoundIndicatorConfigsCount(true);
        for (int i = 0; i < sources.length; ++i) {
            String source = sources[i];
            if (!DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(source) || !DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(source)) continue;
            int[] newConfigs = new int[configsCount];
            String[] newTextConfigs = new String[textConfigsCount];
            int configsCounter = 0;
            int textConfigsCounter = 0;
            for (int j = 0; j < AbstractConfig.GetDirectionalSoundIndicatorConfigsCount(); ++j) {
                DirectionalSoundIndicatorConfig dsiConfig = AbstractConfig.GetDirectionalSoundIndicatorConfig(j, false);
                if (dsiConfig.IsGlobal()) continue;
                if (dsiConfig.IsText()) {
                    String clampableTextValue = DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(source)[j];
                    newTextConfigs[textConfigsCounter] = clampableTextValue.substring(0, Math.min(dsiConfig.GetMaxValue(), clampableTextValue.length()));
                    AbstractConfig.DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get((Object)source)[j] = newTextConfigs[textConfigsCounter];
                    ++textConfigsCounter;
                    continue;
                }
                int clampableValue = DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(source)[j];
                newConfigs[configsCounter] = Math.clamp((long)clampableValue, dsiConfig.GetMinValue(), dsiConfig.GetMaxValue());
                AbstractConfig.DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get((Object)source)[j] = newConfigs[configsCounter];
                ++configsCounter;
            }
            ConfigBind bind = ConfigBind.DSIConfigBind(i);
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, Arrays.stream((int[])newConfigs.clone()).boxed().collect(Collectors.toList()));
            bind = ConfigBind.DSITextConfigBind(i);
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, Arrays.stream((String[])newTextConfigs.clone()).collect(Collectors.toList()));
        }
    }

    public static String GetDirectionalSoundIndicatorGlobalConfigDescription() {
        Object description = "Defines various directional sound indicator global configs.";
        String configsListText = " Configs:\n1: Show    %d ~ %d\n2: Dynamic Rotation    %d ~ %d\n3: Conic Fade    %d ~ %d\n4: Radial Fade    %d ~ %d\n5: Edge    %d ~ %d\n6: Radial Direction    %d ~ %d";
        description = (String)description + String.format(configsListText, DirectionalSoundIndicatorConfig.Show.GetMinValue(), DirectionalSoundIndicatorConfig.Show.GetMaxValue(), DirectionalSoundIndicatorConfig.DynamicRotation.GetMinValue(), DirectionalSoundIndicatorConfig.DynamicRotation.GetMaxValue(), DirectionalSoundIndicatorConfig.ConicFade.GetMinValue(), DirectionalSoundIndicatorConfig.ConicFade.GetMaxValue(), DirectionalSoundIndicatorConfig.RadialFade.GetMinValue(), DirectionalSoundIndicatorConfig.RadialFade.GetMaxValue(), DirectionalSoundIndicatorConfig.DistinctEdge.GetMinValue(), DirectionalSoundIndicatorConfig.DistinctEdge.GetMaxValue(), DirectionalSoundIndicatorConfig.RadialDirection.GetMinValue(), DirectionalSoundIndicatorConfig.RadialDirection.GetMaxValue());
        return description;
    }

    public static String GetDirectionalSoundIndicatorGlobalConfigPath() {
        return "globalDSIConfigs";
    }

    public static List<Integer> GetDirectionalSoundIndicatorGlobalConfigsDefaultValues() {
        int show = 1;
        int dynamicRotation = 1;
        int conficFade = 100;
        int radialFade = 100;
        int distinctEdge = 200;
        int radialDirection = 0;
        return List.of(Integer.valueOf(show), Integer.valueOf(dynamicRotation), Integer.valueOf(conficFade), Integer.valueOf(radialFade), Integer.valueOf(distinctEdge), Integer.valueOf(radialDirection));
    }

    public static int GetDirectionalSoundIndicatorGlobalConfigsCount() {
        int count = 0;
        for (DirectionalSoundIndicatorConfig config : DirectionalSoundIndicatorConfig.values()) {
            if (!config.IsGlobal()) continue;
            ++count;
        }
        return count;
    }

    public static boolean CheckDirectionalSoundIndicatorGlobalConfigs() {
        int configsCount = AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigsCount();
        if (DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.size() < configsCount) {
            ArrayList<Integer> newValues = new ArrayList<Integer>(configsCount);
            List<Integer> defaultValues = AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigsDefaultValues();
            for (int i = 0; i < defaultValues.size(); ++i) {
                if (DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.size() > i) {
                    newValues.add(DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.get(i));
                    continue;
                }
                newValues.add(defaultValues.get(i));
            }
            DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.clear();
            DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.addAll(newValues);
        }
        return true;
    }

    public static List<Integer> GetDirectionalSoundIndicatorGlobalConfigValues() {
        return Collections.synchronizedList(new ArrayList<Integer>(DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA));
    }

    public static int GetDirectionalSoundIndicatorGlobalConfigValue(DirectionalSoundIndicatorConfig config) {
        return AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValue(DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA, config);
    }

    public static int GetDirectionalSoundIndicatorGlobalConfigValue(List<Integer> configs, DirectionalSoundIndicatorConfig config) {
        return configs.get(config.GetNum());
    }

    public static void SetDirectionalSoundIndicatorGlobalConfigNewValue(DirectionalSoundIndicatorConfig config, int newValue) {
        newValue = Math.clamp((long)newValue, AbstractConfig.GetDirectionalSoundIndicatorConfig(config.GetNum(), true).GetMinValue(), AbstractConfig.GetDirectionalSoundIndicatorConfig(config.GetNum(), true).GetMaxValue());
        DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA.set(config.GetNum(), newValue);
        AbstractClientRenderEvents.SynchDirectionalSoundIndicatorRenderGlobalConfigs(AbstractConfig.GetDirectionalSoundIndicatorGlobalConfigValues());
    }

    public static void SaveDirectionalSoundIndicatorGlobalConfigNewValues() {
        ArrayList<Integer> configs = DIRECTIONAL_SOUND_INDICATOR_GLOBAL_CONFIGS_DATA;
        for (int i = 0; i < configs.size(); ++i) {
            configs.set(i, Math.clamp((long)((Integer)configs.get(i)).intValue(), AbstractConfig.GetDirectionalSoundIndicatorConfig(i, true).GetMinValue(), AbstractConfig.GetDirectionalSoundIndicatorConfig(i, true).GetMaxValue()));
        }
        ConfigBind bind = ConfigBind.DSIGlobalConfigBind();
        AbstractConfig.BindConfig(bind);
        AbstractConfig.SetBindedConfigNewValue(bind, configs.stream().map(value -> value).toList());
    }

    public static String GetSubtitleConfigDescription(String source, boolean isTextConfig, boolean configsList) {
        if (source == null || ((String)source).isEmpty()) {
            return "";
        }
        if (((String)source).length() < 2) {
            return ((String)source).toUpperCase();
        }
        source = Objects.equals(source = ((String)source).toLowerCase(), "ui") ? ((String)source).toUpperCase() : ((String)source).substring(0, 1).toUpperCase() + ((String)source).substring(1);
        String description = "Defines various subtitle" + (isTextConfig ? " text" : "") + " configs for " + (String)source + " sound sources.";
        if (configsList) {
            if (!isTextConfig) {
                String configsListText = " Configs:\n1: Priority    %d ~ %d\n2: Life Time    %d ~ %d (%.2f ~ %.2f seconds)\n3: Text Red Color   %d ~ %d\n4: Text Green Color    %d ~ %d\n5: Text Blue Color    %d ~ %d\n6: Background Opacity    %d ~ %d\n7: Text Opacity    %d ~ %d\n8: Final Background Opacity Percent    %d ~ %d\n9: Final Text Opacity Percent    %d ~ %d\n10: Final Text Saturation Percent    %d ~ %d\n11: Final Text Brightness Percent    %d ~ %d\n12: Affixes Saturation    %d ~ %d\n13: Affixes Brightness    %d ~ %d";
                description = description + String.format(configsListText, SubtitleConfig.Priority.GetMinValue(), SubtitleConfig.Priority.GetMaxValue(), SubtitleConfig.LifeTime.GetMinValue(), SubtitleConfig.LifeTime.GetMaxValue(), Float.valueOf((float)SubtitleConfig.LifeTime.GetMinValue() / 20.0f), Float.valueOf((float)SubtitleConfig.LifeTime.GetMaxValue() / 20.0f), SubtitleConfig.TextColorR.GetMinValue(), SubtitleConfig.TextColorR.GetMaxValue(), SubtitleConfig.TextColorG.GetMinValue(), SubtitleConfig.TextColorG.GetMaxValue(), SubtitleConfig.TextColorB.GetMinValue(), SubtitleConfig.TextColorB.GetMaxValue(), SubtitleConfig.BackgroundOpacity.GetMinValue(), SubtitleConfig.BackgroundOpacity.GetMaxValue(), SubtitleConfig.TextOpacity.GetMinValue(), SubtitleConfig.TextOpacity.GetMaxValue(), SubtitleConfig.FinalBackgroundOpacityPercent.GetMinValue(), SubtitleConfig.FinalBackgroundOpacityPercent.GetMaxValue(), SubtitleConfig.FinalTextOpacityPercent.GetMinValue(), SubtitleConfig.FinalTextOpacityPercent.GetMaxValue(), SubtitleConfig.FinalTextSaturationPercent.GetMinValue(), SubtitleConfig.FinalTextSaturationPercent.GetMaxValue(), SubtitleConfig.FinalTextBrightnessPercent.GetMinValue(), SubtitleConfig.FinalTextBrightnessPercent.GetMaxValue(), SubtitleConfig.AffixesSaturationPercent.GetMinValue(), SubtitleConfig.AffixesSaturationPercent.GetMaxValue(), SubtitleConfig.AffixesBrightnessPercent.GetMinValue(), SubtitleConfig.AffixesBrightnessPercent.GetMaxValue());
            } else {
                String configsListText = " Configs:\n1: Replaced Text    0 ~ %d symbols\n2: Prefix    0 ~ %d symbols\n3: Suffix    0 ~ %d symbols";
                description = description + String.format(configsListText, SubtitleConfig.ReplacedText.GetMaxValue(), SubtitleConfig.Prefix.GetMaxValue(), SubtitleConfig.Suffix.GetMaxValue());
            }
        }
        return description;
    }

    public static String GetSubtitleConfigPath(String source, boolean isTextConfig) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        return source.toLowerCase() + "SourceSubtitle" + (isTextConfig ? "Text" : "") + "Configs";
    }

    public static List<Integer> GetSubtitleConfigsDefaultValues(int sourceIndex) {
        int colorG;
        int colorR;
        int priority = 50;
        int lifeTime = 60;
        int backgroundOpacity = 204;
        int textOpacity = 255;
        int opacityFinalPercent = 100;
        int saturationAndBrightnessFinalPercent = 29;
        int affixesSaturationAndBrightnessPercent = 100;
        return List.of(priority, lifeTime, colorR, colorG, switch (sourceIndex) {
            case 0 -> {
                colorR = 255;
                colorG = 255;
                yield 255;
            }
            case 1 -> {
                colorR = 205;
                colorG = 205;
                yield 205;
            }
            case 2 -> {
                colorR = 255;
                colorG = 205;
                yield 155;
            }
            case 3 -> {
                colorR = 155;
                colorG = 155;
                yield 255;
            }
            case 4 -> {
                colorR = 255;
                colorG = 155;
                yield 255;
            }
            case 5 -> {
                colorR = 255;
                colorG = 155;
                yield 155;
            }
            case 6 -> {
                colorR = 155;
                colorG = 255;
                yield 155;
            }
            case 7 -> {
                colorR = 255;
                colorG = 255;
                yield 155;
            }
            case 8 -> {
                colorR = 155;
                colorG = 255;
                yield 255;
            }
            case 9 -> {
                colorR = 155;
                colorG = 155;
                yield 155;
            }
            case 10 -> {
                colorR = 205;
                colorG = 205;
                yield 205;
            }
            default -> {
                colorR = 255;
                colorG = 255;
                yield 255;
            }
        }, backgroundOpacity, textOpacity, opacityFinalPercent, opacityFinalPercent, saturationAndBrightnessFinalPercent, saturationAndBrightnessFinalPercent, affixesSaturationAndBrightnessPercent, affixesSaturationAndBrightnessPercent);
    }

    public static List<String> GetSubtitleTextConfigsDefaultValues(int sourceIndex) {
        return List.of("", "", "");
    }

    public static SubtitleConfig GetSubtitleConfig(int index, boolean isGlobal) {
        for (SubtitleConfig config : SubtitleConfig.values()) {
            if (config.GetNum() != index || config.IsGlobal() != isGlobal) continue;
            return config;
        }
        return null;
    }

    public static int GetSubtitleConfigsCount() {
        int count = 0;
        for (SubtitleConfig config : SubtitleConfig.values()) {
            if (config.IsGlobal()) continue;
            ++count;
        }
        return count;
    }

    public static int GetSubtitleConfigsCount(boolean textOnly) {
        int count = 0;
        for (SubtitleConfig config : SubtitleConfig.values()) {
            if (config.IsGlobal() || config.IsText() != textOnly) continue;
            ++count;
        }
        return count;
    }

    public static boolean CheckSubtitleConfigs() {
        String[] sources = AbstractConfig.GetSources();
        int configsCount = AbstractConfig.GetSubtitleConfigsCount();
        for (int i = 0; i < sources.length; ++i) {
            int j;
            String source = sources[i];
            int[] defaultValues = AbstractConfig.GetSubtitleConfigsDefaultValues(i).stream().mapToInt(Integer::intValue).toArray();
            String[] defaultTextValues = (String[])AbstractConfig.GetSubtitleTextConfigsDefaultValues(i).toArray(String[]::new);
            if (!SUBTITLE_CONFIGS_DATA.containsKey(source)) {
                SUBTITLE_CONFIGS_DATA.put(source, defaultValues);
            } else if (SUBTITLE_CONFIGS_DATA.get(source).length < configsCount) {
                int[] newValues = new int[configsCount];
                int[] currentValues = SUBTITLE_CONFIGS_DATA.get(source);
                for (j = 0; j < defaultValues.length; ++j) {
                    newValues[j] = SUBTITLE_CONFIGS_DATA.get(source).length > j ? currentValues[j] : defaultValues[j];
                }
                SUBTITLE_CONFIGS_DATA.put(source, newValues);
            }
            if (!SUBTITLE_TEXT_CONFIGS_DATA.containsKey(source)) {
                SUBTITLE_TEXT_CONFIGS_DATA.put(source, defaultTextValues);
                continue;
            }
            if (SUBTITLE_TEXT_CONFIGS_DATA.get(source).length >= configsCount) continue;
            String[] newTextValues = new String[configsCount];
            String[] currentTextValues = SUBTITLE_TEXT_CONFIGS_DATA.get(source);
            for (j = 0; j < defaultTextValues.length; ++j) {
                newTextValues[j] = SUBTITLE_TEXT_CONFIGS_DATA.get(source).length > j ? currentTextValues[j] : defaultTextValues[j];
            }
            SUBTITLE_TEXT_CONFIGS_DATA.put(source, newTextValues);
        }
        for (String checkableSource : sources) {
            int[] clampedValues = new int[configsCount];
            String[] clampedTextValues = new String[configsCount];
            if (!SUBTITLE_CONFIGS_DATA.containsKey(checkableSource) || SUBTITLE_CONFIGS_DATA.get(checkableSource).length < configsCount) {
                return false;
            }
            if (!SUBTITLE_TEXT_CONFIGS_DATA.containsKey(checkableSource) || SUBTITLE_TEXT_CONFIGS_DATA.get(checkableSource).length < configsCount) {
                return false;
            }
            for (SubtitleConfig config : SubtitleConfig.values()) {
                if (config.IsGlobal()) continue;
                if (config.IsText()) {
                    String textConfigValue = SUBTITLE_TEXT_CONFIGS_DATA.get(checkableSource)[config.GetNum()];
                    clampedTextValues[config.GetNum()] = textConfigValue.substring(0, Math.min(config.GetMaxValue(), textConfigValue.length()));
                    continue;
                }
                clampedValues[config.GetNum()] = Math.clamp((long)SUBTITLE_CONFIGS_DATA.get(checkableSource)[config.GetNum()], config.GetMinValue(), config.GetMaxValue());
            }
            SUBTITLE_CONFIGS_DATA.put(checkableSource, (int[])clampedValues.clone());
            SUBTITLE_TEXT_CONFIGS_DATA.put(checkableSource, (String[])clampedTextValues.clone());
        }
        return true;
    }

    public static Map<String, int[]> GetSubtitleConfigValues() {
        HashMap<String, int[]> values = new HashMap<String, int[]>();
        for (String source : AbstractConfig.GetSources()) {
            values.put(source, (int[])SUBTITLE_CONFIGS_DATA.get(source).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static Map<String, String[]> GetSubtitleTextConfigValues() {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String source : AbstractConfig.GetSources()) {
            values.put(source, (String[])SUBTITLE_TEXT_CONFIGS_DATA.get(source).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static Object GetSubtitleConfigValue(String sound, String source, SubtitleConfig config) {
        return AbstractConfig.GetSubtitleConfigValue(SUBTITLE_CONFIGS_DATA.get(source), SUBTITLE_TEXT_CONFIGS_DATA.get(source), IC_SOUNDS_DATA, sound, IC_SOUNDS_SUBTITLE_CONFIGS_DATA, IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA, config);
    }

    public static Object GetSubtitleConfigValue(int[] configs, String[] textConfigs, List<String> icSounds, String sound, Map<String, int[]> icConfigs, Map<String, String[]> icTextConfigs, SubtitleConfig config) {
        if (config.IsText()) {
            if (icSounds.contains(sound) && icTextConfigs.containsKey(sound)) {
                return icTextConfigs.get(sound)[config.GetNum()];
            }
            if (textConfigs != null) {
                return textConfigs[config.GetNum()];
            }
            return "";
        }
        if (icSounds.contains(sound) && icConfigs.containsKey(sound)) {
            return icConfigs.get(sound)[config.GetNum()];
        }
        if (configs != null) {
            return configs[config.GetNum()];
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SetSubtitleConfigNewValue(String sound, String source, SubtitleConfig config, Object newValue) {
        if (config.IsText()) {
            String newStringValue = ((String)newValue).substring(0, Math.min(config.GetMaxValue(), ((String)newValue).length()));
            if (IC_SOUNDS_DATA.contains(sound) && IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.containsKey(sound)) {
                Map<String, String[]> map = IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA;
                synchronized (map) {
                    AbstractConfig.IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.get((Object)sound)[config.GetNum()] = (String)newValue;
                }
            }
            Map<String, String[]> map = SUBTITLE_TEXT_CONFIGS_DATA;
            synchronized (map) {
                AbstractConfig.SUBTITLE_TEXT_CONFIGS_DATA.get((Object)source)[config.GetNum()] = newStringValue;
            }
            AbstractClientRenderEvents.SynchSubtitleRenderTextConfigs(AbstractConfig.GetSubtitleTextConfigValues());
        } else {
            int newIntValue = Math.clamp((long)((Integer)newValue).intValue(), AbstractConfig.GetSubtitleConfig(config.GetNum(), false).GetMinValue(), AbstractConfig.GetSubtitleConfig(config.GetNum(), false).GetMaxValue());
            if (IC_SOUNDS_DATA.contains(sound) && IC_SOUNDS_SUBTITLE_CONFIGS_DATA.containsKey(sound)) {
                Map<String, int[]> map = IC_SOUNDS_SUBTITLE_CONFIGS_DATA;
                synchronized (map) {
                    AbstractConfig.IC_SOUNDS_SUBTITLE_CONFIGS_DATA.get((Object)sound)[config.GetNum()] = (Integer)newValue;
                }
            }
            Map<String, int[]> map = SUBTITLE_CONFIGS_DATA;
            synchronized (map) {
                AbstractConfig.SUBTITLE_CONFIGS_DATA.get((Object)source)[config.GetNum()] = newIntValue;
            }
            AbstractClientRenderEvents.SynchSubtitleRenderConfigs(AbstractConfig.GetSubtitleConfigValues());
        }
    }

    public static void SaveSubtitleConfigNewValues() {
        String[] sources = AbstractConfig.GetSources();
        int configsCount = AbstractConfig.GetSubtitleConfigsCount(false);
        int textConfigsCount = AbstractConfig.GetSubtitleConfigsCount(true);
        for (int i = 0; i < sources.length; ++i) {
            String source = sources[i];
            if (!SUBTITLE_CONFIGS_DATA.containsKey(source) || !SUBTITLE_TEXT_CONFIGS_DATA.containsKey(source)) continue;
            int[] newConfigs = new int[configsCount];
            String[] newTextConfigs = new String[textConfigsCount];
            int configsCounter = 0;
            int textConfigsCounter = 0;
            for (int j = 0; j < AbstractConfig.GetSubtitleConfigsCount(); ++j) {
                SubtitleConfig subtitleConfig = AbstractConfig.GetSubtitleConfig(j, false);
                if (subtitleConfig.IsGlobal()) continue;
                if (subtitleConfig.IsText()) {
                    String clampableTextValue = SUBTITLE_TEXT_CONFIGS_DATA.get(source)[j];
                    newTextConfigs[textConfigsCounter] = clampableTextValue.substring(0, Math.min(subtitleConfig.GetMaxValue(), clampableTextValue.length()));
                    AbstractConfig.SUBTITLE_TEXT_CONFIGS_DATA.get((Object)source)[j] = newTextConfigs[textConfigsCounter];
                    ++textConfigsCounter;
                    continue;
                }
                int clampableValue = SUBTITLE_CONFIGS_DATA.get(source)[j];
                newConfigs[configsCounter] = Math.clamp((long)clampableValue, subtitleConfig.GetMinValue(), subtitleConfig.GetMaxValue());
                AbstractConfig.SUBTITLE_CONFIGS_DATA.get((Object)source)[j] = newConfigs[configsCounter];
                ++configsCounter;
            }
            ConfigBind bind = ConfigBind.SubtitleConfigBind(i);
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, Arrays.stream((int[])newConfigs.clone()).boxed().collect(Collectors.toList()));
            bind = ConfigBind.SubtitleTextConfigBind(i);
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, Arrays.stream((String[])newTextConfigs.clone()).collect(Collectors.toList()));
        }
    }

    public static String GetSubtitleGlobalConfigDescription() {
        Object description = "Defines various subtitle global configs.";
        String configsListText = " Configs:\n1: Horizontal Anchor    %d ~ %d\n2: Vertical Anchor    %d ~ %d\n3: Horizontal Offset    %d ~ %d\n4: Vertical Offset    %d ~ %d\n5: Scale    %d ~ %d\n6: Priority Order    %d ~ %d\n7: Show Volume    %d ~ %d\n8: Show Pitch    %d ~ %d\n9: V/P Anchor    %d ~ %d\n10: V/P Hint    %d ~ %d\n11: V/P Saturation Percent    %d ~ %d\n12: V/P Brightness Percent    %d ~ %d\n13: Replace Text With ID    %d ~ %d\n14: Show All Sounds    %d ~ %d\n15: Show Direction    %d ~ %d\n16: Show In World    %d ~ %d\n17: In World Scale    %d ~ %d\n18: In World Y Offset    %d ~ %d (%d ~ %d blocks)\n19: In World Combination Distance    %d ~ %d (%d ~ %d blocks)\n20: In World Opacity Fade Minimum Distance    %d ~ %d (%d ~ %d blocks)\n21: In World Opacity Fade Maximum Distance    %d ~ %d (%d ~ %d blocks)\n22: In World Opacity Fade Percent    %d ~ %d";
        description = (String)description + String.format(configsListText, SubtitleConfig.HorizontalLocation.GetMinValue(), SubtitleConfig.HorizontalLocation.GetMaxValue(), SubtitleConfig.VerticalLocation.GetMinValue(), SubtitleConfig.VerticalLocation.GetMaxValue(), SubtitleConfig.HorizontalOffset.GetMinValue(), SubtitleConfig.HorizontalOffset.GetMaxValue(), SubtitleConfig.VerticalOffset.GetMinValue(), SubtitleConfig.VerticalOffset.GetMaxValue(), SubtitleConfig.Scale.GetMinValue(), SubtitleConfig.Scale.GetMaxValue(), SubtitleConfig.PriorityOrder.GetMinValue(), SubtitleConfig.PriorityOrder.GetMaxValue(), SubtitleConfig.VolumeCharacteristic.GetMinValue(), SubtitleConfig.VolumeCharacteristic.GetMaxValue(), SubtitleConfig.PitchCharacteristic.GetMinValue(), SubtitleConfig.PitchCharacteristic.GetMaxValue(), SubtitleConfig.CharacteristicsLocation.GetMinValue(), SubtitleConfig.CharacteristicsLocation.GetMaxValue(), SubtitleConfig.CharacteristicsHint.GetMinValue(), SubtitleConfig.CharacteristicsHint.GetMaxValue(), SubtitleConfig.CharacteristicsSaturationPercent.GetMinValue(), SubtitleConfig.CharacteristicsSaturationPercent.GetMaxValue(), SubtitleConfig.CharacteristicsBrightnessPercent.GetMinValue(), SubtitleConfig.CharacteristicsBrightnessPercent.GetMaxValue(), SubtitleConfig.ReplaceNameWithLocation.GetMinValue(), SubtitleConfig.ReplaceNameWithLocation.GetMaxValue(), SubtitleConfig.ShowAll.GetMinValue(), SubtitleConfig.ShowAll.GetMaxValue(), SubtitleConfig.DirectionArrows.GetMinValue(), SubtitleConfig.DirectionArrows.GetMaxValue(), SubtitleConfig.ShowInWorld.GetMinValue(), SubtitleConfig.ShowInWorld.GetMaxValue(), SubtitleConfig.InWorldScale.GetMinValue(), SubtitleConfig.InWorldScale.GetMaxValue(), SubtitleConfig.InWorldOffsetY.GetMinValue(), SubtitleConfig.InWorldOffsetY.GetMaxValue(), SubtitleConfig.InWorldOffsetY.GetMinValue() / 20, SubtitleConfig.InWorldOffsetY.GetMaxValue() / 20, SubtitleConfig.InWorldRefreshDistance.GetMinValue(), SubtitleConfig.InWorldRefreshDistance.GetMaxValue(), SubtitleConfig.InWorldRefreshDistance.GetMinValue() / 20, SubtitleConfig.InWorldRefreshDistance.GetMaxValue() / 20, SubtitleConfig.InWorldOpacityFadeMinDistance.GetMinValue(), SubtitleConfig.InWorldOpacityFadeMinDistance.GetMaxValue(), SubtitleConfig.InWorldOpacityFadeMinDistance.GetMinValue() / 20, SubtitleConfig.InWorldOpacityFadeMinDistance.GetMaxValue() / 20, SubtitleConfig.InWorldOpacityFadeMaxDistance.GetMinValue(), SubtitleConfig.InWorldOpacityFadeMaxDistance.GetMaxValue(), SubtitleConfig.InWorldOpacityFadeMaxDistance.GetMinValue() / 20, SubtitleConfig.InWorldOpacityFadeMaxDistance.GetMaxValue() / 20, SubtitleConfig.InWorldOpacityFadePercent.GetMinValue(), SubtitleConfig.InWorldOpacityFadePercent.GetMaxValue());
        return description;
    }

    public static String GetSubtitleGlobalConfigPath() {
        return "globalSubtitleConfigs";
    }

    public static List<Integer> GetSubtitleGlobalConfigsDefaultValues() {
        int horizontalAnchor = 1;
        int verticalAnchor = 1;
        int horizontalOffset = 0;
        int verticalOffset = 35;
        int scale = 100;
        int priorityOrder = 0;
        int showVolume = 0;
        int showPitch = 0;
        int characteristicsAnchor = 0;
        int characteristicsHint = 0;
        int characteristicsSaturationPercent = 42;
        int characteristicsBrightnessPercent = 71;
        int replaceTextWithLocation = 0;
        int showAll = 0;
        int showDirection = 1;
        int showInWorld = 0;
        int inWorldScale = 100;
        int inWorldOffsetY = 10;
        int inWorldRefreshDistance = 35;
        int inWorldOpacityFadeMinDistance = 20;
        int inWorldOpacityFadeMaxDistance = 100;
        int inWorldOpacityFadePercent = 0;
        return List.of(horizontalAnchor, verticalAnchor, horizontalOffset, verticalOffset, scale, priorityOrder, showVolume, showPitch, characteristicsAnchor, characteristicsHint, characteristicsSaturationPercent, characteristicsBrightnessPercent, replaceTextWithLocation, showAll, showDirection, showInWorld, inWorldScale, inWorldOffsetY, inWorldRefreshDistance, inWorldOpacityFadeMinDistance, inWorldOpacityFadeMaxDistance, inWorldOpacityFadePercent);
    }

    public static int GetSubtitleGlobalConfigsCount() {
        int count = 0;
        for (SubtitleConfig config : SubtitleConfig.values()) {
            if (!config.IsGlobal()) continue;
            ++count;
        }
        return count;
    }

    public static boolean CheckSubtitleGlobalConfigs() {
        int configsCount = AbstractConfig.GetSubtitleGlobalConfigsCount();
        if (SUBTITLE_GLOBAL_CONFIGS_DATA.size() < configsCount) {
            ArrayList<Integer> newValues = new ArrayList<Integer>(configsCount);
            List<Integer> defaultValues = AbstractConfig.GetSubtitleGlobalConfigsDefaultValues();
            for (int i = 0; i < defaultValues.size(); ++i) {
                if (SUBTITLE_GLOBAL_CONFIGS_DATA.size() > i) {
                    newValues.add(SUBTITLE_GLOBAL_CONFIGS_DATA.get(i));
                    continue;
                }
                newValues.add(defaultValues.get(i));
            }
            SUBTITLE_GLOBAL_CONFIGS_DATA.clear();
            SUBTITLE_GLOBAL_CONFIGS_DATA.addAll(new ArrayList(newValues));
        }
        return true;
    }

    public static List<Integer> GetSubtitleGlobalConfigValues() {
        return Collections.synchronizedList(new ArrayList<Integer>(SUBTITLE_GLOBAL_CONFIGS_DATA));
    }

    public static int GetSubtitleGlobalConfigValue(SubtitleConfig config) {
        return AbstractConfig.GetSubtitleGlobalConfigValue(SUBTITLE_GLOBAL_CONFIGS_DATA, config);
    }

    public static int GetSubtitleGlobalConfigValue(List<Integer> configs, SubtitleConfig config) {
        return configs.get(config.GetNum());
    }

    public static void SetSubtitleGlobalConfigNewValue(SubtitleConfig config, int newValue) {
        newValue = Math.clamp((long)newValue, AbstractConfig.GetSubtitleConfig(config.GetNum(), true).GetMinValue(), AbstractConfig.GetSubtitleConfig(config.GetNum(), true).GetMaxValue());
        SUBTITLE_GLOBAL_CONFIGS_DATA.set(config.GetNum(), newValue);
        AbstractClientRenderEvents.SynchSubtitleRenderGlobalConfigs(AbstractConfig.GetSubtitleGlobalConfigValues());
    }

    public static void SaveSubtitleGlobalConfigNewValues() {
        ArrayList<Integer> configs = SUBTITLE_GLOBAL_CONFIGS_DATA;
        for (int i = 0; i < configs.size(); ++i) {
            configs.set(i, Math.clamp((long)((Integer)configs.get(i)).intValue(), AbstractConfig.GetSubtitleConfig(i, true).GetMinValue(), AbstractConfig.GetSubtitleConfig(i, true).GetMaxValue()));
        }
        ConfigBind bind = ConfigBind.SubtitleGlobalConfigBind();
        AbstractConfig.BindConfig(bind);
        AbstractConfig.SetBindedConfigNewValue(bind, configs.stream().map(value -> value).toList());
    }

    public static String GetIndividuallyConfiguredSoundsDescription() {
        return "Defines all individually configured sounds. Essentially, dictionary keys.";
    }

    public static String GetIndividuallyConfiguredSoundsPath() {
        return "individuallyConfiguredSounds";
    }

    public static List<String> GetIndividuallyConfiguredSoundsDefaultValue() {
        return List.of();
    }

    public static String GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigsDescription() {
        return "Defines all DSI configs for individually configured sounds. Essentially, dictionary values.";
    }

    public static String GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigsPath() {
        return "IndividuallyConfiguredDSIConfigs";
    }

    public static List<Integer> GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigsDefaultValues() {
        return List.of();
    }

    public static Map<String, int[]> GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigs() {
        HashMap<String, int[]> values = new HashMap<String, int[]>();
        for (String sound : IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.keySet()) {
            values.put(sound, (int[])IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(sound).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static String GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigsDescription() {
        return "Defines all DSI text configs for individually configured sounds. Essentially, dictionary values.";
    }

    public static String GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigsPath() {
        return "IndividuallyConfiguredDSITextConfigs";
    }

    public static List<String> GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigsDefaultValues() {
        return List.of();
    }

    public static Map<String, String[]> GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigs() {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String sound : IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.keySet()) {
            values.put(sound, (String[])IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(sound).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static String GetIndividuallyConfiguredSoundsSubtitleConfigsDescription() {
        return "Defines all subtitle configs for individually configured sounds. Essentially, dictionary values.";
    }

    public static String GetIndividuallyConfiguredSoundsSubtitleConfigsPath() {
        return "IndividuallyConfiguredSubtitleConfigs";
    }

    public static List<Integer> GetIndividuallyConfiguredSoundsSubtitleConfigsDefaultValues() {
        return List.of();
    }

    public static Map<String, int[]> GetIndividuallyConfiguredSoundsSubtitleConfigs() {
        HashMap<String, int[]> values = new HashMap<String, int[]>();
        for (String sound : IC_SOUNDS_SUBTITLE_CONFIGS_DATA.keySet()) {
            values.put(sound, (int[])IC_SOUNDS_SUBTITLE_CONFIGS_DATA.get(sound).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static String GetIndividuallyConfiguredSoundsSubtitleTextConfigsDescription() {
        return "Defines all subtitle text configs for individually configured sounds. Essentially, dictionary values.";
    }

    public static String GetIndividuallyConfiguredSoundsSubtitleTextConfigsPath() {
        return "IndividuallyConfiguredSubtitleTextConfigs";
    }

    public static List<String> GetIndividuallyConfiguredSoundsSubtitleTextConfigsDefaultValues() {
        return List.of();
    }

    public static Map<String, String[]> GetIndividuallyConfiguredSoundsSubtitleTextConfigs() {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        for (String sound : IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.keySet()) {
            values.put(sound, (String[])IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.get(sound).clone());
        }
        return Collections.synchronizedMap(values);
    }

    public static String[] GetIndividuallyConfiguredSounds() {
        return IC_SOUNDS_DATA.toArray(new String[IC_SOUNDS_DATA.size()]);
    }

    public static void AddIndividuallyConfiguredSound(String source, String sound) {
        if (!IC_SOUNDS_DATA.contains(sound)) {
            IC_SOUNDS_DATA.add(sound);
            int[] newValues = new int[AbstractConfig.GetDirectionalSoundIndicatorConfigsCount()];
            String[] newTextValues = new String[AbstractConfig.GetDirectionalSoundIndicatorConfigsCount()];
            for (DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig : DirectionalSoundIndicatorConfig.values()) {
                if (directionalSoundIndicatorConfig.IsGlobal()) continue;
                if (directionalSoundIndicatorConfig.IsText()) {
                    newTextValues[directionalSoundIndicatorConfig.GetNum()] = (String)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(sound, source, directionalSoundIndicatorConfig);
                    continue;
                }
                newValues[directionalSoundIndicatorConfig.GetNum()] = (Integer)AbstractConfig.GetDirectionalSoundIndicatorConfigValue(sound, source, directionalSoundIndicatorConfig);
            }
            IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.put(sound, (int[])newValues.clone());
            IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.put(sound, (String[])newTextValues.clone());
            newValues = new int[AbstractConfig.GetSubtitleConfigsCount()];
            newTextValues = new String[AbstractConfig.GetSubtitleConfigsCount()];
            for (Enum enum_ : SubtitleConfig.values()) {
                if (((SubtitleConfig)enum_).IsGlobal()) continue;
                if (((SubtitleConfig)enum_).IsText()) {
                    newTextValues[((SubtitleConfig)enum_).GetNum()] = (String)AbstractConfig.GetSubtitleConfigValue(sound, source, (SubtitleConfig)enum_);
                    continue;
                }
                newValues[((SubtitleConfig)enum_).GetNum()] = (Integer)AbstractConfig.GetSubtitleConfigValue(sound, source, (SubtitleConfig)enum_);
            }
            IC_SOUNDS_SUBTITLE_CONFIGS_DATA.put(sound, (int[])newValues.clone());
            IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.put(sound, (String[])newTextValues.clone());
        }
        AbstractClientRenderEvents.SynchIndividuallyConfiguredSoundsRenderConfigs(IC_SOUNDS_DATA, AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleTextConfigs());
    }

    public static void RemoveIndividuallyConfiguredSound(String sound) {
        if (IC_SOUNDS_DATA.contains(sound)) {
            IC_SOUNDS_DATA.remove(sound);
            if (IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(sound)) {
                IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.remove(sound);
            }
            if (IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(sound)) {
                IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.remove(sound);
            }
            if (IC_SOUNDS_SUBTITLE_CONFIGS_DATA.containsKey(sound)) {
                IC_SOUNDS_SUBTITLE_CONFIGS_DATA.remove(sound);
            }
            if (IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.containsKey(sound)) {
                IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.remove(sound);
            }
            AbstractClientRenderEvents.SynchIndividuallyConfiguredSoundsRenderConfigs(IC_SOUNDS_DATA, AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsDirectionalSoundIndicatorTextConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleConfigs(), AbstractConfig.GetIndividuallyConfiguredSoundsSubtitleTextConfigs());
        }
    }

    public static void SetIndividuallyConfiguredSounds(String[] sounds) {
        IC_SOUNDS_DATA.clear();
        IC_SOUNDS_DATA.addAll(Arrays.stream(sounds).collect(Collectors.toList()));
    }

    public static void SaveIndividuallyConfiguredSoundsConfigs() {
        if (!IC_SOUNDS_DATA.isEmpty()) {
            ArrayList<String> sounds = new ArrayList<String>();
            ArrayList<Integer> dsiConfigs = new ArrayList<Integer>();
            ArrayList<String> dsiTextConfigs = new ArrayList<String>();
            ArrayList<Integer> subtitleConfigs = new ArrayList<Integer>();
            ArrayList<String> subtitleTextConfigs = new ArrayList<String>();
            for (String sound2 : IC_SOUNDS_DATA) {
                if (!IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.containsKey(sound2) || !IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.containsKey(sound2) || !IC_SOUNDS_SUBTITLE_CONFIGS_DATA.containsKey(sound2) || !IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.containsKey(sound2)) continue;
                sounds.add(sound2);
                for (DirectionalSoundIndicatorConfig directionalSoundIndicatorConfig : DirectionalSoundIndicatorConfig.values()) {
                    if (directionalSoundIndicatorConfig.IsGlobal()) continue;
                    if (directionalSoundIndicatorConfig.IsText()) {
                        dsiTextConfigs.add(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_TEXT_CONFIGS_DATA.get(sound2)[directionalSoundIndicatorConfig.GetNum()]);
                        continue;
                    }
                    dsiConfigs.add(IC_SOUNDS_DIRECTIONAL_SOUND_INDICATOR_CONFIGS_DATA.get(sound2)[directionalSoundIndicatorConfig.GetNum()]);
                }
                for (Enum enum_ : SubtitleConfig.values()) {
                    if (((SubtitleConfig)enum_).IsGlobal()) continue;
                    if (((SubtitleConfig)enum_).IsText()) {
                        subtitleTextConfigs.add(IC_SOUNDS_SUBTITLE_TEXT_CONFIGS_DATA.get(sound2)[((SubtitleConfig)enum_).GetNum()]);
                        continue;
                    }
                    subtitleConfigs.add(IC_SOUNDS_SUBTITLE_CONFIGS_DATA.get(sound2)[((SubtitleConfig)enum_).GetNum()]);
                }
            }
            ConfigBind bind = ConfigBind.ICConfigBind();
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, sounds.stream().map(sound -> sound).toList());
            bind = ConfigBind.ICDSIConfigBind();
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, dsiConfigs.stream().map(value -> value).toList());
            bind = ConfigBind.ICDSITextConfigBind();
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, dsiTextConfigs.stream().map(value -> value).toList());
            bind = ConfigBind.ICSubtitleConfigBind();
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, subtitleConfigs.stream().map(value -> value).toList());
            bind = ConfigBind.ICSubtitleTextConfigBind();
            AbstractConfig.BindConfig(bind);
            AbstractConfig.SetBindedConfigNewValue(bind, subtitleTextConfigs.stream().map(value -> value).toList());
        }
    }

    public static String GetIgnorablesSourcesDescription() {
        return "Specifies sounds sources that are ignored by the directional sound indicator and subtitle visualization.";
    }

    public static String GetIgnorablesSourcesPath() {
        return "ignorableSources";
    }

    public static List<String> GetIgnorablesSourcesDefaultValue() {
        return List.of();
    }

    public static String[] GetIgnorableSources() {
        return IGNORABLE_SOURCES_DATA.toArray(new String[IGNORABLE_SOURCES_DATA.size()]);
    }

    public static boolean ContainsInIgnorableSources(String source) {
        return AbstractConfig.ContainsInIgnorableSources(IGNORABLE_SOURCES_DATA, source);
    }

    public static boolean ContainsInIgnorableSources(List<String> sources, String source) {
        return sources.contains(source);
    }

    public static void AddInIgnorableSources(String source) {
        if (!AbstractConfig.ContainsInIgnorableSources(source)) {
            IGNORABLE_SOURCES_DATA.add(source);
        }
        AbstractClientRenderEvents.SynchIgnorableSourcesRender(new ArrayList<String>(IGNORABLE_SOURCES_DATA));
    }

    public static void RemoveFromIgnorableSources(String source) {
        if (AbstractConfig.ContainsInIgnorableSources(source)) {
            IGNORABLE_SOURCES_DATA.remove(source);
        }
        AbstractClientRenderEvents.SynchIgnorableSourcesRender(new ArrayList<String>(IGNORABLE_SOURCES_DATA));
    }

    public static void SaveIgnorableSources() {
        ConfigBind bind = ConfigBind.IgnorableSourcesConfigBind();
        AbstractConfig.BindConfig(bind);
        AbstractConfig.SetBindedConfigNewValue(bind, new ArrayList<String>(IGNORABLE_SOURCES_DATA).stream().map(source -> source).toList());
    }

    public static String GetIgnorablesSoundsDescription() {
        return "Specifies sounds that are ignored by the directional sound indicator and subtitle visualization.";
    }

    public static String GetIgnorablesSoundsPath() {
        return "ignorableSounds";
    }

    public static List<String> GetIgnorablesSoundsDefaultValue() {
        return List.of("minecraft:ui.toast.in", "minecraft:ui.button.click", "minecraft:ui.stonecutter.select_recipe", "minecraft:ui.stonecutter.take_result", "minecraft:ui.cartography_table.take_result", "minecraft:ui.toast.challenge_complete", "minecraft:ui.loom.take_result", "minecraft:ui.loom.select_pattern", "minecraft:ui.toast.out");
    }

    public static String[] GetIgnorableSounds() {
        return IGNORABLE_SOUNDS_DATA.toArray(new String[IGNORABLE_SOUNDS_DATA.size()]);
    }

    public static boolean ContainsInIgnorableSounds(String sound) {
        return AbstractConfig.ContainsInIgnorableSounds(IGNORABLE_SOUNDS_DATA, sound);
    }

    public static boolean ContainsInIgnorableSounds(List<String> sounds, String sound) {
        return sounds.contains(sound);
    }

    public static void AddInIgnorableSounds(String sound) {
        if (!AbstractConfig.ContainsInIgnorableSounds(sound)) {
            IGNORABLE_SOUNDS_DATA.add(sound);
        }
        AbstractClientRenderEvents.SynchIgnorableSoundsRender(new ArrayList<String>(IGNORABLE_SOUNDS_DATA));
    }

    public static void RemoveFromIgnorableSounds(String sound) {
        if (AbstractConfig.ContainsInIgnorableSounds(sound)) {
            IGNORABLE_SOUNDS_DATA.remove(sound);
        }
        AbstractClientRenderEvents.SynchIgnorableSoundsRender(new ArrayList<String>(IGNORABLE_SOUNDS_DATA));
    }

    public static void SaveIgnorableSounds() {
        ConfigBind bind = ConfigBind.IgnorableSoundsConfigBind();
        AbstractConfig.BindConfig(bind);
        AbstractConfig.SetBindedConfigNewValue(bind, new ArrayList<String>(IGNORABLE_SOUNDS_DATA).stream().map(sound -> sound).toList());
    }

    public static String GetFavoriteSoundsDescription() {
        return "Specifies sounds that are displayed first in config screen's sound list";
    }

    public static String GetFavoriteSoundsPath() {
        return "favoriteSounds";
    }

    public static List<String> GetFavoriteSoundsDefaultValue() {
        return List.of();
    }

    public static String[] GetFavoriteSounds() {
        return FAVORITE_SOUNDS_DATA.toArray(new String[FAVORITE_SOUNDS_DATA.size()]);
    }

    public static boolean ContainsInFavoriteSounds(String sound) {
        return AbstractConfig.ContainsInFavoriteSounds(FAVORITE_SOUNDS_DATA, sound);
    }

    public static boolean ContainsInFavoriteSounds(List<String> sounds, String sound) {
        return sounds.contains(sound);
    }

    public static void AddInFavoriteSounds(String sound) {
        if (!AbstractConfig.ContainsInFavoriteSounds(sound)) {
            FAVORITE_SOUNDS_DATA.add(sound);
        }
        AbstractClientRenderEvents.SynchFavoriteSoundsRender(new ArrayList<String>(FAVORITE_SOUNDS_DATA));
    }

    public static void RemoveFromFavoriteSounds(String sound) {
        if (AbstractConfig.ContainsInFavoriteSounds(sound)) {
            FAVORITE_SOUNDS_DATA.remove(sound);
        }
        AbstractClientRenderEvents.SynchFavoriteSoundsRender(new ArrayList<String>(FAVORITE_SOUNDS_DATA));
    }

    public static void SaveFavoriteSounds() {
        ConfigBind bind = ConfigBind.FavoriteSoundsConfigBind();
        AbstractConfig.BindConfig(bind);
        AbstractConfig.SetBindedConfigNewValue(bind, new ArrayList<String>(FAVORITE_SOUNDS_DATA).stream().map(sound -> sound).toList());
    }

    public static AbstractConfig SetupInstance(AbstractConfig instance) {
        _instance = instance;
        return _instance;
    }

    protected static void BindConfig(ConfigBind bind) {
        _instance.InstanceBindConfig(bind);
    }

    protected abstract void InstanceBindConfig(ConfigBind var1);

    protected static List<Object> GetBindedConfigValue(ConfigBind bind) {
        return _instance.InstanceGetBindedConfigValue(bind);
    }

    protected abstract List<Object> InstanceGetBindedConfigValue(ConfigBind var1);

    protected static void SetBindedConfigNewValue(ConfigBind bind, List<Object> newValues) {
        _instance.InstanceSetBindedConfigNewValue(bind, newValues);
    }

    protected abstract void InstanceSetBindedConfigNewValue(ConfigBind var1, List<Object> var2);

    protected static String[] GetSources() {
        return _instance.InstanceGetSources();
    }

    protected abstract String[] InstanceGetSources();

    public static void SaveConfig() {
        _instance.InstanceSaveConfig();
    }

    protected abstract void InstanceSaveConfig();

    public static enum DirectionalSoundIndicatorConfig {
        Radius(0, "", 0, 200),
        Thickness(1, "", 2, 200),
        Width(2, "", 2, 360),
        ColorR(3, "Color", 0, 255),
        ColorG(4, "Color", 0, 255),
        ColorB(5, "Color", 0, 255),
        Opacity(6, "", 0, 255),
        LifeTime(7, "LifeTime", 2, 400),
        OpacityMDP(8, "MDP", 0, 500),
        WidthMDP(9, "MDP", 0, 500),
        LifeTimeMDP(10, "LifeTime,MDP", 0, 500),
        Show(0, "Global", 0, 1),
        DynamicRotation(1, "Global", 0, 1),
        ConicFade(2, "Global", 0, 500),
        RadialFade(3, "Global", 0, 500),
        DistinctEdge(4, "Global", 0, 500),
        RadialDirection(5, "Global", 0, 1);

        private final int _config;
        private final String _types;
        private final int _minValue;
        private final int _maxValue;

        private DirectionalSoundIndicatorConfig(int config, String types, int minValue, int maxValue) {
            this._config = config;
            this._types = types;
            this._minValue = minValue;
            this._maxValue = maxValue;
        }

        public int GetNum() {
            return this._config;
        }

        public boolean IsColor() {
            return this._types.contains("Color");
        }

        public boolean IsLifeTime() {
            return this._types.contains("LifeTime");
        }

        public boolean IsMaxDistancePercent() {
            return this._types.contains("MDP");
        }

        public boolean IsText() {
            return this._types.contains("Text");
        }

        public boolean IsGlobal() {
            return this._types.contains("Global");
        }

        public int GetMinValue() {
            return this._minValue;
        }

        public int GetMaxValue() {
            return this._maxValue;
        }
    }

    public static enum SubtitleConfig {
        Priority(0, "", 1, 100),
        LifeTime(1, "LifeTime", 2, 400),
        TextColorR(2, "Color", 0, 255),
        TextColorG(3, "Color", 0, 255),
        TextColorB(4, "Color", 0, 255),
        BackgroundOpacity(5, "", 0, 255),
        TextOpacity(6, "", 0, 255),
        FinalBackgroundOpacityPercent(7, "Final", 0, 500),
        FinalTextOpacityPercent(8, "Final", 0, 500),
        FinalTextSaturationPercent(9, "Final", 0, 500),
        FinalTextBrightnessPercent(10, "Final", 0, 500),
        ReplacedText(11, "Text", 0, 40),
        Prefix(12, "Text", 0, 20),
        Suffix(13, "Text", 0, 20),
        AffixesSaturationPercent(14, "", 0, 500),
        AffixesBrightnessPercent(15, "", 0, 500),
        HorizontalLocation(0, "Global", 0, 1),
        VerticalLocation(1, "Global", 0, 1),
        HorizontalOffset(2, "Global", 0, 200),
        VerticalOffset(3, "Global", 0, 200),
        Scale(4, "Global", 25, 500),
        PriorityOrder(5, "Global", 0, 1),
        VolumeCharacteristic(6, "Global", 0, 1),
        PitchCharacteristic(7, "Global", 0, 1),
        CharacteristicsLocation(8, "Global", 0, 3),
        CharacteristicsHint(9, "Global", 0, 1),
        CharacteristicsSaturationPercent(10, "Global", 0, 500),
        CharacteristicsBrightnessPercent(11, "Global", 0, 500),
        ReplaceNameWithLocation(12, "Global", 0, 1),
        ShowAll(13, "Global", 0, 1),
        DirectionArrows(14, "Global", 0, 1),
        ShowInWorld(15, "Global", 0, 2),
        InWorldScale(16, "Global", 25, 500),
        InWorldOffsetY(17, "Global", 0, 200),
        InWorldRefreshDistance(18, "Global", 0, 200),
        InWorldOpacityFadeMinDistance(19, "Global", 0, 400),
        InWorldOpacityFadeMaxDistance(20, "Global", 0, 400),
        InWorldOpacityFadePercent(21, "Global", 0, 500);

        private final int _config;
        private final String _types;
        private final int _minValue;
        private final int _maxValue;

        private SubtitleConfig(int config, String types, int minValue, int maxValue) {
            this._config = config;
            this._types = types;
            this._minValue = minValue;
            this._maxValue = maxValue;
        }

        public int GetNum() {
            return this._config;
        }

        public boolean IsLifeTime() {
            return this._types.contains("LifeTime");
        }

        public boolean IsColor() {
            return this._types.contains("Color");
        }

        public boolean IsFinal() {
            return this._types.contains("Final");
        }

        public boolean IsText() {
            return this._types.contains("Text");
        }

        public boolean IsGlobal() {
            return this._types.contains("Global");
        }

        public int GetMinValue() {
            return this._minValue;
        }

        public int GetMaxValue() {
            return this._maxValue;
        }
    }
}

