/*
 * Decompiled with CFR 0.152.
 */
package com.dgneos.sound_visualizer.client;

import com.dgneos.sound_visualizer.AbstractBetterSubtitle;
import com.dgneos.sound_visualizer.AbstractClientData;
import com.dgneos.sound_visualizer.AbstractDirectionalSoundIndicator;
import com.dgneos.sound_visualizer.ModLogic;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ClientData
extends AbstractClientData {
    protected static final Minecraft MC = Minecraft.getInstance();
    public static final OptionInstance<Boolean> SHOW_DIRECTIONAL_SOUND_INDICATORS = OptionInstance.createBoolean((String)"options.sound_visualizer.show_directional_sound_indicators", (boolean)true);

    @Override
    protected AbstractDirectionalSoundIndicator InstanceCreateDirectionalSoundIndicator(Object sound, float fixedRotation, float distanceWeight) {
        return new DirectionalSoundIndicator((SoundInstance)sound, new Vec3(ModLogic.GetSoundPosX(sound), ModLogic.GetSoundPosY(sound), ModLogic.GetSoundPosZ(sound)), fixedRotation, distanceWeight);
    }

    @Override
    protected AbstractBetterSubtitle InstanceCreateBetterSubtitle(Object sound, String subtitleText, double inWorldPosX, double inWorldPosY, double inWorldPosZ) {
        return new BetterSubtitle((SoundInstance)sound, (Component)Component.literal((String)subtitleText), new Vec3(inWorldPosX, inWorldPosY, inWorldPosZ));
    }

    @Override
    protected Object InstanceGetShowDSIsOptionInstance() {
        return SHOW_DIRECTIONAL_SOUND_INDICATORS;
    }

    public static class DirectionalSoundIndicator
    extends AbstractDirectionalSoundIndicator {
        private final DynamicTexture _dynamicTexture;
        private final ResourceLocation _textureLocation;
        private NativeImage _image;

        public DirectionalSoundIndicator(@Nonnull SoundInstance sound, Vec3 position, float fixedRotation, float distanceWeight) {
            super(sound, sound.getSource().getName(), position.x, position.y, position.z, fixedRotation, distanceWeight);
            this._dynamicTexture = new DynamicTexture(this._image);
            this._textureLocation = ResourceLocation.fromNamespaceAndPath((String)"sound_visualizer", (String)this.GetLocation());
            MC.getTextureManager().register(this._textureLocation, (AbstractTexture)this._dynamicTexture);
            RenderSystem.recordRenderCall(() -> {
                this._loaded = true;
            });
        }

        @Override
        public void Kill() {
            MC.getTextureManager().release(this._textureLocation);
        }

        @Override
        protected void SetupNativeImage() {
            this._image = new NativeImage(this.GetDiametr(), this.GetDiametr(), true);
        }

        @Override
        protected void SetPixelRGBA(int x, int y, int color) {
            this._image.setPixel(x, y, ARGB.fromABGR((int)color));
        }
    }

    public static class BetterSubtitle
    extends AbstractBetterSubtitle {
        public BetterSubtitle(@Nonnull SoundInstance sound, Component text, Vec3 inWorldPosition) {
            super(sound, sound.getSource().getName(), text.getString(), sound.getX(), sound.getY(), sound.getZ(), inWorldPosition.x, inWorldPosition.y, inWorldPosition.z);
        }
    }
}

