/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.mistersecret312.aperture_innovations.Config;
import net.mistersecret312.aperture_innovations.client.Layers;
import net.mistersecret312.aperture_innovations.client.overlay.CrosshairOverlay;
import net.mistersecret312.aperture_innovations.client.renderer.LongFallBootsRenderProperties;
import net.mistersecret312.aperture_innovations.client.renderer.PortalGunRenderProperties;
import net.mistersecret312.aperture_innovations.client.resourcepack.ResourcePackReloadListener;
import net.mistersecret312.aperture_innovations.datapack.PortalGunVariant;
import net.mistersecret312.aperture_innovations.init.AdvancementInit;
import net.mistersecret312.aperture_innovations.init.AttachmentTypeInit;
import net.mistersecret312.aperture_innovations.init.BlockInit;
import net.mistersecret312.aperture_innovations.init.DataComponentInit;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.init.ItemTabInit;
import net.mistersecret312.aperture_innovations.init.NetworkInit;
import net.mistersecret312.aperture_innovations.init.RecipeInit;
import net.mistersecret312.aperture_innovations.init.SoundInit;
import net.mistersecret312.aperture_innovations.init.StatisticsInit;
import net.mistersecret312.aperture_innovations.items.ColorfulGelItem;
import net.mistersecret312.aperture_innovations.items.ColorfulGelItemProperty;
import net.mistersecret312.aperture_innovations.items.LongFallBootsItem;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.util.Lazy;
import org.slf4j.Logger;

@Mod(value="aperture_innovations")
public class ApertureInnovations {
    public static final String MODID = "aperture_innovations";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final TagKey<Block> SHOOT_THROUGH = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"shoot_through"));
    public static final TagKey<Block> IMPORTALABLE = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"importalable"));
    public static final TagKey<Block> PORTALABLE = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"portalable"));

    public static ResourceLocation of(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public ApertureInnovations(IEventBus modEventBus, ModContainer modContainer) {
        ItemInit.register(modEventBus);
        BlockInit.register(modEventBus);
        ItemTabInit.register(modEventBus);
        SoundInit.register(modEventBus);
        StatisticsInit.register(modEventBus);
        RecipeInit.register(modEventBus);
        AdvancementInit.register(modEventBus);
        AttachmentTypeInit.register(modEventBus);
        DataComponentInit.register(modEventBus);
        modEventBus.addListener(Layers::registerLayers);
        modEventBus.addListener(NetworkInit::registerPackets);
        modEventBus.addListener(ApertureInnovations::registerCapabilities);
        modEventBus.addListener(event -> event.dataPackRegistry(PortalGunVariant.REGISTRY_KEY, PortalGunVariant.CODEC, PortalGunVariant.CODEC));
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG, "aperture_innovations-common.toml");
        if (FMLEnvironment.dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new PortalGunItem.Energy((ItemStack)stack), new ItemLike[]{ItemInit.PORTAL_GUN});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new LongFallBootsItem.Energy((ItemStack)stack), new ItemLike[]{ItemInit.LONG_FALL_BOOTS});
    }

    @EventBusSubscriber(modid="aperture_innovations", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        public static final Lazy<KeyMapping> RESET_PORTAL_GUN = Lazy.of(() -> new KeyMapping("aperture_innovations.portal_gun.reset", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 82, "key.category.aperture_innovations"));

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ItemInit.COLORFUL_GEL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ApertureInnovations.MODID, (String)"colored"), (ItemPropertyFunction)new ColorfulGelItemProperty()));
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem((IClientItemExtensions)LongFallBootsRenderProperties.INSTANCE, new Holder[]{ItemInit.LONG_FALL_BOOTS});
            event.registerItem((IClientItemExtensions)PortalGunRenderProperties.INSTANCE, new Holder[]{ItemInit.PORTAL_GUN});
        }

        @SubscribeEvent
        public static void registerClientReload(RegisterClientReloadListenersEvent event) {
            ResourcePackReloadListener.ReloadListener.registerReloadListener(event);
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            ColorfulGelItem gelItem = (ColorfulGelItem)((Object)ItemInit.COLORFUL_GEL.get());
            event.register((stack, color) -> color != 1 ? -1 : FastColor.ARGB32.opaque((int)gelItem.getColor(stack)), new ItemLike[]{(ItemLike)ItemInit.COLORFUL_GEL.get()});
        }

        @SubscribeEvent
        public static void registerKeybindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)RESET_PORTAL_GUN.get());
        }

        @SubscribeEvent
        public static void registerOverlays(RegisterGuiLayersEvent event) {
            event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)ApertureInnovations.MODID, (String)"portal_crosshair"), CrosshairOverlay.OVERLAY);
        }
    }
}

