/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;

public class NearPortalDeathCriterion
extends SimpleCriterionTrigger<NearPortalDeathTriggerInstance> {
    public void trigger(ServerPlayer player, double distanceToPortal, boolean isFloor) {
        this.trigger(player, trigger -> trigger.matches(distanceToPortal, isFloor));
    }

    public Codec<NearPortalDeathTriggerInstance> codec() {
        return NearPortalDeathTriggerInstance.CODEC;
    }

    public record NearPortalDeathTriggerInstance(Optional<ContextAwarePredicate> player, Optional<Double> distance, Optional<Boolean> isFloor) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<NearPortalDeathTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(NearPortalDeathTriggerInstance::player), (App)Codec.DOUBLE.optionalFieldOf("distance").forGetter(NearPortalDeathTriggerInstance::distance), (App)Codec.BOOL.optionalFieldOf("isFloor").forGetter(NearPortalDeathTriggerInstance::isFloor)).apply((Applicative)instance, NearPortalDeathTriggerInstance::new));

        public boolean matches(double distanceToPortal, boolean isFloor) {
            if (this.distance.isPresent() && this.distance.get() < distanceToPortal) {
                return false;
            }
            return !this.isFloor.isPresent() || this.isFloor.get() == isFloor;
        }
    }
}

