/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class PortalTravelCriterion
extends SimpleCriterionTrigger<PortalTravelTriggerInstance> {
    public void trigger(ServerPlayer player, ResourceLocation initialDimension, ResourceLocation destinationDimension, double teleportDistance, double verticalFlight, double horizontalJump, boolean lunacy) {
        this.trigger(player, trigger -> trigger.matches(initialDimension, destinationDimension, teleportDistance, horizontalJump, verticalFlight, lunacy));
    }

    public Codec<PortalTravelTriggerInstance> codec() {
        return PortalTravelTriggerInstance.CODEC;
    }

    public record PortalTravelTriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> initialDimension, Optional<ResourceLocation> destinationDimension, Optional<Double> teleportDistance, Optional<Double> horizontalJump, Optional<Double> verticalFlight, Optional<Boolean> lunacy) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<PortalTravelTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(PortalTravelTriggerInstance::player), (App)ResourceLocation.CODEC.optionalFieldOf("from").forGetter(PortalTravelTriggerInstance::initialDimension), (App)ResourceLocation.CODEC.optionalFieldOf("to").forGetter(PortalTravelTriggerInstance::destinationDimension), (App)Codec.DOUBLE.optionalFieldOf("distance").forGetter(PortalTravelTriggerInstance::teleportDistance), (App)Codec.DOUBLE.optionalFieldOf("jump").forGetter(PortalTravelTriggerInstance::horizontalJump), (App)Codec.DOUBLE.optionalFieldOf("flight").forGetter(PortalTravelTriggerInstance::verticalFlight), (App)Codec.BOOL.optionalFieldOf("lunacy").forGetter(PortalTravelTriggerInstance::lunacy)).apply((Applicative)instance, PortalTravelTriggerInstance::new));

        public boolean matches(ResourceLocation initialDimension, ResourceLocation destinationDimension, double teleportDistance, double horizontalJump, double verticalFlight, boolean lunacy) {
            if (this.initialDimension.isPresent() && !Objects.equals(this.initialDimension.get(), initialDimension)) {
                return false;
            }
            if (this.destinationDimension.isPresent() && !Objects.equals(this.destinationDimension.get(), destinationDimension)) {
                return false;
            }
            if (this.teleportDistance.isPresent() && this.teleportDistance.get() > teleportDistance) {
                return false;
            }
            if (this.horizontalJump.isPresent() && this.horizontalJump.get() > horizontalJump) {
                return false;
            }
            if (this.verticalFlight.isPresent() && this.verticalFlight.get() > verticalFlight) {
                return false;
            }
            return !this.lunacy.isPresent() || this.lunacy.get() == lunacy;
        }
    }
}

