/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ThrownIntoFluidCriterion
extends SimpleCriterionTrigger<ThrownIntoFluidTriggerInstance> {
    public void trigger(ServerPlayer player, ItemStack stack, BlockPos pos) {
        this.trigger(player, trigger -> trigger.matches(stack, player.level(), pos));
    }

    public Codec<ThrownIntoFluidTriggerInstance> codec() {
        return ThrownIntoFluidTriggerInstance.CODEC;
    }

    public record ThrownIntoFluidTriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<FluidPredicate> fluid) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<ThrownIntoFluidTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(ThrownIntoFluidTriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(ThrownIntoFluidTriggerInstance::item), (App)FluidPredicate.CODEC.optionalFieldOf("fluid").forGetter(ThrownIntoFluidTriggerInstance::fluid)).apply((Applicative)instance, ThrownIntoFluidTriggerInstance::new));

        public boolean matches(ItemStack stack, Level level, BlockPos blockPos) {
            if (this.item.isPresent() && !this.item.get().test(stack)) {
                return false;
            }
            return !this.fluid.isPresent() || this.fluid.get().matches((ServerLevel)level, blockPos);
        }
    }
}

