/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.capabilities;

import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.network.ClientboundApertureCapabilityPacket;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ApertureCapability
implements INBTSerializable<CompoundTag> {
    public static final EntityCapability<ApertureCapability, Void> APERTURE_CAPABILITY = EntityCapability.createVoid((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"aperture_innovations", (String)"aperture"), ApertureCapability.class);
    public Vector3d distanceVec = new Vector3d();
    public Pair<UUID, Boolean> portal;
    public double horizontalDistance = 0.0;
    public double verticalDistance = 0.0;
    public int frictionlessTime = 0;

    public void tick(Level level, LivingEntity living) {
        if (level.isClientSide()) {
            return;
        }
        if (living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundApertureCapabilityPacket(this.frictionlessTime), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.frictionlessTime > 0) {
            --this.frictionlessTime;
        }
        if (living.onGround() || living.isFallFlying()) {
            this.portal = null;
            this.distanceVec = new Vector3d();
            this.horizontalDistance = 0.0;
            this.verticalDistance = 0.0;
            this.frictionlessTime = 0;
        } else if (this.portal != null) {
            Vec3 speed = living.getDeltaMovement();
            Vector3f movementVector = new Vector3f(speed.x > 0.0 ? (float)speed.x : (float)(-speed.x), speed.y > 0.0 ? (float)speed.y : (float)(-speed.y), speed.z > 0.0 ? (float)speed.z : (float)(-speed.z));
            this.distanceVec.add((Vector3fc)movementVector);
        }
    }

    public void updateDistance() {
        if (this.portal == null || this.distanceVec == null) {
            return;
        }
        if (this.distanceVec.lengthSquared() > 0.0) {
            this.horizontalDistance += (double)Mth.sqrt((float)((float)(Math.pow(this.distanceVec.x, 2.0) + Math.pow(this.distanceVec.z, 2.0))));
            this.verticalDistance += Math.sqrt(Math.pow(this.distanceVec.y, 2.0));
        }
        this.distanceVec = new Vector3d();
    }

    public void setFrictionlessTime(int frictionlessTime) {
        this.frictionlessTime = frictionlessTime;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag distanceTag = new CompoundTag();
        distanceTag.putDouble("x", this.distanceVec.x);
        distanceTag.putDouble("y", this.distanceVec.y);
        distanceTag.putDouble("z", this.distanceVec.z);
        tag.put("distance", (Tag)distanceTag);
        tag.putDouble("horizontal", this.horizontalDistance);
        tag.putDouble("vertical", this.verticalDistance);
        tag.putInt("frictionlessTime", this.frictionlessTime);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        Vector3d distanceVec = new Vector3d();
        CompoundTag distanceTag = nbt.getCompound("distance");
        distanceVec.x = distanceTag.getDouble("x");
        distanceVec.y = distanceTag.getDouble("y");
        distanceVec.z = distanceTag.getDouble("z");
        this.distanceVec = distanceVec;
        this.horizontalDistance = nbt.getDouble("horizontal");
        this.verticalDistance = nbt.getDouble("vertical");
        this.frictionlessTime = nbt.getInt("frictionlessTime");
    }
}

