/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.capabilities;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class ApertureEnergy
implements IEnergyStorage,
INBTSerializable<Tag> {
    public static final char[] PREFIXES = new char[]{'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y', 'R', 'Q'};
    protected long energy = 0L;
    protected long capacity;
    protected long maxReceive;
    protected long maxExtract;

    public ApertureEnergy(long capacity, long maxReceive, long maxExtract) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return ApertureEnergy.regularEnergy(this.receiveLongEnergy(maxReceive, simulate));
    }

    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long energyReceived = Math.min(this.getTrueMaxEnergyStored() - this.energy, Math.min(this.maxReceive(), maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        if (energyReceived != 0L) {
            this.onEnergyChanged(energyReceived, simulate);
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return ApertureEnergy.regularEnergy(this.extractLongEnergy(maxExtract, simulate));
    }

    public long extractLongEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long energyExtracted = Math.min(this.energy, Math.min(this.maxExtract(), maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        if (energyExtracted != 0L) {
            this.onEnergyChanged(energyExtracted, simulate);
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return ApertureEnergy.regularEnergy(this.getTrueEnergyStored());
    }

    public long getTrueEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return ApertureEnergy.regularEnergy(this.getTrueMaxEnergyStored());
    }

    public long getTrueMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract() > 0L;
    }

    public boolean canReceive() {
        return this.maxReceive() > 0L && this.energy < this.getTrueMaxEnergyStored();
    }

    public boolean canReceive(long receivedEnergy) {
        return this.energy + receivedEnergy <= this.getTrueMaxEnergyStored();
    }

    public long setEnergy(long energy) {
        this.energy = energy;
        return energy;
    }

    public abstract void onEnergyChanged(long var1, boolean var3);

    public long maxReceive() {
        return this.maxReceive;
    }

    public long maxExtract() {
        return this.maxExtract;
    }

    public Tag serializeNBT(HolderLookup.Provider provider) {
        return LongTag.valueOf((long)this.energy);
    }

    public void deserializeNBT(HolderLookup.Provider provider, Tag nbt) {
        if (!(nbt instanceof LongTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        LongTag longTag = (LongTag)nbt;
        this.setEnergy(longTag.getAsLong());
    }

    public static int regularEnergy(long energy) {
        return (int)Math.min(Integer.MAX_VALUE, energy);
    }

    public static String energyToString(long energy) {
        int prefix;
        if (energy < 1000L) {
            return energy + " FE";
        }
        double total = energy;
        for (prefix = -1; total >= 1000.0 && prefix < PREFIXES.length; total /= 1000.0, ++prefix) {
        }
        total *= 100.0;
        total = Math.floor(total);
        return (total /= 100.0) + " " + PREFIXES[prefix] + "FE";
    }

    public static String energyToString(long energy, long capacity) {
        return ApertureEnergy.energyToString(energy) + "/" + ApertureEnergy.energyToString(capacity);
    }

    public static abstract class Item
    extends ApertureEnergy {
        protected ItemStack stack;

        public Item(ItemStack stack, long capacity, long maxReceive, long maxExtract) {
            super(capacity, maxReceive, maxExtract);
            this.stack = stack;
            this.energy = this.loadEnergy(stack);
        }

        public abstract long loadEnergy(ItemStack var1);
    }
}

