/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class ColorUtil {
    public static final int MAX_INT_VALUE = 255;
    public static final int MIN_INT_VALUE = 0;
    public static final float MAX_FLOAT_VALUE = 1.0f;
    public static final float MIN_FLOAT_VALUE = 0.0f;
    public static final String RED = "red";
    public static final String GREEN = "green";
    public static final String BLUE = "blue";
    public static final String ALPHA = "alpha";

    public static class RGBA {
        protected final float red;
        protected final float green;
        protected final float blue;
        protected final float alpha;
        public static final Codec<RGBA> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(ColorUtil.RED).forGetter(RGBA::red), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(ColorUtil.GREEN).forGetter(RGBA::green), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(ColorUtil.BLUE).forGetter(RGBA::blue), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf(ColorUtil.ALPHA).forGetter(RGBA::alpha)).apply((Applicative)instance, RGBA::new));

        public RGBA(float red, float green, float blue, float alpha) {
            if (red > 1.0f || green > 1.0f || blue > 1.0f || alpha > 1.0f) {
                throw new IllegalArgumentException("No value may be higher than 1.0");
            }
            if (red < 0.0f || green < 0.0f || blue < 0.0f || alpha < 0.0f) {
                throw new IllegalArgumentException("No value may be lower than 0.0");
            }
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public RGBA(int red, int green, int blue, int alpha) {
            if (red > 255 || green > 255 || blue > 255 || alpha > 255) {
                throw new IllegalArgumentException("No value may be higher than 255");
            }
            if (red < 0 || green < 0 || blue < 0 || alpha < 0) {
                throw new IllegalArgumentException("No value may be lower than 0");
            }
            this.red = (float)red / 255.0f;
            this.green = (float)green / 255.0f;
            this.blue = (float)blue / 255.0f;
            this.alpha = (float)alpha / 255.0f;
        }

        public float red() {
            return this.red;
        }

        public float green() {
            return this.green;
        }

        public float blue() {
            return this.blue;
        }

        public float alpha() {
            return this.alpha;
        }
    }
}

