/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.renderer.PortalRenderer;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;

public class CrosshairOverlay {
    public static final LayeredDraw.Layer OVERLAY = (guiGraphics, deltaTracker) -> {
        boolean hasPortalGun;
        LocalPlayer player = Minecraft.getInstance().player;
        if (Minecraft.getInstance().options.hideGui) {
            return;
        }
        if (!Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        if (player == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean bl = hasPortalGun = main.is((Item)ItemInit.PORTAL_GUN.get()) || off.is((Item)ItemInit.PORTAL_GUN.get());
        if (!hasPortalGun) {
            return;
        }
        ItemStack gunStack = main.is((Item)ItemInit.PORTAL_GUN.get()) ? main : off;
        PortalGunItem portalGun = (PortalGunItem)gunStack.getItem();
        int dualityState = portalGun.getDualityState(gunStack);
        ClientPortalLink link = PortalRenderer.LINKS.get(portalGun.getUUID(gunStack, false));
        if (link != null) {
            boolean hasPrimary = link.posPrimary() != null || link.moonshotPrimary();
            boolean hasSecondary = link.posSecondary() != null || link.moonshotSecondary();
            ColorUtil.RGBA primaryColor = ClientPortalUtilities.getPortalColor(link, true);
            ColorUtil.RGBA secondaryColor = ClientPortalUtilities.getPortalColor(link, false);
            ResourceLocation primaryCrosshairTexture = ClientPortalUtilities.getCrosshairTexture(link, true);
            ResourceLocation secondaryCrosshairTexture = ClientPortalUtilities.getCrosshairTexture(link, false);
            int uOffsetPrimary = hasPrimary ? 0 : 51;
            int uOffsetSecondary = hasSecondary ? 34 : 17;
            poseStack.pushPose();
            int screenWidth = 0;
            int screenHeight = 0;
            Window window = Minecraft.getInstance().getWindow();
            if (window != null) {
                screenWidth = window.getGuiScaledWidth();
                screenHeight = window.getGuiScaledHeight();
            }
            int x = (screenWidth - 17) / 2;
            int y = (screenHeight - 33) / 2;
            poseStack.translate((float)x, (float)y, 0.0f);
            poseStack.pushPose();
            if (dualityState == 1) {
                primaryCrosshairTexture = secondaryCrosshairTexture;
                primaryColor = secondaryColor;
                poseStack.translate(17.0f, 33.0f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                uOffsetPrimary = uOffsetSecondary;
            }
            RenderSystem.setShaderColor((float)primaryColor.red(), (float)primaryColor.green(), (float)primaryColor.blue(), (float)primaryColor.alpha());
            guiGraphics.blit(primaryCrosshairTexture, 0, 0, (float)uOffsetPrimary, 0.0f, 17, 33, 68, 33);
            poseStack.popPose();
            poseStack.pushPose();
            if (dualityState == 0) {
                secondaryCrosshairTexture = primaryCrosshairTexture;
                secondaryColor = primaryColor;
                poseStack.translate(17.0f, 33.0f, 0.0f);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                uOffsetSecondary = uOffsetPrimary;
            }
            RenderSystem.setShaderColor((float)secondaryColor.red(), (float)secondaryColor.green(), (float)secondaryColor.blue(), (float)secondaryColor.alpha());
            guiGraphics.blit(secondaryCrosshairTexture, 0, 0, (float)uOffsetSecondary, 0.0f, 17, 33, 68, 33);
            poseStack.popPose();
            poseStack.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    };
}

