/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.mistersecret312.aperture_innovations.ApertureInnovations;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.resourcepack.ClientPortalGunVariant;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import net.mistersecret312.aperture_innovations.portal.PortalUtilities;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.specialty.DynamicGeoItemRenderer;
import software.bernie.geckolib.util.RenderUtil;

public class PortalGunRenderer
extends DynamicGeoItemRenderer<PortalGunItem> {
    private static final RenderStateShard.ShaderStateShard SHADER_STATE = new RenderStateShard.ShaderStateShard(GameRenderer::getRendertypeEntityTranslucentEmissiveShader);
    private static final RenderStateShard.TransparencyStateShard TRANSPARENCY_STATE = new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderStateShard.WriteMaskStateShard WRITE_MASK = new RenderStateShard.WriteMaskStateShard(true, true);
    private static final BiFunction<ResourceLocation, Boolean, RenderType> GLOWING_RENDER_TYPE = Util.memoize((texture, isGlowing) -> {
        RenderStateShard.TextureStateShard textureState = new RenderStateShard.TextureStateShard(texture, false, false);
        return RenderType.create((String)"geo_glowing_layer", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(SHADER_STATE).setTextureState((RenderStateShard.EmptyTextureStateShard)textureState).setTransparencyState(TRANSPARENCY_STATE).setOverlayState(new RenderStateShard.OverlayStateShard(true)).setWriteMaskState(WRITE_MASK).createCompositeState(isGlowing.booleanValue()));
    });

    public PortalGunRenderer() {
        super((GeoModel)new DefaultedItemGeoModel(ApertureInnovations.of("portal_gun")));
    }

    protected boolean boneRenderOverride(PoseStack poseStack, GeoBone bone, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int colour) {
        ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
        if (gunCore.contains(bone.getName())) {
            int portal = ((PortalGunItem)this.getAnimatable()).getLastShotPortal(this.currentItemStack);
            ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
            if (portal == -1) {
                return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
            }
            ColorUtil.RGBA color = ClientPortalUtilities.getPortalColor(link, portal == 0);
            Color originalColor = new Color(colour, true);
            float red = (float)originalColor.getRed() * color.red() / 255.0f;
            float green = (float)originalColor.getGreen() * color.green() / 255.0f;
            float blue = (float)originalColor.getBlue() * color.blue() / 255.0f;
            float alpha = (float)originalColor.getAlpha() * color.alpha() / 255.0f;
            Color resultColor = new Color(red, green, blue, alpha);
            this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, resultColor.getRGB());
            return true;
        }
        if (bone.getName().equals("StripePrimary") || bone.getName().equals("StripeSecondary")) {
            int stripeColor;
            boolean isPrimary = bone.getName().equals("StripePrimary");
            int n = stripeColor = isPrimary ? ((PortalGunItem)this.getAnimatable()).getPrimaryStripeColor(this.currentItemStack) : ((PortalGunItem)this.getAnimatable()).getSecondaryStripeColor(this.currentItemStack);
            if (stripeColor == -1) {
                ColorUtil.RGBA color;
                ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
                ClientPortalGunVariant variant = ClientPortalGunVariant.DEFAULT_VARIANT;
                if (link != null) {
                    variant = link.getVariant();
                }
                ColorUtil.RGBA rGBA = color = isPrimary ? variant.primaryStripeColor() : variant.secondaryStripeColor();
                if (color.red() == 1.0f && color.green() == 1.0f && color.blue() == 1.0f && color.alpha() == 1.0f) {
                    return true;
                }
                Color originalColor = new Color(colour, true);
                float red = (float)originalColor.getRed() * color.red() / 255.0f;
                float green = (float)originalColor.getGreen() * color.green() / 255.0f;
                float blue = (float)originalColor.getBlue() * color.blue() / 255.0f;
                float alpha = (float)originalColor.getAlpha() * color.alpha() / 255.0f;
                Color resultColor = new Color(red, green, blue, alpha);
                this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, resultColor.getRGB());
            } else {
                Color color = new Color(stripeColor, false);
                if (color.getRGB() == -1) {
                    return true;
                }
                Color originalColor = new Color(colour, true);
                float red = (float)(originalColor.getRed() * color.getRed()) / 255.0f;
                float green = (float)(originalColor.getGreen() * color.getGreen()) / 255.0f;
                float blue = (float)(originalColor.getBlue() * color.getBlue()) / 255.0f;
                float alpha = (float)(originalColor.getAlpha() * color.getAlpha()) / 255.0f;
                Color resultColor = new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f);
                this.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, resultColor.getRGB());
            }
            return true;
        }
        return super.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour);
    }

    @Nullable
    protected RenderType getRenderTypeOverrideForBone(GeoBone bone, PortalGunItem animatable, ResourceLocation texturePath, MultiBufferSource bufferSource, float partialTick) {
        ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
        if (gunCore.contains(bone.getName())) {
            return GLOWING_RENDER_TYPE.apply(this.getTextureOverrideForBone(bone, animatable, partialTick), false);
        }
        return super.getRenderTypeOverrideForBone(bone, (Item)animatable, texturePath, bufferSource, partialTick);
    }

    @Nullable
    protected ResourceLocation getTextureOverrideForBone(GeoBone bone, PortalGunItem animatable, float partialTick) {
        int portal = ((PortalGunItem)this.getAnimatable()).getLastShotPortal(this.currentItemStack);
        ClientPortalLink link = PortalUtilities.getPortalLinks().get(((PortalGunItem)this.getAnimatable()).getUUID(this.currentItemStack, false));
        if (link != null) {
            ArrayList gunCore = Lists.newArrayList((Object[])new String[]{"CoreOuter", "CoreInner", "PortalLight", "Muzzle"});
            if (gunCore.contains(bone.getName())) {
                return ClientPortalUtilities.getPortalGunCoreTexture(link, portal);
            }
            return ClientPortalUtilities.getPortalGunTexture(link);
        }
        return ApertureInnovations.of("textures/item/portal_gun.png");
    }

    public RenderType getRenderType(PortalGunItem animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)texture);
    }

    public void renderRecursively(PoseStack poseStack, PortalGunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.pushPose();
        RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
        RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtil.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.itemRenderTranslations));
        }
        RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
        this.textureOverride = this.getTextureOverrideForBone(bone, (PortalGunItem)this.animatable, partialTick);
        ResourceLocation texture = this.textureOverride == null ? this.getTextureLocation((PortalGunItem)this.animatable) : this.textureOverride;
        RenderType renderTypeOverride = this.getRenderTypeOverrideForBone(bone, (PortalGunItem)this.animatable, texture, bufferSource, partialTick);
        if (texture != null && renderTypeOverride == null) {
            renderTypeOverride = this.getRenderType((PortalGunItem)this.animatable, texture, bufferSource, partialTick);
        }
        if (renderTypeOverride != null) {
            buffer = bufferSource.getBuffer(renderTypeOverride);
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, partialTick, packedLight, packedOverlay, colour)) {
            super.renderCubesOfBone(poseStack, bone, buffer, packedLight, packedOverlay, colour);
        }
        if (renderTypeOverride != null) {
            buffer = bufferSource.getBuffer(renderTypeOverride);
        }
        if (!isReRender) {
            this.applyRenderLayersForBone(poseStack, (GeoAnimatable)animatable, bone, renderTypeOverride, bufferSource, buffer, partialTick, packedLight, packedOverlay);
        }
        buffer = this.checkAndRefreshBuffer(isReRender, buffer, bufferSource, renderTypeOverride);
        super.renderChildBones(poseStack, (GeoAnimatable)animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.popPose();
    }
}

