/*
 * Decompiled with CFR 0.152.
 */
package net.mistersecret312.aperture_innovations.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.mistersecret312.aperture_innovations.client.ColorUtil;
import net.mistersecret312.aperture_innovations.client.PortalRenderTypes;
import net.mistersecret312.aperture_innovations.init.ItemInit;
import net.mistersecret312.aperture_innovations.items.PortalGunItem;
import net.mistersecret312.aperture_innovations.portal.ClientPortalLink;
import net.mistersecret312.aperture_innovations.portal.ClientPortalUtilities;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;

public class PortalRenderer {
    public static HashMap<UUID, ClientPortalLink> LINKS = new HashMap();

    public static void primaryRender(ClientPortalLink link, MultiBufferSource.BufferSource buffer, PoseStack poseStack, Camera camera, float scale) {
        if (link.posPrimary() != null) {
            poseStack.pushPose();
            Vec3 pos = link.posPrimary().getCenter();
            poseStack.translate(-camera.getPosition().x + pos.x, -camera.getPosition().y + pos.y + 0.5, -camera.getPosition().z + pos.z);
            poseStack.mulPose(link.directionPrimary().getRotation());
            if (link.wallPrimary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.scale(scale, scale, 1.0f);
            poseStack.translate(0.5f, 0.0f, 0.51f);
            PortalRenderer.renderPortalFrame(ClientPortalUtilities.getPortalClosedTexture(link, true), ClientPortalUtilities.getPortalColor(link, true), (MultiBufferSource)buffer, poseStack);
            poseStack.popPose();
        }
    }

    public static void secondaryRender(ClientPortalLink link, MultiBufferSource.BufferSource buffer, PoseStack poseStack, Camera camera, float scale) {
        if (link.posSecondary() != null) {
            poseStack.pushPose();
            Vec3 pos = link.posSecondary().getCenter();
            poseStack.translate(-camera.getPosition().x + pos.x, -camera.getPosition().y + pos.y + 0.5, -camera.getPosition().z + pos.z);
            poseStack.mulPose(link.directionSecondary().getRotation());
            if (link.wallSecondary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.scale(scale, scale, 1.0f);
            poseStack.translate(0.5f, 0.0f, 0.51f);
            PortalRenderer.renderPortalFrame(ClientPortalUtilities.getPortalClosedTexture(link, false), ClientPortalUtilities.getPortalColor(link, false), (MultiBufferSource)buffer, poseStack);
            poseStack.popPose();
        }
    }

    public static void renderPortalNonSee(MultiBufferSource buffer, Matrix4f modelViewMatrix, PoseStack poseStack, Camera camera, ClientPortalLink link, boolean isPrimary, float scale) {
        poseStack.pushPose();
        Vec3 pos = isPrimary ? link.posPrimary().getCenter() : link.posSecondary().getCenter();
        Direction direction = isPrimary ? link.directionPrimary() : link.directionSecondary();
        poseStack.mulPose(camera.rotation().invert(new Quaternionf()));
        poseStack.translate((float)(pos.x - camera.getPosition().x), (float)(pos.y - camera.getPosition().y + 0.5), (float)(pos.z - camera.getPosition().z));
        poseStack.mulPose(direction.getRotation());
        if (isPrimary) {
            if (link.wallPrimary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.translate(0.5f, 0.0f, 0.52f);
        } else {
            if (link.wallSecondary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.translate(0.5f, 0.0f, 0.52f);
        }
        poseStack.scale(1.0f, 2.0f, 1.0f);
        poseStack.translate(-0.5, 0.0, 0.0);
        poseStack.scale(scale, scale, scale);
        VertexConsumer consumerA = buffer.getBuffer(PortalRenderTypes.portal(isPrimary ? link.getVariant().primaryPortal().getMaskTexture() : link.getVariant().secondaryPortal().getMaskTexture()));
        consumerA.addVertex(poseStack.last().pose(), -0.5f, -0.5f, 0.0f).setUv(0.0f, 1.0f).setColor(FastColor.ABGR32.color((int)255, (int)255, (int)255, (int)255));
        consumerA.addVertex(poseStack.last().pose(), 0.5f, -0.5f, 0.0f).setUv(1.0f, 1.0f).setColor(FastColor.ABGR32.color((int)255, (int)255, (int)255, (int)255));
        consumerA.addVertex(poseStack.last().pose(), 0.5f, 0.5f, 0.0f).setUv(1.0f, 0.0f).setColor(FastColor.ABGR32.color((int)255, (int)255, (int)255, (int)255));
        consumerA.addVertex(poseStack.last().pose(), -0.5f, 0.5f, 0.0f).setUv(0.0f, 0.0f).setColor(FastColor.ABGR32.color((int)255, (int)255, (int)255, (int)255));
        poseStack.popPose();
    }

    public static void renderPortalFrame(ResourceLocation texture, ColorUtil.RGBA color, MultiBufferSource buffer, PoseStack poseStack) {
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        VertexConsumer consumerA = buffer.getBuffer(PortalRenderTypes.portalFrame(texture));
        consumerA.addVertex(poseStack.last().pose(), -0.5f, -0.5f, 0.0f).setUv(0.0f, 1.0f).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), 0.5f, -0.5f, 0.0f).setUv(1.0f, 1.0f).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), 0.5f, 0.5f, 0.0f).setUv(1.0f, 0.0f).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), -0.5f, 0.5f, 0.0f).setUv(0.0f, 0.0f).setColor(color.red(), color.green(), color.blue(), color.alpha());
        poseStack.popPose();
    }

    public static void renderPortalHighlight(MultiBufferSource buffer, PoseStack poseStack, ResourceLocation texture, ColorUtil.RGBA color, boolean isPrimary) {
        poseStack.pushPose();
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4f matrix = poseStack.last().pose();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)516);
        GL11.glEnable((int)2960);
        RenderSystem.stencilFunc((int)517, (int)1, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)color.red(), (float)color.green(), (float)color.blue(), (float)color.alpha());
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, -0.5f, -0.5f, 0.0f).setUv(0.0f, 1.0f);
        builder.addVertex(matrix, 0.5f, -0.5f, 0.0f).setUv(1.0f, 1.0f);
        builder.addVertex(matrix, 0.5f, 0.5f, 0.0f).setUv(1.0f, 0.0f);
        builder.addVertex(matrix, -0.5f, 0.5f, 0.0f).setUv(0.0f, 0.0f);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2960);
        if (!isPrimary) {
            RenderSystem.clear((int)1024, (boolean)Minecraft.ON_OSX);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        poseStack.popPose();
    }

    public static void renderPortalVortex(ClientPortalLink link, Camera camera, TextureAtlasSprite sprite, MultiBufferSource buffer, PoseStack poseStack, boolean isPrimary) {
        ItemStack gunStack;
        PortalGunItem portalGun;
        UUID linkID;
        boolean hasPortalGun;
        poseStack.pushPose();
        Vec3 pos = isPrimary ? link.posPrimary().getCenter() : link.posSecondary().getCenter();
        Direction direction = isPrimary ? link.directionPrimary() : link.directionSecondary();
        poseStack.translate(pos.x - camera.getPosition().x, pos.y - camera.getPosition().y + 0.5, pos.z - camera.getPosition().z);
        poseStack.mulPose(direction.getRotation());
        if (isPrimary) {
            if (link.wallPrimary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingPrimary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingPrimary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.translate(0.5f, 0.0f, 0.52f);
        } else {
            if (link.wallSecondary()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(link.ceilingSecondary() ? 0.0f : 180.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.translate(0.0f, 0.5f, -0.5f);
                if (link.ceilingSecondary()) {
                    poseStack.translate(0.0f, 0.0f, 1.0f);
                }
            }
            poseStack.translate(0.5f, 0.0f, 0.52f);
        }
        float scale = ClientPortalUtilities.getPortalOpeningAnimationProgress(link.linkID(), isPrimary);
        poseStack.translate(-0.3125f, 0.0f, 0.005f);
        poseStack.scale(scale, scale, scale);
        poseStack.scale(2.0f, 2.0f, 2.0f);
        ColorUtil.RGBA color = ClientPortalUtilities.getPortalColor(link, isPrimary);
        VertexConsumer consumerA = buffer.getBuffer(PortalRenderTypes.portalVortex(sprite.atlasLocation()));
        consumerA.addVertex(poseStack.last().pose(), -0.5f, -0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV1()).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), 0.5f, -0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV1()).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), 0.5f, 0.5f, 0.0f).setUv(sprite.getU1(), sprite.getV0()).setColor(color.red(), color.green(), color.blue(), color.alpha());
        consumerA.addVertex(poseStack.last().pose(), -0.5f, 0.5f, 0.0f).setUv(sprite.getU0(), sprite.getV0()).setColor(color.red(), color.green(), color.blue(), color.alpha());
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack main = player.getMainHandItem();
        ItemStack off = player.getOffhandItem();
        boolean bl = hasPortalGun = main.is((Item)ItemInit.PORTAL_GUN.get()) || off.is((Item)ItemInit.PORTAL_GUN.get());
        if (hasPortalGun && (linkID = (portalGun = (PortalGunItem)(gunStack = main.is((Item)ItemInit.PORTAL_GUN.get()) ? main : off).getItem()).getUUID(gunStack, false)) != null && linkID.equals(link.linkID())) {
            ResourceLocation texture = ClientPortalUtilities.getPortalHighlightTexture(link, isPrimary);
            poseStack.pushPose();
            poseStack.translate(0.15625f, 0.0f, 0.0f);
            PortalRenderer.renderPortalHighlight(buffer, poseStack, texture, color, isPrimary);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(0.3125f, 0.0f, 0.0f);
            PortalRenderer.renderPortalHighlight(buffer, poseStack, texture, color, isPrimary);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

